/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpeterson.jackson.module.versioning;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.github.jonpeterson.jackson.module.versioning.JsonSerializeToVersion;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelConverter;
import java.io.IOException;

public class VersionedModelDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private final StdDeserializer<T> delegate;
    private final JsonVersionedModel jsonVersionedModel;
    private final VersionedModelConverter converter;
    private final BeanPropertyDefinition serializeToVersionProperty;
    private final JsonSerializeToVersion serializeToVersionAnnotation;

    public VersionedModelDeserializer(StdDeserializer<T> delegate, JsonVersionedModel jsonVersionedModel, BeanPropertyDefinition serializeToVersionProperty) {
        super(delegate.getValueType());
        this.delegate = delegate;
        this.jsonVersionedModel = jsonVersionedModel;
        this.serializeToVersionProperty = serializeToVersionProperty;
        this.serializeToVersionAnnotation = serializeToVersionProperty != null ? serializeToVersionProperty.getAccessor().getAnnotation(JsonSerializeToVersion.class) : null;
        Class<? extends VersionedModelConverter> converterClass = jsonVersionedModel.toCurrentConverterClass();
        if (converterClass != VersionedModelConverter.class) {
            try {
                this.converter = converterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("unable to create instance of converter '" + converterClass.getName() + "'", e);
            }
        } else {
            this.converter = null;
        }
    }

    @Override
    public void resolve(DeserializationContext context) throws JsonMappingException {
        if (this.delegate instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)this.delegate)).resolve(context);
        }
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        if (!(jsonNode instanceof ObjectNode)) {
            throw context.mappingException("value must be a JSON object");
        }
        ObjectNode modelData = (ObjectNode)jsonNode;
        JsonNode modelVersionNode = modelData.remove(this.jsonVersionedModel.propertyName());
        String modelVersion = null;
        if (modelVersionNode != null) {
            modelVersion = modelVersionNode.asText();
        }
        if (modelVersion == null) {
            modelVersion = this.jsonVersionedModel.defaultDeserializeToVersion();
        }
        if (modelVersion.isEmpty()) {
            throw context.mappingException("'" + this.jsonVersionedModel.propertyName() + "' property was null and defaultDeserializeToVersion was not set");
        }
        if (this.converter != null && (this.jsonVersionedModel.alwaysConvert() || !modelVersion.equals(this.jsonVersionedModel.currentVersion()))) {
            modelData = this.converter.convert(modelData, modelVersion, this.jsonVersionedModel.currentVersion(), context.getNodeFactory());
        }
        if (this.serializeToVersionAnnotation != null && this.serializeToVersionAnnotation.defaultToSource()) {
            modelData.put(this.serializeToVersionProperty.getName(), modelVersion);
        }
        TreeTraversingParser postInterceptionParser = new TreeTraversingParser(modelData, parser.getCodec());
        ((JsonParser)postInterceptionParser).nextToken();
        return this.delegate.deserialize(postInterceptionParser, context);
    }
}

