/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpeterson.jackson.module.versioning;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelDeserializer;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelUtils;

class VersioningBeanDeserializationModifier
extends BeanDeserializerModifier {
    VersioningBeanDeserializationModifier() {
    }

    private static <T> VersionedModelDeserializer<T> createVersioningDeserializer(StdDeserializer<T> deserializer, JsonVersionedModel jsonVersionedModel, BeanPropertyDefinition serializeToVersionProperty) {
        return new VersionedModelDeserializer<T>(deserializer, jsonVersionedModel, serializeToVersionProperty);
    }

    @Override
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDescription, JsonDeserializer<?> deserializer) {
        JsonVersionedModel jsonVersionedModel;
        if (deserializer instanceof StdDeserializer && (jsonVersionedModel = beanDescription.getClassAnnotations().get(JsonVersionedModel.class)) != null) {
            return VersioningBeanDeserializationModifier.createVersioningDeserializer((StdDeserializer)deserializer, jsonVersionedModel, VersionedModelUtils.getSerializeToVersionProperty(beanDescription));
        }
        return deserializer;
    }
}

