/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpeterson.jackson.module.versioning;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelSerializer;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelUtils;

class VersioningBeanSerializationModifier
extends BeanSerializerModifier {
    VersioningBeanSerializationModifier() {
    }

    private static <T> VersionedModelSerializer<T> createVersioningSerializer(StdSerializer<T> serializer2, JsonVersionedModel jsonVersionedModel, BeanPropertyDefinition serializeToVersionProperty) {
        return new VersionedModelSerializer<T>(serializer2, jsonVersionedModel, serializeToVersionProperty);
    }

    @Override
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDescription, JsonSerializer<?> serializer2) {
        JsonVersionedModel jsonVersionedModel;
        if (serializer2 instanceof StdSerializer && (jsonVersionedModel = beanDescription.getClassAnnotations().get(JsonVersionedModel.class)) != null) {
            return VersioningBeanSerializationModifier.createVersioningSerializer((StdSerializer)serializer2, jsonVersionedModel, VersionedModelUtils.getSerializeToVersionProperty(beanDescription));
        }
        return serializer2;
    }
}

