/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.Utf8;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class Utf8Old
extends Utf8 {
    private static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(() -> new Cache());

    @Override
    public int encodedLength(CharSequence in) {
        Cache cache2 = CACHE.get();
        int estimated = (int)((float)in.length() * cache2.encoder.maxBytesPerChar());
        if (cache2.lastOutput == null || cache2.lastOutput.capacity() < estimated) {
            cache2.lastOutput = ByteBuffer.allocate(Math.max(128, estimated));
        }
        cache2.lastOutput.clear();
        cache2.lastInput = in;
        CharBuffer wrap = in instanceof CharBuffer ? (CharBuffer)in : CharBuffer.wrap(in);
        CoderResult result = cache2.encoder.encode(wrap, cache2.lastOutput, true);
        if (result.isError()) {
            try {
                result.throwException();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("bad character encoding", e);
            }
        }
        cache2.lastOutput.flip();
        return cache2.lastOutput.remaining();
    }

    @Override
    public void encodeUtf8(CharSequence in, ByteBuffer out2) {
        Cache cache2 = CACHE.get();
        if (cache2.lastInput != in) {
            this.encodedLength(in);
        }
        out2.put(cache2.lastOutput);
    }

    @Override
    public String decodeUtf8(ByteBuffer buffer, int offset, int length) {
        CharsetDecoder decoder = Utf8Old.CACHE.get().decoder;
        decoder.reset();
        buffer = buffer.duplicate();
        buffer.position(offset);
        buffer.limit(offset + length);
        try {
            CharBuffer result = decoder.decode(buffer);
            return result.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Bad encoding", e);
        }
    }

    private static class Cache {
        final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharSequence lastInput = null;
        ByteBuffer lastOutput = null;

        Cache() {
        }
    }
}

