/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCSerializeException;
import java.nio.ByteBuffer;

public class BufferBytesReceiver
implements BytesReceiver {
    private final ByteBuffer buffer;

    public BufferBytesReceiver(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public BytesReceiver put(byte data) {
        this.buffer.put(data);
        return this;
    }

    @Override
    public BytesReceiver put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public BytesReceiver put(ByteBuffer src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public BytesReceiver clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public BytesReceiver.PlaceHolder putPlaceHolder(byte[] src) {
        PlaceHolderImpl placeHolder = new PlaceHolderImpl(this.position(), src.length);
        this.put(src);
        return placeHolder;
    }

    @Override
    public byte[] toByteArray() {
        this.buffer.flip();
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        return bytes;
    }

    private class PlaceHolderImpl
    implements BytesReceiver.PlaceHolder {
        private final int position;
        private final int size;

        PlaceHolderImpl(int position, int size2) {
            this.position = position;
            this.size = size2;
        }

        @Override
        public void replace(byte[] src) throws OSCSerializeException {
            if (src.length != this.size) {
                throw new OSCSerializeException(String.format("Trying to replace placeholder of size %d with data of size %d", this.size, src.length));
            }
            int curPosition = BufferBytesReceiver.this.buffer.position();
            BufferBytesReceiver.this.buffer.position(this.position);
            BufferBytesReceiver.this.put(src);
            BufferBytesReceiver.this.buffer.position(curPosition);
        }
    }
}

