/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCSerializerAndParserBuilder;
import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.OSCImpulse;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibraryInfo {
    private static final String MANIFEST_FILE = "/META-INF/MANIFEST.MF";
    public static final String UNKNOWN_VALUE = "<unknown>";
    private static final char MANIFEST_CONTINUATION_LINE_INDICATOR = ' ';
    private static final int KEY_PLUS_VALUE_COUNT = 2;
    private static final Set<Package> UNINTERESTING_PKGS;
    private final Properties manifestProperties = LibraryInfo.readJarManifest();

    private static Properties parseManifestFile(InputStream manifestIn) throws IOException {
        Properties manifestProps = new Properties();
        try (BufferedReader manifestBufferedIn = new BufferedReader(new InputStreamReader(manifestIn, StandardCharsets.UTF_8));){
            String manifestLine = manifestBufferedIn.readLine();
            String currentKey = null;
            StringBuilder currentValue = new StringBuilder(80);
            while (manifestLine != null) {
                if (!manifestLine.trim().isEmpty() && !manifestLine.startsWith("[#%]")) {
                    if (manifestLine.charAt(0) == ' ') {
                        currentValue.append(manifestLine.substring(1));
                    } else {
                        String[] keyAndValue;
                        if (currentKey != null) {
                            manifestProps.setProperty(currentKey, currentValue.toString());
                        }
                        if ((keyAndValue = manifestLine.split(": ", 2)).length < 2) {
                            throw new IOException("Invalid manifest line: \"" + manifestLine + '\"');
                        }
                        currentKey = keyAndValue[0];
                        currentValue.setLength(0);
                        currentValue.append(keyAndValue[1]);
                    }
                }
                manifestLine = manifestBufferedIn.readLine();
            }
            if (currentKey != null) {
                manifestProps.setProperty(currentKey, currentValue.toString());
            }
        }
        return manifestProps;
    }

    private static Properties readJarManifest() throws IOException {
        Properties mavenProps;
        try (InputStream manifestFileIn = LibraryInfo.class.getResourceAsStream(MANIFEST_FILE);){
            if (manifestFileIn == null) {
                throw new IOException("Failed locating resource in the classpath: /META-INF/MANIFEST.MF");
            }
            mavenProps = LibraryInfo.parseManifestFile(manifestFileIn);
        }
        return mavenProps;
    }

    public Properties getManifestProperties() {
        return this.manifestProperties;
    }

    public String getVersion() {
        return this.getManifestProperties().getProperty("Bundle-Version", UNKNOWN_VALUE);
    }

    public String getOscSpecificationVersion() {
        return this.getManifestProperties().getProperty("Supported-OSC-Version", UNKNOWN_VALUE);
    }

    public String getLicense() {
        return this.getManifestProperties().getProperty("Bundle-License", UNKNOWN_VALUE);
    }

    public boolean isArrayEncodingSupported() {
        return true;
    }

    public boolean isArrayDecodingSupported() {
        return true;
    }

    public List<ArgumentHandler> getEncodingArgumentHandlers() {
        return new ArrayList<ArgumentHandler>(this.getDecodingArgumentHandlers().values());
    }

    public Map<Character, ArgumentHandler> getDecodingArgumentHandlers() {
        return new OSCSerializerAndParserBuilder().getIdentifierToTypeMapping();
    }

    private static String extractPrettyClassName(Class javaClass) {
        String prettyClassName = UNINTERESTING_PKGS.contains(javaClass.getPackage()) ? javaClass.getSimpleName() : javaClass.getCanonicalName();
        return prettyClassName;
    }

    private static String extractTypeClassOrMarkerValue(ArgumentHandler type) {
        String classOrMarkerValue;
        if (type.isMarkerOnly()) {
            try {
                Object markerValue = type.parse(null);
                String markerValueStr = markerValue == null ? "null" : markerValue.toString();
                classOrMarkerValue = LibraryInfo.extractPrettyClassName(type.getJavaClass()) + ':' + markerValueStr;
            }
            catch (OSCParseException ex) {
                throw new IllegalStateException("Developer error; This should never happen", ex);
            }
        } else {
            classOrMarkerValue = LibraryInfo.extractPrettyClassName(type.getJavaClass());
        }
        return classOrMarkerValue;
    }

    public String createManifestPropertiesString() {
        StringBuilder info = new StringBuilder(1024);
        for (Map.Entry<Object, Object> manifestEntry : this.getManifestProperties().entrySet()) {
            String key2 = (String)manifestEntry.getKey();
            String value = (String)manifestEntry.getValue();
            info.append(String.format("%32s", key2)).append(" -> ").append(value).append('\n');
        }
        return info.toString();
    }

    public String createLibrarySummary() {
        StringBuilder summary = new StringBuilder(1024);
        summary.append("\nName:        ").append(this.getManifestProperties().getProperty("Bundle-Name", UNKNOWN_VALUE)).append("\nDescription: ").append(this.getManifestProperties().getProperty("Bundle-Description", UNKNOWN_VALUE)).append("\nVersion:     ").append(this.getVersion()).append("\nOSC-Spec.:   ").append(this.getOscSpecificationVersion()).append("\nLicense:     ").append(this.getLicense()).append("\nArgument serialization:\n                  [Java] -> [OSC]");
        if (this.isArrayEncodingSupported()) {
            summary.append("\n        ").append(String.format("%16s", LibraryInfo.extractPrettyClassName(List.class))).append(" -> '").append('[').append("'...'").append(']').append('\'');
        }
        for (ArgumentHandler argumentHandler : this.getEncodingArgumentHandlers()) {
            summary.append("\n        ").append(String.format("%16s", LibraryInfo.extractTypeClassOrMarkerValue(argumentHandler))).append(" -> '").append(argumentHandler.getDefaultIdentifier()).append('\'');
        }
        summary.append("\nArgument parsing:\n                   [OSC] -> [Java]");
        if (this.isArrayDecodingSupported()) {
            summary.append("\n               '").append('[').append("'...'").append(']').append("' -> ").append(LibraryInfo.extractPrettyClassName(List.class));
        }
        for (Map.Entry entry : this.getDecodingArgumentHandlers().entrySet()) {
            summary.append("\n                     '").append(entry.getKey()).append("' -> ").append(LibraryInfo.extractTypeClassOrMarkerValue((ArgumentHandler)entry.getValue()));
        }
        return summary.toString();
    }

    public static boolean hasStandardProtocolFamily() {
        try {
            Class.forName("java.net.StandardProtocolFamily");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static boolean hasAwtColor() {
        try {
            Class.forName("java.awt.Color");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static void main(String[] args2) throws IOException {
        Logger log = LoggerFactory.getLogger(LibraryInfo.class);
        if (log.isInfoEnabled()) {
            LibraryInfo libraryInfo = new LibraryInfo();
            log.info(libraryInfo.createLibrarySummary());
        }
    }

    static {
        HashSet<Package> tmpUninterestingPkgs = new HashSet<Package>();
        tmpUninterestingPkgs.add(Package.getPackage("java.lang"));
        tmpUninterestingPkgs.add(Package.getPackage("java.util"));
        if (LibraryInfo.hasAwtColor()) {
            tmpUninterestingPkgs.add(Color.class.getPackage());
        }
        tmpUninterestingPkgs.add(OSCImpulse.class.getPackage());
        UNINTERESTING_PKGS = Collections.unmodifiableSet(tmpUninterestingPkgs);
    }
}

