/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SerializableByteBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ByteBuffer buffer;

    public SerializableByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    private void writeObject(ObjectOutputStream serializer2) throws IOException {
        serializer2.defaultWriteObject();
        serializer2.writeInt(this.buffer.capacity());
        serializer2.writeInt(this.buffer.position());
        serializer2.writeInt(this.buffer.limit());
        this.buffer.reset();
        serializer2.writeInt(this.buffer.position());
        serializer2.writeObject(this.buffer.order().toString());
        if (this.buffer.hasArray()) {
            serializer2.write(this.buffer.array());
        } else {
            byte[] bufferArray = new byte[this.buffer.capacity()];
            this.buffer.rewind();
            ((Buffer)this.buffer).limit(this.buffer.capacity());
            this.buffer.get(bufferArray);
            serializer2.write(this.buffer.array());
        }
    }

    private void readObject(ObjectInputStream deserializer) throws IOException, ClassNotFoundException {
        deserializer.defaultReadObject();
        int capacity = deserializer.readInt();
        int position = deserializer.readInt();
        int limit = deserializer.readInt();
        int mark = deserializer.readInt();
        String orderName = (String)deserializer.readObject();
        ByteOrder order = orderName.equals(ByteOrder.LITTLE_ENDIAN.toString()) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] bufferArray = new byte[capacity];
        int bufferContentSize = deserializer.read(bufferArray);
        if (bufferContentSize != capacity) {
            throw new IllegalStateException("Actual content size does not match the indicated buffer size");
        }
        this.buffer = ByteBuffer.wrap(bufferArray, 0, capacity);
        this.buffer.order(order);
        ((Buffer)this.buffer).position(mark);
        this.buffer.mark();
        ((Buffer)this.buffer).limit(limit);
        ((Buffer)this.buffer).position(position);
    }
}

