/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.handler.BlobArgumentHandler;
import com.illposed.osc.argument.handler.BooleanFalseArgumentHandler;
import com.illposed.osc.argument.handler.BooleanTrueArgumentHandler;
import com.illposed.osc.argument.handler.ByteArrayBlobArgumentHandler;
import com.illposed.osc.argument.handler.CharArgumentHandler;
import com.illposed.osc.argument.handler.ColorArgumentHandler;
import com.illposed.osc.argument.handler.DateTimeStampArgumentHandler;
import com.illposed.osc.argument.handler.DoubleArgumentHandler;
import com.illposed.osc.argument.handler.FloatArgumentHandler;
import com.illposed.osc.argument.handler.ImpulseArgumentHandler;
import com.illposed.osc.argument.handler.IntegerArgumentHandler;
import com.illposed.osc.argument.handler.LongArgumentHandler;
import com.illposed.osc.argument.handler.MidiMessageArgumentHandler;
import com.illposed.osc.argument.handler.NullArgumentHandler;
import com.illposed.osc.argument.handler.StringArgumentHandler;
import com.illposed.osc.argument.handler.SymbolArgumentHandler;
import com.illposed.osc.argument.handler.TimeTag64ArgumentHandler;
import com.illposed.osc.argument.handler.UnsignedIntegerArgumentHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final List<ArgumentHandler> TYPES_STATIC_COMMON;

    private Activator() {
    }

    public static Map<Character, ArgumentHandler> createParserTypes() {
        HashMap<Character, ArgumentHandler> parserTypes = new HashMap<Character, ArgumentHandler>(TYPES_STATIC_COMMON.size() + 1);
        for (ArgumentHandler type : TYPES_STATIC_COMMON) {
            parserTypes.put(Character.valueOf(type.getDefaultIdentifier()), type);
        }
        StringArgumentHandler stringArgumentHandler = new StringArgumentHandler();
        parserTypes.put(Character.valueOf(stringArgumentHandler.getDefaultIdentifier()), stringArgumentHandler);
        SymbolArgumentHandler symbolArgumentHandler = new SymbolArgumentHandler();
        parserTypes.put(Character.valueOf(symbolArgumentHandler.getDefaultIdentifier()), symbolArgumentHandler);
        return parserTypes;
    }

    public static List<ArgumentHandler> createSerializerTypes() {
        ArrayList<ArgumentHandler> serializerTypes = new ArrayList<ArgumentHandler>(TYPES_STATIC_COMMON.size() + 2);
        serializerTypes.addAll(TYPES_STATIC_COMMON);
        StringArgumentHandler stringArgumentHandler = new StringArgumentHandler();
        serializerTypes.add(stringArgumentHandler);
        SymbolArgumentHandler symbolArgumentHandler = new SymbolArgumentHandler();
        serializerTypes.add(symbolArgumentHandler);
        try {
            String awtColorArgHClsName = ColorArgumentHandler.class.getPackage().getName() + ".AwtColorArgumentHandler";
            Class<?> awtColorArgumentHandler = Activator.class.getClassLoader().loadClass(awtColorArgHClsName);
            Field instance = awtColorArgumentHandler.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            serializerTypes.add((ArgumentHandler)instance.get(null));
        }
        catch (ClassNotFoundException ex) {
            LOG.debug("Not supporting AWT color serialization", ex);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            LOG.error("Failed to add AWT Color serializer", ex);
        }
        ArgumentHandler<byte[]> byteArrayBlobArgumentHandler = ByteArrayBlobArgumentHandler.INSTANCE;
        serializerTypes.add(byteArrayBlobArgumentHandler);
        ArgumentHandler<Date> dateArgumentHandler = DateTimeStampArgumentHandler.INSTANCE;
        serializerTypes.add(dateArgumentHandler);
        return serializerTypes;
    }

    static {
        ArrayList<ArgumentHandler<Object>> types = new ArrayList<ArgumentHandler<Object>>();
        types.add(BlobArgumentHandler.INSTANCE);
        types.add(BooleanFalseArgumentHandler.INSTANCE);
        types.add(BooleanTrueArgumentHandler.INSTANCE);
        types.add(CharArgumentHandler.INSTANCE);
        types.add(ColorArgumentHandler.INSTANCE);
        types.add(DoubleArgumentHandler.INSTANCE);
        types.add(FloatArgumentHandler.INSTANCE);
        types.add(ImpulseArgumentHandler.INSTANCE);
        types.add(IntegerArgumentHandler.INSTANCE);
        types.add(LongArgumentHandler.INSTANCE);
        types.add(MidiMessageArgumentHandler.INSTANCE);
        types.add(NullArgumentHandler.INSTANCE);
        types.add(TimeTag64ArgumentHandler.INSTANCE);
        types.add(UnsignedIntegerArgumentHandler.INSTANCE);
        types.trimToSize();
        TYPES_STATIC_COMMON = Collections.unmodifiableList(types);
    }
}

