/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.argument.ArgumentHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;

public class LongArgumentHandler
implements ArgumentHandler<Long>,
Cloneable {
    public static final int BYTES = 8;
    public static final ArgumentHandler<Long> INSTANCE = new LongArgumentHandler();

    protected LongArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'h';
    }

    @Override
    public Class<Long> getJavaClass() {
        return Long.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public LongArgumentHandler clone() throws CloneNotSupportedException {
        return (LongArgumentHandler)super.clone();
    }

    @Override
    public Long parse(ByteBuffer input) {
        Long value = input.asLongBuffer().get();
        ((Buffer)input).position(input.position() + 8);
        return value;
    }

    @Override
    public void serialize(BytesReceiver output, Long value) {
        long curValue = value;
        byte[] longIntBytes = new byte[8];
        longIntBytes[7] = (byte)curValue;
        longIntBytes[6] = (byte)(curValue >>>= 8);
        longIntBytes[5] = (byte)(curValue >>>= 8);
        longIntBytes[4] = (byte)(curValue >>>= 8);
        longIntBytes[3] = (byte)(curValue >>>= 8);
        longIntBytes[2] = (byte)(curValue >>>= 8);
        longIntBytes[1] = (byte)(curValue >>>= 8);
        longIntBytes[0] = (byte)(curValue >>>= 8);
        output.put(longIntBytes);
    }
}

