/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.transport;

import com.illposed.osc.OSCSerializerAndParserBuilder;
import com.illposed.osc.transport.NetworkProtocol;
import com.illposed.osc.transport.Transport;
import com.illposed.osc.transport.tcp.TCPTransport;
import com.illposed.osc.transport.udp.UDPTransport;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class OSCPort {
    public static final int DEFAULT_SC_OSC_PORT = 57110;
    public static final int DEFAULT_SC_LANG_OSC_PORT = 57120;
    private final Transport transport;

    protected OSCPort(SocketAddress local, SocketAddress remote, OSCSerializerAndParserBuilder serializerAndParserBuilder, NetworkProtocol protocol) throws IOException {
        switch (protocol) {
            case UDP: {
                this.transport = new UDPTransport(local, remote, serializerAndParserBuilder);
                break;
            }
            case TCP: {
                if (!(local instanceof InetSocketAddress) || !(remote instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("Only InetSocketAddress is supported for TCP transport.");
                }
                this.transport = new TCPTransport((InetSocketAddress)local, (InetSocketAddress)remote, serializerAndParserBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected NetworkProtocol: " + (Object)((Object)protocol));
            }
        }
    }

    protected OSCPort(SocketAddress local, SocketAddress remote, OSCSerializerAndParserBuilder serializerAndParserBuilder) throws IOException {
        this(local, remote, serializerAndParserBuilder, NetworkProtocol.UDP);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public static int defaultSCOSCPort() {
        return 57110;
    }

    public static int defaultSCLangOSCPort() {
        return 57120;
    }

    public static InetAddress generateWildcard(SocketAddress address) throws UnknownHostException {
        return InetAddress.getByName(OSCPort.extractFamily(address) == 4 ? "0.0.0.0" : "::");
    }

    public static int extractFamily(SocketAddress address) {
        InetSocketAddress iNetAddress;
        int family = address instanceof InetSocketAddress ? ((iNetAddress = (InetSocketAddress)address).getAddress() instanceof Inet4Address ? 4 : (iNetAddress.getAddress() instanceof Inet6Address ? 6 : 0)) : 0;
        return family;
    }

    public void connect() throws IOException {
        this.transport.connect();
    }

    public void disconnect() throws IOException {
        this.transport.disconnect();
    }

    public boolean isConnected() {
        return this.transport.isConnected();
    }

    public void close() throws IOException {
        this.transport.close();
    }

    public String toString() {
        return String.format("[%s (%s)]", this.getClass().getSimpleName(), this.transport);
    }
}

