/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.transport.channel;

import com.illposed.osc.BufferBytesReceiver;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCParser;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.OSCSerializer;
import com.illposed.osc.OSCSerializerAndParserBuilder;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;

public class OSCDatagramChannel
extends SelectableChannel {
    private final DatagramChannel underlyingChannel;
    private final OSCParser parser;
    private final OSCSerializerAndParserBuilder serializerBuilder;

    public OSCDatagramChannel(DatagramChannel underlyingChannel, OSCSerializerAndParserBuilder serializerAndParserBuilder) {
        this.underlyingChannel = underlyingChannel;
        OSCParser tmpParser = null;
        if (serializerAndParserBuilder != null) {
            tmpParser = serializerAndParserBuilder.buildParser();
        }
        this.parser = tmpParser;
        this.serializerBuilder = serializerAndParserBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCPacket read(ByteBuffer buffer) throws IOException, OSCParseException {
        OSCPacket oscPacket;
        boolean completed = false;
        try {
            this.begin();
            buffer.clear();
            if (this.underlyingChannel.isConnected()) {
                this.underlyingChannel.read(buffer);
            } else {
                this.underlyingChannel.receive(buffer);
            }
            buffer.flip();
            if (buffer.limit() == 0) {
                throw new OSCParseException("Received a packet without any data", buffer);
            }
            oscPacket = this.parser.convert(buffer);
            completed = true;
        }
        finally {
            this.end(completed);
        }
        return oscPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer buffer, OSCPacket packet, SocketAddress remoteAddress2) throws IOException, OSCSerializeException {
        boolean completed = false;
        try {
            this.begin();
            OSCSerializer serializer2 = this.serializerBuilder.buildSerializer(new BufferBytesReceiver(buffer));
            buffer.rewind();
            serializer2.write(packet);
            buffer.flip();
            if (this.underlyingChannel.isConnected()) {
                this.underlyingChannel.write(buffer);
            } else {
                if (remoteAddress2 == null) {
                    throw new IllegalStateException("Not connected and no remote address is given");
                }
                this.underlyingChannel.send(buffer, remoteAddress2);
            }
            completed = true;
        }
        finally {
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buffer, OSCPacket packet) throws IOException, OSCSerializeException {
        boolean completed = false;
        try {
            this.begin();
            if (!this.underlyingChannel.isConnected()) {
                throw new IllegalStateException("Either connect the channel or use write()");
            }
            this.send(buffer, packet, null);
            completed = true;
        }
        finally {
            this.end(completed);
        }
    }

    @Override
    public SelectorProvider provider() {
        return this.underlyingChannel.provider();
    }

    @Override
    public boolean isRegistered() {
        return this.underlyingChannel.isRegistered();
    }

    @Override
    public SelectionKey keyFor(Selector sel) {
        return this.underlyingChannel.keyFor(sel);
    }

    @Override
    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.underlyingChannel.register(sel, ops, att);
    }

    @Override
    public SelectableChannel configureBlocking(boolean block2) throws IOException {
        return this.underlyingChannel.configureBlocking(block2);
    }

    @Override
    public boolean isBlocking() {
        return this.underlyingChannel.isBlocking();
    }

    @Override
    public Object blockingLock() {
        return this.underlyingChannel.blockingLock();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.underlyingChannel.close();
    }

    @Override
    public int validOps() {
        return this.underlyingChannel.validOps();
    }
}

