/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.transport.tcp;

import com.illposed.osc.ByteArrayListBytesReceiver;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCParser;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.OSCSerializer;
import com.illposed.osc.OSCSerializerAndParserBuilder;
import com.illposed.osc.transport.Transport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;

public class TCPTransport
implements Transport {
    private final InetSocketAddress local;
    private final InetSocketAddress remote;
    private final OSCParser parser;
    private final ByteArrayListBytesReceiver serializationBuffer;
    private final OSCSerializer serializer;
    private Socket clientSocket;
    private ServerSocket serverSocket;

    public TCPTransport(InetSocketAddress local, InetSocketAddress remote) throws IOException {
        this(local, remote, new OSCSerializerAndParserBuilder());
    }

    public TCPTransport(InetSocketAddress local, InetSocketAddress remote, OSCSerializerAndParserBuilder builder) throws IOException {
        this.local = local;
        this.remote = remote;
        this.parser = builder.buildParser();
        this.serializationBuffer = new ByteArrayListBytesReceiver();
        this.serializer = builder.buildSerializer(this.serializationBuffer);
        this.clientSocket = null;
        this.serverSocket = null;
    }

    private Socket getClientSocket() throws IOException {
        if (this.clientSocket == null || this.clientSocket.isClosed()) {
            this.clientSocket = new Socket();
        }
        return this.clientSocket;
    }

    private ServerSocket getServerSocket() throws IOException {
        if (this.serverSocket == null || this.serverSocket.isClosed()) {
            this.serverSocket = new ServerSocket();
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.bind(this.local);
        }
        return this.serverSocket;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() throws IOException {
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    public boolean isListening() throws IOException {
        boolean listening;
        try {
            new Socket(this.local.getAddress(), this.local.getPort()).close();
            listening = true;
        }
        catch (ConnectException cex) {
            listening = false;
        }
        return listening;
    }

    @Override
    public void close() throws IOException {
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Override
    public void send(OSCPacket packet) throws IOException, OSCSerializeException {
        this.serializer.write(packet);
        Socket clientSock = this.getClientSocket();
        if (!clientSock.isConnected()) {
            clientSock.connect(this.remote);
        }
        try (OutputStream out2 = clientSock.getOutputStream();){
            this.serializationBuffer.writeTo(out2);
        }
    }

    private byte[] readAllBytes(InputStream inputStream2) throws IOException {
        try (ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();){
            int readLen;
            int bufLen = 4096;
            byte[] buffer = new byte[4096];
            while ((readLen = inputStream2.read(buffer, 0, 4096)) != -1) {
                outputStream2.write(buffer, 0, readLen);
            }
            byte[] byArray = outputStream2.toByteArray();
            return byArray;
        }
    }

    @Override
    public OSCPacket receive() throws IOException, OSCParseException {
        Socket dataSocket;
        byte[] bytes;
        ServerSocket serverSock = this.getServerSocket();
        while ((bytes = this.readAllBytes((dataSocket = serverSock.accept()).getInputStream())).length == 0) {
        }
        return this.parser.convert(ByteBuffer.wrap(bytes));
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    public String toString() {
        return String.format("%s: local=%s, remote=%s", this.getClass().getSimpleName(), this.local, this.remote);
    }
}

