/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import io.github.axisangles.ktmath.Vector3;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\bG\n\u0002\u0010\n\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J%\u0010!\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020%2\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\u001e\u0010(\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J%\u0010(\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020%2\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b)\u0010'J6\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J=\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%\u00a2\u0006\u0004\b1\u00102J.\u00103\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J5\u00103\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%\u00a2\u0006\u0004\b4\u00105JE\u00106\u001a\u00020\u00072\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%2\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007\u00a2\u0006\u0004\b:\u0010;J-\u0010<\u001a\u00020\u00072\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%\u00a2\u0006\u0004\b=\u0010>J\u000e\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007J'\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020%2\b\u0010C\u001a\u0004\u0018\u00010%2\u0006\u0010D\u001a\u00020%\u00a2\u0006\u0004\bE\u0010FJ\u0086\u0001\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\u00052\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u0005J\u0015\u0010X\u001a\u00020%2\u0006\u0010Y\u001a\u00020%\u00a2\u0006\u0004\bZ\u0010[J\u0015\u0010\\\u001a\u00020%2\u0006\u0010]\u001a\u00020%\u00a2\u0006\u0004\b^\u0010[J\u0015\u0010_\u001a\u00020%2\u0006\u0010Y\u001a\u00020%\u00a2\u0006\u0004\b`\u0010[J\u0015\u0010a\u001a\u00020%2\u0006\u0010]\u001a\u00020%\u00a2\u0006\u0004\bb\u0010[J \u0010c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u0007H\u0007J\u0016\u0010f\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010g\u001a\u00020\u0007J \u0010h\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u0007H\u0007J\u000e\u0010j\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u000e\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020mJ\u000e\u0010n\u001a\u00020m2\u0006\u0010o\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006p"}, d2={"Lcom/jme3/math/FastMath;", "", "<init>", "()V", "DBL_EPSILON", "", "FLT_EPSILON", "", "ZERO_TOLERANCE", "ONE_THIRD", "PI", "TWO_PI", "HALF_PI", "QUARTER_PI", "INV_PI", "INV_TWO_PI", "DEG_TO_RAD", "RAD_TO_DEG", "rand", "Ljava/util/Random;", "getRand", "()Ljava/util/Random;", "isApproxZero", "", "value", "tolerance", "isApproxEqual", "valueOne", "valueTwo", "isPowerOfTwo", "number", "", "nearestPowerOfTwo", "interpolateLinear", "scale", "startValue", "endValue", "Lio/github/axisangles/ktmath/Vector3;", "interpolateLinear-kkCv5LM", "(FFFFFFF)Lio/github/axisangles/ktmath/Vector3;", "extrapolateLinear", "extrapolateLinear-kkCv5LM", "interpolateCatmullRom", "u", "T", "p0", "p1", "p2", "p3", "interpolateCatmullRom-qhKgqnk", "(FFFFFFFFFFFFFF)Lio/github/axisangles/ktmath/Vector3;", "interpolateBezier", "interpolateBezier-rNrCmzo", "(FFFFFFFFFFFFF)Lio/github/axisangles/ktmath/Vector3;", "getCatmullRomP1toP2Length", "startRange", "endRange", "curveTension", "getCatmullRomP1toP2Length--zib6Ao", "(FFFFFFFFFFFFFFF)F", "getBezierP1toP2Length", "getBezierP1toP2Length-s_ffMxU", "(FFFFFFFFFFFF)F", "fastInvSqrt", "x", "computeNormal", "v1", "v2", "v3", "computeNormal-OO2gT7M", "(FFFLio/github/axisangles/ktmath/Vector3;FFF)Lio/github/axisangles/ktmath/Vector3;", "determinant", "m00", "m01", "m02", "m03", "m10", "m11", "m12", "m13", "m20", "m21", "m22", "m23", "m30", "m31", "m32", "m33", "sphericalToCartesian", "sphereCoords", "sphericalToCartesian-1s-5YWc", "(FFF)Lio/github/axisangles/ktmath/Vector3;", "cartesianToSpherical", "cartCoords", "cartesianToSpherical-1s-5YWc", "sphericalToCartesianZ", "sphericalToCartesianZ-1s-5YWc", "cartesianZToSpherical", "cartesianZToSpherical-1s-5YWc", "normalize", "min", "max", "copysign", "y", "clamp", "input", "saturate", "convertHalfToFloat", "half", "", "convertFloatToHalf", "flt", "core"})
public final class FastMath {
    @NotNull
    public static final FastMath INSTANCE = new FastMath();
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float ZERO_TOLERANCE = 1.0E-4f;
    public static final float ONE_THIRD = 0.33333334f;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float INV_PI = 0.31830987f;
    public static final float INV_TWO_PI = 0.15915494f;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    @NotNull
    private static final Random rand = new Random(System.currentTimeMillis());

    private FastMath() {
    }

    @NotNull
    public final Random getRand() {
        return rand;
    }

    public final boolean isApproxZero(float value, float tolerance) {
        return value < tolerance && value > -tolerance;
    }

    public final boolean isApproxZero(float value) {
        return this.isApproxZero(value, 1.0E-4f);
    }

    public final boolean isApproxEqual(float valueOne, float valueTwo, float tolerance) {
        return this.isApproxZero(valueTwo - valueOne, tolerance);
    }

    public final boolean isApproxEqual(float valueOne, float valueTwo) {
        return this.isApproxEqual(valueOne, valueTwo, 1.0E-4f);
    }

    public final boolean isPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    public final int nearestPowerOfTwo(int number) {
        return (int)Math.pow(2.0, Math.ceil(Math.log(number) / Math.log(2.0)));
    }

    public final float interpolateLinear(float scale, float startValue, float endValue) {
        if (startValue == endValue) {
            return startValue;
        }
        if (scale <= 0.0f) {
            return startValue;
        }
        if (scale >= 1.0f) {
            return endValue;
        }
        return (1.0f - scale) * startValue + scale * endValue;
    }

    @NotNull
    public final Vector3 interpolateLinear-kkCv5LM(float scale, float f, float f2, float f3, float f4, float f5, float f6) {
        float x = this.interpolateLinear(scale, f, f4);
        float y = this.interpolateLinear(scale, f2, f5);
        float z = this.interpolateLinear(scale, f3, f6);
        float f7 = x;
        float f8 = y;
        float f9 = z;
        Vector3.constructor-impl(f7, f8, f9);
        return Vector3.box-impl(f7, f8, f9);
    }

    public final float extrapolateLinear(float scale, float startValue, float endValue) {
        return (1.0f - scale) * startValue + scale * endValue;
    }

    @NotNull
    public final Vector3 extrapolateLinear-kkCv5LM(float scale, float f, float f2, float f3, float f4, float f5, float f6) {
        float x = this.extrapolateLinear(scale, f, f4);
        float y = this.extrapolateLinear(scale, f2, f5);
        float z = this.extrapolateLinear(scale, f3, f6);
        float f7 = x;
        float f8 = y;
        float f9 = z;
        Vector3.constructor-impl(f7, f8, f9);
        return Vector3.box-impl(f7, f8, f9);
    }

    public final float interpolateCatmullRom(float u, float T, float p0, float p1, float p2, float p3) {
        float c1 = p1;
        float c2 = -1.0f * T * p0 + T * p2;
        float c3 = (float)2 * T * p0 + (T - (float)3) * p1 + ((float)3 - (float)2 * T) * p2 + -T * p3;
        float c4 = -T * p0 + ((float)2 - T) * p1 + (T - (float)2) * p2 + T * p3;
        return ((c4 * u + c3) * u + c2) * u + c1;
    }

    @NotNull
    public final Vector3 interpolateCatmullRom-qhKgqnk(float u, float T, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float x = this.interpolateCatmullRom(u, T, f, f4, f7, f10);
        float y = this.interpolateCatmullRom(u, T, f2, f5, f8, f11);
        float z = this.interpolateCatmullRom(u, T, f3, f6, f9, f12);
        float f13 = x;
        float f14 = y;
        float f15 = z;
        Vector3.constructor-impl(f13, f14, f15);
        return Vector3.box-impl(f13, f14, f15);
    }

    public final float interpolateBezier(float u, float p0, float p1, float p2, float p3) {
        float oneMinusU = 1.0f - u;
        float oneMinusU2 = oneMinusU * oneMinusU;
        float u2 = u * u;
        return p0 * oneMinusU2 * oneMinusU + 3.0f * p1 * u * oneMinusU2 + 3.0f * p2 * u2 * oneMinusU + p3 * u2 * u;
    }

    @NotNull
    public final Vector3 interpolateBezier-rNrCmzo(float u, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float x = this.interpolateBezier(u, f, f4, f7, f10);
        float y = this.interpolateBezier(u, f2, f5, f8, f11);
        float z = this.interpolateBezier(u, f3, f6, f9, f12);
        float f13 = x;
        float f14 = y;
        float f15 = z;
        Vector3.constructor-impl(f13, f14, f15);
        return Vector3.box-impl(f13, f14, f15);
    }

    public final float getCatmullRomP1toP2Length--zib6Ao(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float startRange, float endRange, float curveTension) {
        Vector3 vector3;
        float l2;
        Vector3 vector32;
        float l1;
        float len;
        float f13;
        float f14;
        float f15;
        Vector3 vector33;
        float epsilon = 0.001f;
        float middleValue = (startRange + endRange) * 0.5f;
        Vector3.Companion companion = Vector3.Companion;
        float f16 = companion.getNULL-x();
        float f17 = companion.getNULL-y();
        float f18 = companion.getNULL-z();
        Vector3.Companion companion2 = Vector3.Companion;
        float f19 = companion2.getNULL-x();
        float f20 = companion2.getNULL-y();
        float f21 = companion2.getNULL-z();
        if (!(startRange == 0.0f)) {
            vector33 = this.interpolateCatmullRom-qhKgqnk(startRange, curveTension, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
            f15 = vector33.unbox-impl-x();
            f14 = vector33.unbox-impl-y();
            f13 = vector33.unbox-impl-z();
            f16 = f15;
            f17 = f14;
            f18 = f13;
        }
        if (!(endRange == 1.0f)) {
            vector33 = this.interpolateCatmullRom-qhKgqnk(endRange, curveTension, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
            f15 = vector33.unbox-impl-x();
            f14 = vector33.unbox-impl-y();
            f13 = vector33.unbox-impl-z();
            f19 = f15;
            f20 = f14;
            f21 = f13;
        }
        vector33 = this.interpolateCatmullRom-qhKgqnk(middleValue, curveTension, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        float f22 = vector33.unbox-impl-x();
        float f23 = vector33.unbox-impl-y();
        float f24 = vector33.unbox-impl-z();
        Vector3 vector34 = Vector3.minus-1s-5YWc(f19, f20, f21, f16, f17, f18);
        float l = Vector3.len-impl(vector34.unbox-impl-x(), vector34.unbox-impl-y(), vector34.unbox-impl-z());
        if (l + epsilon < (len = (l1 = Vector3.len-impl((vector32 = Vector3.minus-1s-5YWc(f22, f23, f24, f16, f17, f18)).unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z())) + (l2 = Vector3.len-impl((vector3 = Vector3.minus-1s-5YWc(f19, f20, f21, f22, f23, f24)).unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z())))) {
            l1 = this.getCatmullRomP1toP2Length--zib6Ao(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, startRange, middleValue, curveTension);
            l2 = this.getCatmullRomP1toP2Length--zib6Ao(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, middleValue, endRange, curveTension);
        }
        l = l1 + l2;
        return l;
    }

    public final float getBezierP1toP2Length-s_ffMxU(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        p0-x = f;
        p0-y = f2;
        p0-z = f3;
        float delta = 0.02f;
        float result = 0.0f;
        for (float t = 0.0f; t <= 1.0f; t += delta) {
            Vector3 vector3 = this.interpolateBezier-rNrCmzo(t, p0-x, p0-y, p0-z, f4, f5, f6, f7, f8, f9, f10, f11, f12);
            float f13 = vector3.unbox-impl-x();
            float f14 = vector3.unbox-impl-y();
            float f15 = vector3.unbox-impl-z();
            Vector3 vector32 = Vector3.minus-1s-5YWc(p0-x, p0-y, p0-z, f13, f14, f15);
            result += Vector3.len-impl(vector32.unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z());
            p0-x = f13;
            p0-y = f14;
            p0-z = f15;
        }
        return result;
    }

    public final float fastInvSqrt(float x) {
        float x2 = x;
        float xhalf = 0.5f * x2;
        int i = Float.floatToIntBits(x2);
        i = 1597463174 - (i >> 1);
        x2 = Float.intBitsToFloat(i);
        x2 *= 1.5f - xhalf * x2 * x2;
        return x2;
    }

    @NotNull
    public final Vector3 computeNormal-OO2gT7M(float f, float f2, float f3, @Nullable Vector3 v2, float f4, float f5, float f6) {
        Vector3 vector3 = v2;
        Intrinsics.checkNotNull(vector3);
        Vector3 vector32 = vector3;
        Vector3 vector33 = Vector3.minus-1s-5YWc(f, f2, f3, vector32.unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z());
        float f7 = vector33.unbox-impl-x();
        float f8 = vector33.unbox-impl-y();
        float f9 = vector33.unbox-impl-z();
        Vector3 vector34 = Vector3.minus-1s-5YWc(f4, f5, f6, v2.unbox-impl-x(), v2.unbox-impl-y(), v2.unbox-impl-z());
        float f10 = vector34.unbox-impl-x();
        float f11 = vector34.unbox-impl-y();
        float f12 = vector34.unbox-impl-z();
        Vector3 vector35 = Vector3.cross-1s-5YWc(f10, f11, f12, f7, f8, f9);
        return Vector3.unit-impl(vector35.unbox-impl-x(), vector35.unbox-impl-y(), vector35.unbox-impl-z());
    }

    public final float determinant(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        double det01 = m20 * m31 - m21 * m30;
        double det02 = m20 * m32 - m22 * m30;
        double det03 = m20 * m33 - m23 * m30;
        double det12 = m21 * m32 - m22 * m31;
        double det13 = m21 * m33 - m23 * m31;
        double det23 = m22 * m33 - m23 * m32;
        return (float)(m00 * (m11 * det23 - m12 * det13 + m13 * det12) - m01 * (m10 * det23 - m12 * det03 + m13 * det02) + m02 * (m10 * det13 - m11 * det03 + m13 * det01) - m03 * (m10 * det12 - m11 * det02 + m12 * det01));
    }

    @NotNull
    public final Vector3 sphericalToCartesian-1s-5YWc(float f, float f2, float f3) {
        float y = f * (float)Math.sin(f3);
        float a = f * (float)Math.cos(f3);
        float x = a * (float)Math.cos(f2);
        float z = a * (float)Math.sin(f2);
        float f4 = x;
        float f5 = y;
        float f6 = z;
        Vector3.constructor-impl(f4, f5, f6);
        return Vector3.box-impl(f4, f5, f6);
    }

    @NotNull
    public final Vector3 cartesianToSpherical-1s-5YWc(float f, float f2, float f3) {
        float x = f;
        if (x == 0.0f) {
            x = 1.1920929E-7f;
        }
        float vx = (float)Math.sqrt(x * x + f2 * f2 + f3 * f3);
        float vy = (float)Math.atan(f3 / x);
        if (x < 0.0f) {
            vy += (float)Math.PI;
        }
        float vz = (float)Math.asin(f2 / vx);
        float f4 = vx;
        float f5 = vy;
        float f6 = vz;
        Vector3.constructor-impl(f4, f5, f6);
        return Vector3.box-impl(f4, f5, f6);
    }

    @NotNull
    public final Vector3 sphericalToCartesianZ-1s-5YWc(float f, float f2, float f3) {
        float z = f * (float)Math.sin(f3);
        float a = f * (float)Math.cos(f3);
        float x = a * (float)Math.cos(f2);
        float y = a * (float)Math.sin(f2);
        float f4 = x;
        float f5 = y;
        float f6 = z;
        Vector3.constructor-impl(f4, f5, f6);
        return Vector3.box-impl(f4, f5, f6);
    }

    @NotNull
    public final Vector3 cartesianZToSpherical-1s-5YWc(float f, float f2, float f3) {
        float x = f;
        if (x == 0.0f) {
            x = 1.1920929E-7f;
        }
        float vx = (float)Math.sqrt(x * x + f2 * f2 + f3 * f3);
        float vz = (float)Math.atan(f3 / x);
        if (x < 0.0f) {
            vz += (float)Math.PI;
        }
        float vy = (float)Math.asin(f2 / vx);
        float f4 = vx;
        float f5 = vy;
        float f6 = vz;
        Vector3.constructor-impl(f4, f5, f6);
        return Vector3.box-impl(f4, f5, f6);
    }

    @JvmStatic
    public static final float normalize(float value, float min, float max) {
        float v = value;
        if (Float.isInfinite(v) || Float.isNaN(v)) {
            return 0.0f;
        }
        float range = max - min;
        while (v > max) {
            v -= range;
        }
        while (v < min) {
            v += range;
        }
        return v;
    }

    public final float copysign(float x, float y) {
        return y >= 0.0f && x <= 0.0f ? -x : (y < 0.0f && x >= 0.0f ? -x : x);
    }

    @JvmStatic
    public static final float clamp(float input, float min, float max) {
        return input < min ? min : (input > max ? max : input);
    }

    public final float saturate(float input) {
        return FastMath.clamp(input, 0.0f, 1.0f);
    }

    public final float convertHalfToFloat(short half) {
        return switch (half) {
            case 0 -> 0.0f;
            case 32768 -> -0.0f;
            case 31744 -> Float.POSITIVE_INFINITY;
            case 64512 -> Float.NEGATIVE_INFINITY;
            default -> Float.intBitsToFloat((half & 0x8000) << 16 | (half & 0x7C00) + 114688 << 13 | (half & 0x3FF) << 13);
        };
    }

    public final short convertFloatToHalf(float flt) {
        if (Float.isNaN(flt)) {
            throw new UnsupportedOperationException("NaN to half conversion not supported!");
        }
        if (flt == Float.POSITIVE_INFINITY) {
            return 31744;
        }
        if (flt == Float.NEGATIVE_INFINITY) {
            return -1024;
        }
        if (flt == 0.0f) {
            return 0;
        }
        if (flt == -0.0f) {
            return Short.MIN_VALUE;
        }
        if (flt > 65504.0f) {
            return 31743;
        }
        if (flt < -65504.0f) {
            return -1025;
        }
        if (flt > 0.0f && flt < 5.96046E-8f) {
            return 1;
        }
        if (flt < 0.0f && flt > -5.96046E-8f) {
            return -32767;
        }
        int f = Float.floatToIntBits(flt);
        return (short)(f >> 16 & 0x8000 | (f & 0x7F800000) - 0x38000000 >> 13 & 0x7C00 | f >> 13 & 0x3FF);
    }
}

