/*
 * Decompiled with CFR 0.152.
 */
package com.mayakapps.kache.collection;

import com.mayakapps.kache.annotation.IntRange;
import com.mayakapps.kache.collection.ObjectList;
import com.mayakapps.kache.collection.ObjectListKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003567B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0019\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J#\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dJ\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\r\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010!J\u0017\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0086\u0002J\u001c\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u0017\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0086\u0002J\u0017\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0086\u0002J\u0017\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0086\u0002J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010!J\u0017\u0010#\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0086\u0002J\u001c\u0010#\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u0017\u0010#\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0086\u0002J\u0017\u0010#\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0086\u0002J\u0017\u0010#\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0086\u0002J\u0013\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0019\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0015\u0010&\u001a\u00028\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0002\u0010'J/\u0010(\u001a\u00020\u000f2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0*H\u0086\b\u00f8\u0001\u0000J\u001a\u0010-\u001a\u00020\u000f2\b\b\u0001\u0010.\u001a\u00020\u00042\b\b\u0001\u0010/\u001a\u00020\u0004J\u0014\u00100\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0019\u00100\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0015J\u0014\u00100\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0014\u00100\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u00100\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ \u00101\u001a\u00028\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u000f2\b\b\u0002\u00104\u001a\u00020\u0004R\u0012\u0010\u0006\u001a\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00068"}, d2={"Lcom/mayakapps/kache/collection/MutableObjectList;", "E", "Lcom/mayakapps/kache/collection/ObjectList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "list", "Lcom/mayakapps/kache/collection/MutableObjectList$ObjectListMutableList;", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "([Ljava/lang/Object;)Z", "(I[Ljava/lang/Object;)Z", "", "", "", "Lkotlin/sequences/Sequence;", "asList", "asMutableList", "", "clear", "ensureCapacity", "minusAssign", "(Ljava/lang/Object;)V", "([Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "(I)Ljava/lang/Object;", "removeIf", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "removeRange", "start", "end", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "trim", "minCapacity", "MutableObjectListIterator", "ObjectListMutableList", "SubList", "kache"})
@SourceDebugExtension(value={"SMAP\nObjectList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectList.kt\ncom/mayakapps/kache/collection/MutableObjectList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ObjectList.kt\ncom/mayakapps/kache/collection/ObjectList\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1635:1\n965#1,2:1640\n965#1,2:1644\n669#1:1647\n972#1,2:1650\n972#1,2:1657\n972#1,2:1660\n972#1,2:1663\n972#1,2:1667\n1864#2,3:1636\n1855#2:1639\n1856#2:1642\n1855#2:1662\n1856#2:1665\n1313#3:1643\n1314#3:1646\n1313#3:1666\n1314#3:1669\n97#4:1648\n322#4,4:1653\n327#4:1659\n92#4:1670\n92#4:1671\n92#4:1672\n92#4:1673\n92#4:1674\n92#4:1675\n92#4:1676\n92#4:1677\n13309#5:1649\n13310#5:1652\n*S KotlinDebug\n*F\n+ 1 ObjectList.kt\ncom/mayakapps/kache/collection/MutableObjectList\n*L\n915#1:1640,2\n924#1:1644,2\n944#1:1647\n1067#1:1650,2\n1076#1:1657,2\n1094#1:1660,2\n1103#1:1663,2\n1112#1:1667,2\n757#1:1636,3\n914#1:1639\n914#1:1642\n1102#1:1662\n1102#1:1665\n923#1:1643\n923#1:1646\n1111#1:1666\n1111#1:1669\n996#1:1648\n1075#1:1653,4\n1075#1:1659\n1122#1:1670\n1126#1:1671\n1176#1:1672\n1192#1:1673\n1208#1:1674\n1224#1:1675\n1240#1:1676\n1259#1:1677\n1066#1:1649\n1066#1:1652\n*E\n"})
public final class MutableObjectList<E>
extends ObjectList<E> {
    @Nullable
    private ObjectListMutableList<E> list;

    public MutableObjectList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableObjectList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(E element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index, E element) {
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        this.ensureCapacity(this._size + 1);
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto(content, content, index + 1, index, this._size);
        }
        content[index] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index, @NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto(content, content, index + elements.length, index, this._size);
        }
        ArraysKt.copyInto$default(elements, content, index, 0, 0, 12, null);
        this._size += elements.length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@IntRange(from=0L) int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this._size + elements.size());
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto(content, content, index + elements.size(), index, this._size);
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            content[index + i] = element;
        }
        this._size += elements.size();
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index, @NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto(content, content, index + elements._size, index, this._size);
        }
        ArraysKt.copyInto(elements.content, content, index, 0, elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final void plusAssign(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isEmpty()) {
            return;
        }
        this.ensureCapacity(this._size + elements._size);
        Object[] content = this.content;
        ArraysKt.copyInto(elements.content, content, this._size, 0, elements._size);
        this._size += elements._size;
    }

    public final void plusAssign(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.length == 0) {
            return;
        }
        this.ensureCapacity(this._size + elements.length);
        Object[] content = this.content;
        ArraysKt.copyInto$default(elements, content, this._size, 0, 0, 12, null);
        this._size += elements.length;
    }

    public final void plusAssign(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isEmpty()) {
            return;
        }
        int size2 = this._size;
        this.ensureCapacity(size2 + elements.size());
        Object[] content = this.content;
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            content[i + size2] = elements.get(i);
        }
        this._size += elements.size();
    }

    public final void plusAssign(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterable<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$plusAssign = false;
            this_$iv.add(element);
        }
    }

    public final void plusAssign(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Sequence<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$plusAssign = false;
            this_$iv.add(element);
        }
    }

    public final void clear() {
        ArraysKt.fill(this.content, null, 0, this._size);
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableObjectList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            Object[] objectArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            this.content = objectArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableObjectList mutableObjectList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableObjectList._size;
        }
        mutableObjectList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        Object[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            Object[] objectArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            this.content = objectArray;
        }
    }

    public final void plusAssign(E element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(E element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(E element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final void removeIf(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$removeIf = false;
        int gap = 0;
        int size2 = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getIndices = false;
        kotlin.ranges.IntRange intRange = RangesKt.until(0, this_$iv._size);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                content[i - gap] = content[i];
                if (predicate.invoke(content[i]).booleanValue()) {
                    ++gap;
                }
                if (i == n) break;
                ++i;
            }
        }
        ArraysKt.fill(content, null, size2 - gap, size2);
        this._size -= gap;
    }

    public final boolean removeAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            this.remove(elements[i]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        E[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            E element$iv;
            E element = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final void minusAssign(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        ObjectList<E> this_$iv = elements;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object element = content$iv[i$iv];
            boolean bl = false;
            MutableObjectList this_$iv2 = this;
            boolean $i$f$minusAssign = false;
            this_$iv2.remove(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void minusAssign(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            void this_$iv;
            MutableObjectList mutableObjectList = this;
            E element$iv = elements.get(i);
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element$iv);
        }
    }

    public final void minusAssign(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterable<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final void minusAssign(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Sequence<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final E removeAt(@IntRange(from=0L) int index) {
        if (!(0 <= index ? index < this._size : false)) {
            ObjectList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + (this_$iv._size - 1));
        }
        Object[] content = this.content;
        Object element = content[index];
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index != this_$iv._size - 1) {
            ArraysKt.copyInto(content, content, index, index + 1, this._size);
        }
        int n = this._size;
        this._size = n + -1;
        content[this._size] = null;
        return (E)element;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end2) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end2 ? end2 <= this._size : false) break block7;
            }
            throw new IndexOutOfBoundsException("Start (" + start2 + ") and end (" + end2 + ") must be in 0.." + this._size);
        }
        if (end2 < start2) {
            throw new IllegalArgumentException("Start (" + start2 + ") is more than end (" + end2 + ')');
        }
        if (end2 != start2) {
            if (end2 < this._size) {
                ArraysKt.copyInto(this.content, this.content, start2, end2, this._size);
            }
            int newSize = this._size - (end2 - start2);
            ArraysKt.fill(this.content, null, newSize, this._size);
            this._size = newSize;
        }
    }

    public final boolean retainAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (ArraysKt.indexOf(elements, element) >= 0) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (elements.contains(element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (elements.contains(element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (CollectionsKt.contains(elements, element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (SequencesKt.contains(elements, element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final E set(@IntRange(from=0L) int index, E element) {
        if (!(0 <= index ? index < this._size : false)) {
            ObjectList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("set index " + index + " must be between 0 .. " + (this_$iv._size - 1));
        }
        Object[] content = this.content;
        Object old = content[index];
        content[index] = element;
        return (E)old;
    }

    @Override
    @NotNull
    public List<E> asList() {
        return this.asMutableList();
    }

    @NotNull
    public final List<E> asMutableList() {
        List list;
        ObjectListMutableList<E> objectListMutableList = this.list;
        if (objectListMutableList != null) {
            list = objectListMutableList;
        } else {
            ObjectListMutableList objectListMutableList2;
            ObjectListMutableList it = objectListMutableList2 = new ObjectListMutableList(this);
            boolean bl = false;
            this.list = it;
            list = objectListMutableList2;
        }
        return list;
    }

    public MutableObjectList() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\r\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mayakapps/kache/collection/MutableObjectList$MutableObjectListIterator;", "T", "", "list", "", "index", "", "(Ljava/util/List;I)V", "prevIndex", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "kache"})
    private static final class MutableObjectListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final List<T> list;
        private int prevIndex;

        public MutableObjectListIterator(@NotNull List<T> list, int index) {
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = list;
            this.prevIndex = index - 1;
        }

        @Override
        public boolean hasNext() {
            return this.prevIndex < this.list.size() - 1;
        }

        @Override
        public T next() {
            ++this.prevIndex;
            return this.list.get(this.prevIndex);
        }

        @Override
        public void remove() {
            this.list.remove(this.prevIndex);
            int n = this.prevIndex;
            this.prevIndex = n + -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.prevIndex >= 0;
        }

        @Override
        public int nextIndex() {
            return this.prevIndex + 1;
        }

        @Override
        public T previous() {
            int n = this.prevIndex;
            this.prevIndex = n + -1;
            return this.list.get(n);
        }

        @Override
        public int previousIndex() {
            return this.prevIndex;
        }

        @Override
        public void add(T element) {
            ++this.prevIndex;
            this.list.add(this.prevIndex, element);
        }

        @Override
        public void set(T element) {
            this.list.set(this.prevIndex, element);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\"\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u001e\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006*"}, d2={"Lcom/mayakapps/kache/collection/MutableObjectList$ObjectListMutableList;", "T", "", "objectList", "Lcom/mayakapps/kache/collection/MutableObjectList;", "(Lcom/mayakapps/kache/collection/MutableObjectList;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "kache"})
    private static final class ObjectListMutableList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final MutableObjectList<T> objectList;

        public ObjectListMutableList(@NotNull MutableObjectList<T> objectList) {
            Intrinsics.checkNotNullParameter(objectList, "objectList");
            this.objectList = objectList;
        }

        public int getSize() {
            return this.objectList.getSize();
        }

        @Override
        public boolean contains(Object element) {
            return this.objectList.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            return this.objectList.containsAll((Iterable)elements);
        }

        @Override
        public T get(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return (T)this.objectList.get(index);
        }

        @Override
        public int indexOf(Object element) {
            return this.objectList.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.objectList.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.objectList.lastIndexOf(element);
        }

        @Override
        public boolean add(T element) {
            return this.objectList.add(element);
        }

        @Override
        public void add(int index, T element) {
            this.objectList.add(index, element);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            return this.objectList.addAll(index, elements);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            return this.objectList.addAll((Iterable)elements);
        }

        @Override
        public void clear() {
            this.objectList.clear();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new MutableObjectListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            return this.objectList.remove(element);
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            return this.objectList.removeAll((Iterable)elements);
        }

        public T removeAt(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return this.objectList.removeAt(index);
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            return this.objectList.retainAll(elements);
        }

        @Override
        public T set(int index, T element) {
            ObjectListKt.access$checkIndex(this, index);
            return this.objectList.set(index, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            ObjectListKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            return CollectionToArray.toArray(this, array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002J\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/mayakapps/kache/collection/MutableObjectList$SubList;", "T", "", "list", "start", "", "end", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "kache"})
    @SourceDebugExtension(value={"SMAP\nObjectList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectList.kt\ncom/mayakapps/kache/collection/MutableObjectList$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1635:1\n1855#2,2:1636\n1855#2,2:1638\n*S KotlinDebug\n*F\n+ 1 ObjectList.kt\ncom/mayakapps/kache/collection/MutableObjectList$SubList\n*L\n1412#1:1636,2\n1494#1:1638,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final List<T> list;
        private final int start;
        private int end;

        public SubList(@NotNull List<T> list, int start2, int end2) {
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = list;
            this.start = start2;
            this.end = end2;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.contains(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public T get(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return this.list.get(index + this.start);
        }

        @Override
        public int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        @Override
        public boolean add(T element) {
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, element);
            return true;
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index + this.start, element);
            int n = this.end;
            this.end = n + 1;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.list.addAll(index + this.start, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.list.addAll(this.end, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new MutableObjectListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), element)) continue;
                this.list.remove(i);
                int n2 = this.end;
                this.end = n2 + -1;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            int originalEnd = this.end;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.remove(it);
            }
            return originalEnd != this.end;
        }

        public T removeAt(int index) {
            ObjectListKt.access$checkIndex(this, index);
            T element = this.list.remove(index + this.start);
            int n = this.end;
            this.end = n + -1;
            return element;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T element;
                    if (!elements.contains(element = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return originalEnd != this.end;
        }

        @Override
        public T set(int index, T element) {
            ObjectListKt.access$checkIndex(this, index);
            return this.list.set(index + this.start, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            ObjectListKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            return CollectionToArray.toArray(this, array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray(this);
        }
    }
}

