/*
 * Decompiled with CFR 0.152.
 */
package dev.llelievr.espflashkotlin;

import dev.llelievr.espflashkotlin.Command;
import dev.llelievr.espflashkotlin.Direction;
import dev.llelievr.espflashkotlin.Packet;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003J;\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0006\u0010'\u001a\u00020\u000bJ\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\tH\u00d6\u0001J\b\u0010,\u001a\u00020-H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Ldev/llelievr/espflashkotlin/CommandPacket;", "", "direction", "Ldev/llelievr/espflashkotlin/Direction;", "command", "Ldev/llelievr/espflashkotlin/Command;", "size", "", "checksum", "", "data", "", "(Ldev/llelievr/espflashkotlin/Direction;Ldev/llelievr/espflashkotlin/Command;SI[B)V", "getChecksum", "()I", "setChecksum", "(I)V", "getCommand", "()Ldev/llelievr/espflashkotlin/Command;", "setCommand", "(Ldev/llelievr/espflashkotlin/Command;)V", "getData", "()[B", "setData", "([B)V", "getDirection", "()Ldev/llelievr/espflashkotlin/Direction;", "setDirection", "(Ldev/llelievr/espflashkotlin/Direction;)V", "getSize", "()S", "setSize", "(S)V", "component1", "component2", "component3", "component4", "component5", "copy", "encode", "equals", "", "other", "hashCode", "toString", "", "Companion", "espflashkotlin"})
public final class CommandPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Direction direction;
    @NotNull
    private Command command;
    private short size;
    private int checksum;
    @NotNull
    private byte[] data;

    public CommandPacket(@NotNull Direction direction, @NotNull Command command, short size2, int checksum, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)command, "command");
        Intrinsics.checkNotNullParameter(data, "data");
        this.direction = direction;
        this.command = command;
        this.size = size2;
        this.checksum = checksum;
        this.data = data;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "<set-?>");
        this.direction = direction;
    }

    @NotNull
    public final Command getCommand() {
        return this.command;
    }

    public final void setCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, "<set-?>");
        this.command = command;
    }

    public final short getSize() {
        return this.size;
    }

    public final void setSize(short s) {
        this.size = s;
    }

    public final int getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(int n) {
        this.checksum = n;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final void setData(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.data = byArray;
    }

    @NotNull
    public final byte[] encode() {
        ByteBuffer byteBuffer;
        ByteBuffer $this$encode_u24lambda_u240 = byteBuffer = ByteBuffer.allocate(8 + this.data.length).order(ByteOrder.LITTLE_ENDIAN);
        boolean bl = false;
        $this$encode_u24lambda_u240.put(this.direction.getValue());
        $this$encode_u24lambda_u240.put(this.command.getValue());
        $this$encode_u24lambda_u240.putShort(this.size);
        $this$encode_u24lambda_u240.putInt(this.checksum);
        $this$encode_u24lambda_u240.put(this.data);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return "CommandPacket(direction=" + this.direction + ", command=" + this.command + " (" + HexExtensionsKt.toHexString(this.command.getValue(), HexFormat.Companion.getDefault()) + "), size=" + this.size + ", checksum=" + this.checksum + ")";
    }

    @NotNull
    public final Direction component1() {
        return this.direction;
    }

    @NotNull
    public final Command component2() {
        return this.command;
    }

    public final short component3() {
        return this.size;
    }

    public final int component4() {
        return this.checksum;
    }

    @NotNull
    public final byte[] component5() {
        return this.data;
    }

    @NotNull
    public final CommandPacket copy(@NotNull Direction direction, @NotNull Command command, short size2, int checksum, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)command, "command");
        Intrinsics.checkNotNullParameter(data, "data");
        return new CommandPacket(direction, command, size2, checksum, data);
    }

    public static /* synthetic */ CommandPacket copy$default(CommandPacket commandPacket, Direction direction, Command command, short s, int n, byte[] byArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            direction = commandPacket.direction;
        }
        if ((n2 & 2) != 0) {
            command = commandPacket.command;
        }
        if ((n2 & 4) != 0) {
            s = commandPacket.size;
        }
        if ((n2 & 8) != 0) {
            n = commandPacket.checksum;
        }
        if ((n2 & 0x10) != 0) {
            byArray = commandPacket.data;
        }
        return commandPacket.copy(direction, command, s, n, byArray);
    }

    public int hashCode() {
        int result = this.direction.hashCode();
        result = result * 31 + this.command.hashCode();
        result = result * 31 + Short.hashCode(this.size);
        result = result * 31 + Integer.hashCode(this.checksum);
        result = result * 31 + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandPacket)) {
            return false;
        }
        CommandPacket commandPacket = (CommandPacket)other;
        if (this.direction != commandPacket.direction) {
            return false;
        }
        if (this.command != commandPacket.command) {
            return false;
        }
        if (this.size != commandPacket.size) {
            return false;
        }
        if (this.checksum != commandPacket.checksum) {
            return false;
        }
        return Intrinsics.areEqual(this.data, commandPacket.data);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ldev/llelievr/espflashkotlin/CommandPacket$Companion;", "", "()V", "createCommand", "", "command", "Ldev/llelievr/espflashkotlin/Packet;", "espflashkotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] createCommand(@NotNull Packet command) {
            Intrinsics.checkNotNullParameter(command, "command");
            byte[] payload = command.encode();
            if (payload.length > Short.MAX_VALUE) {
                throw new IllegalStateException("Payload size too big".toString());
            }
            CommandPacket packet = new CommandPacket(Direction.REQUEST, command.getCommand(), (short)payload.length, command.checksum(), payload);
            byte[] commandPayload = packet.encode();
            if (commandPayload.length - payload.length != 8) {
                throw new IllegalStateException("invalid payload size".toString());
            }
            return commandPayload;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

