/*
 * Decompiled with CFR 0.152.
 */
package dev.llelievr.espflashkotlin;

import dev.llelievr.espflashkotlin.Command;
import dev.llelievr.espflashkotlin.DataPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/llelievr/espflashkotlin/FlashData;", "Ldev/llelievr/espflashkotlin/DataPacket;", "size", "", "sequence", "data", "", "(II[B)V", "getData", "()[B", "getSequence", "()I", "getSize", "component1", "component2", "component3", "copy", "encode", "equals", "", "other", "", "hashCode", "toString", "", "espflashkotlin"})
public final class FlashData
extends DataPacket {
    private final int size;
    private final int sequence;
    @NotNull
    private final byte[] data;

    public FlashData(int size2, int sequence, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        super(Command.FLASH_DATA);
        this.size = size2;
        this.sequence = sequence;
        this.data = data;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSequence() {
        return this.sequence;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @Override
    @NotNull
    public byte[] data() {
        return this.data;
    }

    @Override
    @NotNull
    public byte[] encode() {
        ByteBuffer byteBuffer;
        ByteBuffer $this$encode_u24lambda_u240 = byteBuffer = ByteBuffer.allocate(16 + this.data.length).order(ByteOrder.LITTLE_ENDIAN);
        boolean bl = false;
        $this$encode_u24lambda_u240.putInt(this.size);
        $this$encode_u24lambda_u240.putInt(this.sequence);
        $this$encode_u24lambda_u240.putInt(0);
        $this$encode_u24lambda_u240.putInt(0);
        $this$encode_u24lambda_u240.put(this.data);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return "FlashData(size=" + this.size + ", sequence=" + this.sequence + ")";
    }

    public final int component1() {
        return this.size;
    }

    public final int component2() {
        return this.sequence;
    }

    @NotNull
    public final byte[] component3() {
        return this.data;
    }

    @NotNull
    public final FlashData copy(int size2, int sequence, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        return new FlashData(size2, sequence, data);
    }

    public static /* synthetic */ FlashData copy$default(FlashData flashData, int n, int n2, byte[] byArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = flashData.size;
        }
        if ((n3 & 2) != 0) {
            n2 = flashData.sequence;
        }
        if ((n3 & 4) != 0) {
            byArray = flashData.data;
        }
        return flashData.copy(n, n2, byArray);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.size);
        result = result * 31 + Integer.hashCode(this.sequence);
        result = result * 31 + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlashData)) {
            return false;
        }
        FlashData flashData = (FlashData)other;
        if (this.size != flashData.size) {
            return false;
        }
        if (this.sequence != flashData.sequence) {
            return false;
        }
        return Intrinsics.areEqual(this.data, flashData.data);
    }
}

