/*
 * Decompiled with CFR 0.152.
 */
package dev.llelievr.espflashkotlin;

import dev.llelievr.espflashkotlin.ChangeBaudrate;
import dev.llelievr.espflashkotlin.CommandPacket;
import dev.llelievr.espflashkotlin.FlashBegin;
import dev.llelievr.espflashkotlin.FlashData;
import dev.llelievr.espflashkotlin.FlashEnd;
import dev.llelievr.espflashkotlin.FlashMD5;
import dev.llelievr.espflashkotlin.FlasherSerialInterface;
import dev.llelievr.espflashkotlin.FlasherStub;
import dev.llelievr.espflashkotlin.FlasherTarget;
import dev.llelievr.espflashkotlin.FlashingProgressListener;
import dev.llelievr.espflashkotlin.MemBegin;
import dev.llelievr.espflashkotlin.MemData;
import dev.llelievr.espflashkotlin.MemEnd;
import dev.llelievr.espflashkotlin.Packet;
import dev.llelievr.espflashkotlin.ReadReg;
import dev.llelievr.espflashkotlin.ResponsePacket;
import dev.llelievr.espflashkotlin.SLIPParser;
import dev.llelievr.espflashkotlin.Sync;
import dev.llelievr.espflashkotlin.targets.ESP32Target;
import dev.llelievr.espflashkotlin.targets.Esp32c3Target;
import dev.llelievr.espflashkotlin.targets.Esp8266Target;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 E2\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bJ\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\bH\u0002J\b\u0010(\u001a\u00020\"H\u0002J\u000e\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0001J\u0018\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\"2\u0006\u0010,\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J \u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\b2\b\b\u0002\u00104\u001a\u000205J\b\u00106\u001a\u00020\"H\u0002J\b\u00107\u001a\u00020\"H\u0002J\u0010\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020\rH\u0002J\u001a\u0010:\u001a\u00020\r2\u0006\u0010,\u001a\u00020\b2\b\b\u0002\u0010;\u001a\u00020\bH\u0002J\u0018\u0010<\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u001f\u0010=\u001a\u00020\"\"\b\b\u0000\u0010>*\u00020?2\u0006\u0010@\u001a\u0002H>H\u0002\u00a2\u0006\u0002\u0010AJ)\u0010B\u001a\u00020C\"\b\b\u0000\u0010>*\u00020?2\u0006\u0010@\u001a\u0002H>2\b\b\u0002\u00109\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010DR \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Ldev/llelievr/espflashkotlin/Flasher;", "", "serialInterface", "Ldev/llelievr/espflashkotlin/FlasherSerialInterface;", "(Ldev/llelievr/espflashkotlin/FlasherSerialInterface;)V", "binsToFlash", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "", "currentTarget", "Ldev/llelievr/espflashkotlin/FlasherTarget;", "currentTimeout", "", "Ljava/lang/Long;", "flashing", "", "logger", "Lorg/slf4j/Logger;", "progressListeners", "Ldev/llelievr/espflashkotlin/FlashingProgressListener;", "slipParser", "Ldev/llelievr/espflashkotlin/SLIPParser;", "targets", "Ljava/util/HashMap;", "addBin", "bin", "offset", "addProgressListener", "listener", "addTarget", "magic", "target", "begin", "", "bytesToMd5", "", "bytes", "changeBaud", "baud", "end", "flash", "port", "flashBegin", "size", "loadStub", "stub", "Ldev/llelievr/espflashkotlin/FlasherStub;", "memBegin", "padTo", "data", "alignment", "padCharacter", "", "resetAfterFlash", "resetToFlash", "setReadTimeout", "timeout", "timeoutPerMb", "millisPerMb", "writeBinToFlash", "writeCommand", "T", "Ldev/llelievr/espflashkotlin/Packet;", "command", "(Ldev/llelievr/espflashkotlin/Packet;)V", "writeWait", "Ldev/llelievr/espflashkotlin/ResponsePacket;", "(Ldev/llelievr/espflashkotlin/Packet;J)Ldev/llelievr/espflashkotlin/ResponsePacket;", "Companion", "espflashkotlin"})
@SourceDebugExtension(value={"SMAP\nFlasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flasher.kt\ndev/llelievr/espflashkotlin/Flasher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,491:1\n1045#2:492\n1855#2,2:493\n1855#2,2:503\n1324#3,3:495\n1324#3,3:498\n1324#3,2:501\n1326#3:505\n*S KotlinDebug\n*F\n+ 1 Flasher.kt\ndev/llelievr/espflashkotlin/Flasher\n*L\n162#1:492\n162#1:493,2\n289#1:503,2\n210#1:495,3\n223#1:498,3\n288#1:501,2\n288#1:505\n*E\n"})
public final class Flasher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlasherSerialInterface serialInterface;
    @Nullable
    private Logger logger;
    @NotNull
    private final SLIPParser slipParser;
    @Nullable
    private FlasherTarget currentTarget;
    @Nullable
    private Long currentTimeout;
    @NotNull
    private final HashMap<Integer, FlasherTarget> targets;
    @NotNull
    private final ArrayList<Pair<Integer, byte[]>> binsToFlash;
    private boolean flashing;
    @NotNull
    private final ArrayList<FlashingProgressListener> progressListeners;
    public static final int CHIP_DETECT_MAGIC_REG_ADDR = 0x40001000;
    public static final int ESP_RAM_BLOCK = 6144;
    public static final int ESP_ROM_BAUD = 115200;
    public static final int ERASE_REGION_MILLIS_PER_MB = 30000;
    public static final int MD5_TIMEOUT_MILLIS_PER_MB = 8000;
    public static final long DEFAULT_TIMEOUT = 3000L;

    public Flasher(@NotNull FlasherSerialInterface serialInterface) {
        Intrinsics.checkNotNullParameter(serialInterface, "serialInterface");
        this.serialInterface = serialInterface;
        this.logger = LoggerFactory.getLogger(Flasher.class);
        this.slipParser = new SLIPParser(this.serialInterface);
        this.targets = new HashMap();
        this.binsToFlash = new ArrayList();
        this.progressListeners = new ArrayList();
        this.addTarget(-999167, new Esp8266Target());
        this.addTarget(15736195, new ESP32Target());
        this.addTarget(1763790959, new Esp32c3Target());
        this.addTarget(456216687, new Esp32c3Target());
    }

    @NotNull
    public final Flasher addTarget(int magic, @NotNull FlasherTarget target) {
        Intrinsics.checkNotNullParameter(target, "target");
        if (this.flashing) {
            throw new IllegalStateException("Cannot add a target while flashing".toString());
        }
        Integer n = magic;
        ((Map)this.targets).put(n, target);
        return this;
    }

    @NotNull
    public final Flasher addProgressListener(@NotNull FlashingProgressListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.progressListeners.add(listener2);
        return this;
    }

    @NotNull
    public final Flasher addBin(@NotNull byte[] bin, int offset) {
        Intrinsics.checkNotNullParameter(bin, "bin");
        if (this.flashing) {
            throw new IllegalStateException("Cannot add bin while flashing".toString());
        }
        this.binsToFlash.add(new Pair<Integer, byte[]>(offset, bin));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flash(@NotNull Object port2) {
        Intrinsics.checkNotNullParameter(port2, "port");
        if (this.flashing) {
            throw new IllegalStateException("This flasher is already flashing".toString());
        }
        this.flashing = true;
        this.serialInterface.openSerial(port2);
        try {
            this.begin();
            if (this.binsToFlash.isEmpty()) {
                throw new IllegalStateException("No binary added to the flasher".toString());
            }
            Iterable $this$sortedBy$iv = this.binsToFlash;
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getFirst()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                this.writeBinToFlash((byte[])pair.getSecond(), ((Number)pair.getFirst()).intValue());
            }
            this.end();
        }
        finally {
            this.serialInterface.closeSerial();
            this.flashing = false;
        }
    }

    private final void flashBegin(int size2, int offset) {
        FlasherTarget flasherTarget = this.currentTarget;
        if (flasherTarget == null) {
            throw new IllegalStateException("target not set".toString());
        }
        FlasherTarget flasherTarget2 = flasherTarget;
        int writeSize = flasherTarget2.getFlashWriteSize();
        int blockCount = (size2 + writeSize - 1) / writeSize;
        int eraseSize = flasherTarget2.getEraseSize(offset, size2);
        Logger logger = this.logger;
        if (logger != null) {
            logger.debug("Write bin, erase = " + eraseSize + "  write = " + size2 + " ");
        }
        this.writeWait((Packet)new FlashBegin(eraseSize, blockCount, writeSize, offset), Flasher.timeoutPerMb$default(this, eraseSize, 0, 2, null));
    }

    private final void memBegin(int size2, int offset) {
        int writeSize = 6144;
        int blockCount = (size2 + writeSize - 1) / writeSize;
        Logger logger = this.logger;
        if (logger != null) {
            logger.debug("Write mem, write = " + size2 + " ");
        }
        Flasher.writeWait$default(this, new MemBegin(size2, blockCount, writeSize, offset), 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadStub(FlasherStub stub) {
        block10: {
            byte[] packetData;
            Sequence<List<Byte>> dataChunks;
            Sequence<List<Byte>> textChunks;
            this.memBegin(stub.getText().length, stub.getText_start());
            Sequence<List<Byte>> $this$forEachIndexed$iv = textChunks = SequencesKt.chunked(ArraysKt.asSequence(stub.getText()), 6144);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator<List<Byte>> iterator2 = $this$forEachIndexed$iv.iterator();
            while (iterator2.hasNext()) {
                void chunk;
                int n;
                List<Byte> item$iv = iterator2.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List<Byte> list = item$iv;
                int index = n;
                boolean bl = false;
                Logger logger = this.logger;
                if (logger != null) {
                    logger.debug("Progress " + (float)index / (float)SequencesKt.count(textChunks) * (float)100);
                }
                Flasher.writeWait$default(this, new MemData(chunk.size(), index, CollectionsKt.toByteArray((Collection)chunk)), 0L, 2, null);
            }
            this.memBegin(stub.getData().length, stub.getData_start());
            Sequence<List<Byte>> $this$forEachIndexed$iv2 = dataChunks = SequencesKt.chunked(ArraysKt.asSequence(stub.getData()), 6144);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            Object object = $this$forEachIndexed$iv2.iterator();
            while (object.hasNext()) {
                void chunk;
                int n;
                List<Byte> item$iv = object.next();
                if ((n = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List<Byte> index = item$iv;
                int index2 = n;
                boolean bl = false;
                Logger logger = this.logger;
                if (logger != null) {
                    logger.debug("Progress " + (float)index2 / (float)SequencesKt.count(dataChunks) * (float)100);
                }
                Flasher.writeWait$default(this, new MemData(chunk.size(), index2, CollectionsKt.toByteArray((Collection)chunk)), 0L, 2, null);
            }
            Flasher.writeWait$default(this, new MemEnd(stub.getEntry() == 0 ? 1 : 0, stub.getEntry()), 0L, 2, null);
            Logger logger = this.logger;
            if (logger != null) {
                logger.debug("Waiting for OHAI response");
            }
            this.setReadTimeout(3000L);
            Iterator<byte[]> iterator3 = this.slipParser.getSlipReader();
            if (iterator3 == null) {
                throw new IllegalStateException("no SLIP reader".toString());
            }
            Iterator<byte[]> reader = iterator3;
            byte[] byArray = packetData = reader.next();
            object = new byte[4];
            object[0] = 79;
            object[1] = 72;
            object[2] = 65;
            object[3] = 73;
            if (!Arrays.equals(byArray, (byte[])object)) {
                Logger logger2 = this.logger;
                if (logger2 != null) {
                    logger2.debug("Failed to start stub, unexpected response: " + HexExtensionsKt.toHexString$default(packetData, null, 1, null));
                }
            }
            Logger logger3 = this.logger;
            if (logger3 == null) break block10;
            logger3.debug("Stub running...");
        }
    }

    private final boolean changeBaud(int baud) {
        FlasherTarget flasherTarget = this.currentTarget;
        if (flasherTarget == null) {
            throw new IllegalStateException("target not set".toString());
        }
        FlasherTarget flasherTarget2 = flasherTarget;
        ChangeBaudrate command = new ChangeBaudrate(baud, flasherTarget2.stub() != null ? 115200 : 0);
        if (!command.isPacketSupported(flasherTarget2)) {
            Logger logger = this.logger;
            if (logger != null) {
                logger.debug("Cannot change the baudrate, packet not supported on this target");
            }
            return false;
        }
        Flasher.writeWait$default(this, command, 0L, 2, null);
        this.serialInterface.changeBaud(baud);
        Thread.sleep(500L);
        this.slipParser.flushInput();
        return true;
    }

    @NotNull
    public final byte[] padTo(@NotNull byte[] data, int alignment, byte padCharacter) {
        Intrinsics.checkNotNullParameter(data, "data");
        byte[] byArray = Arrays.copyOf(data, data.length);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, size)");
        byte[] paddedData = byArray;
        int padMod = data.length % alignment;
        if (padMod != 0) {
            int n = 0;
            int n2 = alignment - padMod;
            byte[] byArray2 = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                byArray2[n3] = padCharacter;
            }
            byte[] padding = byArray2;
            paddedData = ArraysKt.plus(paddedData, padding);
        }
        return paddedData;
    }

    public static /* synthetic */ byte[] padTo$default(Flasher flasher, byte[] byArray, int n, byte by, int n2, Object object) {
        if ((n2 & 4) != 0) {
            by = (byte)-1;
        }
        return flasher.padTo(byArray, n, by);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeBinToFlash(byte[] bin, int offset) {
        FlashMD5 command;
        Sequence<List<Byte>> chunks;
        FlasherTarget flasherTarget = this.currentTarget;
        if (flasherTarget == null) {
            throw new IllegalStateException("target not set".toString());
        }
        FlasherTarget flasherTarget2 = flasherTarget;
        int writeSize = flasherTarget2.getFlashWriteSize();
        byte[] image = Flasher.padTo$default(this, bin, 4, (byte)0, 4, null);
        String binMd5 = this.bytesToMd5(image);
        this.flashBegin(image.length, offset);
        Sequence<List<Byte>> $this$forEachIndexed$iv = chunks = SequencesKt.chunked(ArraysKt.asSequence(image), writeSize);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator<List<Byte>> iterator2 = $this$forEachIndexed$iv.iterator();
        while (iterator2.hasNext()) {
            void chunk;
            int n;
            List<Byte> item$iv = iterator2.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List<Byte> list = item$iv;
            int index = n;
            boolean bl = false;
            Iterable $this$forEach$iv = this.progressListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FlashingProgressListener it = (FlashingProgressListener)element$iv;
                boolean bl2 = false;
                it.progress((float)(index * writeSize) / (float)image.length);
            }
            byte[] block2 = CollectionsKt.toByteArray((Collection)chunk);
            if (block2.length < writeSize) {
                int n2 = 0;
                int n3 = writeSize - block2.length;
                byte[] byArray = new byte[n3];
                byte[] byArray2 = block2;
                while (n2 < n3) {
                    int n4 = n2++;
                    byArray[n4] = -1;
                }
                block2 = ArraysKt.plus(byArray2, byArray);
            }
            Flasher.writeWait$default(this, new FlashData(block2.length, index, block2), 0L, 2, null);
        }
        if (flasherTarget2.stub() != null) {
            Flasher.writeWait$default(this, new ReadReg(0x40001000), 0L, 2, null);
        }
        if ((command = new FlashMD5(offset, image.length)).isPacketSupported(flasherTarget2)) {
            String string;
            ResponsePacket res = this.writeWait((Packet)command, this.timeoutPerMb(image.length, 8000));
            byte[] byArray = res.optionalData();
            if (byArray == null) {
                throw new IllegalStateException("could not read md5 from response".toString());
            }
            byte[] md5Data = byArray;
            switch (md5Data.length) {
                case 32: {
                    String string2 = md5Data.toString();
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    String string3 = string2.toLowerCase(locale);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(locale)");
                    break;
                }
                case 16: {
                    string = HexExtensionsKt.toHexString$default(md5Data, null, 1, null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid md5 format".toString());
                }
            }
            String md5Str = string;
            if (!Intrinsics.areEqual(md5Str, binMd5)) {
                throw new IllegalStateException(("MD5 of file does not match data in flash!, local = " + binMd5 + ", mcu = " + md5Str).toString());
            }
        }
    }

    private final void begin() {
        block8: {
            FlasherTarget target;
            this.serialInterface.changeBaud(115200);
            this.resetToFlash();
            Logger logger = this.logger;
            if (logger != null) {
                logger.debug("Trying to sync");
            }
            for (int i = 10; -1 < i; --i) {
                try {
                    this.slipParser.flushInput();
                    this.writeWait((Packet)new Sync(), 500L);
                    break;
                }
                catch (IllegalStateException e) {
                    Thread.sleep(500L);
                    if (i != 0) continue;
                    throw new IllegalStateException("Could not sync with the device".toString());
                }
            }
            ResponsePacket chipMagicResponse = Flasher.writeWait$default(this, new ReadReg(0x40001000), 0L, 2, null);
            FlasherTarget flasherTarget = this.targets.get(chipMagicResponse.getValue());
            if (flasherTarget == null) {
                String string = Integer.toString(chipMagicResponse.getValue(), CharsKt.checkRadix(16));
                Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
                throw new IllegalStateException(("Unsupported chip, with magic 0x" + string).toString());
            }
            this.currentTarget = target = flasherTarget;
            target.init();
            FlasherStub stub = target.stub();
            if (stub == null) break block8;
            Logger logger2 = this.logger;
            if (logger2 != null) {
                logger2.debug("Uploading STUB");
            }
            this.loadStub(stub);
            int newBaud = target.getUploadBaudrate();
            if (this.changeBaud(newBaud)) {
                Logger logger3 = this.logger;
                if (logger3 != null) {
                    logger3.debug("Baudrate changed to " + newBaud);
                }
            }
        }
    }

    private final void end() {
        FlasherTarget flasherTarget = this.currentTarget;
        if (flasherTarget == null) {
            throw new IllegalStateException("target not set".toString());
        }
        FlasherTarget flasherTarget2 = flasherTarget;
        if (flasherTarget2.stub() != null) {
            this.flashBegin(0, 0);
            Flasher.writeWait$default(this, new FlashEnd(0, 1, null), 0L, 2, null);
        }
        this.resetAfterFlash();
    }

    private final void resetToFlash() {
        this.serialInterface.setDTR(false);
        this.serialInterface.setRTS(true);
        Thread.sleep(100L);
        this.serialInterface.setDTR(true);
        this.serialInterface.setRTS(false);
        Thread.sleep(50L);
        this.serialInterface.setDTR(false);
    }

    private final void resetAfterFlash() {
        Thread.sleep(100L);
        this.serialInterface.setRTS(true);
        Thread.sleep(100L);
        this.serialInterface.setRTS(false);
    }

    private final void setReadTimeout(long timeout) {
        Long l = this.currentTimeout;
        long l2 = timeout;
        if (l == null || l != l2) {
            this.serialInterface.setReadTimeout(timeout);
            this.currentTimeout = timeout;
        }
    }

    private final <T extends Packet> void writeCommand(T command) {
        FlasherTarget flasherTarget = this.currentTarget;
        if (flasherTarget != null && !command.isPacketSupported(flasherTarget)) {
            throw new IllegalStateException("Usage of unsupported packet for this target".toString());
        }
        byte[] commandBuf = CommandPacket.Companion.createCommand(command);
        byte[] encoded = this.slipParser.encodeSLIP(commandBuf);
        Logger logger = this.logger;
        if (logger != null) {
            logger.trace(StringsKt.trimIndent("\n                ---------------------\n                Command " + command + "\n                packetPayload=" + HexExtensionsKt.toHexString$default(encoded, null, 1, null) + "\n                size=" + encoded.length + "\n                data=" + HexExtensionsKt.toHexString$default(commandBuf, null, 1, null) + "\n                ---------------------\n            "));
        }
        this.serialInterface.write(encoded);
    }

    private final <T extends Packet> ResponsePacket writeWait(T command, long timeout) {
        this.writeCommand(command);
        this.setReadTimeout(timeout);
        Iterator<byte[]> iterator2 = this.slipParser.getSlipReader();
        if (iterator2 == null) {
            throw new IllegalStateException("No SLIP reader".toString());
        }
        Iterator<byte[]> reader = iterator2;
        ResponsePacket res = null;
        for (int retry = 100; -1 < retry; --retry) {
            byte[] packetData = reader.next();
            res = ResponsePacket.Companion.decodeResponse(packetData);
            if (res.getCommand() != command.getCommand()) continue;
            Logger logger = this.logger;
            if (logger != null) {
                logger.trace(res.toString());
            }
            return res;
        }
        ResponsePacket responsePacket = res;
        String string = "the response does not match the request, req = " + command.getCommand() + " res = " + (responsePacket != null ? responsePacket.getCommand() : null);
        throw new IllegalStateException(string.toString());
    }

    static /* synthetic */ ResponsePacket writeWait$default(Flasher flasher, Packet packet, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 3000L;
        }
        return flasher.writeWait(packet, l);
    }

    private final String bytesToMd5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(bytes);
        byte[] digest = md5.digest();
        StringBuilder md5str = new StringBuilder();
        Intrinsics.checkNotNull(digest);
        for (byte b : digest) {
            String string = "%02x";
            Object[] objectArray = new Object[]{b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
            md5str.append(string2);
        }
        String string = md5str.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final long timeoutPerMb(int size2, int millisPerMb) {
        int defaultTimeout = 3000;
        return Math.max(defaultTimeout, (int)Math.floor((double)millisPerMb * ((double)size2 / 1000000.0)));
    }

    static /* synthetic */ long timeoutPerMb$default(Flasher flasher, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 30000;
        }
        return flasher.timeoutPerMb(n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/llelievr/espflashkotlin/Flasher$Companion;", "", "()V", "CHIP_DETECT_MAGIC_REG_ADDR", "", "DEFAULT_TIMEOUT", "", "ERASE_REGION_MILLIS_PER_MB", "ESP_RAM_BLOCK", "ESP_ROM_BAUD", "MD5_TIMEOUT_MILLIS_PER_MB", "espflashkotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

