/*
 * Decompiled with CFR 0.152.
 */
package dev.llelievr.espflashkotlin;

import dev.llelievr.espflashkotlin.Command;
import dev.llelievr.espflashkotlin.Direction;
import dev.llelievr.espflashkotlin.FlashError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ldev/llelievr/espflashkotlin/ResponsePacket;", "", "direction", "Ldev/llelievr/espflashkotlin/Direction;", "command", "Ldev/llelievr/espflashkotlin/Command;", "value", "", "optionalData", "", "(Ldev/llelievr/espflashkotlin/Direction;Ldev/llelievr/espflashkotlin/Command;I[B)V", "getCommand", "()Ldev/llelievr/espflashkotlin/Command;", "getDirection", "()Ldev/llelievr/espflashkotlin/Direction;", "getOptionalData", "()[B", "getValue", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "espflashkotlin"})
public final class ResponsePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Direction direction;
    @NotNull
    private final Command command;
    private final int value;
    @Nullable
    private final byte[] optionalData;
    private static final int STATUS_BYTES_LENGTH = 2;

    public ResponsePacket(@NotNull Direction direction, @NotNull Command command, int value, @Nullable byte[] optionalData) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)command, "command");
        this.direction = direction;
        this.command = command;
        this.value = value;
        this.optionalData = optionalData;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @NotNull
    public final Command getCommand() {
        return this.command;
    }

    public final int getValue() {
        return this.value;
    }

    @Nullable
    public final byte[] getOptionalData() {
        return this.optionalData;
    }

    @Nullable
    public final byte[] optionalData() {
        return this.optionalData;
    }

    @NotNull
    public String toString() {
        return "ResponsePacket(direction=" + this.direction + ", command=" + this.command + ", value=" + this.value + ")";
    }

    @NotNull
    public final Direction component1() {
        return this.direction;
    }

    @NotNull
    public final Command component2() {
        return this.command;
    }

    public final int component3() {
        return this.value;
    }

    @Nullable
    public final byte[] component4() {
        return this.optionalData;
    }

    @NotNull
    public final ResponsePacket copy(@NotNull Direction direction, @NotNull Command command, int value, @Nullable byte[] optionalData) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)command, "command");
        return new ResponsePacket(direction, command, value, optionalData);
    }

    public static /* synthetic */ ResponsePacket copy$default(ResponsePacket responsePacket, Direction direction, Command command, int n, byte[] byArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            direction = responsePacket.direction;
        }
        if ((n2 & 2) != 0) {
            command = responsePacket.command;
        }
        if ((n2 & 4) != 0) {
            n = responsePacket.value;
        }
        if ((n2 & 8) != 0) {
            byArray = responsePacket.optionalData;
        }
        return responsePacket.copy(direction, command, n, byArray);
    }

    public int hashCode() {
        int result = this.direction.hashCode();
        result = result * 31 + this.command.hashCode();
        result = result * 31 + Integer.hashCode(this.value);
        result = result * 31 + (this.optionalData == null ? 0 : Arrays.hashCode(this.optionalData));
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResponsePacket)) {
            return false;
        }
        ResponsePacket responsePacket = (ResponsePacket)other;
        if (this.direction != responsePacket.direction) {
            return false;
        }
        if (this.command != responsePacket.command) {
            return false;
        }
        if (this.value != responsePacket.value) {
            return false;
        }
        return Intrinsics.areEqual(this.optionalData, responsePacket.optionalData);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/llelievr/espflashkotlin/ResponsePacket$Companion;", "", "()V", "STATUS_BYTES_LENGTH", "", "decodeResponse", "Ldev/llelievr/espflashkotlin/ResponsePacket;", "data", "", "espflashkotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResponsePacket decodeResponse(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            ByteBuffer buff = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
            if (data.length < 8) {
                throw new IllegalStateException("Failed to read response".toString());
            }
            Direction direction = Direction.Companion.getByValue(buff.get());
            if (direction == null) {
                throw new IllegalStateException("unable to decode direction".toString());
            }
            Direction direction2 = direction;
            if (direction2 != Direction.RESPONSE) {
                throw new IllegalStateException("Received response packet with direction not set to response".toString());
            }
            Command command = Command.Companion.getByValue(buff.get());
            if (command == null) {
                throw new IllegalStateException("unable to decode command".toString());
            }
            Command command2 = command;
            buff.getShort();
            int value = buff.getInt();
            byte[] optionalData = data.length - 8 > 2 ? CollectionsKt.toByteArray((Collection<Byte>)ArraysKt.slice(data, RangesKt.until(8, data.length - 2))) : null;
            List<Byte> statusBytes = ArraysKt.slice(data, RangesKt.until(data.length - 2, data.length));
            if (((Number)statusBytes.get(0)).byteValue() == 1) {
                Object object = FlashError.Companion.getByValue(((Number)statusBytes.get(1)).byteValue());
                if (object == null || (object = object.getMeaning()) == null) {
                    object = "unknown";
                }
                String string = "Flashing Error, " + (String)object;
                throw new IllegalStateException(string.toString());
            }
            return new ResponsePacket(direction2, command2, value, optionalData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

