/*
 * Decompiled with CFR 0.152.
 */
package dev.llelievr.espflashkotlin;

import dev.llelievr.espflashkotlin.FlasherSerialInterface;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/llelievr/espflashkotlin/SLIPParser;", "", "serialInterface", "Ldev/llelievr/espflashkotlin/FlasherSerialInterface;", "(Ldev/llelievr/espflashkotlin/FlasherSerialInterface;)V", "logger", "Lorg/slf4j/Logger;", "getSerialInterface", "()Ldev/llelievr/espflashkotlin/FlasherSerialInterface;", "slipReader", "", "", "encodeSLIP", "input", "flushInput", "", "getSlipReader", "slipReaderGenerator", "espflashkotlin"})
public final class SLIPParser {
    @NotNull
    private final FlasherSerialInterface serialInterface;
    @Nullable
    private Logger logger;
    @Nullable
    private Iterator<byte[]> slipReader;

    public SLIPParser(@NotNull FlasherSerialInterface serialInterface) {
        Intrinsics.checkNotNullParameter(serialInterface, "serialInterface");
        this.serialInterface = serialInterface;
        this.logger = LoggerFactory.getLogger(SLIPParser.class);
    }

    @NotNull
    public final FlasherSerialInterface getSerialInterface() {
        return this.serialInterface;
    }

    public final void flushInput() {
        this.serialInterface.flushIOBuffers();
        this.slipReader = this.slipReaderGenerator();
    }

    @Nullable
    public final Iterator<byte[]> getSlipReader() {
        return this.slipReader;
    }

    private final Iterator<byte[]> slipReaderGenerator() {
        return SequencesKt.iterator((Function2)new Function2<SequenceScope<? super byte[]>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SLIPParser this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$iterator = (SequenceScope)this.L$0;
                        partialPacket = new ByteArrayOutputStream();
                        packetStarted = false;
                        inEscape = false;
                        while (true) {
                            available = this.this$0.getSerialInterface().availableBytes();
                            toRead = available == 0 ? 1 : available;
                            readBytes = this.this$0.getSerialInterface().read(toRead);
                            v0 = SLIPParser.access$getLogger$p(this.this$0);
                            if (v0 != null) {
                                v0.trace("Read " + readBytes.length + " bytes: " + HexExtensionsKt.toHexString$default(readBytes, null, 1, null));
                            }
                            if (!packetStarted && readBytes[0] == 0) {
                                throw new IllegalStateException("No serial data received.".toString());
                            }
                            var9_10 = 0;
                            var10_11 = readBytes.length;
                            break block0;
                            break;
                        }
                    }
                    case 1: {
                        var10_11 = this.I$1;
                        var9_10 = this.I$0;
                        readBytes = (byte[])this.L$2;
                        partialPacket = (ByteArrayOutputStream)this.L$1;
                        $this$iterator = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        while (true) {
                            packetStarted = false;
                            inEscape = false;
                            partialPacket.reset();
                            ** GOTO lbl70
                            break;
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (true) {
                    if (var9_10 >= var10_11) ** continue;
                    b = readBytes[var9_10];
                    if (!packetStarted) {
                        if (b != -64) {
                            throw new IllegalStateException(("Read invalid data: " + HexExtensionsKt.toHexString$default(readBytes, null, 1, null)).toString());
                        }
                        packetStarted = true;
                    } else if (b == -37) {
                        inEscape = true;
                    } else if (inEscape) {
                        inEscape = false;
                        var12_13 = b;
                        if (var12_13 == -36) {
                            partialPacket.write(192);
                        } else {
                            if (var12_13 != -35) {
                                throw new IllegalStateException(("Invalid slip escape, Read invalid data: " + HexExtensionsKt.toHexString(readBytes, HexFormat.Companion.getDefault())).toString());
                            }
                            partialPacket.write(219);
                        }
                    } else {
                        if (b == -64) {
                            v2 = partialPacket.toByteArray();
                            Intrinsics.checkNotNullExpressionValue(v2, "toByteArray(...)");
                            this.L$0 = $this$iterator;
                            this.L$1 = partialPacket;
                            this.L$2 = readBytes;
                            this.I$0 = var9_10;
                            this.I$1 = var10_11;
                            this.label = 1;
                            if ((v1 = $this$iterator.yield(v2, this)) != var13_2) ** continue;
                            return var13_2;
                        }
                        partialPacket.write(b);
                    }
                    ++var9_10;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super byte[]> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final byte[] encodeSLIP(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter(input, "input");
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        outputStream2.write(192);
        for (byte by : input) {
            byte by2 = by;
            if (by2 == -64) {
                outputStream2.write(219);
                outputStream2.write(220);
                continue;
            }
            if (by2 == -37) {
                outputStream2.write(219);
                outputStream2.write(221);
                continue;
            }
            outputStream2.write(by);
        }
        outputStream2.write(192);
        byte[] byArray = outputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SLIPParser $this) {
        return $this.logger;
    }
}

