/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr;

import com.melloware.jintellitype.HotkeyListener;
import com.melloware.jintellitype.JIntellitype;
import dev.slimevr.VRServer;
import dev.slimevr.config.KeybindingsConfig;
import io.eiren.util.OperatingSystem;
import io.eiren.util.logging.LogManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ldev/slimevr/Keybinding;", "Lcom/melloware/jintellitype/HotkeyListener;", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "getServer", "()Ldev/slimevr/VRServer;", "config", "Ldev/slimevr/config/KeybindingsConfig;", "getConfig", "()Ldev/slimevr/config/KeybindingsConfig;", "onHotKey", "", "identifier", "", "Companion", "core"})
public final class Keybinding
implements HotkeyListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VRServer server;
    @NotNull
    private final KeybindingsConfig config;
    @NotNull
    private static final String RESET_SOURCE_NAME = "Keybinding";
    private static final int FULL_RESET = 1;
    private static final int YAW_RESET = 2;
    private static final int MOUNTING_RESET = 3;
    private static final int PAUSE_TRACKING = 4;

    public Keybinding(@NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        this.config = this.server.configManager.getVrConfig().getKeybindings();
        if (OperatingSystem.Companion.getCurrentPlatform() != OperatingSystem.WINDOWS) {
            LogManager.info("[Keybinding] Currently only supported on Windows. Keybindings will be disabled.");
        } else {
            try {
                if (JIntellitype.getInstance() != null) {
                    JIntellitype.getInstance().addHotKeyListener(this);
                    String fullResetBinding = this.config.getFullResetBinding();
                    JIntellitype.getInstance().registerHotKey(1, fullResetBinding);
                    LogManager.info("[Keybinding] Bound full reset to " + fullResetBinding);
                    String yawResetBinding = this.config.getYawResetBinding();
                    JIntellitype.getInstance().registerHotKey(2, yawResetBinding);
                    LogManager.info("[Keybinding] Bound yaw reset to " + yawResetBinding);
                    String mountingResetBinding = this.config.getMountingResetBinding();
                    JIntellitype.getInstance().registerHotKey(3, mountingResetBinding);
                    LogManager.info("[Keybinding] Bound reset mounting to " + mountingResetBinding);
                    String pauseTrackingBinding = this.config.getPauseTrackingBinding();
                    JIntellitype.getInstance().registerHotKey(4, pauseTrackingBinding);
                    LogManager.info("[Keybinding] Bound pause tracking to " + pauseTrackingBinding);
                }
            }
            catch (Throwable e) {
                LogManager.warning("[Keybinding] JIntellitype initialization failed. Keybindings will be disabled. Try restarting your computer.");
            }
        }
    }

    @NotNull
    public final VRServer getServer() {
        return this.server;
    }

    @NotNull
    public final KeybindingsConfig getConfig() {
        return this.config;
    }

    @Override
    public void onHotKey(int identifier) {
        switch (identifier) {
            case 1: {
                this.server.scheduleResetTrackersFull(RESET_SOURCE_NAME, this.config.getFullResetDelay());
                break;
            }
            case 2: {
                this.server.scheduleResetTrackersYaw(RESET_SOURCE_NAME, this.config.getYawResetDelay());
                break;
            }
            case 3: {
                this.server.scheduleResetTrackersMounting(RESET_SOURCE_NAME, this.config.getMountingResetDelay());
                break;
            }
            case 4: {
                this.server.scheduleTogglePauseTracking(RESET_SOURCE_NAME, this.config.getPauseTrackingDelay());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/slimevr/Keybinding$Companion;", "", "<init>", "()V", "RESET_SOURCE_NAME", "", "FULL_RESET", "", "YAW_RESET", "MOUNTING_RESET", "PAUSE_TRACKING", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

