/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr;

import com.jme3.system.NanoTimer;
import dev.slimevr.autobone.AutoBoneHandler;
import dev.slimevr.bridge.Bridge;
import dev.slimevr.bridge.ISteamVRBridge;
import dev.slimevr.config.ConfigManager;
import dev.slimevr.firmware.FirmwareUpdateHandler;
import dev.slimevr.firmware.SerialFlashingHandler;
import dev.slimevr.games.vrchat.VRCConfigHandler;
import dev.slimevr.games.vrchat.VRCConfigHandlerStub;
import dev.slimevr.games.vrchat.VRChatConfigManager;
import dev.slimevr.osc.OSCHandler;
import dev.slimevr.osc.OSCRouter;
import dev.slimevr.osc.VMCHandler;
import dev.slimevr.osc.VRCOSCHandler;
import dev.slimevr.posestreamer.BVHRecorder;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.protocol.rpc.settings.RPCSettingsHandler;
import dev.slimevr.reset.ResetHandler;
import dev.slimevr.serial.ProvisioningHandler;
import dev.slimevr.serial.SerialHandler;
import dev.slimevr.serial.SerialHandlerStub;
import dev.slimevr.setup.HandshakeHandler;
import dev.slimevr.setup.TapSetupHandler;
import dev.slimevr.status.StatusSystem;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import dev.slimevr.tracking.trackers.DeviceManager;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.TrackerStatusListener;
import dev.slimevr.tracking.trackers.TrackerUtils;
import dev.slimevr.tracking.trackers.udp.TrackersUDPServer;
import dev.slimevr.websocketapi.WebSocketVRBridge;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.datatypes.TrackerIdT;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u009e\u00012\u00020\u0001:\u0002\u009e\u0001B\u00b1\u0001\b\u0007\u0012H\b\u0002\u0010\u0002\u001aB\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0003j\u0002`\f\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u000e\u0012\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010_\u001a\u00020`2\u0010\u0010a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0bJ'\u0010c\u001a\u0004\u0018\u0001Hd\"\n\b\u0000\u0010d*\u0004\u0018\u00010\u000b2\f\u0010a\u001a\b\u0012\u0004\u0012\u0002Hd0b\u00a2\u0006\u0002\u0010eJ\u000e\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020(J\u0014\u0010i\u001a\u00020g2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\b0*J\u0010\u0010k\u001a\u00020g2\b\u0010l\u001a\u0004\u0018\u00010\bJ\u0014\u0010m\u001a\u00020g2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020n0*J\b\u0010o\u001a\u00020gH\u0016J\u000e\u0010p\u001a\u00020g2\u0006\u0010q\u001a\u00020(J\u0010\u0010r\u001a\u00020g2\u0006\u0010l\u001a\u00020\bH\u0002J\u000e\u0010s\u001a\u00020g2\u0006\u0010l\u001a\u00020\bJ\u0006\u0010t\u001a\u00020gJ \u0010u\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\u000e\b\u0002\u0010w\u001a\b\u0012\u0004\u0012\u00020x0\u0007J \u0010y\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\u000e\b\u0002\u0010w\u001a\b\u0012\u0004\u0012\u00020x0\u0007J \u0010z\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\u000e\b\u0002\u0010w\u001a\b\u0012\u0004\u0012\u00020x0\u0007J\u0010\u0010{\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u0018J\u0006\u0010|\u001a\u00020`J\u0018\u0010}\u001a\u00020g2\u0006\u0010~\u001a\u00020`2\b\u0010\u007f\u001a\u0004\u0018\u00010\u0018J\u0011\u0010\u0080\u0001\u001a\u00020g2\b\u0010\u007f\u001a\u0004\u0018\u00010\u0018J\u001b\u0010\u0081\u0001\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u001b\u0010\u0084\u0001\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u001b\u0010\u0085\u0001\u001a\u00020g2\b\u0010v\u001a\u0004\u0018\u00010\u00182\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J#\u0010\u0086\u0001\u001a\u00020g2\u0006\u0010~\u001a\u00020`2\b\u0010\u007f\u001a\u0004\u0018\u00010\u00182\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u001b\u0010\u0087\u0001\u001a\u00020g2\b\u0010\u007f\u001a\u0004\u0018\u00010\u00182\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u0010\u0010\u0088\u0001\u001a\u00020g2\u0007\u0010\u0089\u0001\u001a\u00020`J\u0010\u0010\u008a\u0001\u001a\u00020g2\u0007\u0010\u0089\u0001\u001a\u00020`J\u0010\u0010\u008b\u0001\u001a\u00020g2\u0007\u0010\u0089\u0001\u001a\u00020`J\u0013\u0010\u0092\u0001\u001a\u0004\u0018\u00010\b2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001J\u0007\u0010\u0095\u0001\u001a\u00020gJ\u0007\u0010\u0096\u0001\u001a\u00020gJ#\u0010\u0097\u0001\u001a\u00020g2\u0006\u0010l\u001a\u00020\b2\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\b\u0010\u009a\u0001\u001a\u00030\u0099\u0001J\u0010\u0010\u009b\u0001\u001a\u00020g2\u0007\u0010\u009c\u0001\u001a\u00020,J\u0010\u0010\u009d\u0001\u001a\u00020g2\u0007\u0010\u009c\u0001\u001a\u00020,R\u0010\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0*0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020,0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020(0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0010\u00103\u001a\u0002048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u00020:8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020<8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010>\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0010\u0010K\u001a\u00020L8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020N8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u00020P8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010S\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u0010\u0010W\u001a\u00020X8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Y\u001a\u00020Z8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010[\u001a\u00020\\8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010]\u001a\u00020^8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u008c\u0001\u001a\u00020x8F\u00a2\u0006\b\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001R\u001a\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\u00a8\u0006\u009f\u0001"}, d2={"Ldev/slimevr/VRServer;", "Ljava/lang/Thread;", "bridgeProvider", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "server", "", "Ldev/slimevr/tracking/trackers/Tracker;", "computedTrackers", "Lkotlin/sequences/Sequence;", "Ldev/slimevr/bridge/Bridge;", "Ldev/slimevr/BridgeProvider;", "serialHandlerProvider", "Lkotlin/Function1;", "Ldev/slimevr/serial/SerialHandler;", "flashingHandlerProvider", "Ldev/slimevr/firmware/SerialFlashingHandler;", "vrcConfigHandlerProvider", "Ldev/slimevr/games/vrchat/VRCConfigHandler;", "acquireMulticastLock", "Lkotlin/Function0;", "", "configPath", "", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "configManager", "Ldev/slimevr/config/ConfigManager;", "humanPoseManager", "Ldev/slimevr/tracking/processor/HumanPoseManager;", "trackers", "", "trackersServer", "Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer;", "getTrackersServer", "()Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer;", "bridges", "tasks", "Ljava/util/Queue;", "Ljava/lang/Runnable;", "newTrackersConsumers", "Ljava/util/function/Consumer;", "trackerStatusListeners", "Ldev/slimevr/tracking/trackers/TrackerStatusListener;", "onTick", "lock", "oSCRouter", "Ldev/slimevr/osc/OSCRouter;", "getOSCRouter", "()Ldev/slimevr/osc/OSCRouter;", "vrcOSCHandler", "Ldev/slimevr/osc/VRCOSCHandler;", "vMCHandler", "Ldev/slimevr/osc/VMCHandler;", "getVMCHandler", "()Ldev/slimevr/osc/VMCHandler;", "deviceManager", "Ldev/slimevr/tracking/trackers/DeviceManager;", "bvhRecorder", "Ldev/slimevr/posestreamer/BVHRecorder;", "serialHandler", "serialFlashingHandler", "getSerialFlashingHandler", "()Ldev/slimevr/firmware/SerialFlashingHandler;", "setSerialFlashingHandler", "(Ldev/slimevr/firmware/SerialFlashingHandler;)V", "firmwareUpdateHandler", "Ldev/slimevr/firmware/FirmwareUpdateHandler;", "getFirmwareUpdateHandler", "()Ldev/slimevr/firmware/FirmwareUpdateHandler;", "vrcConfigManager", "Ldev/slimevr/games/vrchat/VRChatConfigManager;", "getVrcConfigManager", "()Ldev/slimevr/games/vrchat/VRChatConfigManager;", "autoBoneHandler", "Ldev/slimevr/autobone/AutoBoneHandler;", "tapSetupHandler", "Ldev/slimevr/setup/TapSetupHandler;", "protocolAPI", "Ldev/slimevr/protocol/ProtocolAPI;", "timer", "Ljava/util/Timer;", "fpsTimer", "Lcom/jme3/system/NanoTimer;", "getFpsTimer", "()Lcom/jme3/system/NanoTimer;", "provisioningHandler", "Ldev/slimevr/serial/ProvisioningHandler;", "resetHandler", "Ldev/slimevr/reset/ResetHandler;", "statusSystem", "Ldev/slimevr/status/StatusSystem;", "handshakeHandler", "Ldev/slimevr/setup/HandshakeHandler;", "hasBridge", "", "bridgeClass", "Ljava/lang/Class;", "getVRBridge", "E", "(Ljava/lang/Class;)Ldev/slimevr/bridge/Bridge;", "addOnTick", "", "runnable", "addNewTrackerConsumer", "consumer", "trackerUpdated", "tracker", "addSkeletonUpdatedCallback", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "run", "queueTask", "r", "trackerAdded", "registerTracker", "updateSkeletonModel", "resetTrackersFull", "resetSourceName", "bodyParts", "", "resetTrackersYaw", "resetTrackersMounting", "clearTrackersMounting", "getPauseTracking", "setPauseTracking", "pauseTracking", "sourceName", "togglePauseTracking", "scheduleResetTrackersFull", "delay", "", "scheduleResetTrackersYaw", "scheduleResetTrackersMounting", "scheduleSetPauseTracking", "scheduleTogglePauseTracking", "setLegTweaksEnabled", "value", "setSkatingReductionEnabled", "setFloorClipEnabled", "trackersCount", "getTrackersCount", "()I", "allTrackers", "getAllTrackers", "()Ljava/util/List;", "getTrackerById", "id", "Lsolarxr_protocol/datatypes/TrackerIdT;", "clearTrackersDriftCompensation", "refreshTrackersDriftCompensationEnabled", "trackerStatusChanged", "oldStatus", "Ldev/slimevr/tracking/trackers/TrackerStatus;", "newStatus", "addTrackerStatusListener", "listener", "removeTrackerStatusListener", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nVRServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VRServer.kt\ndev/slimevr/VRServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n1863#2,2:468\n*S KotlinDebug\n*F\n+ 1 VRServer.kt\ndev/slimevr/VRServer\n*L\n440#1:468,2\n*E\n"})
public final class VRServer
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ConfigManager configManager;
    @JvmField
    @NotNull
    public final HumanPoseManager humanPoseManager;
    @NotNull
    private final List<Tracker> trackers;
    @NotNull
    private final TrackersUDPServer trackersServer;
    @NotNull
    private final List<Bridge> bridges;
    @NotNull
    private final Queue<Runnable> tasks;
    @NotNull
    private final List<Consumer<Tracker>> newTrackersConsumers;
    @NotNull
    private final List<TrackerStatusListener> trackerStatusListeners;
    @NotNull
    private final List<Runnable> onTick;
    @Nullable
    private final Object lock;
    @NotNull
    private final OSCRouter oSCRouter;
    @JvmField
    @NotNull
    public final VRCOSCHandler vrcOSCHandler;
    @NotNull
    private final VMCHandler vMCHandler;
    @JvmField
    @NotNull
    public final DeviceManager deviceManager;
    @JvmField
    @NotNull
    public final BVHRecorder bvhRecorder;
    @JvmField
    @NotNull
    public final SerialHandler serialHandler;
    @Nullable
    private SerialFlashingHandler serialFlashingHandler;
    @NotNull
    private final FirmwareUpdateHandler firmwareUpdateHandler;
    @NotNull
    private final VRChatConfigManager vrcConfigManager;
    @JvmField
    @NotNull
    public final AutoBoneHandler autoBoneHandler;
    @JvmField
    @NotNull
    public final TapSetupHandler tapSetupHandler;
    @JvmField
    @NotNull
    public final ProtocolAPI protocolAPI;
    @NotNull
    private final Timer timer;
    @NotNull
    private final NanoTimer fpsTimer;
    @JvmField
    @NotNull
    public final ProvisioningHandler provisioningHandler;
    @JvmField
    @NotNull
    public final ResetHandler resetHandler;
    @JvmField
    @NotNull
    public final StatusSystem statusSystem;
    @JvmField
    @NotNull
    public final HandshakeHandler handshakeHandler;
    @NotNull
    private static final AtomicInteger nextLocalTrackerId = new AtomicInteger();
    private static VRServer instance;

    @JvmOverloads
    public VRServer(@NotNull Function2<? super VRServer, ? super List<Tracker>, ? extends Sequence<? extends Bridge>> bridgeProvider, @NotNull Function1<? super VRServer, ? extends SerialHandler> serialHandlerProvider, @NotNull Function1<? super VRServer, ? extends SerialFlashingHandler> flashingHandlerProvider, @NotNull Function1<? super VRServer, ? extends VRCConfigHandler> vrcConfigHandlerProvider, @NotNull Function0<? extends Object> acquireMulticastLock, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter(bridgeProvider, "bridgeProvider");
        Intrinsics.checkNotNullParameter(serialHandlerProvider, "serialHandlerProvider");
        Intrinsics.checkNotNullParameter(flashingHandlerProvider, "flashingHandlerProvider");
        Intrinsics.checkNotNullParameter(vrcConfigHandlerProvider, "vrcConfigHandlerProvider");
        Intrinsics.checkNotNullParameter(acquireMulticastLock, "acquireMulticastLock");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        super("VRServer");
        this.trackers = new FastList();
        this.bridges = new FastList();
        this.tasks = new LinkedBlockingQueue();
        this.newTrackersConsumers = new FastList();
        this.trackerStatusListeners = new FastList();
        this.onTick = new FastList();
        this.lock = acquireMulticastLock.invoke();
        this.timer = new Timer();
        this.fpsTimer = new NanoTimer();
        this.statusSystem = new StatusSystem();
        this.handshakeHandler = new HandshakeHandler();
        this.configManager = new ConfigManager(configPath);
        this.configManager.loadConfig();
        this.deviceManager = new DeviceManager(this);
        this.serialHandler = serialHandlerProvider.invoke(this);
        this.serialFlashingHandler = flashingHandlerProvider.invoke(this);
        this.provisioningHandler = new ProvisioningHandler(this);
        this.resetHandler = new ResetHandler();
        this.tapSetupHandler = new TapSetupHandler();
        this.humanPoseManager = new HumanPoseManager(this);
        this.autoBoneHandler = new AutoBoneHandler(this);
        this.firmwareUpdateHandler = new FirmwareUpdateHandler(this);
        this.vrcConfigManager = new VRChatConfigManager(this, vrcConfigHandlerProvider.invoke(this));
        this.protocolAPI = new ProtocolAPI(this);
        List<Tracker> computedTrackers = this.humanPoseManager.getComputedTrackers();
        int trackerPort = this.configManager.getVrConfig().getServer().getTrackerPort();
        LogManager.info("Starting the tracker server on port " + trackerPort + "...");
        this.trackersServer = new TrackersUDPServer(trackerPort, "Sensors UDP server", arg_0 -> VRServer._init_$lambda$3(this, arg_0));
        WebSocketVRBridge[] webSocketVRBridgeArray = new WebSocketVRBridge[]{new WebSocketVRBridge(computedTrackers, this)};
        Iterator<WebSocketVRBridge> iterator2 = SequencesKt.plus(bridgeProvider.invoke(this, computedTrackers), SequencesKt.sequenceOf(webSocketVRBridgeArray)).iterator();
        while (iterator2.hasNext()) {
            Bridge bridge = iterator2.next();
            this.tasks.add(() -> VRServer._init_$lambda$4(bridge));
            this.bridges.add(bridge);
        }
        this.vrcOSCHandler = new VRCOSCHandler(this, this.configManager.getVrConfig().getVrcOSC(), computedTrackers);
        this.vMCHandler = new VMCHandler(this, this.humanPoseManager, this.configManager.getVrConfig().getVMC());
        FastList<OSCHandler> oscHandlers = new FastList<OSCHandler>();
        oscHandlers.add(this.vrcOSCHandler);
        oscHandlers.add(this.vMCHandler);
        this.oSCRouter = new OSCRouter(this.configManager.getVrConfig().getOscRouter(), oscHandlers);
        this.bvhRecorder = new BVHRecorder(this);
        for (Tracker tracker : computedTrackers) {
            this.registerTracker(tracker);
        }
        instance = this;
    }

    public /* synthetic */ VRServer(Function2 function2, Function1 function1, Function1 function12, Function1 function13, Function0 function0, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = VRServer::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            function1 = VRServer::_init_$lambda$1;
        }
        if ((n & 4) != 0) {
            function12 = 3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function13 = VRServer::_init_$lambda$2;
        }
        if ((n & 0x10) != 0) {
            function0 = 5.INSTANCE;
        }
        this(function2, function1, function12, function13, function0, string);
    }

    @NotNull
    public final TrackersUDPServer getTrackersServer() {
        return this.trackersServer;
    }

    @NotNull
    public final OSCRouter getOSCRouter() {
        return this.oSCRouter;
    }

    @NotNull
    public final VMCHandler getVMCHandler() {
        return this.vMCHandler;
    }

    @Nullable
    public final SerialFlashingHandler getSerialFlashingHandler() {
        return this.serialFlashingHandler;
    }

    public final void setSerialFlashingHandler(@Nullable SerialFlashingHandler serialFlashingHandler) {
        this.serialFlashingHandler = serialFlashingHandler;
    }

    @NotNull
    public final FirmwareUpdateHandler getFirmwareUpdateHandler() {
        return this.firmwareUpdateHandler;
    }

    @NotNull
    public final VRChatConfigManager getVrcConfigManager() {
        return this.vrcConfigManager;
    }

    @NotNull
    public final NanoTimer getFpsTimer() {
        return this.fpsTimer;
    }

    public final boolean hasBridge(@NotNull Class<? extends Bridge> bridgeClass) {
        Intrinsics.checkNotNullParameter(bridgeClass, "bridgeClass");
        for (Bridge bridge : this.bridges) {
            if (!bridgeClass.isAssignableFrom(bridge.getClass())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final <E extends Bridge> E getVRBridge(@NotNull Class<E> bridgeClass) {
        Intrinsics.checkNotNullParameter(bridgeClass, "bridgeClass");
        for (Bridge bridge : this.bridges) {
            if (!bridgeClass.isAssignableFrom(bridge.getClass())) continue;
            return (E)((Bridge)bridgeClass.cast(bridge));
        }
        return null;
    }

    public final void addOnTick(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        this.onTick.add(runnable);
    }

    public final void addNewTrackerConsumer(@NotNull Consumer<Tracker> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        this.queueTask(() -> VRServer.addNewTrackerConsumer$lambda$5(this, consumer));
    }

    public final void trackerUpdated(@Nullable Tracker tracker) {
        this.queueTask(() -> VRServer.trackerUpdated$lambda$6(this, tracker));
    }

    public final void addSkeletonUpdatedCallback(@NotNull Consumer<HumanSkeleton> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        this.queueTask(() -> VRServer.addSkeletonUpdatedCallback$lambda$7(this, consumer));
    }

    @Override
    public void run() {
        this.trackersServer.start();
        while (true) {
            Iterator<Object> task;
            this.fpsTimer.update();
            while (this.tasks.poll() != null) {
                task.run();
            }
            for (Runnable task2 : this.onTick) {
                task2.run();
            }
            for (Bridge bridge : this.bridges) {
                bridge.dataRead();
            }
            for (Tracker tracker : this.trackers) {
                tracker.tick(this.fpsTimer.getTimePerFrame());
            }
            this.humanPoseManager.update();
            task = this.bridges.iterator();
            while (task.hasNext()) {
                Bridge bridge;
                bridge = (Bridge)task.next();
                bridge.dataWrite();
            }
            this.vrcOSCHandler.update();
            this.vMCHandler.update();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException error) {
                LogManager.info("VRServer thread interrupted");
                return;
            }
        }
    }

    public final void queueTask(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter(r, "r");
        this.tasks.add(r);
    }

    private final void trackerAdded(Tracker tracker) {
        this.humanPoseManager.trackerAdded(tracker);
        this.updateSkeletonModel();
        if (tracker.isComputed()) {
            this.vMCHandler.addComputedTracker(tracker);
        }
        this.refreshTrackersDriftCompensationEnabled();
    }

    public final void registerTracker(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this.configManager.getVrConfig().readTrackerConfig(tracker);
        this.queueTask(() -> VRServer.registerTracker$lambda$8(this, tracker));
    }

    public final void updateSkeletonModel() {
        this.queueTask(() -> VRServer.updateSkeletonModel$lambda$9(this));
    }

    public final void resetTrackersFull(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.queueTask(() -> VRServer.resetTrackersFull$lambda$10(this, resetSourceName, bodyParts));
    }

    public static /* synthetic */ void resetTrackersFull$default(VRServer vRServer, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        vRServer.resetTrackersFull(string, list);
    }

    public final void resetTrackersYaw(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.queueTask(() -> VRServer.resetTrackersYaw$lambda$11(this, resetSourceName, bodyParts));
    }

    public static /* synthetic */ void resetTrackersYaw$default(VRServer vRServer, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = TrackerUtils.INSTANCE.getAllBodyPartsButFingers();
        }
        vRServer.resetTrackersYaw(string, list);
    }

    public final void resetTrackersMounting(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.queueTask(() -> VRServer.resetTrackersMounting$lambda$12(this, resetSourceName, bodyParts));
    }

    public static /* synthetic */ void resetTrackersMounting$default(VRServer vRServer, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = TrackerUtils.INSTANCE.getAllBodyPartsButFingers();
        }
        vRServer.resetTrackersMounting(string, list);
    }

    public final void clearTrackersMounting(@Nullable String resetSourceName) {
        this.queueTask(() -> VRServer.clearTrackersMounting$lambda$13(this, resetSourceName));
    }

    public final boolean getPauseTracking() {
        return this.humanPoseManager.getPauseTracking();
    }

    public final void setPauseTracking(boolean pauseTracking, @Nullable String sourceName) {
        this.queueTask(() -> VRServer.setPauseTracking$lambda$14(this, pauseTracking, sourceName));
    }

    public final void togglePauseTracking(@Nullable String sourceName) {
        this.queueTask(() -> VRServer.togglePauseTracking$lambda$15(this, sourceName));
    }

    public final void scheduleResetTrackersFull(@Nullable String resetSourceName, long delay) {
        if (delay > 0L) {
            this.resetHandler.sendStarted(1);
        }
        Timer timer = this.timer;
        TimerTask timerTask2 = new TimerTask(this, resetSourceName){
            final /* synthetic */ VRServer this$0;
            final /* synthetic */ String $resetSourceName$inlined;
            {
                this.this$0 = vRServer;
                this.$resetSourceName$inlined = string;
            }

            public void run() {
                TimerTask $this$scheduleResetTrackersFull_u24lambda_u2416 = this;
                boolean bl = false;
                this.this$0.queueTask(new Runnable(this.this$0, this.$resetSourceName$inlined){
                    final /* synthetic */ VRServer this$0;
                    final /* synthetic */ String $resetSourceName;
                    {
                        this.this$0 = $receiver;
                        this.$resetSourceName = $resetSourceName;
                    }

                    public final void run() {
                        HumanPoseManager.resetTrackersFull$default(this.this$0.humanPoseManager, this.$resetSourceName, null, 2, null);
                        this.this$0.resetHandler.sendFinished(1);
                    }
                });
            }
        };
        timer.schedule(timerTask2, delay);
    }

    public final void scheduleResetTrackersYaw(@Nullable String resetSourceName, long delay) {
        if (delay > 0L) {
            this.resetHandler.sendStarted(0);
        }
        Timer timer = this.timer;
        TimerTask timerTask2 = new TimerTask(this, resetSourceName){
            final /* synthetic */ VRServer this$0;
            final /* synthetic */ String $resetSourceName$inlined;
            {
                this.this$0 = vRServer;
                this.$resetSourceName$inlined = string;
            }

            public void run() {
                TimerTask $this$scheduleResetTrackersYaw_u24lambda_u2417 = this;
                boolean bl = false;
                this.this$0.queueTask(new Runnable(this.this$0, this.$resetSourceName$inlined){
                    final /* synthetic */ VRServer this$0;
                    final /* synthetic */ String $resetSourceName;
                    {
                        this.this$0 = $receiver;
                        this.$resetSourceName = $resetSourceName;
                    }

                    public final void run() {
                        HumanPoseManager.resetTrackersYaw$default(this.this$0.humanPoseManager, this.$resetSourceName, null, 2, null);
                        this.this$0.resetHandler.sendFinished(0);
                    }
                });
            }
        };
        timer.schedule(timerTask2, delay);
    }

    public final void scheduleResetTrackersMounting(@Nullable String resetSourceName, long delay) {
        if (delay > 0L) {
            this.resetHandler.sendStarted(2);
        }
        Timer timer = this.timer;
        TimerTask timerTask2 = new TimerTask(this, resetSourceName){
            final /* synthetic */ VRServer this$0;
            final /* synthetic */ String $resetSourceName$inlined;
            {
                this.this$0 = vRServer;
                this.$resetSourceName$inlined = string;
            }

            public void run() {
                TimerTask $this$scheduleResetTrackersMounting_u24lambda_u2418 = this;
                boolean bl = false;
                this.this$0.queueTask(new Runnable(this.this$0, this.$resetSourceName$inlined){
                    final /* synthetic */ VRServer this$0;
                    final /* synthetic */ String $resetSourceName;
                    {
                        this.this$0 = $receiver;
                        this.$resetSourceName = $resetSourceName;
                    }

                    public final void run() {
                        HumanPoseManager.resetTrackersMounting$default(this.this$0.humanPoseManager, this.$resetSourceName, null, 2, null);
                        this.this$0.resetHandler.sendFinished(2);
                    }
                });
            }
        };
        timer.schedule(timerTask2, delay);
    }

    public final void scheduleSetPauseTracking(boolean pauseTracking, @Nullable String sourceName, long delay) {
        Timer timer = this.timer;
        TimerTask timerTask2 = new TimerTask(this, pauseTracking, sourceName){
            final /* synthetic */ VRServer this$0;
            final /* synthetic */ boolean $pauseTracking$inlined;
            final /* synthetic */ String $sourceName$inlined;
            {
                this.this$0 = vRServer;
                this.$pauseTracking$inlined = bl;
                this.$sourceName$inlined = string;
            }

            public void run() {
                TimerTask $this$scheduleSetPauseTracking_u24lambda_u2419 = this;
                boolean bl = false;
                this.this$0.queueTask(new Runnable(this.this$0, this.$pauseTracking$inlined, this.$sourceName$inlined){
                    final /* synthetic */ VRServer this$0;
                    final /* synthetic */ boolean $pauseTracking;
                    final /* synthetic */ String $sourceName;
                    {
                        this.this$0 = $receiver;
                        this.$pauseTracking = $pauseTracking;
                        this.$sourceName = $sourceName;
                    }

                    public final void run() {
                        this.this$0.humanPoseManager.setPauseTracking(this.$pauseTracking, this.$sourceName);
                    }
                });
            }
        };
        timer.schedule(timerTask2, delay);
    }

    public final void scheduleTogglePauseTracking(@Nullable String sourceName, long delay) {
        Timer timer = this.timer;
        TimerTask timerTask2 = new TimerTask(this, sourceName){
            final /* synthetic */ VRServer this$0;
            final /* synthetic */ String $sourceName$inlined;
            {
                this.this$0 = vRServer;
                this.$sourceName$inlined = string;
            }

            public void run() {
                TimerTask $this$scheduleTogglePauseTracking_u24lambda_u2420 = this;
                boolean bl = false;
                this.this$0.queueTask(new Runnable(this.this$0, this.$sourceName$inlined){
                    final /* synthetic */ VRServer this$0;
                    final /* synthetic */ String $sourceName;
                    {
                        this.this$0 = $receiver;
                        this.$sourceName = $sourceName;
                    }

                    public final void run() {
                        this.this$0.humanPoseManager.togglePauseTracking(this.$sourceName);
                    }
                });
            }
        };
        timer.schedule(timerTask2, delay);
    }

    public final void setLegTweaksEnabled(boolean value) {
        this.queueTask(() -> VRServer.setLegTweaksEnabled$lambda$21(this, value));
    }

    public final void setSkatingReductionEnabled(boolean value) {
        this.queueTask(() -> VRServer.setSkatingReductionEnabled$lambda$22(this, value));
    }

    public final void setFloorClipEnabled(boolean value) {
        this.queueTask(() -> VRServer.setFloorClipEnabled$lambda$23(this, value));
    }

    public final int getTrackersCount() {
        return this.trackers.size();
    }

    @NotNull
    public final List<Tracker> getAllTrackers() {
        return new FastList<Collection>(this.trackers);
    }

    @Nullable
    public final Tracker getTrackerById(@NotNull TrackerIdT id) {
        Intrinsics.checkNotNullParameter(id, "id");
        for (Tracker tracker : this.trackers) {
            if (tracker.getTrackerNum() != id.getTrackerNum()) continue;
            if (id.getDeviceId() == null && tracker.getDevice() == null) {
                return tracker;
            }
            if (tracker.getDevice() == null || id.getDeviceId() == null || id.getDeviceId().getId() != tracker.getDevice().getId()) continue;
            return tracker;
        }
        return null;
    }

    public final void clearTrackersDriftCompensation() {
        for (Tracker t : this.getAllTrackers()) {
            if (!t.isImu()) continue;
            t.getResetsHandler().clearDriftCompensation();
        }
    }

    public final void refreshTrackersDriftCompensationEnabled() {
        for (Tracker t : this.getAllTrackers()) {
            if (!t.isImu()) continue;
            t.getResetsHandler().refreshDriftCompensationEnabled();
        }
    }

    public final void trackerStatusChanged(@NotNull Tracker tracker, @NotNull TrackerStatus oldStatus, @NotNull TrackerStatus newStatus) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        Intrinsics.checkNotNullParameter((Object)oldStatus, "oldStatus");
        Intrinsics.checkNotNullParameter((Object)newStatus, "newStatus");
        Iterable $this$forEach$iv = this.trackerStatusListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackerStatusListener it = (TrackerStatusListener)element$iv;
            boolean bl = false;
            it.onTrackerStatusChanged(tracker, oldStatus, newStatus);
        }
    }

    public final void addTrackerStatusListener(@NotNull TrackerStatusListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.trackerStatusListeners.add(listener2);
    }

    public final void removeTrackerStatusListener(@NotNull TrackerStatusListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.trackerStatusListeners.removeIf(arg_0 -> VRServer.removeTrackerStatusListener$lambda$26(arg_0 -> VRServer.removeTrackerStatusListener$lambda$25(listener2, arg_0), arg_0));
    }

    @JvmOverloads
    public VRServer(@NotNull Function2<? super VRServer, ? super List<Tracker>, ? extends Sequence<? extends Bridge>> bridgeProvider, @NotNull Function1<? super VRServer, ? extends SerialHandler> serialHandlerProvider, @NotNull Function1<? super VRServer, ? extends SerialFlashingHandler> flashingHandlerProvider, @NotNull Function1<? super VRServer, ? extends VRCConfigHandler> vrcConfigHandlerProvider, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter(bridgeProvider, "bridgeProvider");
        Intrinsics.checkNotNullParameter(serialHandlerProvider, "serialHandlerProvider");
        Intrinsics.checkNotNullParameter(flashingHandlerProvider, "flashingHandlerProvider");
        Intrinsics.checkNotNullParameter(vrcConfigHandlerProvider, "vrcConfigHandlerProvider");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        this(bridgeProvider, serialHandlerProvider, flashingHandlerProvider, vrcConfigHandlerProvider, null, configPath, 16, null);
    }

    @JvmOverloads
    public VRServer(@NotNull Function2<? super VRServer, ? super List<Tracker>, ? extends Sequence<? extends Bridge>> bridgeProvider, @NotNull Function1<? super VRServer, ? extends SerialHandler> serialHandlerProvider, @NotNull Function1<? super VRServer, ? extends SerialFlashingHandler> flashingHandlerProvider, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter(bridgeProvider, "bridgeProvider");
        Intrinsics.checkNotNullParameter(serialHandlerProvider, "serialHandlerProvider");
        Intrinsics.checkNotNullParameter(flashingHandlerProvider, "flashingHandlerProvider");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        this(bridgeProvider, serialHandlerProvider, flashingHandlerProvider, null, null, configPath, 24, null);
    }

    @JvmOverloads
    public VRServer(@NotNull Function2<? super VRServer, ? super List<Tracker>, ? extends Sequence<? extends Bridge>> bridgeProvider, @NotNull Function1<? super VRServer, ? extends SerialHandler> serialHandlerProvider, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter(bridgeProvider, "bridgeProvider");
        Intrinsics.checkNotNullParameter(serialHandlerProvider, "serialHandlerProvider");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        this(bridgeProvider, serialHandlerProvider, null, null, null, configPath, 28, null);
    }

    @JvmOverloads
    public VRServer(@NotNull Function2<? super VRServer, ? super List<Tracker>, ? extends Sequence<? extends Bridge>> bridgeProvider, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter(bridgeProvider, "bridgeProvider");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        this(bridgeProvider, null, null, null, null, configPath, 30, null);
    }

    @JvmOverloads
    public VRServer(@NotNull String configPath) {
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        this(null, null, null, null, null, configPath, 31, null);
    }

    private static final Sequence _init_$lambda$0(VRServer vRServer, List list) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        Intrinsics.checkNotNullParameter(list, "<unused var>");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Bridge>, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(SequenceScope<? super Bridge> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final SerialHandlerStub _init_$lambda$1(VRServer vRServer) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        return new SerialHandlerStub();
    }

    private static final VRCConfigHandlerStub _init_$lambda$2(VRServer vRServer) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        return new VRCConfigHandlerStub();
    }

    private static final void _init_$lambda$3(VRServer this$0, Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this$0.registerTracker(tracker);
    }

    private static final void _init_$lambda$4(Bridge $bridge) {
        $bridge.startBridge();
    }

    private static final void addNewTrackerConsumer$lambda$5(VRServer this$0, Consumer $consumer) {
        this$0.newTrackersConsumers.add($consumer);
        for (Tracker tracker : this$0.trackers) {
            $consumer.accept(tracker);
        }
    }

    private static final void trackerUpdated$lambda$6(VRServer this$0, Tracker $tracker) {
        this$0.humanPoseManager.trackerUpdated($tracker);
        this$0.updateSkeletonModel();
        this$0.refreshTrackersDriftCompensationEnabled();
        this$0.configManager.getVrConfig().writeTrackerConfig($tracker);
        this$0.configManager.saveConfig();
    }

    private static final void addSkeletonUpdatedCallback$lambda$7(VRServer this$0, Consumer $consumer) {
        this$0.humanPoseManager.addSkeletonUpdatedCallback($consumer);
    }

    private static final void registerTracker$lambda$8(VRServer this$0, Tracker $tracker) {
        this$0.trackers.add($tracker);
        this$0.trackerAdded($tracker);
        for (Consumer<Tracker> tc : this$0.newTrackersConsumers) {
            tc.accept($tracker);
        }
    }

    private static final void updateSkeletonModel$lambda$9(VRServer this$0) {
        this$0.humanPoseManager.updateSkeletonModelFromServer();
        this$0.vrcOSCHandler.setHeadTracker(TrackerUtils.getTrackerForSkeleton(this$0.trackers, TrackerPosition.HEAD));
        ISteamVRBridge iSteamVRBridge = this$0.getVRBridge(ISteamVRBridge.class);
        boolean bl = iSteamVRBridge != null ? iSteamVRBridge.updateShareSettingsAutomatically() : false;
        if (bl) {
            ProtocolAPI protocolAPI = this$0.protocolAPI;
            RPCHandler rPCHandler = this$0.protocolAPI.rpcHandler;
            Intrinsics.checkNotNullExpressionValue(rPCHandler, "rpcHandler");
            RPCSettingsHandler.Companion.sendSteamVRUpdatedSettings(protocolAPI, rPCHandler);
        }
    }

    private static final void resetTrackersFull$lambda$10(VRServer this$0, String $resetSourceName, List $bodyParts) {
        this$0.humanPoseManager.resetTrackersFull($resetSourceName, $bodyParts);
    }

    private static final void resetTrackersYaw$lambda$11(VRServer this$0, String $resetSourceName, List $bodyParts) {
        this$0.humanPoseManager.resetTrackersYaw($resetSourceName, $bodyParts);
    }

    private static final void resetTrackersMounting$lambda$12(VRServer this$0, String $resetSourceName, List $bodyParts) {
        this$0.humanPoseManager.resetTrackersMounting($resetSourceName, $bodyParts);
    }

    private static final void clearTrackersMounting$lambda$13(VRServer this$0, String $resetSourceName) {
        this$0.humanPoseManager.clearTrackersMounting($resetSourceName);
    }

    private static final void setPauseTracking$lambda$14(VRServer this$0, boolean $pauseTracking, String $sourceName) {
        this$0.humanPoseManager.setPauseTracking($pauseTracking, $sourceName);
        ISteamVRBridge iSteamVRBridge = this$0.getVRBridge(ISteamVRBridge.class);
        boolean bl = iSteamVRBridge != null ? iSteamVRBridge.updateShareSettingsAutomatically() : false;
        if (bl) {
            ProtocolAPI protocolAPI = this$0.protocolAPI;
            RPCHandler rPCHandler = this$0.protocolAPI.rpcHandler;
            Intrinsics.checkNotNullExpressionValue(rPCHandler, "rpcHandler");
            RPCSettingsHandler.Companion.sendSteamVRUpdatedSettings(protocolAPI, rPCHandler);
        }
    }

    private static final void togglePauseTracking$lambda$15(VRServer this$0, String $sourceName) {
        this$0.humanPoseManager.togglePauseTracking($sourceName);
        ISteamVRBridge iSteamVRBridge = this$0.getVRBridge(ISteamVRBridge.class);
        boolean bl = iSteamVRBridge != null ? iSteamVRBridge.updateShareSettingsAutomatically() : false;
        if (bl) {
            ProtocolAPI protocolAPI = this$0.protocolAPI;
            RPCHandler rPCHandler = this$0.protocolAPI.rpcHandler;
            Intrinsics.checkNotNullExpressionValue(rPCHandler, "rpcHandler");
            RPCSettingsHandler.Companion.sendSteamVRUpdatedSettings(protocolAPI, rPCHandler);
        }
    }

    private static final void setLegTweaksEnabled$lambda$21(VRServer this$0, boolean $value) {
        this$0.humanPoseManager.setLegTweaksEnabled($value);
    }

    private static final void setSkatingReductionEnabled$lambda$22(VRServer this$0, boolean $value) {
        this$0.humanPoseManager.setSkatingCorrectionEnabled($value);
    }

    private static final void setFloorClipEnabled$lambda$23(VRServer this$0, boolean $value) {
        this$0.humanPoseManager.setFloorClipEnabled($value);
    }

    private static final boolean removeTrackerStatusListener$lambda$25(TrackerStatusListener $listener, TrackerStatusListener it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual($listener, it);
    }

    private static final boolean removeTrackerStatusListener$lambda$26(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final int getNextLocalTrackerId() {
        return Companion.getNextLocalTrackerId();
    }

    public static final int getCurrentLocalTrackerId() {
        return Companion.getCurrentLocalTrackerId();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldev/slimevr/VRServer$Companion;", "", "<init>", "()V", "nextLocalTrackerId", "Ljava/util/concurrent/atomic/AtomicInteger;", "value", "Ldev/slimevr/VRServer;", "instance", "getInstance", "()Ldev/slimevr/VRServer;", "instanceInitialized", "", "getInstanceInitialized", "()Z", "getNextLocalTrackerId", "", "currentLocalTrackerId", "getCurrentLocalTrackerId$annotations", "getCurrentLocalTrackerId", "()I", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VRServer getInstance() {
            VRServer vRServer = instance;
            if (vRServer != null) {
                return vRServer;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final boolean getInstanceInitialized() {
            return instance != null;
        }

        @JvmStatic
        public final int getNextLocalTrackerId() {
            return nextLocalTrackerId.incrementAndGet();
        }

        public final int getCurrentLocalTrackerId() {
            return nextLocalTrackerId.get();
        }

        @JvmStatic
        public static /* synthetic */ void getCurrentLocalTrackerId$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

