/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.autobone;

import dev.slimevr.VRServer;
import dev.slimevr.autobone.AutoBoneStep;
import dev.slimevr.autobone.BoneContribution;
import dev.slimevr.autobone.PoseFrameIterator;
import dev.slimevr.autobone.PoseFrameStep;
import dev.slimevr.autobone.StatsCalculator;
import dev.slimevr.autobone.errors.AutoBoneException;
import dev.slimevr.autobone.errors.BodyProportionError;
import dev.slimevr.autobone.errors.FootHeightOffsetError;
import dev.slimevr.autobone.errors.HeightError;
import dev.slimevr.autobone.errors.OffsetSlideError;
import dev.slimevr.autobone.errors.PositionError;
import dev.slimevr.autobone.errors.PositionOffsetError;
import dev.slimevr.autobone.errors.SlideError;
import dev.slimevr.config.AutoBoneConfig;
import dev.slimevr.config.SkeletonConfig;
import dev.slimevr.poseframeformat.PfrIO;
import dev.slimevr.poseframeformat.PfsIO;
import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrames;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerRole;
import io.eiren.util.OperatingSystem;
import io.eiren.util.StringUtils;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Vector3;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 x2\u00020\u0001:\u0003vwxB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010K\u001a\u00020LH\u0002J$\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020O2\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0PJ\u0014\u0010Q\u001a\u00020R2\n\b\u0002\u0010N\u001a\u0004\u0018\u00010OH\u0007J\u0018\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020U2\b\b\u0002\u0010V\u001a\u00020DJ\u001e\u0010W\u001a\u00020L2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\u0006\u0010[\u001a\u00020\tH\u0002J\u001c\u0010\\\u001a\u00020L2\u0006\u0010T\u001a\u00020U2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0YJ<\u0010]\u001a\u00060^R\u00020\u00002\u0006\u0010T\u001a\u00020U2\b\b\u0002\u0010V\u001a\u00020D2\b\b\u0002\u0010_\u001a\u00020H2\u0014\b\u0002\u0010`\u001a\u000e\u0012\b\u0012\u00060bR\u00020\u0000\u0018\u00010aJ,\u0010c\u001a\u00020L2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\u0014\b\u0002\u0010`\u001a\u000e\u0012\b\u0012\u00060bR\u00020\u0000\u0018\u00010aH\u0002J\u0016\u0010X\u001a\u00020L2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0YH\u0002J\u0010\u0010d\u001a\u00020\t2\u0006\u0010N\u001a\u00020OH\u0002J\u001e\u0010e\u001a\u00020\t2\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J$\u0010f\u001a\u00020L2\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010g\u001a\u00020\t2\b\b\u0002\u0010h\u001a\u00020RH\u0002J2\u0010i\u001a\u00020L2\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010g\u001a\u00020\t2\b\b\u0002\u0010j\u001a\u00020RH\u0002J\u0016\u0010k\u001a\u00020\t2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0YH\u0002J\u0016\u0010p\u001a\u00020L2\u0006\u0010T\u001a\u00020U2\u0006\u0010q\u001a\u00020rJ\u0016\u0010p\u001a\u00020L2\u0006\u0010T\u001a\u00020U2\u0006\u0010s\u001a\u00020mJ\u000e\u0010p\u001a\u00020L2\u0006\u0010T\u001a\u00020UJ\u0018\u0010t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020m\u0012\u0004\u0012\u00020U0u0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\b0\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0011\u0010l\u001a\u00020m8F\u00a2\u0006\u0006\u001a\u0004\bn\u0010o\u00a8\u0006y"}, d2={"Ldev/slimevr/autobone/AutoBone;", "", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "offsets", "Ljava/util/EnumMap;", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "", "getOffsets", "()Ljava/util/EnumMap;", "adjustOffsets", "Lio/eiren/util/collections/FastList;", "kotlin.jvm.PlatformType", "getAdjustOffsets", "()Lio/eiren/util/collections/FastList;", "estimatedHeight", "getEstimatedHeight", "()F", "setEstimatedHeight", "(F)V", "adjustedHeightNormalized", "getAdjustedHeightNormalized", "setAdjustedHeightNormalized", "slideError", "Ldev/slimevr/autobone/errors/SlideError;", "getSlideError", "()Ldev/slimevr/autobone/errors/SlideError;", "setSlideError", "(Ldev/slimevr/autobone/errors/SlideError;)V", "offsetSlideError", "Ldev/slimevr/autobone/errors/OffsetSlideError;", "getOffsetSlideError", "()Ldev/slimevr/autobone/errors/OffsetSlideError;", "setOffsetSlideError", "(Ldev/slimevr/autobone/errors/OffsetSlideError;)V", "footHeightOffsetError", "Ldev/slimevr/autobone/errors/FootHeightOffsetError;", "getFootHeightOffsetError", "()Ldev/slimevr/autobone/errors/FootHeightOffsetError;", "setFootHeightOffsetError", "(Ldev/slimevr/autobone/errors/FootHeightOffsetError;)V", "bodyProportionError", "Ldev/slimevr/autobone/errors/BodyProportionError;", "getBodyProportionError", "()Ldev/slimevr/autobone/errors/BodyProportionError;", "setBodyProportionError", "(Ldev/slimevr/autobone/errors/BodyProportionError;)V", "heightError", "Ldev/slimevr/autobone/errors/HeightError;", "getHeightError", "()Ldev/slimevr/autobone/errors/HeightError;", "setHeightError", "(Ldev/slimevr/autobone/errors/HeightError;)V", "positionError", "Ldev/slimevr/autobone/errors/PositionError;", "getPositionError", "()Ldev/slimevr/autobone/errors/PositionError;", "setPositionError", "(Ldev/slimevr/autobone/errors/PositionError;)V", "positionOffsetError", "Ldev/slimevr/autobone/errors/PositionOffsetError;", "getPositionOffsetError", "()Ldev/slimevr/autobone/errors/PositionOffsetError;", "setPositionOffsetError", "(Ldev/slimevr/autobone/errors/PositionOffsetError;)V", "globalConfig", "Ldev/slimevr/config/AutoBoneConfig;", "getGlobalConfig", "()Ldev/slimevr/config/AutoBoneConfig;", "globalSkeletonConfig", "Ldev/slimevr/config/SkeletonConfig;", "getGlobalSkeletonConfig", "()Ldev/slimevr/config/SkeletonConfig;", "loadConfigValues", "", "applyConfig", "humanPoseManager", "Ldev/slimevr/tracking/processor/HumanPoseManager;", "", "applyAndSaveConfig", "", "calcTargetHmdHeight", "frames", "Ldev/slimevr/poseframeformat/PoseFrames;", "config", "updateRecordingScale", "step", "Ldev/slimevr/autobone/PoseFrameStep;", "Ldev/slimevr/autobone/AutoBoneStep;", "scale", "filterFrames", "processFrames", "Ldev/slimevr/autobone/AutoBone$AutoBoneResults;", "skeletonConfig", "epochCallback", "Ljava/util/function/Consumer;", "Ldev/slimevr/autobone/AutoBone$Epoch;", "epoch", "sumAdjustedHeightOffsets", "sumHeightOffsets", "scaleSkeleton", "targetHeight", "onlyAdjustedHeight", "scaleOffsets", "onlyHeightOffsets", "getErrorDeriv", "lengthsString", "", "getLengthsString", "()Ljava/lang/String;", "saveRecording", "recordingFile", "Ljava/io/File;", "recordingFileName", "loadRecordings", "Lorg/apache/commons/lang3/tuple/Pair;", "Epoch", "AutoBoneResults", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAutoBone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoBone.kt\ndev/slimevr/autobone/AutoBone\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,699:1\n1#2:700\n13409#3,2:701\n13409#3,2:703\n13409#3,2:707\n216#4,2:705\n*S KotlinDebug\n*F\n+ 1 AutoBone.kt\ndev/slimevr/autobone/AutoBone\n*L\n477#1:701,2\n489#1:703,2\n622#1:707,2\n571#1:705,2\n*E\n"})
public final class AutoBone {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final VRServer server;
    @NotNull
    private final EnumMap<SkeletonConfigOffsets, Float> offsets;
    @NotNull
    private final FastList<SkeletonConfigOffsets> adjustOffsets;
    private float estimatedHeight;
    private float adjustedHeightNormalized;
    @NotNull
    private SlideError slideError;
    @NotNull
    private OffsetSlideError offsetSlideError;
    @NotNull
    private FootHeightOffsetError footHeightOffsetError;
    @NotNull
    private BodyProportionError bodyProportionError;
    @NotNull
    private HeightError heightError;
    @NotNull
    private PositionError positionError;
    @NotNull
    private PositionOffsetError positionOffsetError;
    @NotNull
    private final AutoBoneConfig globalConfig;
    @NotNull
    private final SkeletonConfig globalSkeletonConfig;
    public static final float MIN_HEIGHT = 0.4f;
    public static final float MIN_SLIDE_DIST = 0.002f;
    @NotNull
    public static final String AUTOBONE_FOLDER = "AutoBone Recordings";
    @NotNull
    public static final String LOADAUTOBONE_FOLDER = "Load AutoBone Recordings";
    @NotNull
    private static final File saveDir;
    @NotNull
    private static final File loadDir;
    @NotNull
    private static final SkeletonConfigOffsets[] SYMM_CONFIGS;

    public AutoBone(@NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        this.offsets = new EnumMap(SkeletonConfigOffsets.class);
        SkeletonConfigOffsets[] skeletonConfigOffsetsArray = new SkeletonConfigOffsets[]{SkeletonConfigOffsets.HEAD, SkeletonConfigOffsets.NECK, SkeletonConfigOffsets.UPPER_CHEST, SkeletonConfigOffsets.CHEST, SkeletonConfigOffsets.WAIST, SkeletonConfigOffsets.HIP, SkeletonConfigOffsets.HIPS_WIDTH, SkeletonConfigOffsets.UPPER_LEG, SkeletonConfigOffsets.LOWER_LEG};
        this.adjustOffsets = new FastList<SkeletonConfigOffsets[]>(skeletonConfigOffsetsArray);
        this.estimatedHeight = 1.0f;
        this.adjustedHeightNormalized = 1.0f;
        this.slideError = new SlideError();
        this.offsetSlideError = new OffsetSlideError();
        this.footHeightOffsetError = new FootHeightOffsetError();
        this.bodyProportionError = new BodyProportionError();
        this.heightError = new HeightError();
        this.positionError = new PositionError();
        this.positionOffsetError = new PositionOffsetError();
        this.globalConfig = this.server.configManager.getVrConfig().getAutoBone();
        this.globalSkeletonConfig = this.server.configManager.getVrConfig().getSkeleton();
        this.loadConfigValues();
    }

    @NotNull
    public final EnumMap<SkeletonConfigOffsets, Float> getOffsets() {
        return this.offsets;
    }

    @NotNull
    public final FastList<SkeletonConfigOffsets> getAdjustOffsets() {
        return this.adjustOffsets;
    }

    public final float getEstimatedHeight() {
        return this.estimatedHeight;
    }

    public final void setEstimatedHeight(float f) {
        this.estimatedHeight = f;
    }

    public final float getAdjustedHeightNormalized() {
        return this.adjustedHeightNormalized;
    }

    public final void setAdjustedHeightNormalized(float f) {
        this.adjustedHeightNormalized = f;
    }

    @NotNull
    public final SlideError getSlideError() {
        return this.slideError;
    }

    public final void setSlideError(@NotNull SlideError slideError) {
        Intrinsics.checkNotNullParameter(slideError, "<set-?>");
        this.slideError = slideError;
    }

    @NotNull
    public final OffsetSlideError getOffsetSlideError() {
        return this.offsetSlideError;
    }

    public final void setOffsetSlideError(@NotNull OffsetSlideError offsetSlideError) {
        Intrinsics.checkNotNullParameter(offsetSlideError, "<set-?>");
        this.offsetSlideError = offsetSlideError;
    }

    @NotNull
    public final FootHeightOffsetError getFootHeightOffsetError() {
        return this.footHeightOffsetError;
    }

    public final void setFootHeightOffsetError(@NotNull FootHeightOffsetError footHeightOffsetError) {
        Intrinsics.checkNotNullParameter(footHeightOffsetError, "<set-?>");
        this.footHeightOffsetError = footHeightOffsetError;
    }

    @NotNull
    public final BodyProportionError getBodyProportionError() {
        return this.bodyProportionError;
    }

    public final void setBodyProportionError(@NotNull BodyProportionError bodyProportionError) {
        Intrinsics.checkNotNullParameter(bodyProportionError, "<set-?>");
        this.bodyProportionError = bodyProportionError;
    }

    @NotNull
    public final HeightError getHeightError() {
        return this.heightError;
    }

    public final void setHeightError(@NotNull HeightError heightError) {
        Intrinsics.checkNotNullParameter(heightError, "<set-?>");
        this.heightError = heightError;
    }

    @NotNull
    public final PositionError getPositionError() {
        return this.positionError;
    }

    public final void setPositionError(@NotNull PositionError positionError) {
        Intrinsics.checkNotNullParameter(positionError, "<set-?>");
        this.positionError = positionError;
    }

    @NotNull
    public final PositionOffsetError getPositionOffsetError() {
        return this.positionOffsetError;
    }

    public final void setPositionOffsetError(@NotNull PositionOffsetError positionOffsetError) {
        Intrinsics.checkNotNullParameter(positionOffsetError, "<set-?>");
        this.positionOffsetError = positionOffsetError;
    }

    @NotNull
    public final AutoBoneConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @NotNull
    public final SkeletonConfig getGlobalSkeletonConfig() {
        return this.globalSkeletonConfig;
    }

    private final void loadConfigValues() {
        Function<SkeletonConfigOffsets, Float> function;
        this.offsets.clear();
        HumanPoseManager skeleton = this.server.humanPoseManager;
        if (skeleton != null) {
            function = arg_0 -> AutoBone.loadConfigValues$lambda$0(skeleton, arg_0);
        } else {
            SkeletonConfigManager defaultConfig = new SkeletonConfigManager(false, null, 2, null);
            function = arg_0 -> AutoBone.loadConfigValues$lambda$1(defaultConfig, arg_0);
        }
        Function<SkeletonConfigOffsets, Float> getOffset = function;
        Iterator iterator2 = this.adjustOffsets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            SkeletonConfigOffsets bone = (SkeletonConfigOffsets)((Object)iterator3.next());
            Float f = getOffset.apply(bone);
            Intrinsics.checkNotNullExpressionValue(f, "apply(...)");
            float offset = ((Number)f).floatValue();
            if (!(offset > 0.0f)) continue;
            Float f2 = Float.valueOf(offset);
            ((Map)this.offsets).put(bone, f2);
        }
    }

    public final void applyConfig(@NotNull HumanPoseManager humanPoseManager, @NotNull Map<SkeletonConfigOffsets, Float> offsets) {
        Intrinsics.checkNotNullParameter(humanPoseManager, "humanPoseManager");
        Intrinsics.checkNotNullParameter(offsets, "offsets");
        for (Map.Entry<SkeletonConfigOffsets, Float> entry : offsets.entrySet()) {
            SkeletonConfigOffsets offset = entry.getKey();
            float value = ((Number)entry.getValue()).floatValue();
            humanPoseManager.setOffset(offset, Float.valueOf(value));
        }
    }

    public static /* synthetic */ void applyConfig$default(AutoBone autoBone, HumanPoseManager humanPoseManager, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = autoBone.offsets;
        }
        autoBone.applyConfig(humanPoseManager, map);
    }

    @JvmOverloads
    public final boolean applyAndSaveConfig(@Nullable HumanPoseManager humanPoseManager) {
        if (humanPoseManager == null) {
            return false;
        }
        AutoBone.applyConfig$default(this, humanPoseManager, null, 2, null);
        humanPoseManager.saveConfig();
        this.server.configManager.saveConfig();
        LogManager.info("[AutoBone] Configured skeleton bone lengths");
        return true;
    }

    public static /* synthetic */ boolean applyAndSaveConfig$default(AutoBone autoBone, HumanPoseManager humanPoseManager, int n, Object object) {
        if ((n & 1) != 0) {
            humanPoseManager = autoBone.server.humanPoseManager;
        }
        return autoBone.applyAndSaveConfig(humanPoseManager);
    }

    public final float calcTargetHmdHeight(@NotNull PoseFrames frames, @NotNull AutoBoneConfig config) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(config, "config");
        float targetHeight = 0.0f;
        HumanPoseManager humanPoseManager = this.server.humanPoseManager;
        if (config.getUseSkeletonHeight() && humanPoseManager != null) {
            targetHeight = humanPoseManager.getUserHeightFromConfig();
            LogManager.warning("[AutoBone] Target height loaded from skeleton (Make sure you reset before running!): " + targetHeight);
        } else {
            float hmdHeight = frames.getMaxHmdHeight();
            if (hmdHeight <= 0.4f) {
                LogManager.warning("[AutoBone] Max headset height detected (Value seems too low, did you not stand up straight while measuring?): " + hmdHeight);
            } else {
                LogManager.info("[AutoBone] Max headset height detected: " + hmdHeight);
            }
            targetHeight = hmdHeight;
        }
        return targetHeight;
    }

    public static /* synthetic */ float calcTargetHmdHeight$default(AutoBone autoBone, PoseFrames poseFrames, AutoBoneConfig autoBoneConfig, int n, Object object) {
        if ((n & 2) != 0) {
            autoBoneConfig = autoBone.globalConfig;
        }
        return autoBone.calcTargetHmdHeight(poseFrames, autoBoneConfig);
    }

    private final void updateRecordingScale(PoseFrameStep<AutoBoneStep> step, float scale) {
        step.getFramePlayer1().setScales(scale);
        step.getFramePlayer2().setScales(scale);
        step.getSkeleton1().update();
        step.getSkeleton2().update();
    }

    public final void filterFrames(@NotNull PoseFrames frames, @NotNull PoseFrameStep<AutoBoneStep> step) {
        int i;
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(step, "step");
        float[] frameErrors = new float[frames.getMaxFrameCount()];
        StatsCalculator frameStats = new StatsCalculator();
        StatsCalculator recordingStats = new StatsCalculator();
        int n = frames.getMaxFrameCount();
        for (int i2 = 0; i2 < n; ++i2) {
            frameStats.reset();
            int n2 = frames.getMaxFrameCount();
            for (int j = 0; j < n2; ++j) {
                if (i2 == j) continue;
                step.setCursors(i2, j, true);
                frameStats.addValue(this.getErrorDeriv(step));
            }
            frameErrors[i2] = frameStats.getMean();
            recordingStats.addValue(frameStats.getMean());
        }
        LogManager.info("[AutoBone] Full recording mean error: " + frameStats.getMean() + " (SD " + frameStats.getStandardDeviation() + ")");
        float sdMult = 1.4f;
        float mean = recordingStats.getMean();
        float sd = recordingStats.getStandardDeviation() * sdMult;
        for (i = frameErrors.length - 1; -1 < i; --i) {
            Iterator iterator2;
            float err = frameErrors[i];
            if (!(err < mean - sd) && !(err > mean + sd)) continue;
            Intrinsics.checkNotNullExpressionValue(frames.getFrameHolders().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                TrackerFrames frameHolder = (TrackerFrames)iterator2.next();
                frameHolder.getFrames().remove(i);
            }
        }
        step.setMaxFrameCount(frames.getMaxFrameCount());
        recordingStats.reset();
        int n3 = frames.getMaxFrameCount();
        for (i = 0; i < n3; ++i) {
            frameStats.reset();
            int n4 = frames.getMaxFrameCount();
            for (int j = 0; j < n4; ++j) {
                if (i == j) continue;
                step.setCursors(i, j, true);
                frameStats.addValue(this.getErrorDeriv(step));
            }
            recordingStats.addValue(frameStats.getMean());
        }
        LogManager.info("[AutoBone] Full recording after mean error: " + frameStats.getMean() + " (SD " + frameStats.getStandardDeviation() + ")");
    }

    @NotNull
    public final AutoBoneResults processFrames(@NotNull PoseFrames frames, @NotNull AutoBoneConfig config, @NotNull SkeletonConfig skeletonConfig, @Nullable Consumer<Epoch> epochCallback) throws AutoBoneException {
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(skeletonConfig, "skeletonConfig");
        if (!(!((Collection)frames.getFrameHolders()).isEmpty())) {
            boolean $i$a$-check-AutoBone$processFrames$42 = false;
            String $i$a$-check-AutoBone$processFrames$42 = "Recording has no trackers.";
            throw new IllegalStateException($i$a$-check-AutoBone$processFrames$42.toString());
        }
        if (!(frames.getMaxFrameCount() > 0)) {
            boolean $i$a$-check-AutoBone$processFrames$52 = false;
            String $i$a$-check-AutoBone$processFrames$52 = "Recording has no frames.";
            throw new IllegalStateException($i$a$-check-AutoBone$processFrames$52.toString());
        }
        this.loadConfigValues();
        float targetHmdHeight = skeletonConfig.getUserHeight() > 0.4f ? skeletonConfig.getUserHeight() : this.calcTargetHmdHeight(frames, config);
        if (!(targetHmdHeight > 0.4f)) {
            boolean bl = false;
            String string = "Configured height (" + targetHmdHeight + ") is too small (<= 0.4).";
            throw new IllegalStateException(string.toString());
        }
        PoseFrameStep<AutoBoneStep> step = new PoseFrameStep<AutoBoneStep>(config, this.server.configManager, frames, AutoBone::processFrames$lambda$5, this::step, arg_0 -> AutoBone.processFrames$lambda$6(this, epochCallback, arg_0), 0, 0, 0, config.getRandSeed(), new AutoBoneStep(0.0f, targetHmdHeight, 1.0f, 1, null), 448, null);
        AutoBone.scaleSkeleton$default(this, step.getSkeleton1(), 0.0f, false, 6, null);
        AutoBone.scaleSkeleton$default(this, step.getSkeleton2(), 0.0f, false, 6, null);
        this.adjustedHeightNormalized = this.sumAdjustedHeightOffsets(step.getSkeleton1());
        AutoBone.scaleOffsets$default(this, null, 0.0f, false, 7, null);
        AutoBone.applyConfig$default(this, step.getSkeleton1(), null, 2, null);
        AutoBone.applyConfig$default(this, step.getSkeleton2(), null, 2, null);
        this.estimatedHeight = targetHmdHeight;
        this.updateRecordingScale(step, 1.0f / targetHmdHeight);
        if (config.getUseFrameFiltering()) {
            this.filterFrames(frames, step);
        }
        PoseFrameIterator.INSTANCE.iterateFrames(step);
        Iterator<Map.Entry<SkeletonConfigOffsets, Float>> iterator2 = this.offsets.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SkeletonConfigOffsets, Float> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            entry.setValue(Float.valueOf(((Number)entry.getValue()).floatValue() * this.estimatedHeight));
        }
        LogManager.info("[AutoBone] Target height: " + step.getData().getTargetHmdHeight() + ", Final height: " + this.estimatedHeight);
        if (step.getData().getErrorStats().getMean() > config.getMaxFinalError()) {
            throw new AutoBoneException("The final epoch error value (" + step.getData().getErrorStats().getMean() + ") has exceeded the maximum allowed value (" + config.getMaxFinalError() + ").");
        }
        return new AutoBoneResults(this.estimatedHeight, step.getData().getTargetHmdHeight(), this.offsets);
    }

    public static /* synthetic */ AutoBoneResults processFrames$default(AutoBone autoBone, PoseFrames poseFrames, AutoBoneConfig autoBoneConfig, SkeletonConfig skeletonConfig, Consumer consumer, int n, Object object) throws AutoBoneException {
        if ((n & 2) != 0) {
            autoBoneConfig = autoBone.globalConfig;
        }
        if ((n & 4) != 0) {
            skeletonConfig = autoBone.globalSkeletonConfig;
        }
        if ((n & 8) != 0) {
            consumer = null;
        }
        return autoBone.processFrames(poseFrames, autoBoneConfig, skeletonConfig, consumer);
    }

    private final void epoch(PoseFrameStep<AutoBoneStep> step, Consumer<Epoch> epochCallback) {
        AutoBoneConfig config = step.getConfig();
        int epoch = step.getEpoch();
        if (epoch <= 0 || epoch >= config.getNumEpochs() - 1 || (epoch + 1) % config.getPrintEveryNumEpochs() == 0) {
            LogManager.info("[AutoBone] Epoch: " + (epoch + 1) + ", Mean error: " + step.getData().getErrorStats().getMean() + " (SD " + step.getData().getErrorStats().getStandardDeviation() + "), Adjust rate: " + step.getData().getAdjustRate());
            LogManager.info("[AutoBone] Target height: " + step.getData().getTargetHmdHeight() + ", Estimated height: " + this.estimatedHeight);
        }
        if (epochCallback != null) {
            EnumMap<SkeletonConfigOffsets, Float> scaledOffsets = new EnumMap<SkeletonConfigOffsets, Float>(this.offsets);
            Iterator<Map.Entry<SkeletonConfigOffsets, Float>> iterator2 = scaledOffsets.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<SkeletonConfigOffsets, Float> entry;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                entry.setValue(Float.valueOf(((Number)entry.getValue()).floatValue() * this.estimatedHeight));
            }
            epochCallback.accept(new Epoch(epoch + 1, config.getNumEpochs(), step.getData().getErrorStats(), scaledOffsets));
        }
    }

    static /* synthetic */ void epoch$default(AutoBone autoBone, PoseFrameStep poseFrameStep, Consumer consumer, int n, Object object) {
        if ((n & 2) != 0) {
            consumer = null;
        }
        autoBone.epoch(poseFrameStep, consumer);
    }

    private final void step(PoseFrameStep<AutoBoneStep> step) {
        float f;
        float f2;
        HumanPoseManager skeleton1 = step.getSkeleton1();
        HumanPoseManager skeleton2 = step.getSkeleton2();
        if (!step.getConfig().getScaleEachStep()) {
            float maxHeight = step.getData().getTargetHmdHeight() + 0.2f;
            float minHeight = step.getData().getTargetHmdHeight() - 0.2f;
            step.getData().setHmdHeight(this.estimatedHeight);
            float heightErrorDeriv = this.getErrorDeriv(step);
            float heightAdjust = AutoBone.Companion.errorFunc(heightErrorDeriv) * step.getData().getAdjustRate();
            float negHeight = RangesKt.coerceIn(this.estimatedHeight - heightAdjust, minHeight, maxHeight);
            this.updateRecordingScale(step, 1.0f / negHeight);
            step.getData().setHmdHeight(negHeight);
            float negHeightErrorDeriv = this.getErrorDeriv(step);
            float posHeight = RangesKt.coerceIn(this.estimatedHeight + heightAdjust, minHeight, maxHeight);
            this.updateRecordingScale(step, 1.0f / posHeight);
            step.getData().setHmdHeight(posHeight);
            float posHeightErrorDeriv = this.getErrorDeriv(step);
            if (negHeightErrorDeriv < heightErrorDeriv && negHeightErrorDeriv < posHeightErrorDeriv) {
                this.estimatedHeight = negHeight;
                this.updateRecordingScale(step, 1.0f / negHeight);
            } else if (posHeightErrorDeriv < heightErrorDeriv) {
                this.estimatedHeight = posHeight;
            } else {
                this.updateRecordingScale(step, 1.0f / this.estimatedHeight);
            }
        }
        step.getData().setHmdHeight(this.estimatedHeight);
        float errorDeriv = this.getErrorDeriv(step);
        float error = AutoBone.Companion.errorFunc(errorDeriv);
        if (Float.isNaN(error) || Float.isInfinite(error)) {
            LogManager.warning("[AutoBone] Error value is invalid, resetting variables to recover");
            this.loadConfigValues();
            step.getData().getErrorStats().reset();
            return;
        }
        step.getData().getErrorStats().addValue(errorDeriv);
        float adjustVal = error * step.getData().getAdjustRate();
        if (adjustVal == 0.0f) {
            return;
        }
        Tracker negHeight = skeleton2.getComputedTracker(TrackerRole.LEFT_FOOT);
        Tracker negHeightErrorDeriv = skeleton1.getComputedTracker(TrackerRole.LEFT_FOOT);
        Vector3 vector3 = Vector3.minus-1s-5YWc(negHeight.getPosition-x(), negHeight.getPosition-y(), negHeight.getPosition-z(), negHeightErrorDeriv.getPosition-x(), negHeightErrorDeriv.getPosition-y(), negHeightErrorDeriv.getPosition-z());
        float f3 = vector3.unbox-impl-x();
        float slideLLen = Vector3.len-impl(f3, f2 = vector3.unbox-impl-y(), f = vector3.unbox-impl-z());
        Vector3 slideLUnit = slideLLen > 0.002f ? Vector3.div-impl(f3, f2, f, slideLLen) : null;
        Tracker tracker = skeleton2.getComputedTracker(TrackerRole.RIGHT_FOOT);
        Tracker tracker2 = skeleton1.getComputedTracker(TrackerRole.RIGHT_FOOT);
        Vector3 vector32 = Vector3.minus-1s-5YWc(tracker.getPosition-x(), tracker.getPosition-y(), tracker.getPosition-z(), tracker2.getPosition-x(), tracker2.getPosition-y(), tracker2.getPosition-z());
        float f4 = vector32.unbox-impl-x();
        float f5 = vector32.unbox-impl-y();
        float f6 = vector32.unbox-impl-z();
        float slideRLen = Vector3.len-impl(f4, f5, f6);
        Vector3 slideRUnit = slideRLen > 0.002f ? Vector3.div-impl(f4, f5, f6, slideRLen) : null;
        EnumMap<SkeletonConfigOffsets, Float> intermediateOffsets = new EnumMap<SkeletonConfigOffsets, Float>(this.offsets);
        Iterator<Map.Entry<SkeletonConfigOffsets, Float>> iterator2 = intermediateOffsets.entrySet().iterator();
        while (iterator2.hasNext()) {
            float newLength;
            Map.Entry<SkeletonConfigOffsets, Float> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (step.getEpoch() < 0) break;
            Intrinsics.checkNotNullExpressionValue(entry.getKey().affectedOffsets, "affectedOffsets");
            if (((Object[])entry.getKey().affectedOffsets).length == 0) break;
            Float originalLength = entry.getValue();
            SkeletonConfigOffsets skeletonConfigOffsets = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)skeletonConfigOffsets, "<get-key>(...)");
            float slideDot = BoneContribution.INSTANCE.getSlideDot(skeleton1, skeleton2, skeletonConfigOffsets, slideLUnit, slideRUnit);
            float dotLength = originalLength.floatValue() * slideDot;
            float curAdjustVal = adjustVal * -dotLength;
            if (curAdjustVal == 0.0f || (newLength = originalLength.floatValue() + curAdjustVal) < 0.01f) continue;
            SkeletonConfigOffsets skeletonConfigOffsets2 = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)skeletonConfigOffsets2, "<get-key>(...)");
            skeleton1.setOffset(skeletonConfigOffsets2, Float.valueOf(newLength));
            SkeletonConfigOffsets skeletonConfigOffsets3 = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)skeletonConfigOffsets3, "<get-key>(...)");
            skeleton2.setOffset(skeletonConfigOffsets3, Float.valueOf(newLength));
            AutoBone.scaleSkeleton$default(this, skeleton1, 0.0f, true, 2, null);
            AutoBone.scaleSkeleton$default(this, skeleton2, 0.0f, true, 2, null);
            skeleton1.update();
            skeleton2.update();
            float newErrorDeriv = this.getErrorDeriv(step);
            if (newErrorDeriv < errorDeriv) {
                entry.setValue(Float.valueOf(newLength));
            }
            AutoBone.applyConfig$default(this, skeleton1, null, 2, null);
            AutoBone.applyConfig$default(this, skeleton2, null, 2, null);
        }
        this.offsets.putAll((Map<SkeletonConfigOffsets, Float>)intermediateOffsets);
        AutoBone.scaleOffsets$default(this, null, 0.0f, true, 3, null);
        AutoBone.applyConfig$default(this, skeleton1, null, 2, null);
        AutoBone.applyConfig$default(this, skeleton2, null, 2, null);
    }

    private final float sumAdjustedHeightOffsets(HumanPoseManager humanPoseManager) {
        float sum = 0.0f;
        SkeletonConfigOffsets[] $this$forEach$iv = SkeletonConfigManager.Companion.getHEIGHT_OFFSETS();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SkeletonConfigOffsets element$iv;
            SkeletonConfigOffsets it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!this.adjustOffsets.contains((Object)it)) continue;
            sum += humanPoseManager.getOffset(it);
        }
        return sum;
    }

    private final float sumHeightOffsets(EnumMap<SkeletonConfigOffsets, Float> offsets) {
        float sum = 0.0f;
        SkeletonConfigOffsets[] $this$forEach$iv = SkeletonConfigManager.Companion.getHEIGHT_OFFSETS();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SkeletonConfigOffsets element$iv;
            SkeletonConfigOffsets it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Float f = offsets.get((Object)it);
            if (f == null) {
                continue;
            }
            sum = sum + f.floatValue();
        }
        return sum;
    }

    static /* synthetic */ float sumHeightOffsets$default(AutoBone autoBone, EnumMap enumMap, int n, Object object) {
        if ((n & 1) != 0) {
            enumMap = autoBone.offsets;
        }
        return autoBone.sumHeightOffsets(enumMap);
    }

    private final void scaleSkeleton(HumanPoseManager humanPoseManager, float targetHeight, boolean onlyAdjustedHeight) {
        float f;
        if (onlyAdjustedHeight) {
            float adjHeight = this.sumAdjustedHeightOffsets(humanPoseManager);
            float adjTarget = targetHeight - (humanPoseManager.getUserHeightFromConfig() - adjHeight);
            f = adjTarget / adjHeight;
        } else {
            f = targetHeight / humanPoseManager.getUserHeightFromConfig();
        }
        float scale = f;
        SkeletonConfigOffsets[] offsets = onlyAdjustedHeight ? SkeletonConfigManager.Companion.getHEIGHT_OFFSETS() : SkeletonConfigOffsets.values;
        Iterator<SkeletonConfigOffsets> iterator2 = ArrayIteratorKt.iterator(offsets);
        while (iterator2.hasNext()) {
            SkeletonConfigOffsets offset = iterator2.next();
            if (onlyAdjustedHeight && !this.adjustOffsets.contains((Object)offset)) continue;
            humanPoseManager.setOffset(offset, Float.valueOf(humanPoseManager.getOffset(offset) * scale));
        }
    }

    static /* synthetic */ void scaleSkeleton$default(AutoBone autoBone, HumanPoseManager humanPoseManager, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        autoBone.scaleSkeleton(humanPoseManager, f, bl);
    }

    private final void scaleOffsets(EnumMap<SkeletonConfigOffsets, Float> offsets, float targetHeight, boolean onlyHeightOffsets) {
        float scale = targetHeight / this.sumHeightOffsets(offsets);
        Iterator<Map.Entry<SkeletonConfigOffsets, Float>> iterator2 = offsets.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SkeletonConfigOffsets, Float> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (onlyHeightOffsets && !ArraysKt.contains(SkeletonConfigManager.Companion.getHEIGHT_OFFSETS(), entry.getKey())) continue;
            entry.setValue(Float.valueOf(((Number)entry.getValue()).floatValue() * scale));
        }
    }

    static /* synthetic */ void scaleOffsets$default(AutoBone autoBone, EnumMap enumMap, float f, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            enumMap = autoBone.offsets;
        }
        if ((n & 2) != 0) {
            f = autoBone.adjustedHeightNormalized;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        autoBone.scaleOffsets(enumMap, f, bl);
    }

    private final float getErrorDeriv(PoseFrameStep<AutoBoneStep> step) throws AutoBoneException {
        AutoBoneConfig config = step.getConfig();
        float sumError = 0.0f;
        if (config.getSlideErrorFactor() > 0.0f) {
            sumError += this.slideError.getStepError(step) * config.getSlideErrorFactor();
        }
        if (config.getOffsetSlideErrorFactor() > 0.0f) {
            sumError += this.offsetSlideError.getStepError(step) * config.getOffsetSlideErrorFactor();
        }
        if (config.getFootHeightOffsetErrorFactor() > 0.0f) {
            sumError += this.footHeightOffsetError.getStepError(step) * config.getFootHeightOffsetErrorFactor();
        }
        if (config.getBodyProportionErrorFactor() > 0.0f) {
            sumError += this.bodyProportionError.getStepError(step) * config.getBodyProportionErrorFactor();
        }
        if (config.getHeightErrorFactor() > 0.0f) {
            sumError += this.heightError.getStepError(step) * config.getHeightErrorFactor();
        }
        if (config.getPositionErrorFactor() > 0.0f) {
            sumError += this.positionError.getStepError(step) * config.getPositionErrorFactor();
        }
        if (config.getPositionOffsetErrorFactor() > 0.0f) {
            sumError += this.positionOffsetError.getStepError(step) * config.getPositionOffsetErrorFactor();
        }
        return sumError;
    }

    @NotNull
    public final String getLengthsString() {
        StringBuilder configInfo = new StringBuilder();
        Map $this$forEach$iv = this.offsets;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            SkeletonConfigOffsets key2 = (SkeletonConfigOffsets)((Object)entry.getKey());
            Float value = (Float)entry.getValue();
            if (((CharSequence)configInfo).length() > 0) {
                configInfo.append(", ");
            }
            configInfo.append(key2.configKey).append(": ").append(StringUtils.prettyNumber(value.floatValue() * 100.0f, 2));
        }
        String string = configInfo.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void saveRecording(@NotNull PoseFrames frames, @NotNull File recordingFile) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(recordingFile, "recordingFile");
        if (saveDir.isDirectory() || saveDir.mkdirs()) {
            LogManager.info("[AutoBone] Exporting frames to \"" + recordingFile.getPath() + "\"...");
            if (PfsIO.INSTANCE.tryWriteToFile(recordingFile, frames)) {
                LogManager.info("[AutoBone] Done exporting! Recording can be found at \"" + recordingFile.getPath() + "\".");
            } else {
                LogManager.severe("[AutoBone] Failed to export the recording to \"" + recordingFile.getPath() + "\".");
            }
        } else {
            LogManager.severe("[AutoBone] Failed to create the recording directory \"" + saveDir.getPath() + "\".");
        }
    }

    public final void saveRecording(@NotNull PoseFrames frames, @NotNull String recordingFileName) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        Intrinsics.checkNotNullParameter(recordingFileName, "recordingFileName");
        this.saveRecording(frames, new File(saveDir, recordingFileName));
    }

    public final void saveRecording(@NotNull PoseFrames frames) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        File recordingFile = null;
        int recordingIndex = 1;
        while ((recordingFile = new File(saveDir, "ABRecording" + recordingIndex++ + ".pfs")).exists()) {
        }
        this.saveRecording(frames, recordingFile);
    }

    @NotNull
    public final FastList<Pair<String, PoseFrames>> loadRecordings() {
        FastList<Pair<String, PoseFrames>> recordings;
        block4: {
            recordings = new FastList<Pair<String, PoseFrames>>();
            File[] fileArray = loadDir.listFiles();
            if (fileArray == null) break block4;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PoseFrames poseFrames;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!file.isFile()) continue;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (StringsKt.endsWith(string, ".pfs", true)) {
                    LogManager.info("[AutoBone] Loading PFS recording from \"" + file.getPath() + "\"...");
                    Intrinsics.checkNotNull(file);
                    poseFrames = PfsIO.INSTANCE.tryReadFromFile(file);
                } else {
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    if (!StringsKt.endsWith(string2, ".pfr", true)) continue;
                    LogManager.info("[AutoBone] Loading PFR recording from \"" + file.getPath() + "\"...");
                    Intrinsics.checkNotNull(file);
                    poseFrames = PfrIO.INSTANCE.tryReadFromFile(file);
                }
                PoseFrames frames = poseFrames;
                if (frames == null) {
                    LogManager.severe("[AutoBone] Failed to load recording from \"" + file.getPath() + "\".");
                    continue;
                }
                recordings.add(Pair.of(file.getName(), frames));
                LogManager.info("[AutoBone] Loaded recording from \"" + file.getPath() + "\".");
            }
        }
        return recordings;
    }

    @JvmOverloads
    public final boolean applyAndSaveConfig() {
        return AutoBone.applyAndSaveConfig$default(this, null, 1, null);
    }

    private static final Float loadConfigValues$lambda$0(HumanPoseManager $skeleton, SkeletonConfigOffsets key2) {
        Intrinsics.checkNotNullParameter((Object)key2, "key");
        return Float.valueOf($skeleton.getOffset(key2));
    }

    private static final Float loadConfigValues$lambda$1(SkeletonConfigManager $defaultConfig, SkeletonConfigOffsets config) {
        Intrinsics.checkNotNullParameter((Object)config, "config");
        return Float.valueOf($defaultConfig.getOffset(config));
    }

    private static final void processFrames$lambda$5(PoseFrameStep step) {
        Intrinsics.checkNotNullParameter(step, "step");
        ((AutoBoneStep)step.getData()).setAdjustRate(AutoBone.Companion.decayFunc(step.getConfig().getInitialAdjustRate(), step.getConfig().getAdjustRateDecay(), step.getEpoch()));
    }

    private static final void processFrames$lambda$6(AutoBone this$0, Consumer $epochCallback, PoseFrameStep step) {
        Intrinsics.checkNotNullParameter(step, "step");
        this$0.epoch(step, $epochCallback);
    }

    static {
        String string;
        Path path;
        Companion = new Companion(null);
        SkeletonConfigOffsets[] skeletonConfigOffsetsArray = OperatingSystem.Companion.resolveConfigDirectory("dev.slimevr.SlimeVR");
        saveDir = new File(skeletonConfigOffsetsArray != null && (path = skeletonConfigOffsetsArray.resolve(AUTOBONE_FOLDER)) != null && (string = ((Object)path).toString()) != null ? string : AUTOBONE_FOLDER);
        skeletonConfigOffsetsArray = OperatingSystem.Companion.resolveConfigDirectory("dev.slimevr.SlimeVR");
        loadDir = new File(skeletonConfigOffsetsArray != null && (path = skeletonConfigOffsetsArray.resolve(LOADAUTOBONE_FOLDER)) != null && (string = ((Object)path).toString()) != null ? string : LOADAUTOBONE_FOLDER);
        skeletonConfigOffsetsArray = new SkeletonConfigOffsets[]{SkeletonConfigOffsets.HIPS_WIDTH, SkeletonConfigOffsets.SHOULDERS_WIDTH, SkeletonConfigOffsets.SHOULDERS_DISTANCE, SkeletonConfigOffsets.UPPER_ARM, SkeletonConfigOffsets.LOWER_ARM, SkeletonConfigOffsets.UPPER_LEG, SkeletonConfigOffsets.LOWER_LEG, SkeletonConfigOffsets.FOOT_LENGTH};
        SYMM_CONFIGS = skeletonConfigOffsetsArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ldev/slimevr/autobone/AutoBone$AutoBoneResults;", "", "finalHeight", "", "targetHeight", "configValues", "Ljava/util/EnumMap;", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "<init>", "(Ldev/slimevr/autobone/AutoBone;FFLjava/util/EnumMap;)V", "getFinalHeight", "()F", "getTargetHeight", "getConfigValues", "()Ljava/util/EnumMap;", "heightDifference", "getHeightDifference", "core"})
    public final class AutoBoneResults {
        private final float finalHeight;
        private final float targetHeight;
        @NotNull
        private final EnumMap<SkeletonConfigOffsets, Float> configValues;

        public AutoBoneResults(float finalHeight, @NotNull float targetHeight, EnumMap<SkeletonConfigOffsets, Float> configValues) {
            Intrinsics.checkNotNullParameter(configValues, "configValues");
            this.finalHeight = finalHeight;
            this.targetHeight = targetHeight;
            this.configValues = configValues;
        }

        public final float getFinalHeight() {
            return this.finalHeight;
        }

        public final float getTargetHeight() {
            return this.targetHeight;
        }

        @NotNull
        public final EnumMap<SkeletonConfigOffsets, Float> getConfigValues() {
            return this.configValues;
        }

        public final float getHeightDifference() {
            return Math.abs(this.targetHeight - this.finalHeight);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ldev/slimevr/autobone/AutoBone$Companion;", "", "<init>", "()V", "MIN_HEIGHT", "", "MIN_SLIDE_DIST", "AUTOBONE_FOLDER", "", "LOADAUTOBONE_FOLDER", "saveDir", "Ljava/io/File;", "getSaveDir", "()Ljava/io/File;", "loadDir", "getLoadDir", "errorFunc", "errorDeriv", "decayFunc", "initialAdjustRate", "adjustRateDecay", "epoch", "", "SYMM_CONFIGS", "", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "getSYMM_CONFIGS", "()[Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "[Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getSaveDir() {
            return saveDir;
        }

        @NotNull
        public final File getLoadDir() {
            return loadDir;
        }

        private final float errorFunc(float errorDeriv) {
            return 0.5f * (errorDeriv * errorDeriv);
        }

        private final float decayFunc(float initialAdjustRate, float adjustRateDecay, int epoch) {
            return epoch >= 0 ? initialAdjustRate / (1.0f + adjustRateDecay * (float)epoch) : 0.0f;
        }

        @NotNull
        public final SkeletonConfigOffsets[] getSYMM_CONFIGS() {
            return SYMM_CONFIGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Ldev/slimevr/autobone/AutoBone$Epoch;", "", "epoch", "", "totalEpochs", "epochError", "Ldev/slimevr/autobone/StatsCalculator;", "configValues", "Ljava/util/EnumMap;", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "", "<init>", "(Ldev/slimevr/autobone/AutoBone;IILdev/slimevr/autobone/StatsCalculator;Ljava/util/EnumMap;)V", "getEpoch", "()I", "getTotalEpochs", "getEpochError", "()Ldev/slimevr/autobone/StatsCalculator;", "getConfigValues", "()Ljava/util/EnumMap;", "toString", "", "core"})
    public final class Epoch {
        private final int epoch;
        private final int totalEpochs;
        @NotNull
        private final StatsCalculator epochError;
        @NotNull
        private final EnumMap<SkeletonConfigOffsets, Float> configValues;

        public Epoch(int epoch, @NotNull int totalEpochs, @NotNull StatsCalculator epochError, EnumMap<SkeletonConfigOffsets, Float> configValues) {
            Intrinsics.checkNotNullParameter(epochError, "epochError");
            Intrinsics.checkNotNullParameter(configValues, "configValues");
            this.epoch = epoch;
            this.totalEpochs = totalEpochs;
            this.epochError = epochError;
            this.configValues = configValues;
        }

        public final int getEpoch() {
            return this.epoch;
        }

        public final int getTotalEpochs() {
            return this.totalEpochs;
        }

        @NotNull
        public final StatsCalculator getEpochError() {
            return this.epochError;
        }

        @NotNull
        public final EnumMap<SkeletonConfigOffsets, Float> getConfigValues() {
            return this.configValues;
        }

        @NotNull
        public String toString() {
            return "Epoch: " + this.epoch + ", Epoch error: " + this.epochError;
        }
    }
}

