/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.autobone;

import dev.slimevr.VRServer;
import dev.slimevr.autobone.AutoBone;
import dev.slimevr.autobone.AutoBoneListener;
import dev.slimevr.autobone.AutoBoneProcessType;
import dev.slimevr.autobone.StatsCalculator;
import dev.slimevr.autobone.errors.AutoBoneException;
import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.poseframeformat.PoseRecorder;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrame;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrameData;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrames;
import dev.slimevr.tracking.processor.config.SkeletonConfigManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import io.eiren.util.StringUtils;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014JN\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001f2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$H\u0002J\u0014\u0010&\u001a\u00060'R\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010+\u001a\u00020\u0016J\b\u0010,\u001a\u00020\u0016H\u0002J\u0006\u0010-\u001a\u00020\u0016J\u0006\u0010.\u001a\u00020\u0016J\u0006\u0010/\u001a\u00020\u0016J\b\u0010\u000f\u001a\u00020\u0016H\u0002J\u0006\u00100\u001a\u00020\u0016J\b\u00101\u001a\u00020\u0016H\u0002J\u0016\u00102\u001a\u00020\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002J\u0010\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u000208H\u0002J\u0006\u00109\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ldev/slimevr/autobone/AutoBoneHandler;", "", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "poseRecorder", "Ldev/slimevr/poseframeformat/PoseRecorder;", "autoBone", "Ldev/slimevr/autobone/AutoBone;", "recordingLock", "Ljava/util/concurrent/locks/ReentrantLock;", "recordingThread", "Ljava/lang/Thread;", "saveRecordingLock", "saveRecordingThread", "autoBoneLock", "autoBoneThread", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ldev/slimevr/autobone/AutoBoneListener;", "addListener", "", "listener", "removeListener", "announceProcessStatus", "processType", "Ldev/slimevr/autobone/AutoBoneProcessType;", "message", "", "current", "", "total", "eta", "", "completed", "", "success", "processFrames", "Ldev/slimevr/autobone/AutoBone$AutoBoneResults;", "frames", "Ldev/slimevr/poseframeformat/PoseFrames;", "startProcessByType", "startRecording", "startRecordingThread", "stopRecording", "cancelRecording", "saveRecording", "processRecording", "processRecordingThread", "printTrackerInfo", "trackers", "Lio/eiren/util/collections/FastList;", "Ldev/slimevr/poseframeformat/trackerdata/TrackerFrames;", "printSkeletonRatios", "skeleton", "Ldev/slimevr/tracking/processor/config/SkeletonConfigManager;", "applyValues", "core"})
@SourceDebugExtension(value={"SMAP\nAutoBoneHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoBoneHandler.kt\ndev/slimevr/autobone/AutoBoneHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,409:1\n1863#2,2:410\n1863#2,2:412\n1863#2,2:424\n1863#2,2:426\n1#3:414\n381#4,7:415\n216#5,2:422\n*S KotlinDebug\n*F\n+ 1 AutoBoneHandler.kt\ndev/slimevr/autobone/AutoBoneHandler\n*L\n54#1:410,2\n134#1:412,2\n320#1:424,2\n70#1:426,2\n283#1:415,7\n298#1:422,2\n*E\n"})
public final class AutoBoneHandler {
    @NotNull
    private final VRServer server;
    @NotNull
    private final PoseRecorder poseRecorder;
    @NotNull
    private final AutoBone autoBone;
    @NotNull
    private final ReentrantLock recordingLock;
    @Nullable
    private Thread recordingThread;
    @NotNull
    private final ReentrantLock saveRecordingLock;
    @Nullable
    private Thread saveRecordingThread;
    @NotNull
    private final ReentrantLock autoBoneLock;
    @Nullable
    private Thread autoBoneThread;
    @NotNull
    private final CopyOnWriteArrayList<AutoBoneListener> listeners;

    public AutoBoneHandler(@NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        this.poseRecorder = new PoseRecorder(this.server);
        this.autoBone = new AutoBone(this.server);
        this.recordingLock = new ReentrantLock();
        this.saveRecordingLock = new ReentrantLock();
        this.autoBoneLock = new ReentrantLock();
        this.listeners = new CopyOnWriteArrayList();
    }

    public final void addListener(@NotNull AutoBoneListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull AutoBoneListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listeners.removeIf(arg_0 -> AutoBoneHandler.removeListener$lambda$1(arg_0 -> AutoBoneHandler.removeListener$lambda$0(listener2, arg_0), arg_0));
    }

    private final void announceProcessStatus(AutoBoneProcessType processType, String message, long current, long total, float eta, boolean completed, boolean success) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoBoneListener it = (AutoBoneListener)element$iv;
            boolean bl = false;
            it.onAutoBoneProcessStatus(processType, message, current, total, eta, completed, success);
        }
    }

    static /* synthetic */ void announceProcessStatus$default(AutoBoneHandler autoBoneHandler, AutoBoneProcessType autoBoneProcessType, String string, long l, long l2, float f, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        if ((n & 8) != 0) {
            l2 = -1L;
        }
        if ((n & 0x10) != 0) {
            f = -1.0f;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        autoBoneHandler.announceProcessStatus(autoBoneProcessType, string, l, l2, f, bl, bl2);
    }

    private final AutoBone.AutoBoneResults processFrames(PoseFrames frames) throws AutoBoneException {
        return AutoBone.processFrames$default(this.autoBone, frames, null, null, arg_0 -> AutoBoneHandler.processFrames$lambda$4(this, arg_0), 6, null);
    }

    public final boolean startProcessByType(@Nullable AutoBoneProcessType processType) {
        AutoBoneProcessType autoBoneProcessType = processType;
        switch (autoBoneProcessType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[autoBoneProcessType.ordinal()]) {
            case 1: {
                this.startRecording();
                break;
            }
            case 2: {
                this.saveRecording();
                break;
            }
            case 3: {
                this.processRecording();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRecording() {
        Lock lock = this.recordingLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.recordingThread != null) {
                return;
            }
            this.recordingThread = ThreadsKt.thread$default(true, false, null, null, 0, () -> AutoBoneHandler.startRecording$lambda$6$lambda$5(this), 30, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startRecordingThread() {
        block8: {
            try {
                if (this.poseRecorder.isReadyToRecord()) {
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "Recording...", 0L, 0L, 0.0f, false, false, 124, null);
                    int sampleCount = this.autoBone.getGlobalConfig().getSampleCount();
                    float sampleRate = (float)this.autoBone.getGlobalConfig().getSampleRateMs() / 1000.0f;
                    float totalTime = (float)sampleCount * sampleRate;
                    Future framesFuture = PoseRecorder.startFrameRecording$default(this.poseRecorder, sampleCount, sampleRate, null, arg_0 -> AutoBoneHandler.startRecordingThread$lambda$7(this, totalTime, arg_0), 4, null);
                    PoseFrames frames = (PoseFrames)framesFuture.get();
                    LogManager.info("[AutoBone] Done recording!");
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "Saving recording...", 0L, 0L, 0.0f, false, false, 124, null);
                    Intrinsics.checkNotNull(frames);
                    this.autoBone.saveRecording(frames, "LastABRecording.pfr");
                    if (this.autoBone.getGlobalConfig().getSaveRecordings()) {
                        AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "Saving recording (from config option)...", 0L, 0L, 0.0f, false, false, 124, null);
                        this.autoBone.saveRecording(frames);
                    }
                    Iterable $this$forEach$iv = this.listeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AutoBoneListener listener2 = (AutoBoneListener)element$iv;
                        boolean bl = false;
                        listener2.onAutoBoneRecordingEnd(frames);
                    }
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "Done recording!", 0L, 0L, 0.0f, true, true, 28, null);
                    break block8;
                }
                AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "The server is not ready to record", 0L, 0L, 0.0f, true, false, 28, null);
                LogManager.severe("[AutoBone] Unable to record...");
                return;
            }
            catch (Exception e) {
                AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.RECORD, "Recording failed: " + e.getMessage(), 0L, 0L, 0.0f, true, false, 28, null);
                LogManager.severe("[AutoBone] Failed recording!", e);
            }
            finally {
                this.recordingThread = null;
            }
        }
    }

    public final void stopRecording() {
        if (this.poseRecorder.isRecording()) {
            this.poseRecorder.stopFrameRecording();
        }
    }

    public final void cancelRecording() {
        if (this.poseRecorder.isRecording()) {
            this.poseRecorder.cancelFrameRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveRecording() {
        Lock lock = this.saveRecordingLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.saveRecordingThread != null) {
                return;
            }
            this.saveRecordingThread = ThreadsKt.thread$default(true, false, null, null, 0, () -> AutoBoneHandler.saveRecording$lambda$10$lambda$9(this), 30, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveRecordingThread() {
        block8: {
            try {
                Future<PoseFrames> framesFuture = this.poseRecorder.getFramesAsync();
                if (framesFuture != null) {
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.SAVE, "Waiting for recording...", 0L, 0L, 0.0f, false, false, 124, null);
                    PoseFrames frames = framesFuture.get();
                    if (!(!((Collection)frames.getFrameHolders()).isEmpty())) {
                        boolean $i$a$-check-AutoBoneHandler$saveRecordingThread$32 = false;
                        String $i$a$-check-AutoBoneHandler$saveRecordingThread$32 = "Recording has no trackers.";
                        throw new IllegalStateException($i$a$-check-AutoBoneHandler$saveRecordingThread$32.toString());
                    }
                    if (!(frames.getMaxFrameCount() > 0)) {
                        boolean bl = false;
                        String string = "Recording has no frames.";
                        throw new IllegalStateException(string.toString());
                    }
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.SAVE, "Saving recording...", 0L, 0L, 0.0f, false, false, 124, null);
                    Intrinsics.checkNotNull(frames);
                    this.autoBone.saveRecording(frames);
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.SAVE, "Recording saved!", 0L, 0L, 0.0f, true, true, 28, null);
                    break block8;
                }
                AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.SAVE, "No recording found", 0L, 0L, 0.0f, true, false, 28, null);
                LogManager.severe("[AutoBone] Unable to save, no recording was done...");
                return;
            }
            catch (Exception e) {
                AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.SAVE, "Failed to save recording: " + e.getMessage(), 0L, 0L, 0.0f, true, false, 28, null);
                LogManager.severe("[AutoBone] Failed to save recording!", e);
            }
            finally {
                this.saveRecordingThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecording() {
        Lock lock = this.autoBoneLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.autoBoneThread != null) {
                return;
            }
            this.autoBoneThread = ThreadsKt.thread$default(true, false, null, null, 0, () -> AutoBoneHandler.processRecording$lambda$14$lambda$13(this), 30, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processRecordingThread() {
        try {
            AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "Loading recordings...", 0L, 0L, 0.0f, false, false, 124, null);
            FastList<Pair<String, PoseFrames>> frameRecordings = this.autoBone.loadRecordings();
            if (!frameRecordings.isEmpty()) {
                LogManager.info("[AutoBone] Done loading frames!");
            } else {
                Future<PoseFrames> framesFuture = this.poseRecorder.getFramesAsync();
                if (framesFuture == null) {
                    AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "No recordings found...", 0L, 0L, 0.0f, true, false, 28, null);
                    LogManager.severe("[AutoBone] No recordings found in \"" + AutoBone.Companion.getLoadDir().getPath() + "\" and no recording was done...");
                    return;
                }
                AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "Waiting for recording...", 0L, 0L, 0.0f, false, false, 124, null);
                PoseFrames frames = framesFuture.get();
                frameRecordings.add(Pair.of("<Recording>", frames));
            }
            AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "Processing recording(s)...", 0L, 0L, 0.0f, false, false, 124, null);
            LogManager.info("[AutoBone] Processing frames...");
            StatsCalculator errorStats = new StatsCalculator();
            EnumMap offsetStats = new EnumMap(SkeletonConfigOffsets.class);
            SkeletonConfigManager skeletonConfigManagerBuffer = new SkeletonConfigManager(false, null, 2, null);
            Iterator iterator2 = frameRecordings.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Pair pair = (Pair)iterator3.next();
                Intrinsics.checkNotNull(pair);
                String key2 = (String)((Map.Entry)pair).getKey();
                PoseFrames value = (PoseFrames)((Map.Entry)pair).getValue();
                LogManager.info("[AutoBone] Processing frames from \"" + key2 + "\"...");
                this.printTrackerInfo(value.getFrameHolders());
                Intrinsics.checkNotNull(value);
                AutoBone.AutoBoneResults autoBoneResults = this.processFrames(value);
                LogManager.info("[AutoBone] Done processing!");
                errorStats.addValue(autoBoneResults.getHeightDifference());
                for (Object e : ((Map)autoBoneResults.getConfigValues()).entrySet()) {
                    Object object;
                    void $this$getOrPut$iv;
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    Map.Entry offset = (Map.Entry)e;
                    Map map = offsetStats;
                    Object key$iv = offset.getKey();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        StatsCalculator answer$iv = new StatsCalculator();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    StatsCalculator statCalc = (StatsCalculator)object;
                    statCalc.addValue(((Number)offset.getValue()).floatValue() * 100.0f);
                }
                skeletonConfigManagerBuffer.setOffsets((Map<SkeletonConfigOffsets, Float>)autoBoneResults.getConfigValues());
                this.printSkeletonRatios(skeletonConfigManagerBuffer);
                LogManager.info("[AutoBone] Length values: " + this.autoBone.getLengthsString());
            }
            StringBuilder averageLengthVals = new StringBuilder();
            Object $this$forEach$iv = offsetStats;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry entry = element$iv;
                boolean bl = false;
                SkeletonConfigOffsets key3 = (SkeletonConfigOffsets)((Object)entry.getKey());
                StatsCalculator value = (StatsCalculator)entry.getValue();
                if (((CharSequence)averageLengthVals).length() > 0) {
                    averageLengthVals.append(", ");
                }
                averageLengthVals.append(key3.configKey).append(": ").append(StringUtils.prettyNumber(value.getMean(), 2)).append(" (SD ").append(StringUtils.prettyNumber(value.getStandardDeviation(), 2)).append(")");
            }
            LogManager.info("[AutoBone] Average length values: " + averageLengthVals);
            LogManager.info("[AutoBone] Average height error: " + StringUtils.prettyNumber(errorStats.getMean(), 6) + " (SD " + StringUtils.prettyNumber(errorStats.getStandardDeviation(), 6) + ")");
            $this$forEach$iv = this.listeners;
            $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv.iterator();
            while (iterator4.hasNext()) {
                Map.Entry element$iv;
                element$iv = iterator4.next();
                AutoBoneListener listener2 = (AutoBoneListener)((Object)element$iv);
                boolean bl = false;
                listener2.onAutoBoneEnd(this.autoBone.getOffsets());
            }
            AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "Done processing!", 0L, 0L, 0.0f, true, true, 28, null);
        }
        catch (Exception e) {
            AutoBoneHandler.announceProcessStatus$default(this, AutoBoneProcessType.PROCESS, "Processing failed: " + e.getMessage(), 0L, 0L, 0.0f, true, false, 28, null);
            LogManager.severe("[AutoBone] Failed adjustment!", e);
        }
        finally {
            this.autoBoneThread = null;
        }
    }

    private final void printTrackerInfo(FastList<TrackerFrames> trackers) {
        StringBuilder trackerInfo = new StringBuilder();
        Iterator iterator2 = trackers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object;
            TrackerFrames tracker = (TrackerFrames)iterator3.next();
            Object object2 = tracker;
            if (object2 == null || (object2 = ((TrackerFrames)object2).tryGetFrame(0)) == null) continue;
            Object frame = object2;
            if (((CharSequence)trackerInfo).length() > 0) {
                trackerInfo.append(", ");
            }
            if ((object = ((TrackerFrame)frame).tryGetTrackerPosition()) == null || (object = object.getDesignation()) == null) {
                object = "unassigned";
            }
            trackerInfo.append((String)object);
            StringBuilder trackerFlags = new StringBuilder();
            if (((TrackerFrame)frame).hasData(TrackerFrameData.ROTATION)) {
                trackerFlags.append("R");
            }
            if (((TrackerFrame)frame).hasData(TrackerFrameData.POSITION)) {
                trackerFlags.append("P");
            }
            if (((TrackerFrame)frame).hasData(TrackerFrameData.ACCELERATION)) {
                trackerFlags.append("A");
            }
            if (((TrackerFrame)frame).hasData(TrackerFrameData.RAW_ROTATION)) {
                trackerFlags.append("r");
            }
            if (!(((CharSequence)trackerFlags).length() > 0)) continue;
            trackerInfo.append(" (").append((CharSequence)trackerFlags).append(")");
        }
        LogManager.info("[AutoBone] (" + trackers.size() + " trackers) [" + trackerInfo + "]");
    }

    private final void printSkeletonRatios(SkeletonConfigManager skeleton) {
        float neckLength = skeleton.getOffset(SkeletonConfigOffsets.NECK);
        float upperChestLength = skeleton.getOffset(SkeletonConfigOffsets.UPPER_CHEST);
        float chestLength = skeleton.getOffset(SkeletonConfigOffsets.CHEST);
        float waistLength = skeleton.getOffset(SkeletonConfigOffsets.WAIST);
        float hipLength = skeleton.getOffset(SkeletonConfigOffsets.HIP);
        float torsoLength = upperChestLength + chestLength + waistLength + hipLength;
        float hipWidth = skeleton.getOffset(SkeletonConfigOffsets.HIPS_WIDTH);
        float legLength = skeleton.getOffset(SkeletonConfigOffsets.UPPER_LEG) + skeleton.getOffset(SkeletonConfigOffsets.LOWER_LEG);
        float lowerLegLength = skeleton.getOffset(SkeletonConfigOffsets.LOWER_LEG);
        float neckTorso = neckLength / torsoLength;
        float chestTorso = (upperChestLength + chestLength) / torsoLength;
        float torsoWaist = hipWidth / torsoLength;
        float legTorso = legLength / torsoLength;
        float legBody = legLength / (torsoLength + neckLength);
        float kneeLeg = lowerLegLength / legLength;
        LogManager.info("[AutoBone] Ratios: [{Neck-Torso: " + StringUtils.prettyNumber(neckTorso) + "}, {Chest-Torso: " + StringUtils.prettyNumber(chestTorso) + "}, {Torso-Waist: " + StringUtils.prettyNumber(torsoWaist) + "}, {Leg-Torso: " + StringUtils.prettyNumber(legTorso) + "}, {Leg-Body: " + StringUtils.prettyNumber(legBody) + "}, {Knee-Leg: " + StringUtils.prettyNumber(kneeLeg) + "}]");
    }

    public final void applyValues() {
        AutoBone.applyAndSaveConfig$default(this.autoBone, null, 1, null);
    }

    private static final boolean removeListener$lambda$0(AutoBoneListener $listener, AutoBoneListener it) {
        return Intrinsics.areEqual($listener, it);
    }

    private static final boolean removeListener$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processFrames$lambda$4(AutoBoneHandler this$0, AutoBone.Epoch epoch) {
        Intrinsics.checkNotNullParameter(epoch, "epoch");
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoBoneListener listener2 = (AutoBoneListener)element$iv;
            boolean bl = false;
            listener2.onAutoBoneEpoch(epoch);
        }
    }

    private static final Unit startRecording$lambda$6$lambda$5(AutoBoneHandler this$0) {
        this$0.startRecordingThread();
        return Unit.INSTANCE;
    }

    private static final void startRecordingThread$lambda$7(AutoBoneHandler this$0, float $totalTime, PoseRecorder.RecordingProgress progress) {
        Intrinsics.checkNotNullParameter(progress, "progress");
        AutoBoneHandler.announceProcessStatus$default(this$0, AutoBoneProcessType.RECORD, null, progress.getFrame(), progress.getTotalFrames(), $totalTime - (float)progress.getFrame() * $totalTime / (float)progress.getTotalFrames(), false, false, 98, null);
    }

    private static final Unit saveRecording$lambda$10$lambda$9(AutoBoneHandler this$0) {
        this$0.saveRecordingThread();
        return Unit.INSTANCE;
    }

    private static final Unit processRecording$lambda$14$lambda$13(AutoBoneHandler this$0) {
        this$0.processRecordingThread();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AutoBoneProcessType.values().length];
            try {
                nArray[AutoBoneProcessType.RECORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoBoneProcessType.SAVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoBoneProcessType.PROCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

