/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.autobone;

import dev.slimevr.autobone.AutoBone;
import dev.slimevr.tracking.processor.Bone;
import dev.slimevr.tracking.processor.BoneType;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import io.github.axisangles.ktmath.Vector3;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0013"}, d2={"Ldev/slimevr/autobone/BoneContribution;", "", "<init>", "()V", "getBoneLocalTail", "Lio/github/axisangles/ktmath/Vector3;", "skeleton", "Ldev/slimevr/tracking/processor/HumanPoseManager;", "boneType", "Ldev/slimevr/tracking/processor/BoneType;", "getBoneLocalTailDir", "skeleton1", "skeleton2", "getSlideDot", "", "config", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "slideL", "slideR", "core"})
public final class BoneContribution {
    @NotNull
    public static final BoneContribution INSTANCE = new BoneContribution();

    private BoneContribution() {
    }

    @NotNull
    public final Vector3 getBoneLocalTail(@NotNull HumanPoseManager skeleton, @NotNull BoneType boneType) {
        Intrinsics.checkNotNullParameter(skeleton, "skeleton");
        Intrinsics.checkNotNullParameter((Object)boneType, "boneType");
        Bone bone = skeleton.getBone(boneType);
        Vector3 vector3 = bone.getTailPosition();
        Vector3 vector32 = bone.getPosition();
        return Vector3.minus-1s-5YWc(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z(), vector32.unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z());
    }

    @Nullable
    public final Vector3 getBoneLocalTailDir(@NotNull HumanPoseManager skeleton1, @NotNull HumanPoseManager skeleton2, @NotNull BoneType boneType) {
        Intrinsics.checkNotNullParameter(skeleton1, "skeleton1");
        Intrinsics.checkNotNullParameter(skeleton2, "skeleton2");
        Intrinsics.checkNotNullParameter((Object)boneType, "boneType");
        Vector3 vector3 = this.getBoneLocalTail(skeleton2, boneType);
        Vector3 vector32 = this.getBoneLocalTail(skeleton1, boneType);
        Vector3 vector33 = Vector3.minus-1s-5YWc(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z(), vector32.unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z());
        float f = vector33.unbox-impl-x();
        float f2 = vector33.unbox-impl-y();
        float f3 = vector33.unbox-impl-z();
        float boneOffLen = Vector3.len-impl(f, f2, f3);
        return boneOffLen > 0.002f ? Vector3.div-impl(f, f2, f3, boneOffLen) : null;
    }

    public final float getSlideDot(@NotNull HumanPoseManager skeleton1, @NotNull HumanPoseManager skeleton2, @NotNull SkeletonConfigOffsets config, @Nullable Vector3 slideL, @Nullable Vector3 slideR) {
        Intrinsics.checkNotNullParameter(skeleton1, "skeleton1");
        Intrinsics.checkNotNullParameter(skeleton2, "skeleton2");
        Intrinsics.checkNotNullParameter((Object)config, "config");
        float slideDot = 0.0f;
        Vector3 boneOffL = null;
        if (slideL != null) {
            BoneType boneType = config.affectedOffsets[0];
            Intrinsics.checkNotNullExpressionValue((Object)boneType, "get(...)");
            boneOffL = this.getBoneLocalTailDir(skeleton1, skeleton2, boneType);
            if (boneOffL != null) {
                slideDot += Vector3.dot-1s-5YWc(slideL.unbox-impl-x(), slideL.unbox-impl-y(), slideL.unbox-impl-z(), boneOffL.unbox-impl-x(), boneOffL.unbox-impl-y(), boneOffL.unbox-impl-z());
            }
        }
        if (slideR != null) {
            Vector3 boneOffR;
            if (ArraysKt.contains(AutoBone.Companion.getSYMM_CONFIGS(), config)) {
                BoneType boneType = config.affectedOffsets[1];
                Intrinsics.checkNotNullExpressionValue((Object)boneType, "get(...)");
                v2 = this.getBoneLocalTailDir(skeleton1, skeleton2, boneType);
            } else if (slideL != null) {
                v2 = boneOffL;
            } else {
                BoneType boneType = config.affectedOffsets[0];
                Intrinsics.checkNotNullExpressionValue((Object)boneType, "get(...)");
                v2 = boneOffR = this.getBoneLocalTailDir(skeleton1, skeleton2, boneType);
            }
            if (boneOffR != null) {
                slideDot += Vector3.dot-1s-5YWc(slideR.unbox-impl-x(), slideR.unbox-impl-y(), slideR.unbox-impl-z(), boneOffR.unbox-impl-x(), boneOffR.unbox-impl-y(), boneOffR.unbox-impl-z());
            }
        }
        return slideDot / 2.0f;
    }
}

