/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.autobone;

import dev.slimevr.autobone.PoseFrameStep;
import dev.slimevr.config.AutoBoneConfig;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/slimevr/autobone/PoseFrameIterator;", "", "<init>", "()V", "iterateFrames", "", "T", "step", "Ldev/slimevr/autobone/PoseFrameStep;", "randomIndices", "", "count", "", "random", "Lkotlin/random/Random;", "epoch", "core"})
@SourceDebugExtension(value={"SMAP\nPoseFrameIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoseFrameIterator.kt\ndev/slimevr/autobone/PoseFrameIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class PoseFrameIterator {
    @NotNull
    public static final PoseFrameIterator INSTANCE = new PoseFrameIterator();

    private PoseFrameIterator() {
    }

    public final <T> void iterateFrames(@NotNull PoseFrameStep<T> step) {
        Intrinsics.checkNotNullParameter(step, "step");
        if (!(!((Collection)step.getFrames().getFrameHolders()).isEmpty())) {
            boolean $i$a$-check-PoseFrameIterator$iterateFrames$32 = false;
            String $i$a$-check-PoseFrameIterator$iterateFrames$32 = "Recording has no trackers.";
            throw new IllegalStateException($i$a$-check-PoseFrameIterator$iterateFrames$32.toString());
        }
        if (!(step.getMaxFrameCount() > 0)) {
            boolean bl = false;
            String string = "Recording has no frames.";
            throw new IllegalStateException(string.toString());
        }
        int n = step.getConfig().getNumEpochs();
        for (int epoch = step.getConfig().getCalcInitError() ? -1 : 0; epoch < n; ++epoch) {
            step.setEpoch(epoch);
            this.epoch(step);
        }
    }

    private final int[] randomIndices(int count, Random random) {
        int[] randIndices = new int[count];
        int zeroPos = -1;
        int i = 0;
        while (i < count) {
            int index = random.nextInt(count);
            if (i > 0) {
                while (index == zeroPos || randIndices[index] > 0) {
                    index = random.nextInt(count);
                }
            } else {
                zeroPos = index;
            }
            randIndices[index] = i++;
        }
        return randIndices;
    }

    private final <T> void epoch(PoseFrameStep<T> step) {
        block5: {
            AutoBoneConfig config = step.getConfig();
            int frameCount = step.getMaxFrameCount();
            Consumer<PoseFrameStep<PoseFrameStep<T>>> consumer = step.getPreEpoch();
            if (consumer != null) {
                consumer.accept(step);
            }
            int[] randIndices = config.getRandomizeFrameOrder() ? this.randomIndices(step.getMaxFrameCount(), step.getRandom()) : null;
            for (int cursorOffset = config.getMinDataDistance(); cursorOffset <= config.getMaxDataDistance() && cursorOffset < frameCount; ++cursorOffset) {
                for (int frameCursor = 0; frameCursor < frameCount - cursorOffset; frameCursor += config.getCursorIncrement()) {
                    int frameCursor2 = frameCursor + cursorOffset;
                    if (config.getRandomizeFrameOrder() && randIndices != null) {
                        step.setCursors(randIndices[frameCursor], randIndices[frameCursor2], true);
                    } else {
                        step.setCursors(frameCursor, frameCursor2, true);
                    }
                    step.getOnStep().accept(step);
                }
            }
            Consumer<PoseFrameStep<PoseFrameStep<T>>> consumer2 = step.getPostEpoch();
            if (consumer2 == null) break block5;
            consumer2.accept(step);
        }
    }
}

