/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.autobone.errors.proportions;

import dev.slimevr.autobone.errors.proportions.HardProportionLimiter;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/slimevr/autobone/errors/proportions/RangeProportionLimiter;", "Ldev/slimevr/autobone/errors/proportions/HardProportionLimiter;", "targetRatio", "", "skeletonConfigOffset", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "range", "<init>", "(FLdev/slimevr/tracking/processor/config/SkeletonConfigOffsets;F)V", "positiveRange", "negativeRange", "(FLdev/slimevr/tracking/processor/config/SkeletonConfigOffsets;FF)V", "targetPositiveRange", "targetNegativeRange", "getProportionError", "humanPoseManager", "Ldev/slimevr/tracking/processor/HumanPoseManager;", "height", "core"})
@SourceDebugExtension(value={"SMAP\nRangeProportionLimiter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeProportionLimiter.kt\ndev/slimevr/autobone/errors/proportions/RangeProportionLimiter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class RangeProportionLimiter
extends HardProportionLimiter {
    private final float targetPositiveRange;
    private final float targetNegativeRange;

    public RangeProportionLimiter(float targetRatio, @NotNull SkeletonConfigOffsets skeletonConfigOffset, float range) {
        float absRange;
        Intrinsics.checkNotNullParameter((Object)skeletonConfigOffset, "skeletonConfigOffset");
        super(targetRatio, skeletonConfigOffset);
        this.targetPositiveRange = absRange = Math.abs(range);
        this.targetNegativeRange = -absRange;
    }

    public RangeProportionLimiter(float targetRatio, @NotNull SkeletonConfigOffsets skeletonConfigOffset, float positiveRange, float negativeRange) {
        Intrinsics.checkNotNullParameter((Object)skeletonConfigOffset, "skeletonConfigOffset");
        super(targetRatio, skeletonConfigOffset);
        if (!(positiveRange >= negativeRange)) {
            boolean bl = false;
            String string = "positiveRange must not be less than negativeRange";
            throw new IllegalArgumentException(string.toString());
        }
        this.targetPositiveRange = positiveRange;
        this.targetNegativeRange = negativeRange;
    }

    @Override
    public float getProportionError(@NotNull HumanPoseManager humanPoseManager, float height) {
        Intrinsics.checkNotNullParameter(humanPoseManager, "humanPoseManager");
        float boneLength = humanPoseManager.getOffset(this.getSkeletonConfigOffset());
        float ratioOffset = this.getTargetRatio() - boneLength / height;
        if (ratioOffset > this.targetPositiveRange) {
            return ratioOffset - this.targetPositiveRange;
        }
        if (ratioOffset < this.targetNegativeRange) {
            return ratioOffset - this.targetNegativeRange;
        }
        return 0.0f;
    }
}

