/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.github.jonpeterson.jackson.module.versioning.VersioningModule;
import dev.slimevr.config.VRConfig;
import dev.slimevr.config.serializers.QuaternionDeserializer;
import dev.slimevr.config.serializers.QuaternionSerializer;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.ObjectQuaternion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class ConfigManager {
    private final String configPath;
    private final ObjectMapper om;
    private VRConfig vrConfig;

    public ConfigManager(String configPath) {
        this.configPath = configPath;
        this.om = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.SPLIT_LINES));
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.registerModule(new VersioningModule());
        SimpleModule quaternionModule = new SimpleModule();
        quaternionModule.addSerializer(ObjectQuaternion.class, new QuaternionSerializer());
        quaternionModule.addDeserializer(ObjectQuaternion.class, new QuaternionDeserializer());
        this.om.registerModule(quaternionModule);
    }

    public void loadConfig() {
        try {
            this.vrConfig = this.om.readValue((InputStream)new FileInputStream(this.configPath), VRConfig.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            LogManager.severe("Config failed to load: " + String.valueOf(e));
            this.backupConfig();
        }
        if (this.vrConfig == null) {
            this.vrConfig = new VRConfig();
        }
    }

    public static void atomicMove(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException | FileAlreadyExistsException e) {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void backupConfig() {
        Path cfgFile = Paths.get(this.configPath, new String[0]);
        Path tmpBakCfgFile = Paths.get(this.configPath + ".bak.tmp", new String[0]);
        Path bakCfgFile = Paths.get(this.configPath + ".bak", new String[0]);
        try {
            Files.copy(cfgFile, tmpBakCfgFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            LogManager.info("Made a backup copy of config to \"" + String.valueOf(tmpBakCfgFile) + "\"");
        }
        catch (IOException e) {
            LogManager.severe("Unable to make backup copy of config from \"" + String.valueOf(cfgFile) + "\" to \"" + String.valueOf(tmpBakCfgFile) + "\"", e);
            return;
        }
        try {
            ConfigManager.atomicMove(tmpBakCfgFile, bakCfgFile);
        }
        catch (IOException e) {
            LogManager.severe("Unable to move backup config from \"" + String.valueOf(tmpBakCfgFile) + "\" to \"" + String.valueOf(bakCfgFile) + "\"", e);
        }
    }

    public synchronized void saveConfig() {
        Path tmpCfgFile = Paths.get(this.configPath + ".tmp", new String[0]);
        Path cfgFile = Paths.get(this.configPath, new String[0]);
        try {
            File cfgFolder;
            File cfgFileMaybeFolder = cfgFile.toFile();
            if (cfgFileMaybeFolder.isDirectory()) {
                try (Stream<Path> pathStream = Files.walk(cfgFile, new FileVisitOption[0]);){
                    List<Path> list = pathStream.sorted(Comparator.reverseOrder()).toList();
                    for (Path path : list) {
                        Files.delete(path);
                    }
                }
                catch (IOException e) {
                    LogManager.severe("Unable to delete folder that has same name as the config file on path \"" + String.valueOf(cfgFile) + "\"");
                    return;
                }
            }
            if (!(cfgFolder = cfgFile.toAbsolutePath().getParent().toFile()).exists() && !cfgFolder.mkdirs()) {
                LogManager.severe("Unable to create folders for config on path \"" + String.valueOf(cfgFile) + "\"");
                return;
            }
            this.om.writeValue(tmpCfgFile.toFile(), (Object)this.vrConfig);
        }
        catch (IOException e) {
            LogManager.severe("Unable to write serialized config to \"" + String.valueOf(tmpCfgFile) + "\"", e);
            return;
        }
        try {
            ConfigManager.atomicMove(tmpCfgFile, cfgFile);
        }
        catch (IOException e) {
            LogManager.severe("Unable to move new config from \"" + String.valueOf(tmpCfgFile) + "\" to \"" + String.valueOf(cfgFile) + "\"", e);
        }
    }

    public void resetConfig() {
        this.vrConfig = new VRConfig();
        this.saveConfig();
    }

    public VRConfig getVrConfig() {
        return this.vrConfig;
    }
}

