/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelConverter;
import dev.slimevr.config.TrackerConfig;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import dev.slimevr.tracking.trackers.TrackerPosition;
import io.eiren.util.logging.LogManager;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurrentVRConfigConverter
implements VersionedModelConverter {
    @Override
    public ObjectNode convert(ObjectNode modelData, String modelVersion, String targetModelVersion, JsonNodeFactory nodeFactory) {
        try {
            ObjectNode HMDNode;
            ObjectNode trackersNode;
            JsonNode sampleCountNode;
            ObjectNode autoBoneNode;
            JsonNode chestNode;
            ObjectNode offsetsNode;
            ObjectNode skeletonNode;
            ObjectNode oldTrackersNode;
            ObjectNode filtersNode;
            JsonNode node;
            int version2 = Integer.parseInt(modelVersion);
            if (version2 < 2) {
                ObjectNode bodyNode;
                ObjectNode bridgeNode;
                ArrayNode oldTrackersNode2;
                ObjectNode windowNode = (ObjectNode)modelData.get("window");
                DoubleNode zoomNode = (DoubleNode)modelData.get("zoom");
                if (windowNode != null && zoomNode != null) {
                    windowNode.set("zoom", zoomNode);
                    modelData.remove("zoom");
                }
                if ((oldTrackersNode2 = modelData.withArray("trackers")) != null) {
                    Iterator<JsonNode> trackersIter = oldTrackersNode2.iterator();
                    ObjectNode trackersNode2 = nodeFactory.objectNode();
                    while (trackersIter.hasNext()) {
                        node = trackersIter.next();
                        JsonNode resultNode = TrackerConfig.toV2(node, nodeFactory);
                        trackersNode2.set(node.get("name").asText(), resultNode);
                    }
                    modelData.set("trackers", trackersNode2);
                }
                if ((bridgeNode = (ObjectNode)modelData.get("bridge")) != null) {
                    modelData.set("bridges", bridgeNode);
                    modelData.remove("bridge");
                }
                if ((bodyNode = (ObjectNode)modelData.get("body")) != null) {
                    Iterator<Map.Entry<String, JsonNode>> bodyIter = bodyNode.fields();
                    ObjectNode skeletonNode2 = (ObjectNode)modelData.get("skeleton");
                    if (skeletonNode2 == null) {
                        skeletonNode2 = nodeFactory.objectNode();
                    }
                    ObjectNode offsetsNode2 = nodeFactory.objectNode();
                    while (bodyIter.hasNext()) {
                        Map.Entry<String, JsonNode> node2 = bodyIter.next();
                        if (!node2.getValue().isNumber()) continue;
                        offsetsNode2.set(node2.getKey(), node2.getValue());
                    }
                    offsetsNode2.set("shouldersWidth", bodyNode.get("shoulersWidth"));
                    offsetsNode2.set("shouldersDistance", bodyNode.get("shoulersDistance"));
                    offsetsNode2.remove("shoulersWidth");
                    offsetsNode2.remove("shoulersDistance");
                    skeletonNode2.set("offsets", offsetsNode2);
                    modelData.set("skeleton", skeletonNode2);
                    modelData.remove("body");
                }
            }
            if (version2 < 3 && (filtersNode = (ObjectNode)modelData.get("filters")) != null && filtersNode.get("amount").floatValue() > 2.0f) {
                filtersNode.set("amount", new FloatNode(0.2f));
            }
            if (version2 < 4 && (oldTrackersNode = (ObjectNode)modelData.get("trackers")) != null) {
                Iterator<JsonNode> trackersIter = oldTrackersNode.iterator();
                Iterator<String> fieldNamesIter = oldTrackersNode.fieldNames();
                ObjectNode trackersNode3 = nodeFactory.objectNode();
                while (trackersIter.hasNext()) {
                    node = (ObjectNode)trackersIter.next();
                    String fieldName = fieldNamesIter.next();
                    ((ObjectNode)node).set("mountingOrientation", ((ObjectNode)node).get("mountingRotation"));
                    ((ObjectNode)node).remove("mountingRotation");
                    trackersNode3.set(fieldName, node);
                }
                modelData.set("trackers", trackersNode3);
            }
            if (version2 < 5 && (skeletonNode = (ObjectNode)modelData.get("skeleton")) != null && (offsetsNode = (ObjectNode)skeletonNode.get("offsets")) != null) {
                JsonNode kneesNode;
                JsonNode waistNode;
                JsonNode chestNode2;
                float torsoLength = SkeletonConfigOffsets.CHEST.defaultValue + SkeletonConfigOffsets.WAIST.defaultValue + SkeletonConfigOffsets.HIP.defaultValue;
                float chestDistance = SkeletonConfigOffsets.CHEST.defaultValue;
                float waistDistance = SkeletonConfigOffsets.HIP.defaultValue;
                JsonNode torsoNode = offsetsNode.get("torsoLength");
                if (torsoNode != null) {
                    torsoLength = torsoNode.floatValue();
                }
                if ((chestNode2 = offsetsNode.get("chestDistance")) != null) {
                    chestDistance = chestNode2.floatValue();
                }
                if ((waistNode = offsetsNode.get("waistDistance")) != null) {
                    waistDistance = waistNode.floatValue();
                }
                offsetsNode.set("chestLength", offsetsNode.get("chestDistance"));
                offsetsNode.set("waistLength", new FloatNode(torsoLength - chestDistance - waistDistance));
                offsetsNode.set("hipLength", offsetsNode.get("waistDistance"));
                offsetsNode.remove("torsoLength");
                offsetsNode.remove("chestDistance");
                offsetsNode.remove("waistDistance");
                float legsLength = SkeletonConfigOffsets.UPPER_LEG.defaultValue + SkeletonConfigOffsets.LOWER_LEG.defaultValue;
                float kneeHeight = SkeletonConfigOffsets.LOWER_LEG.defaultValue;
                JsonNode legsNode = offsetsNode.get("legsLength");
                if (legsNode != null) {
                    legsLength = legsNode.floatValue();
                }
                if ((kneesNode = offsetsNode.get("kneeHeight")) != null) {
                    kneeHeight = kneesNode.floatValue();
                }
                offsetsNode.set("upperLegLength", new FloatNode(legsLength - kneeHeight));
                offsetsNode.set("lowerLegLength", new FloatNode(kneeHeight));
                offsetsNode.remove("legsLength");
                offsetsNode.remove("kneeHeight");
                skeletonNode.set("offsets", offsetsNode);
                modelData.set("skeleton", skeletonNode);
            }
            if (version2 < 6 && (skeletonNode = (ObjectNode)modelData.get("skeleton")) != null && (offsetsNode = (ObjectNode)skeletonNode.get("offsets")) != null) {
                offsetsNode.set("handDistanceY", offsetsNode.get("controllerDistanceY"));
                offsetsNode.set("handDistanceZ", offsetsNode.get("controllerDistanceZ"));
            }
            if (version2 < 7 && (skeletonNode = (ObjectNode)modelData.get("skeleton")) != null && (offsetsNode = (ObjectNode)skeletonNode.get("offsets")) != null) {
                JsonNode elbowNode;
                JsonNode hipNode;
                JsonNode chestNode3 = offsetsNode.get("chestOffset");
                if (chestNode3 != null) {
                    offsetsNode.set("chestOffset", new FloatNode(-chestNode3.floatValue()));
                }
                if ((hipNode = offsetsNode.get("hipOffset")) != null) {
                    offsetsNode.set("hipOffset", new FloatNode(-hipNode.floatValue()));
                }
                if ((elbowNode = offsetsNode.get("elbowOffset")) != null) {
                    offsetsNode.set("elbowOffset", new FloatNode(-elbowNode.floatValue()));
                }
            }
            if (version2 < 8) {
                ObjectNode tapDetectionNode;
                ObjectNode keybindingsNode = (ObjectNode)modelData.get("keybindings");
                if (keybindingsNode != null) {
                    JsonNode mountingDelayNode;
                    JsonNode yawDelayNode;
                    JsonNode fullDelayNode;
                    JsonNode mountingResetNode;
                    JsonNode yawResetNode;
                    JsonNode fullResetNode = keybindingsNode.get("resetBinding");
                    if (fullResetNode != null) {
                        keybindingsNode.set("fullResetBinding", fullResetNode);
                    }
                    if ((yawResetNode = keybindingsNode.get("quickResetBinding")) != null) {
                        keybindingsNode.set("yawResetBinding", yawResetNode);
                    }
                    if ((mountingResetNode = keybindingsNode.get("resetMountingBinding")) != null) {
                        keybindingsNode.set("mountingResetBinding", mountingResetNode);
                    }
                    if ((fullDelayNode = keybindingsNode.get("resetDelay")) != null) {
                        keybindingsNode.set("fullResetDelay", fullDelayNode);
                    }
                    if ((yawDelayNode = keybindingsNode.get("quickResetDelay")) != null) {
                        keybindingsNode.set("yawResetDelay", yawDelayNode);
                    }
                    if ((mountingDelayNode = keybindingsNode.get("resetMountingDelay")) != null) {
                        keybindingsNode.set("mountingResetDelay", mountingDelayNode);
                    }
                }
                if ((tapDetectionNode = (ObjectNode)modelData.get("tapDetection")) != null) {
                    tapDetectionNode.set("yawResetDelay", tapDetectionNode.get("quickResetDelay"));
                    tapDetectionNode.set("fullResetDelay", tapDetectionNode.get("resetDelay"));
                    tapDetectionNode.set("yawResetEnabled", tapDetectionNode.get("quickResetEnabled"));
                    tapDetectionNode.set("fullResetEnabled", tapDetectionNode.get("resetEnabled"));
                    tapDetectionNode.set("yawResetTaps", tapDetectionNode.get("quickResetTaps"));
                    tapDetectionNode.set("fullResetTaps", tapDetectionNode.get("resetTaps"));
                }
            }
            if (version2 < 9 && (skeletonNode = (ObjectNode)modelData.get("skeleton")) != null && (offsetsNode = (ObjectNode)skeletonNode.get("offsets")) != null && (chestNode = offsetsNode.get("chestLength")) != null) {
                offsetsNode.set("chestLength", new FloatNode(chestNode.floatValue() / 2.0f));
                offsetsNode.set("upperChestLength", new FloatNode(chestNode.floatValue() / 2.0f));
            }
            if (version2 < 10 && (autoBoneNode = (ObjectNode)modelData.get("autoBone")) != null && (sampleCountNode = autoBoneNode.get("sampleCount")) != null && sampleCountNode.intValue() == 1000) {
                autoBoneNode.set("sampleCount", new IntNode(1500));
            }
            if (version2 < 11 && (trackersNode = (ObjectNode)modelData.get("trackers")) != null && (HMDNode = (ObjectNode)trackersNode.get("HMD")) != null) {
                HMDNode.set("designation", new TextNode(TrackerPosition.HEAD.getDesignation()));
                trackersNode.set("HMD", HMDNode);
                modelData.set("trackers", trackersNode);
            }
            if (version2 < 12 && (autoBoneNode = (ObjectNode)modelData.get("autoBone")) != null) {
                JsonNode bodyProportionsNode;
                JsonNode offsetSlideNode = autoBoneNode.get("offsetSlideErrorFactor");
                if (offsetSlideNode != null && offsetSlideNode.floatValue() == 2.0f) {
                    autoBoneNode.set("offsetSlideErrorFactor", new FloatNode(1.0f));
                }
                if ((bodyProportionsNode = autoBoneNode.get("bodyProportionErrorFactor")) != null && bodyProportionsNode.floatValue() == 0.825f) {
                    autoBoneNode.set("bodyProportionErrorFactor", new FloatNode(0.25f));
                }
            }
            if (version2 < 13 && (oldTrackersNode = (ObjectNode)modelData.get("trackers")) != null) {
                Iterator<String> fieldNamesIter = oldTrackersNode.fieldNames();
                String macAddressRegex = "udp://((?:[a-zA-Z\\d]{2}:){5}[a-zA-Z\\d]{2})/0";
                Pattern pattern = Pattern.compile("udp://((?:[a-zA-Z\\d]{2}:){5}[a-zA-Z\\d]{2})/0");
                while (fieldNamesIter.hasNext()) {
                    String trackerId = fieldNamesIter.next();
                    Matcher matcher = pattern.matcher(trackerId);
                    if (!matcher.find()) continue;
                    modelData.withArray("knownDevices").add(matcher.group(1));
                }
            }
            if (version2 < 14 && (autoBoneNode = (ObjectNode)modelData.get("autoBone")) != null) {
                JsonNode numEpochsNode;
                JsonNode bodyProportionsNode;
                JsonNode targetHmdHeight;
                ObjectNode skeletonNode3 = (ObjectNode)modelData.get("skeleton");
                if (skeletonNode3 != null && (targetHmdHeight = autoBoneNode.get("targetHmdHeight")) != null) {
                    skeletonNode3.set("hmdHeight", targetHmdHeight);
                }
                JsonNode offsetSlideNode = autoBoneNode.get("offsetSlideErrorFactor");
                JsonNode slideNode = autoBoneNode.get("slideErrorFactor");
                if (offsetSlideNode != null && slideNode != null && offsetSlideNode.floatValue() == 1.0f && slideNode.floatValue() == 0.0f) {
                    autoBoneNode.set("offsetSlideErrorFactor", new FloatNode(0.0f));
                    autoBoneNode.set("slideErrorFactor", new FloatNode(1.0f));
                }
                if ((bodyProportionsNode = autoBoneNode.get("bodyProportionErrorFactor")) != null && bodyProportionsNode.floatValue() == 0.25f) {
                    autoBoneNode.set("bodyProportionErrorFactor", new FloatNode(0.05f));
                }
                if ((numEpochsNode = autoBoneNode.get("numEpochs")) != null && numEpochsNode.intValue() == 100) {
                    autoBoneNode.set("numEpochs", new IntNode(50));
                }
            }
        }
        catch (Exception e) {
            LogManager.severe("Error during config migration: " + String.valueOf(e));
        }
        return modelData;
    }
}

