/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import dev.slimevr.config.serializers.BooleanMapDeserializer;
import dev.slimevr.config.serializers.FloatMapDeserializer;
import java.util.HashMap;
import java.util.Map;

public class SkeletonConfig {
    @JsonDeserialize(using=BooleanMapDeserializer.class)
    @JsonSerialize(keyUsing=StdKeySerializers.StringKeySerializer.class)
    public Map<String, Boolean> toggles = new HashMap<String, Boolean>();
    @JsonDeserialize(using=FloatMapDeserializer.class)
    @JsonSerialize(keyUsing=StdKeySerializers.StringKeySerializer.class)
    public Map<String, Float> values = new HashMap<String, Float>();
    @JsonDeserialize(using=FloatMapDeserializer.class)
    @JsonSerialize(keyUsing=StdKeySerializers.StringKeySerializer.class)
    public Map<String, Float> offsets = new HashMap<String, Float>();
    private float hmdHeight = 0.0f;
    private float floorHeight = 0.0f;

    public Map<String, Boolean> getToggles() {
        return this.toggles;
    }

    public Map<String, Float> getOffsets() {
        return this.offsets;
    }

    public Map<String, Float> getValues() {
        return this.values;
    }

    public float getHmdHeight() {
        return this.hmdHeight;
    }

    public void setHmdHeight(float hmdHeight) {
        this.hmdHeight = hmdHeight;
    }

    public float getFloorHeight() {
        return this.floorHeight;
    }

    public void setFloorHeight(float hmdHeight) {
        this.floorHeight = hmdHeight;
    }

    @JsonIgnore
    public float getUserHeight() {
        return this.hmdHeight - this.floorHeight;
    }
}

