/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import dev.slimevr.config.AutoBoneConfig;
import dev.slimevr.config.BridgeConfig;
import dev.slimevr.config.CurrentVRConfigConverter;
import dev.slimevr.config.DriftCompensationConfig;
import dev.slimevr.config.FiltersConfig;
import dev.slimevr.config.KeybindingsConfig;
import dev.slimevr.config.LegTweaksConfig;
import dev.slimevr.config.OSCConfig;
import dev.slimevr.config.OverlayConfig;
import dev.slimevr.config.ResetsConfig;
import dev.slimevr.config.ServerConfig;
import dev.slimevr.config.SkeletonConfig;
import dev.slimevr.config.StayAlignedConfig;
import dev.slimevr.config.TapDetectionConfig;
import dev.slimevr.config.TrackerConfig;
import dev.slimevr.config.VMCConfig;
import dev.slimevr.config.VRCOSCConfig;
import dev.slimevr.config.serializers.BridgeConfigMapDeserializer;
import dev.slimevr.config.serializers.TrackerConfigMapDeserializer;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerRole;
import io.github.axisangles.ktmath.Quaternion;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonVersionedModel(currentVersion="14", defaultDeserializeToVersion="14", toCurrentConverterClass=CurrentVRConfigConverter.class)
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;0GJ\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020=0GJ\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020:J\u000e\u0010L\u001a\u00020;2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020P2\u0006\u0010M\u001a\u00020NJ\u0010\u0010Q\u001a\u00020P2\b\u0010M\u001a\u0004\u0018\u00010NJ\u000e\u0010R\u001a\u00020=2\u0006\u0010S\u001a\u00020:J\u0010\u0010T\u001a\u00020J2\b\u0010U\u001a\u0004\u0018\u00010:J\u000e\u0010V\u001a\u00020J2\u0006\u0010U\u001a\u00020:J\u000e\u0010W\u001a\u00020J2\u0006\u0010U\u001a\u00020:R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u00020\u00198G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;098\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020=098\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020:0?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006X"}, d2={"Ldev/slimevr/config/VRConfig;", "", "<init>", "()V", "server", "Ldev/slimevr/config/ServerConfig;", "getServer", "()Ldev/slimevr/config/ServerConfig;", "filters", "Ldev/slimevr/config/FiltersConfig;", "getFilters", "()Ldev/slimevr/config/FiltersConfig;", "driftCompensation", "Ldev/slimevr/config/DriftCompensationConfig;", "getDriftCompensation", "()Ldev/slimevr/config/DriftCompensationConfig;", "oscRouter", "Ldev/slimevr/config/OSCConfig;", "getOscRouter", "()Ldev/slimevr/config/OSCConfig;", "vrcOSC", "Ldev/slimevr/config/VRCOSCConfig;", "getVrcOSC", "()Ldev/slimevr/config/VRCOSCConfig;", "vmc", "Ldev/slimevr/config/VMCConfig;", "getVMC", "()Ldev/slimevr/config/VMCConfig;", "autoBone", "Ldev/slimevr/config/AutoBoneConfig;", "getAutoBone", "()Ldev/slimevr/config/AutoBoneConfig;", "keybindings", "Ldev/slimevr/config/KeybindingsConfig;", "getKeybindings", "()Ldev/slimevr/config/KeybindingsConfig;", "skeleton", "Ldev/slimevr/config/SkeletonConfig;", "getSkeleton", "()Ldev/slimevr/config/SkeletonConfig;", "legTweaks", "Ldev/slimevr/config/LegTweaksConfig;", "getLegTweaks", "()Ldev/slimevr/config/LegTweaksConfig;", "tapDetection", "Ldev/slimevr/config/TapDetectionConfig;", "getTapDetection", "()Ldev/slimevr/config/TapDetectionConfig;", "resetsConfig", "Ldev/slimevr/config/ResetsConfig;", "getResetsConfig", "()Ldev/slimevr/config/ResetsConfig;", "stayAlignedConfig", "Ldev/slimevr/config/StayAlignedConfig;", "getStayAlignedConfig", "()Ldev/slimevr/config/StayAlignedConfig;", "trackers", "", "", "Ldev/slimevr/config/TrackerConfig;", "bridges", "Ldev/slimevr/config/BridgeConfig;", "knownDevices", "", "getKnownDevices", "()Ljava/util/Set;", "overlay", "Ldev/slimevr/config/OverlayConfig;", "getOverlay", "()Ldev/slimevr/config/OverlayConfig;", "getTrackers", "", "getBridges", "hasTrackerByName", "", "name", "getTracker", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "readTrackerConfig", "", "writeTrackerConfig", "getBridge", "bridgeKey", "isKnownDevice", "mac", "addKnownDevice", "forgetKnownDevice", "core"})
public final class VRConfig {
    @NotNull
    private final ServerConfig server = new ServerConfig();
    @NotNull
    private final FiltersConfig filters = new FiltersConfig();
    @NotNull
    private final DriftCompensationConfig driftCompensation = new DriftCompensationConfig();
    @NotNull
    private final OSCConfig oscRouter = new OSCConfig();
    @NotNull
    private final VRCOSCConfig vrcOSC = new VRCOSCConfig();
    @NotNull
    private final VMCConfig vmc = new VMCConfig();
    @NotNull
    private final AutoBoneConfig autoBone = new AutoBoneConfig();
    @NotNull
    private final KeybindingsConfig keybindings = new KeybindingsConfig();
    @NotNull
    private final SkeletonConfig skeleton = new SkeletonConfig();
    @NotNull
    private final LegTweaksConfig legTweaks = new LegTweaksConfig();
    @NotNull
    private final TapDetectionConfig tapDetection = new TapDetectionConfig();
    @NotNull
    private final ResetsConfig resetsConfig = new ResetsConfig();
    @NotNull
    private final StayAlignedConfig stayAlignedConfig = new StayAlignedConfig();
    @JsonDeserialize(using=TrackerConfigMapDeserializer.class)
    @JsonSerialize(keyUsing=StdKeySerializers.StringKeySerializer.class)
    @NotNull
    private final Map<String, TrackerConfig> trackers = new HashMap();
    @JsonDeserialize(using=BridgeConfigMapDeserializer.class)
    @JsonSerialize(keyUsing=StdKeySerializers.StringKeySerializer.class)
    @NotNull
    private final Map<String, BridgeConfig> bridges = new HashMap();
    @NotNull
    private final Set<String> knownDevices = new LinkedHashSet();
    @NotNull
    private final OverlayConfig overlay = new OverlayConfig();

    public VRConfig() {
        this.oscRouter.setPortIn(9002);
        this.oscRouter.setPortOut(9000);
        this.vrcOSC.setPortIn(9001);
        this.vrcOSC.setPortOut(9000);
        this.vrcOSC.setOSCTrackerRole(TrackerRole.WAIST, this.vrcOSC.getOSCTrackerRole(TrackerRole.WAIST, true));
        this.vrcOSC.setOSCTrackerRole(TrackerRole.LEFT_FOOT, this.vrcOSC.getOSCTrackerRole(TrackerRole.WAIST, true));
        this.vrcOSC.setOSCTrackerRole(TrackerRole.RIGHT_FOOT, this.vrcOSC.getOSCTrackerRole(TrackerRole.WAIST, true));
        this.vmc.setPortIn(39540);
        this.vmc.setPortOut(39539);
    }

    @NotNull
    public final ServerConfig getServer() {
        return this.server;
    }

    @NotNull
    public final FiltersConfig getFilters() {
        return this.filters;
    }

    @NotNull
    public final DriftCompensationConfig getDriftCompensation() {
        return this.driftCompensation;
    }

    @NotNull
    public final OSCConfig getOscRouter() {
        return this.oscRouter;
    }

    @NotNull
    public final VRCOSCConfig getVrcOSC() {
        return this.vrcOSC;
    }

    @JvmName(name="getVMC")
    @NotNull
    public final VMCConfig getVMC() {
        return this.vmc;
    }

    @NotNull
    public final AutoBoneConfig getAutoBone() {
        return this.autoBone;
    }

    @NotNull
    public final KeybindingsConfig getKeybindings() {
        return this.keybindings;
    }

    @NotNull
    public final SkeletonConfig getSkeleton() {
        return this.skeleton;
    }

    @NotNull
    public final LegTweaksConfig getLegTweaks() {
        return this.legTweaks;
    }

    @NotNull
    public final TapDetectionConfig getTapDetection() {
        return this.tapDetection;
    }

    @NotNull
    public final ResetsConfig getResetsConfig() {
        return this.resetsConfig;
    }

    @NotNull
    public final StayAlignedConfig getStayAlignedConfig() {
        return this.stayAlignedConfig;
    }

    @NotNull
    public final Set<String> getKnownDevices() {
        return this.knownDevices;
    }

    @NotNull
    public final OverlayConfig getOverlay() {
        return this.overlay;
    }

    @NotNull
    public final Map<String, TrackerConfig> getTrackers() {
        return this.trackers;
    }

    @NotNull
    public final Map<String, BridgeConfig> getBridges() {
        return this.bridges;
    }

    public final boolean hasTrackerByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.trackers.containsKey(name);
    }

    @NotNull
    public final TrackerConfig getTracker(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        TrackerConfig config = this.trackers.get(tracker.getName());
        if (config == null) {
            config = new TrackerConfig(tracker);
            this.trackers.put(tracker.getName(), config);
        }
        return config;
    }

    public final void readTrackerConfig(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        if (tracker.getUserEditable()) {
            TrackerConfig config = this.getTracker(tracker);
            tracker.readConfig(config);
            if (tracker.isImu()) {
                tracker.getResetsHandler().readDriftCompensationConfig(this.driftCompensation);
            }
            tracker.getResetsHandler().readResetConfig(this.resetsConfig);
            if (tracker.getNeedsReset()) {
                tracker.saveMountingResetOrientation(config);
            }
            if (tracker.getAllowFiltering()) {
                Quaternion quaternion = tracker.getRotation();
                tracker.getFilteringHandler().readFilteringConfig-Piknhcc(this.filters, quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            }
        }
    }

    public final void writeTrackerConfig(@Nullable Tracker tracker) {
        Tracker tracker2 = tracker;
        boolean bl = tracker2 != null ? tracker2.getUserEditable() : false;
        if (bl) {
            TrackerConfig tc = this.getTracker(tracker);
            tracker.writeConfig(tc);
        }
    }

    @NotNull
    public final BridgeConfig getBridge(@NotNull String bridgeKey) {
        Intrinsics.checkNotNullParameter(bridgeKey, "bridgeKey");
        BridgeConfig config = this.bridges.get(bridgeKey);
        if (config == null) {
            config = new BridgeConfig();
            this.bridges.put(bridgeKey, config);
        }
        return config;
    }

    public final boolean isKnownDevice(@Nullable String mac) {
        return CollectionsKt.contains((Iterable)this.knownDevices, mac);
    }

    public final boolean addKnownDevice(@NotNull String mac) {
        Intrinsics.checkNotNullParameter(mac, "mac");
        return this.knownDevices.add(mac);
    }

    public final boolean forgetKnownDevice(@NotNull String mac) {
        Intrinsics.checkNotNullParameter(mac, "mac");
        return this.knownDevices.remove(mac);
    }
}

