/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.config.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;

public abstract class MapDeserializer<T>
extends JsonDeserializer<HashMap<String, T>> {
    private final Class<T> valueClass;

    public MapDeserializer(Class<T> valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public HashMap<String, T> deserialize(JsonParser p, DeserializationContext dc) throws IOException {
        TypeFactory typeFactory = dc.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, this.valueClass);
        return (HashMap)dc.readValue(p, mapType);
    }
}

