/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import dev.slimevr.desktop.INetworkListManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/slimevr/desktop/COMNetworkManager;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "instance", "Ldev/slimevr/desktop/INetworkListManager;", "getInstance", "()Ldev/slimevr/desktop/INetworkListManager;", "setInstance", "(Ldev/slimevr/desktop/INetworkListManager;)V", "shouldUninitialize", "", "close", "", "desktop"})
public final class COMNetworkManager
implements AutoCloseable {
    @NotNull
    private INetworkListManager instance;
    private boolean shouldUninitialize = COMUtils.SUCCEEDED(Ole32.INSTANCE.CoInitialize(null));

    public COMNetworkManager() throws COMException {
        Guid.CLSID CLSID_NetworkListManager = new Guid.CLSID("dcb00c01-570f-4a9b-8d69-199fdba5723b");
        Guid.IID IID_INetworkListManager = new Guid.IID("dcb00000-570f-4a9b-8d69-199fdba5723b");
        PointerByReference ptr = new PointerByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance(CLSID_NetworkListManager, null, 7, IID_INetworkListManager, ptr);
        try {
            COMUtils.checkRC(hr);
        }
        catch (Exception err) {
            if (this.shouldUninitialize) {
                Ole32.INSTANCE.CoUninitialize();
            }
            throw err;
        }
        this.instance = new INetworkListManager(ptr.getValue());
    }

    @NotNull
    public final INetworkListManager getInstance() {
        return this.instance;
    }

    public final void setInstance(@NotNull INetworkListManager iNetworkListManager) {
        Intrinsics.checkNotNullParameter(iNetworkListManager, "<set-?>");
        this.instance = iNetworkListManager;
    }

    @Override
    public void close() {
        this.instance.close();
        if (this.shouldUninitialize) {
            Ole32.INSTANCE.CoUninitialize();
        }
    }
}

