/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import dev.slimevr.desktop.ConnectivityFlags;
import dev.slimevr.desktop.NetworkCategory;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u0017B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a8\u0006\u0018"}, d2={"Ldev/slimevr/desktop/INetwork;", "Lcom/sun/jna/platform/win32/COM/Dispatch;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "instance", "Lcom/sun/jna/Pointer;", "<init>", "(Lcom/sun/jna/Pointer;)V", "close", "", "getNativeString", "", "vtableId", "", "GetName", "GetDescription", "IsConnected", "", "GetConnectivity", "", "Ldev/slimevr/desktop/ConnectivityFlags;", "GetCategory", "Ldev/slimevr/desktop/NetworkCategory;", "VTable", "desktop"})
public final class INetwork
extends Dispatch
implements AutoCloseable {
    @NotNull
    public static final VTable VTable = new VTable(null);
    public static final int GetName = 7;
    public static final int SetName = 8;
    public static final int GetDescription = 9;
    public static final int SetDescription = 10;
    public static final int GetNetworkId = 11;
    public static final int GetDomainType = 12;
    public static final int GetNetworkConnections = 13;
    public static final int GetTimeCreatedAndConnected = 14;
    public static final int IsConnectedToInternet = 15;
    public static final int IsConnected = 16;
    public static final int GetConnectivity = 17;
    public static final int GetCategory = 18;
    public static final int SetCategory = 19;

    public INetwork(@Nullable Pointer instance) {
        super(instance);
    }

    @Override
    public void close() {
        this.Release();
    }

    private final String getNativeString(int vtableId) throws COMException {
        PointerByReference pStr = new PointerByReference();
        Object[] objectArray = new Object[]{this.getPointer(), pStr};
        int hr = this._invokeNativeInt(vtableId, objectArray);
        COMUtils.checkRC(new WinNT.HRESULT(hr));
        WTypes.BSTR bstr = new WTypes.BSTR(pStr.getValue());
        String stringValue = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return stringValue;
    }

    @Nullable
    public final String GetName() throws COMException {
        return this.getNativeString(7);
    }

    @Nullable
    public final String GetDescription() throws COMException {
        return this.getNativeString(9);
    }

    public final boolean IsConnected() throws COMException {
        OaIdl.VARIANT_BOOLByReference bool = new OaIdl.VARIANT_BOOLByReference();
        Object[] objectArray = new Object[]{this.getPointer(), bool};
        int hr = this._invokeNativeInt(16, objectArray);
        COMUtils.checkRC(new WinNT.HRESULT(hr));
        return bool.getValue().booleanValue();
    }

    @NotNull
    public final Set<ConnectivityFlags> GetConnectivity() throws COMException {
        IntByReference connectivity = new IntByReference();
        Object[] objectArray = new Object[]{this.getPointer(), connectivity};
        int hr = this._invokeNativeInt(17, objectArray);
        COMUtils.checkRC(new WinNT.HRESULT(hr));
        return ConnectivityFlags.Companion.fromInt(connectivity.getValue());
    }

    @Nullable
    public final NetworkCategory GetCategory() throws COMException {
        IntByReference category = new IntByReference();
        Object[] objectArray = new Object[]{this.getPointer(), category};
        int hr = this._invokeNativeInt(18, objectArray);
        COMUtils.checkRC(new WinNT.HRESULT(hr));
        return NetworkCategory.Companion.fromInt(category.getValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/slimevr/desktop/INetwork$VTable;", "", "<init>", "()V", "GetName", "", "SetName", "GetDescription", "SetDescription", "GetNetworkId", "GetDomainType", "GetNetworkConnections", "GetTimeCreatedAndConnected", "IsConnectedToInternet", "IsConnected", "GetConnectivity", "GetCategory", "SetCategory", "desktop"})
    public static final class VTable {
        private VTable() {
        }

        public /* synthetic */ VTable(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

