/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop;

import dev.slimevr.Keybinding;
import dev.slimevr.VRServer;
import dev.slimevr.bridge.Bridge;
import dev.slimevr.desktop.Main;
import dev.slimevr.desktop.NetworkProfileChecker;
import dev.slimevr.desktop.firmware.DesktopSerialFlashingHandler;
import dev.slimevr.desktop.games.vrchat.DesktopVRCConfigHandler;
import dev.slimevr.desktop.platform.linux.UnixSocketBridge;
import dev.slimevr.desktop.serial.DesktopSerialHandler;
import dev.slimevr.desktop.tracking.trackers.hid.DesktopHIDManager;
import dev.slimevr.firmware.SerialFlashingHandler;
import dev.slimevr.games.vrchat.VRCConfigHandler;
import dev.slimevr.serial.SerialHandler;
import dev.slimevr.tracking.trackers.Tracker;
import io.eiren.util.OperatingSystem;
import io.eiren.util.logging.LogManager;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0006\u0010\u0012\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"VERSION", "", "getVERSION", "()Ljava/lang/String;", "main", "", "args", "", "([Ljava/lang/String;)V", "provideBridges", "Lkotlin/sequences/Sequence;", "Ldev/slimevr/bridge/Bridge;", "server", "Ldev/slimevr/VRServer;", "computedTrackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "CONFIG_FILENAME", "resolveConfig", "desktop"})
@JvmName(name="Main")
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ndev/slimevr/desktop/Main\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
public final class Main {
    @NotNull
    private static final String VERSION;
    @NotNull
    public static final String CONFIG_FILENAME = "vrconfig.yml";

    @NotNull
    public static final String getVERSION() {
        return VERSION;
    }

    public static final void main(@NotNull String[] args2) {
        CommandLine commandLine;
        Intrinsics.checkNotNullParameter(args2, "args");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        Options options2 = new Options();
        options2.addOption("h", "help", false, "Show help");
        options2.addOption("V", "version", false, "Show version");
        try {
            commandLine = parser.parse(options2, args2, true);
        }
        catch (ParseException e) {
            formatter.printHelp("slimevr.jar", options2);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        CommandLine cmd = commandLine;
        if (cmd.hasOption("help")) {
            formatter.printHelp("slimevr.jar", options2);
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (cmd.hasOption("version")) {
            System.out.println((Object)("SlimeVR Server " + VERSION));
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        String[] stringArray = cmd.getArgs();
        Intrinsics.checkNotNullExpressionValue(stringArray, "getArgs(...)");
        if (((Object[])stringArray).length == 0) {
            System.err.println("No command specified, expected 'run'");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (!StringsKt.equals(cmd.getArgs()[0], "run", true)) {
            System.err.println("Unknown command: " + cmd.getArgs()[0] + ", expected 'run'");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Comparable<Path> comparable = OperatingSystem.Companion.resolveLogDirectory("dev.slimevr.SlimeVR");
        if (comparable == null || (comparable = comparable.toFile()) == null || (comparable = ((File)comparable).getAbsoluteFile()) == null) {
            comparable = new File("").getAbsoluteFile();
        }
        Comparable<Path> dir = comparable;
        try {
            LogManager.initialize(dir);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        LogManager.info("Using log folder: " + dir);
        LogManager.info("Running version " + VERSION);
        if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_17)) {
            LogManager.severe("SlimeVR start-up error! A minimum of Java 17 is required.");
            JOptionPane.showMessageDialog(null, "SlimeVR start-up error! A minimum of Java 17 is required.", "SlimeVR: Java Runtime Mismatch", 0);
            LogManager.closeLogger();
            return;
        }
        try {
            new ServerSocket(21110).close();
        }
        catch (IOException e) {
            LogManager.severe("SlimeVR start-up error! Required ports are busy. Make sure there is no other instance of SlimeVR Server running.");
            JOptionPane.showMessageDialog(null, "SlimeVR start-up error! Required ports are busy. Make sure there is no other instance of SlimeVR Server running.", "SlimeVR: Ports are busy", 0);
            LogManager.closeLogger();
            return;
        }
        try {
            String configDir = Main.resolveConfig();
            LogManager.info("Using config dir: " + configDir);
            VRServer vrServer2 = new VRServer(main.vrServer.1.INSTANCE, Main::main$lambda$1, Main::main$lambda$2, Main::main$lambda$3, null, configDir, 16, null);
            vrServer2.start();
            new NetworkProfileChecker(vrServer2);
            new DesktopHIDManager("Sensors HID service", arg_0 -> Main.main$lambda$4(vrServer2, arg_0));
            new Keybinding(vrServer2);
            Thread scanner = ThreadsKt.thread$default(false, false, null, null, 0, () -> Main.main$lambda$5(vrServer2), 31, null);
            vrServer2.join();
            scanner.join();
            LogManager.closeLogger();
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    @NotNull
    public static final Sequence<Bridge> provideBridges(@NotNull VRServer server, @NotNull List<Tracker> computedTrackers) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(computedTrackers, "computedTrackers");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Bridge>, Continuation<? super Unit>, Object>(server, computedTrackers, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ VRServer $server;
            final /* synthetic */ List<Tracker> $computedTrackers;
            {
                this.$server = $server;
                this.$computedTrackers = $computedTrackers;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 9[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(SequenceScope<? super Bridge> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Ref.ObjectRef $linuxBridge) {
                try {
                    T t = $linuxBridge.element;
                    UnixSocketBridge unixSocketBridge = t instanceof UnixSocketBridge ? (UnixSocketBridge)t : null;
                    if (unixSocketBridge != null) {
                        unixSocketBridge.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @NotNull
    public static final String resolveConfig() {
        Path path = Paths.get("config/", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CONFIG_FILENAME;
        }
        Path path2 = OperatingSystem.Companion.resolveConfigDirectory("dev.slimevr.SlimeVR");
        if (path2 == null || (path2 = path2.resolve(CONFIG_FILENAME)) == null) {
            return CONFIG_FILENAME;
        }
        Path configFile = path2;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(configFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            Path path3 = Paths.get(CONFIG_FILENAME, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.exists(path3, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                LogManager.info("Moved local config file to appdata folder");
                Path path4 = Paths.get(CONFIG_FILENAME, new String[0]);
                Intrinsics.checkNotNullExpressionValue(path4, "get(...)");
                Files.move(path4, configFile, new CopyOption[0]);
            }
        }
        return ((Object)configFile).toString();
    }

    private static final SerialHandler main$lambda$1(VRServer vRServer) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        return new DesktopSerialHandler();
    }

    private static final SerialFlashingHandler main$lambda$2(VRServer vRServer) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        return new DesktopSerialFlashingHandler();
    }

    private static final VRCConfigHandler main$lambda$3(VRServer vRServer) {
        Intrinsics.checkNotNullParameter(vRServer, "<unused var>");
        return new DesktopVRCConfigHandler();
    }

    private static final void main$lambda$4(VRServer $vrServer, Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        $vrServer.registerTracker(tracker);
    }

    private static final Unit main$lambda$5(VRServer $vrServer) {
        while (!Intrinsics.areEqual(ConsoleKt.readln(), "exit")) {
        }
        $vrServer.interrupt();
        return Unit.INSTANCE;
    }

    static {
        CharSequence charSequence;
        CharSequence charSequence2 = "v0.16.3";
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "de16acb";
        } else {
            charSequence = charSequence2;
        }
        VERSION = charSequence + "";
    }
}

