/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.firmware;

import com.fazecast.jSerialComm.SerialPort;
import dev.slimevr.firmware.SerialFlashingHandler;
import io.eiren.util.logging.LogManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/slimevr/desktop/firmware/DesktopSerialFlashingHandler;", "Ldev/slimevr/firmware/SerialFlashingHandler;", "<init>", "()V", "port", "Lcom/fazecast/jSerialComm/SerialPort;", "openSerial", "", "", "closeSerial", "setDTR", "value", "", "setRTS", "write", "data", "", "read", "length", "", "changeBaud", "baud", "setReadTimeout", "timeout", "", "availableBytes", "flushIOBuffers", "desktop"})
@SourceDebugExtension(value={"SMAP\nDesktopSerialFlashingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopSerialFlashingHandler.kt\ndev/slimevr/desktop/firmware/DesktopSerialFlashingHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class DesktopSerialFlashingHandler
implements SerialFlashingHandler {
    @Nullable
    private SerialPort port;

    @Override
    public void openSerial(@NotNull Object port2) {
        SerialPort serialPort;
        block5: {
            Intrinsics.checkNotNullParameter(port2, "port");
            if (!(port2 instanceof dev.slimevr.serial.SerialPort)) {
                throw new IllegalStateException("Not a serial port".toString());
            }
            SerialPort[] ports = SerialPort.getCommPorts();
            Intrinsics.checkNotNull(ports);
            SerialPort[] serialPortArray = ports;
            int n = serialPortArray.length;
            for (int i = 0; i < n; ++i) {
                SerialPort serialPort2;
                SerialPort it = serialPort2 = serialPortArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getPortLocation(), ((dev.slimevr.serial.SerialPort)port2).getPortLocation())) continue;
                serialPort = serialPort2;
                break block5;
            }
            serialPort = null;
        }
        if (serialPort == null) {
            throw new IllegalStateException(("Unable to find port " + ((dev.slimevr.serial.SerialPort)port2).getPortLocation()).toString());
        }
        SerialPort comPort = serialPort;
        if (comPort.isOpen()) {
            comPort.closePort();
        }
        if (!comPort.openPort(1000)) {
            throw new IllegalStateException("unable to open port".toString());
        }
        this.port = comPort;
    }

    @Override
    public void closeSerial() {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to close".toString());
        }
        SerialPort p = serialPort;
        try {
            p.closePort();
            LogManager.info("Port closed");
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to close port".toString());
        }
    }

    @Override
    public void setDTR(boolean value) {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to set DTR".toString());
        }
        SerialPort p = serialPort;
        boolean bl = value ? p.setDTR() : p.clearDTR();
    }

    @Override
    public void setRTS(boolean value) {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to set RTS".toString());
        }
        SerialPort p = serialPort;
        boolean bl = value ? p.setRTS() : p.clearRTS();
    }

    @Override
    public void write(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to write".toString());
        }
        SerialPort p = serialPort;
        p.writeBytes(data, data.length);
    }

    @Override
    @NotNull
    public byte[] read(int length) {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to read".toString());
        }
        SerialPort p = serialPort;
        byte[] data = new byte[length];
        p.readBytes(data, length);
        return data;
    }

    @Override
    public void changeBaud(int baud) {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to set the baud".toString());
        }
        SerialPort p = serialPort;
        if (!p.setBaudRate(baud)) {
            throw new IllegalStateException("Unable to change baudrate".toString());
        }
    }

    @Override
    public void setReadTimeout(long timeout) {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to set the timeout".toString());
        }
        SerialPort p = serialPort;
        p.setComPortTimeouts(16, (int)timeout, 0);
    }

    @Override
    public int availableBytes() {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to check available bytes".toString());
        }
        SerialPort p = serialPort;
        return p.bytesAvailable();
    }

    @Override
    public void flushIOBuffers() {
        SerialPort serialPort = this.port;
        if (serialPort == null) {
            throw new IllegalStateException("no port to flush".toString());
        }
        SerialPort p = serialPort;
        p.flushIOBuffers();
    }
}

