/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.games.vrchat;

import dev.slimevr.desktop.games.vrchat.AbstractRegEdit;
import dev.slimevr.desktop.games.vrchat.RegEditLinux;
import dev.slimevr.desktop.games.vrchat.RegEditWindows;
import dev.slimevr.games.vrchat.VRCAvatarMeasurementType;
import dev.slimevr.games.vrchat.VRCConfigHandler;
import dev.slimevr.games.vrchat.VRCConfigValues;
import dev.slimevr.games.vrchat.VRCSpineMode;
import dev.slimevr.games.vrchat.VRCTrackerModel;
import io.eiren.util.OperatingSystem;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0012H\u0002J+\u0010\"\u001a\u00020\u00122!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R5\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u0006#"}, d2={"Ldev/slimevr/desktop/games/vrchat/DesktopVRCConfigHandler;", "Ldev/slimevr/games/vrchat/VRCConfigHandler;", "<init>", "()V", "getDevicesTimer", "Ljava/util/Timer;", "regEdit", "Ldev/slimevr/desktop/games/vrchat/AbstractRegEdit;", "configState", "Ldev/slimevr/games/vrchat/VRCConfigValues;", "vrcConfigKeys", "", "", "onChange", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "config", "", "getOnChange", "()Lkotlin/jvm/functions/Function1;", "setOnChange", "(Lkotlin/jvm/functions/Function1;)V", "intValue", "", "key", "(Ljava/lang/String;)Ljava/lang/Integer;", "doubleValue", "", "(Ljava/lang/String;)Ljava/lang/Double;", "updateCurrentState", "isSupported", "", "()Z", "initHandler", "desktop"})
public final class DesktopVRCConfigHandler
extends VRCConfigHandler {
    @NotNull
    private final Timer getDevicesTimer = new Timer("FetchVRCConfigTimer");
    @NotNull
    private final AbstractRegEdit regEdit = OperatingSystem.Companion.getCurrentPlatform() == OperatingSystem.WINDOWS ? (AbstractRegEdit)new RegEditWindows() : (AbstractRegEdit)new RegEditLinux();
    @Nullable
    private VRCConfigValues configState;
    @NotNull
    private Map<String, String> vrcConfigKeys = OperatingSystem.Companion.getCurrentPlatform() == OperatingSystem.WINDOWS || OperatingSystem.Companion.getCurrentPlatform() == OperatingSystem.LINUX ? this.regEdit.getVRChatKeys("Software\\VRChat\\VRChat") : MapsKt.emptyMap();
    public Function1<? super VRCConfigValues, Unit> onChange;

    @NotNull
    public final Function1<VRCConfigValues, Unit> getOnChange() {
        Function1<VRCConfigValues, Unit> function1 = this.onChange;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException("onChange");
        return null;
    }

    public final void setOnChange(@NotNull Function1<? super VRCConfigValues, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.onChange = function1;
    }

    private final Integer intValue(String key2) {
        String string = this.vrcConfigKeys.get(key2);
        if (string == null) {
            return null;
        }
        String realKey = string;
        return this.regEdit.getDwordValue("Software\\VRChat\\VRChat", realKey);
    }

    private final Double doubleValue(String key2) {
        String string = this.vrcConfigKeys.get(key2);
        if (string == null) {
            return null;
        }
        String realKey = string;
        return this.regEdit.getQwordValue("Software\\VRChat\\VRChat", realKey);
    }

    private final void updateCurrentState() {
        this.vrcConfigKeys = this.regEdit.getVRChatKeys("Software\\VRChat\\VRChat");
        Integer n = this.intValue("VRC_IK_LEGACY");
        int n2 = 1;
        boolean bl = n != null && n == n2;
        Integer n3 = this.intValue("VRC_IK_DISABLE_SHOULDER_TRACKING");
        int n4 = 1;
        n2 = n3 != null && n3 == n4 ? 1 : 0;
        Double d = this.doubleValue("PlayerHeight");
        double d2 = d != null ? d : -1.0;
        Double d3 = this.doubleValue("VRC_IK_CALIBRATION_RANGE");
        double d4 = d3 != null ? d3 : -1.0;
        Integer n5 = this.intValue("VRC_IK_TRACKER_MODEL");
        VRCTrackerModel vRCTrackerModel = VRCTrackerModel.Companion.getByValue(n5 != null ? n5 : -1);
        if (vRCTrackerModel == null) {
            vRCTrackerModel = VRCTrackerModel.UNKNOWN;
        }
        VRCTrackerModel vRCTrackerModel2 = vRCTrackerModel;
        Integer n6 = this.intValue("VRC_IK_FBT_SPINE_MODE");
        VRCSpineMode vRCSpineMode = VRCSpineMode.Companion.getByValue(n6 != null ? n6 : -1);
        if (vRCSpineMode == null) {
            vRCSpineMode = VRCSpineMode.UNKNOWN;
        }
        VRCSpineMode vRCSpineMode2 = vRCSpineMode;
        Integer n7 = this.intValue("VRC_IK_CALIBRATION_VIS");
        int n8 = 1;
        boolean bl2 = n7 != null && n7 == n8;
        Integer n9 = this.intValue("VRC_IK_AVATAR_MEASUREMENT_TYPE");
        VRCAvatarMeasurementType vRCAvatarMeasurementType = VRCAvatarMeasurementType.Companion.getByValue(n9 != null ? n9 : -1);
        if (vRCAvatarMeasurementType == null) {
            vRCAvatarMeasurementType = VRCAvatarMeasurementType.UNKNOWN;
        }
        VRCAvatarMeasurementType vRCAvatarMeasurementType2 = vRCAvatarMeasurementType;
        Integer n10 = this.intValue("VRC_IK_SHOULDER_WIDTH_COMPENSATION");
        int n11 = 1;
        boolean bl3 = n10 != null && n10 == n11;
        VRCConfigValues newConfig = new VRCConfigValues(bl, n2 != 0, bl3, d2, d4, bl2, vRCTrackerModel2, vRCSpineMode2, vRCAvatarMeasurementType2);
        if (!Intrinsics.areEqual(newConfig, this.configState)) {
            this.configState = newConfig;
            this.getOnChange().invoke(newConfig);
        }
    }

    @Override
    public boolean isSupported() {
        return (OperatingSystem.Companion.getCurrentPlatform() == OperatingSystem.WINDOWS || OperatingSystem.Companion.getCurrentPlatform() == OperatingSystem.LINUX) && !this.vrcConfigKeys.isEmpty();
    }

    @Override
    public void initHandler(@NotNull Function1<? super VRCConfigValues, Unit> onChange) {
        Intrinsics.checkNotNullParameter(onChange, "onChange");
        this.setOnChange(onChange);
        if (this.isSupported()) {
            this.updateCurrentState();
            this.getDevicesTimer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ DesktopVRCConfigHandler this$0;
                {
                    this.this$0 = desktopVRCConfigHandler;
                }

                public void run() {
                    TimerTask $this$initHandler_u24lambda_u240 = this;
                    boolean bl = false;
                    DesktopVRCConfigHandler.access$updateCurrentState(this.this$0);
                }
            }, 0L, 3000L);
        }
    }

    public static final /* synthetic */ void access$updateCurrentState(DesktopVRCConfigHandler $this) {
        $this.updateCurrentState();
    }
}

