/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.games.vrchat;

import dev.slimevr.desktop.games.vrchat.AbstractRegEdit;
import io.eiren.util.logging.LogManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InvalidObjectException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u0006H\u0016R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ldev/slimevr/desktop/games/vrchat/RegEditLinux;", "Ldev/slimevr/desktop/games/vrchat/AbstractRegEdit;", "<init>", "()V", "registry", "", "", "getRegistry", "()Ljava/util/Map;", "setRegistry", "(Ljava/util/Map;)V", "getQwordValue", "", "path", "key", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "getDwordValue", "", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "getVRChatKeys", "Companion", "desktop"})
@SourceDebugExtension(value={"SMAP\nRegEdit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegEdit.kt\ndev/slimevr/desktop/games/vrchat/RegEditLinux\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class RegEditLinux
extends AbstractRegEdit {
    @NotNull
    public static final Companion Companion;
    public Map<String, String> registry;
    @NotNull
    public static final String USER_REG_SUBPATH = "steamapps/compatdata/438100/pfx/user.reg";
    @Nullable
    private static final Path USER_REG_PATH;
    @NotNull
    private static final Regex KEY_VALUE_PATTERN;
    @NotNull
    private static final HexFormat HEX_FORMAT;

    public RegEditLinux() {
        if (USER_REG_PATH == null) {
            LogManager.info("[VRChatRegEdit] Couldn't find any VRChat registry file");
        } else {
            LogManager.info("[VRChatRegEdit] Using VRChat registry file: " + USER_REG_PATH);
        }
    }

    @NotNull
    public final Map<String, String> getRegistry() {
        Map<String, String> map = this.registry;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException("registry");
        return null;
    }

    public final void setRegistry(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.registry = map;
    }

    @Override
    @Nullable
    public Double getQwordValue(@NotNull String path, @NotNull String key2) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(key2, "key");
        String string = this.getRegistry().get(key2);
        if (string == null) {
            return null;
        }
        String value = string;
        if (!StringsKt.startsWith$default(value, "hex(4):", false, 2, null)) {
            LogManager.severe("[VRChatRegEdit] Couldn't find value with the expected type");
            return null;
        }
        String string2 = value.substring(7);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return ByteBuffer.wrap(HexExtensionsKt.hexToByteArray(string2, HEX_FORMAT)).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    @Override
    @Nullable
    public Integer getDwordValue(@NotNull String path, @NotNull String key2) {
        Integer n;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(key2, "key");
        try {
            String string = this.getRegistry().get(key2);
            if (string == null) {
                return null;
            }
            String value = string;
            if (!StringsKt.startsWith$default(value, "dword:", false, 2, null)) {
                throw new InvalidObjectException("The requested key is not a DWORD but it is instead a " + value);
            }
            String string2 = value.substring(6);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            n = Integer.parseInt(string2);
        }
        catch (Exception e) {
            LogManager.severe("[VRChatRegEdit] Error reading DWORD: " + e.getMessage());
            n = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, String> getVRChatKeys(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Map keysMap = new LinkedHashMap();
        Map map = new LinkedHashMap();
        try {
            Comparable<Path> comparable = USER_REG_PATH;
            if (comparable == null || (comparable = comparable.toFile()) == null) {
                return keysMap;
            }
            Closeable closeable = new BufferedReader(new FileReader((File)comparable));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                String actualPath = "[" + StringsKt.replace$default(path, "\\", "\\\\", false, 4, null) + "]";
                while (reader.ready()) {
                    String keyValue;
                    String line = reader.readLine();
                    Intrinsics.checkNotNull(line);
                    if (!StringsKt.startsWith$default(line, actualPath, false, 2, null)) continue;
                    reader.readLine();
                    while (reader.ready() && !Intrinsics.areEqual(keyValue = reader.readLine(), "")) {
                        MatchResult it;
                        Intrinsics.checkNotNull(keyValue);
                        if (KEY_VALUE_PATTERN.matchEntire(keyValue) == null) continue;
                        boolean bl2 = false;
                        map.put(it.getGroupValues().get(1), it.getGroupValues().get(2));
                        Map map2 = keysMap;
                        CharSequence charSequence = it.getGroupValues().get(1);
                        Object object = new Regex("_h\\d+$");
                        String string = "";
                        charSequence = ((Regex)object).replace(charSequence, string);
                        object = it.getGroupValues().get(1);
                        map2.put(charSequence, object);
                    }
                    break block7;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            LogManager.severe("[VRChatRegEdit] Error reading Values from VRC registry: " + e.getMessage());
        }
        this.setRegistry(map);
        return keysMap;
    }

    static {
        HexFormat.Builder builder;
        Path path;
        Companion = new Companion(null);
        String string = System.getenv("HOME");
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{".steam", "root", USER_REG_SUBPATH};
            Path path2 = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            Path it2 = path2;
            boolean bl2 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Path path3 = Files.exists(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? it2 : null;
            path = path3;
            if (path3 == null) {
                String[] stringArray2 = new String[]{".steam", "debian-installation", USER_REG_SUBPATH};
                Path path4 = Paths.get(it, Arrays.copyOf(stringArray2, stringArray2.length));
                Intrinsics.checkNotNullExpressionValue(path4, "get(...)");
                Path it3 = path4;
                boolean bl3 = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                Path path5 = Files.exists(it3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? it3 : null;
                path = path5;
                if (path5 == null) {
                    stringArray2 = new String[]{".var", "app", "com.valvesoftware.Steam", "data", "Steam", USER_REG_SUBPATH};
                    Path path6 = Paths.get(it, Arrays.copyOf(stringArray2, stringArray2.length));
                    Intrinsics.checkNotNullExpressionValue(path6, "get(...)");
                    it3 = path6;
                    boolean bl4 = false;
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    path = Files.exists(it3, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? it3 : null;
                }
            }
        } else {
            path = null;
        }
        USER_REG_PATH = path;
        KEY_VALUE_PATTERN = new Regex("\"(.+)\"=(.+)");
        HexFormat.Builder $this$HEX_FORMAT_u24lambda_u246 = builder = new HexFormat.Builder();
        boolean bl = false;
        $this$HEX_FORMAT_u24lambda_u246.setUpperCase(false);
        $this$HEX_FORMAT_u24lambda_u246.getBytes().setByteSeparator(",");
        HEX_FORMAT = builder.build();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ldev/slimevr/desktop/games/vrchat/RegEditLinux$Companion;", "", "<init>", "()V", "USER_REG_SUBPATH", "", "USER_REG_PATH", "Ljava/nio/file/Path;", "getUSER_REG_PATH", "()Ljava/nio/file/Path;", "KEY_VALUE_PATTERN", "Lkotlin/text/Regex;", "getKEY_VALUE_PATTERN", "()Lkotlin/text/Regex;", "HEX_FORMAT", "Lkotlin/text/HexFormat;", "getHEX_FORMAT$annotations", "getHEX_FORMAT", "()Lkotlin/text/HexFormat;", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getUSER_REG_PATH() {
            return USER_REG_PATH;
        }

        @NotNull
        public final Regex getKEY_VALUE_PATTERN() {
            return KEY_VALUE_PATTERN;
        }

        @NotNull
        public final HexFormat getHEX_FORMAT() {
            return HEX_FORMAT;
        }

        public static /* synthetic */ void getHEX_FORMAT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

