/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.games.vrchat;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import dev.slimevr.desktop.games.vrchat.AbstractRegEdit;
import io.eiren.util.logging.LogManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/slimevr/desktop/games/vrchat/RegEditWindows;", "Ldev/slimevr/desktop/games/vrchat/AbstractRegEdit;", "<init>", "()V", "getQwordValue", "", "path", "", "key", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "getDwordValue", "", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "getVRChatKeys", "", "desktop"})
@SourceDebugExtension(value={"SMAP\nRegEdit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegEdit.kt\ndev/slimevr/desktop/games/vrchat/RegEditWindows\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,162:1\n216#2,2:163\n*S KotlinDebug\n*F\n+ 1 RegEdit.kt\ndev/slimevr/desktop/games/vrchat/RegEditWindows\n*L\n69#1:163,2\n*E\n"})
public final class RegEditWindows
extends AbstractRegEdit {
    @Override
    @Nullable
    public Double getQwordValue(@NotNull String path, @NotNull String key2) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(key2, "key");
        WinReg.HKEY hKey = WinReg.HKEY_CURRENT_USER;
        WinReg.HKEYByReference phkResult = new WinReg.HKEYByReference();
        if (Advapi32.INSTANCE.RegOpenKeyEx(hKey, path, 0, 131097, phkResult) != 0) {
            LogManager.severe("[VRChatRegEdit] Error: Cannot open registry key");
            return null;
        }
        Memory lpData = new Memory(8L);
        IntByReference lpcbData = new IntByReference(8);
        int result = Advapi32.INSTANCE.RegQueryValueEx(phkResult.getValue(), key2, 0, null, lpData, lpcbData);
        Advapi32.INSTANCE.RegCloseKey(phkResult.getValue());
        if (result != 0) {
            LogManager.severe("[VRChatRegEdit] Error: Cannot read registry key");
            return null;
        }
        return lpData.getDouble(0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Integer getDwordValue(@NotNull String path, @NotNull String key2) {
        Integer n;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(key2, "key");
        try {
            void var3_3;
            int data = Advapi32Util.registryGetIntValue(WinReg.HKEY_CURRENT_USER, path, key2);
            n = (int)var3_3;
        }
        catch (Exception e) {
            LogManager.severe("[VRChatRegEdit] Error reading DWORD: " + e.getMessage());
            n = null;
        }
        return n;
    }

    @Override
    @NotNull
    public Map<String, String> getVRChatKeys(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Map keysMap = new LinkedHashMap();
        try {
            TreeMap<String, Object> treeMap = Advapi32Util.registryGetValues(WinReg.HKEY_CURRENT_USER, path);
            Intrinsics.checkNotNullExpressionValue(treeMap, "registryGetValues(...)");
            Map $this$forEach$iv = treeMap;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                Map map = keysMap;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                CharSequence charSequence = (CharSequence)k;
                Regex regex = new Regex("_h\\d+$");
                String string = "";
                charSequence = regex.replace(charSequence, string);
                regex = it.getKey();
                map.put(charSequence, regex);
            }
        }
        catch (Exception e) {
            LogManager.severe("[VRChatRegEdit] Error reading Values from VRC registry: " + e.getMessage());
        }
        return keysMap;
    }
}

