/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.platform;

import dev.slimevr.VRServer;
import dev.slimevr.bridge.ISteamVRBridge;
import dev.slimevr.desktop.platform.ProtobufMessages;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerRole;
import dev.slimevr.tracking.trackers.TrackerStatus;
import io.eiren.util.collections.FastList;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH$J\u0012\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\rH$J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\rH\u0004J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\rH\u0004J\b\u0010\u001f\u001a\u00020\u001aH\u0004J\b\u0010 \u001a\u00020\u001aH\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0004J\b\u0010$\u001a\u00020\u001aH\u0016J\u0012\u0010%\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010\bH\u0004J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\bH\u0014J\u0012\u0010(\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0004J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u000201H$J\u0010\u00102\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0004J\u0010\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0004J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u000208H\u0004J\u0012\u00109\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020\u0015H\u0004J\b\u0010;\u001a\u00020\u001aH\u0004J\b\u0010<\u001a\u00020\u001aH\u0004J\u0012\u0010=\u001a\u00020\u001a2\b\u0010>\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010?\u001a\u00020\u001a2\b\u0010>\u001a\u0004\u0018\u00010\bH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\nR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\nR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\nR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Ldev/slimevr/desktop/platform/ProtobufBridge;", "Ldev/slimevr/bridge/ISteamVRBridge;", "bridgeName", "", "<init>", "(Ljava/lang/String;)V", "sharedTrackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "getSharedTrackers$annotations", "()V", "inputQueue", "Ljava/util/Queue;", "Ldev/slimevr/desktop/platform/ProtobufMessages$ProtobufMessage;", "getInputQueue$annotations", "outputQueue", "getOutputQueue$annotations", "remoteTrackersBySerial", "", "getRemoteTrackersBySerial$annotations", "remoteTrackersByTrackerId", "", "getRemoteTrackersByTrackerId$annotations", "hadNewData", "", "signalSend", "", "sendMessageReal", "message", "messageReceived", "sendMessage", "updateMessageQueue", "dataRead", "trackerOverrideUpdate", "source", "target", "dataWrite", "writeTrackerUpdate", "localTracker", "writeBatteryUpdate", "processMessageReceived", "positionReceived", "positionMessage", "Ldev/slimevr/desktop/platform/ProtobufMessages$Position;", "batteryReceived", "batteryMessage", "Ldev/slimevr/desktop/platform/ProtobufMessages$Battery;", "createNewTracker", "trackerAdded", "Ldev/slimevr/desktop/platform/ProtobufMessages$TrackerAdded;", "trackerAddedReceived", "userActionReceived", "userAction", "Ldev/slimevr/desktop/platform/ProtobufMessages$UserAction;", "trackerStatusReceived", "trackerStatus", "Ldev/slimevr/desktop/platform/ProtobufMessages$TrackerStatus;", "getInternalRemoteTrackerById", "trackerId", "reconnected", "disconnected", "addSharedTracker", "tracker", "removeSharedTracker", "Companion", "desktop"})
@SourceDebugExtension(value={"SMAP\nProtobufBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufBridge.kt\ndev/slimevr/desktop/platform/ProtobufBridge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public abstract class ProtobufBridge
implements ISteamVRBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final String bridgeName;
    @JvmField
    @NotNull
    protected final List<Tracker> sharedTrackers;
    @NotNull
    private final Queue<ProtobufMessages.ProtobufMessage> inputQueue;
    @NotNull
    private final Queue<ProtobufMessages.ProtobufMessage> outputQueue;
    @NotNull
    private final Map<String, Tracker> remoteTrackersBySerial;
    @NotNull
    private final Map<Integer, Tracker> remoteTrackersByTrackerId;
    private boolean hadNewData;
    @NotNull
    private static final String resetSourceNamePrefix = "ProtobufBridge";

    public ProtobufBridge(@NotNull String bridgeName) {
        Intrinsics.checkNotNullParameter(bridgeName, "bridgeName");
        this.bridgeName = bridgeName;
        this.sharedTrackers = new FastList();
        this.inputQueue = new LinkedBlockingQueue();
        this.outputQueue = new LinkedBlockingQueue();
        this.remoteTrackersBySerial = new HashMap();
        this.remoteTrackersByTrackerId = new HashMap();
    }

    protected static /* synthetic */ void getSharedTrackers$annotations() {
    }

    private static /* synthetic */ void getInputQueue$annotations() {
    }

    private static /* synthetic */ void getOutputQueue$annotations() {
    }

    private static /* synthetic */ void getRemoteTrackersBySerial$annotations() {
    }

    private static /* synthetic */ void getRemoteTrackersByTrackerId$annotations() {
    }

    protected abstract void signalSend();

    protected abstract boolean sendMessageReal(@Nullable ProtobufMessages.ProtobufMessage var1);

    protected final void messageReceived(@NotNull ProtobufMessages.ProtobufMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.inputQueue.add(message);
    }

    protected final void sendMessage(@NotNull ProtobufMessages.ProtobufMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.outputQueue.add(message);
        this.signalSend();
    }

    protected final void updateMessageQueue() {
        block1: {
            ProtobufMessages.ProtobufMessage message = null;
            do {
                ProtobufMessages.ProtobufMessage protobufMessage;
                ProtobufMessages.ProtobufMessage it = protobufMessage = this.outputQueue.poll();
                boolean bl = false;
                message = it;
                if (protobufMessage == null) break block1;
            } while (this.sendMessageReal(message));
            return;
        }
    }

    @Override
    public void dataRead() {
        this.hadNewData = false;
        ProtobufMessages.ProtobufMessage message = null;
        while (true) {
            ProtobufMessages.ProtobufMessage protobufMessage;
            ProtobufMessages.ProtobufMessage it = protobufMessage = this.inputQueue.poll();
            boolean bl = false;
            message = it;
            if (protobufMessage == null) break;
            this.processMessageReceived(message);
            this.hadNewData = true;
        }
    }

    protected final void trackerOverrideUpdate(@NotNull Tracker source, @NotNull Tracker target) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Vector3 vector3 = source.getPosition();
        target.setPosition-1s-5YWc(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z());
        Quaternion quaternion = source.getRotation();
        target.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        target.setStatus(source.getStatus());
        target.setBatteryLevel(source.getBatteryLevel());
        target.setBatteryVoltage(source.getBatteryVoltage());
        target.dataTick();
    }

    @Override
    public void dataWrite() {
        if (!this.hadNewData) {
            return;
        }
        for (Tracker tracker : this.sharedTrackers) {
            this.writeTrackerUpdate(tracker);
            this.writeBatteryUpdate(tracker);
        }
    }

    protected final void writeTrackerUpdate(@Nullable Tracker localTracker) {
        Object object;
        ProtobufMessages.Position.Builder builder = ProtobufMessages.Position.newBuilder();
        Tracker tracker = localTracker;
        Intrinsics.checkNotNull(tracker);
        ProtobufMessages.Position.Builder builder2 = builder.setTrackerId(tracker.getId());
        if (localTracker.getHasPosition()) {
            object = localTracker.getPosition();
            float f = ((Vector3)object).unbox-impl-x();
            float f2 = ((Vector3)object).unbox-impl-y();
            float f3 = ((Vector3)object).unbox-impl-z();
            builder2.setX(f);
            builder2.setY(f2);
            builder2.setZ(f3);
        }
        if (localTracker.getHasRotation()) {
            object = localTracker.getRotation();
            float f = ((Quaternion)object).unbox-impl-w();
            float f4 = ((Quaternion)object).unbox-impl-x();
            float f5 = ((Quaternion)object).unbox-impl-y();
            float f6 = ((Quaternion)object).unbox-impl-z();
            builder2.setQx(f4);
            builder2.setQy(f5);
            builder2.setQz(f6);
            builder2.setQw(f);
        }
        ProtobufMessages.ProtobufMessage protobufMessage = ProtobufMessages.ProtobufMessage.newBuilder().setPosition(builder2).build();
        Intrinsics.checkNotNullExpressionValue(protobufMessage, "build(...)");
        this.sendMessage(protobufMessage);
    }

    protected void writeBatteryUpdate(@NotNull Tracker localTracker) {
        Intrinsics.checkNotNullParameter(localTracker, "localTracker");
    }

    protected final void processMessageReceived(@Nullable ProtobufMessages.ProtobufMessage message) {
        ProtobufMessages.ProtobufMessage protobufMessage = message;
        Intrinsics.checkNotNull(protobufMessage);
        if (protobufMessage.hasPosition()) {
            ProtobufMessages.Position position = message.getPosition();
            Intrinsics.checkNotNullExpressionValue(position, "getPosition(...)");
            this.positionReceived(position);
        } else if (message.hasUserAction()) {
            ProtobufMessages.UserAction userAction = message.getUserAction();
            Intrinsics.checkNotNullExpressionValue(userAction, "getUserAction(...)");
            this.userActionReceived(userAction);
        } else if (message.hasTrackerStatus()) {
            ProtobufMessages.TrackerStatus trackerStatus = message.getTrackerStatus();
            Intrinsics.checkNotNullExpressionValue(trackerStatus, "getTrackerStatus(...)");
            this.trackerStatusReceived(trackerStatus);
        } else if (message.hasTrackerAdded()) {
            ProtobufMessages.TrackerAdded trackerAdded = message.getTrackerAdded();
            Intrinsics.checkNotNullExpressionValue(trackerAdded, "getTrackerAdded(...)");
            this.trackerAddedReceived(trackerAdded);
        } else if (message.hasBattery()) {
            ProtobufMessages.Battery battery = message.getBattery();
            Intrinsics.checkNotNullExpressionValue(battery, "getBattery(...)");
            this.batteryReceived(battery);
        }
    }

    protected final void positionReceived(@NotNull ProtobufMessages.Position positionMessage) {
        Intrinsics.checkNotNullParameter(positionMessage, "positionMessage");
        Tracker tracker = this.getInternalRemoteTrackerById(positionMessage.getTrackerId());
        if (tracker != null) {
            float f;
            float f2;
            float f3;
            if (positionMessage.hasX()) {
                f3 = positionMessage.getX();
                f2 = positionMessage.getY();
                f = positionMessage.getZ();
                Vector3.constructor-impl(f3, f2, f);
                tracker.setPosition-1s-5YWc(f3, f2, f);
            }
            f3 = positionMessage.getQw();
            f2 = positionMessage.getQx();
            f = positionMessage.getQy();
            float f4 = positionMessage.getQz();
            Quaternion.constructor-impl(f3, f2, f, f4);
            tracker.setRotation-oS71L7k(f3, f2, f, f4);
            tracker.dataTick();
        }
    }

    protected void batteryReceived(@NotNull ProtobufMessages.Battery batteryMessage) {
        Intrinsics.checkNotNullParameter(batteryMessage, "batteryMessage");
    }

    @NotNull
    protected abstract Tracker createNewTracker(@NotNull ProtobufMessages.TrackerAdded var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void trackerAddedReceived(@NotNull ProtobufMessages.TrackerAdded trackerAdded) {
        Intrinsics.checkNotNullParameter(trackerAdded, "trackerAdded");
        Tracker tracker = null;
        tracker = this.getInternalRemoteTrackerById(trackerAdded.getTrackerId());
        if (tracker != null) {
            return;
        }
        tracker = this.createNewTracker(trackerAdded);
        Map<Object, Tracker> map = this.remoteTrackersBySerial;
        synchronized (map) {
            boolean $i$a$-synchronized-ProtobufBridge$trackerAddedReceived$32 = false;
            Tracker tracker2 = tracker;
            Intrinsics.checkNotNull(tracker2);
            Tracker $i$a$-synchronized-ProtobufBridge$trackerAddedReceived$32 = this.remoteTrackersBySerial.put(tracker2.getName(), tracker);
        }
        map = this.remoteTrackersByTrackerId;
        synchronized (map) {
            boolean bl = false;
            Tracker tracker3 = this.remoteTrackersByTrackerId.put(tracker.getTrackerNum(), tracker);
        }
        VRServer.Companion.getInstance().registerTracker(tracker);
    }

    protected final void userActionReceived(@NotNull ProtobufMessages.UserAction userAction) {
        block16: {
            Intrinsics.checkNotNullParameter(userAction, "userAction");
            String string = "%s: %s";
            Object[] objectArray = new Object[]{resetSourceNamePrefix, this.bridgeName};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            String resetSourceName = string2;
            String string3 = userAction.getName();
            if (string3 == null) break block16;
            int n = -1;
            switch (string3.hashCode()) {
                case -834821204: {
                    if (string3.equals("fast_reset")) {
                        n = 1;
                    }
                    break;
                }
                case 1236500192: {
                    if (string3.equals("pause_tracking")) {
                        n = 2;
                    }
                    break;
                }
                case 108404047: {
                    if (string3.equals("reset")) {
                        n = 3;
                    }
                    break;
                }
                case 704804537: {
                    if (string3.equals("mounting_reset")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    VRServer.resetTrackersFull$default(VRServer.Companion.getInstance(), resetSourceName, null, 2, null);
                    break;
                }
                case 1: {
                    VRServer.resetTrackersYaw$default(VRServer.Companion.getInstance(), resetSourceName, null, 2, null);
                    break;
                }
                case 4: {
                    VRServer.resetTrackersMounting$default(VRServer.Companion.getInstance(), resetSourceName, null, 2, null);
                    break;
                }
                case 2: {
                    VRServer.Companion.getInstance().togglePauseTracking(resetSourceName);
                }
            }
        }
    }

    protected final void trackerStatusReceived(@NotNull ProtobufMessages.TrackerStatus trackerStatus) {
        Intrinsics.checkNotNullParameter(trackerStatus, "trackerStatus");
        Tracker tracker = this.getInternalRemoteTrackerById(trackerStatus.getTrackerId());
        if (tracker != null) {
            TrackerStatus trackerStatus2 = TrackerStatus.Companion.getById(trackerStatus.getStatusValue());
            Intrinsics.checkNotNull((Object)trackerStatus2);
            tracker.setStatus(trackerStatus2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Tracker getInternalRemoteTrackerById(int trackerId) {
        Map<Integer, Tracker> map = this.remoteTrackersByTrackerId;
        synchronized (map) {
            boolean bl = false;
            Tracker tracker = this.remoteTrackersByTrackerId.get(trackerId);
            return tracker;
        }
    }

    protected final void reconnected() {
        for (Tracker tracker : this.sharedTrackers) {
            ProtobufMessages.TrackerAdded.Builder builder = ProtobufMessages.TrackerAdded.newBuilder().setTrackerId(tracker.getId()).setTrackerName(tracker.getName()).setTrackerSerial(tracker.getName());
            TrackerPosition trackerPosition = tracker.getTrackerPosition();
            Intrinsics.checkNotNull((Object)trackerPosition);
            TrackerRole trackerRole = trackerPosition.getTrackerRole();
            Intrinsics.checkNotNull((Object)trackerRole);
            ProtobufMessages.TrackerAdded.Builder builder2 = builder.setTrackerRole(trackerRole.getId());
            ProtobufMessages.ProtobufMessage protobufMessage = ProtobufMessages.ProtobufMessage.newBuilder().setTrackerAdded(builder2).build();
            Intrinsics.checkNotNullExpressionValue(protobufMessage, "build(...)");
            this.sendMessage(protobufMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disconnected() {
        Map<Integer, Tracker> map = this.remoteTrackersByTrackerId;
        synchronized (map) {
            boolean bl = false;
            Iterator<Map.Entry<Integer, Tracker>> iterator2 = this.remoteTrackersByTrackerId.entrySet().iterator();
            while (iterator2.hasNext()) {
                Tracker value = iterator2.next().getValue();
                value.setStatus(TrackerStatus.DISCONNECTED);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void addSharedTracker(@Nullable Tracker tracker) {
        if (CollectionsKt.contains((Iterable)this.sharedTrackers, tracker) || tracker == null) {
            return;
        }
        this.sharedTrackers.add(tracker);
        ProtobufMessages.TrackerAdded.Builder builder = ProtobufMessages.TrackerAdded.newBuilder().setTrackerId(tracker.getId()).setTrackerName(tracker.getName()).setTrackerSerial(tracker.getName());
        TrackerPosition trackerPosition = tracker.getTrackerPosition();
        Intrinsics.checkNotNull((Object)trackerPosition);
        TrackerRole trackerRole = trackerPosition.getTrackerRole();
        Intrinsics.checkNotNull((Object)trackerRole);
        ProtobufMessages.TrackerAdded.Builder builder2 = builder.setTrackerRole(trackerRole.getId());
        ProtobufMessages.ProtobufMessage protobufMessage = ProtobufMessages.ProtobufMessage.newBuilder().setTrackerAdded(builder2).build();
        Intrinsics.checkNotNullExpressionValue(protobufMessage, "build(...)");
        this.sendMessage(protobufMessage);
    }

    @Override
    public void removeSharedTracker(@Nullable Tracker tracker) {
        TypeIntrinsics.asMutableCollection(this.sharedTrackers).remove(tracker);
        ProtobufMessages.TrackerStatus.Builder builder = ProtobufMessages.TrackerStatus.newBuilder();
        Tracker tracker2 = tracker;
        Intrinsics.checkNotNull(tracker2);
        ProtobufMessages.TrackerStatus.Builder statusBuilder = builder.setTrackerId(tracker2.getId());
        statusBuilder.setStatus(ProtobufMessages.TrackerStatus.Status.DISCONNECTED);
        ProtobufMessages.ProtobufMessage protobufMessage = ProtobufMessages.ProtobufMessage.newBuilder().setTrackerStatus(statusBuilder).build();
        Intrinsics.checkNotNullExpressionValue(protobufMessage, "build(...)");
        this.sendMessage(protobufMessage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/desktop/platform/ProtobufBridge$Companion;", "", "<init>", "()V", "resetSourceNamePrefix", "", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

