/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.platform;

import dev.slimevr.VRServer;
import dev.slimevr.config.BridgeConfig;
import dev.slimevr.desktop.platform.ProtobufBridge;
import dev.slimevr.desktop.platform.ProtobufMessages;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.protocol.rpc.settings.RPCSettingsHandler;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerRole;
import dev.slimevr.tracking.trackers.TrackerUtils;
import io.eiren.util.collections.FastList;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.rpc.StatusDataUnion;
import solarxr_protocol.rpc.StatusSteamVRDisconnectedT;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001fH\u0016J\u001a\u0010&\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u000bH\u0014J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00106\u001a\u00020\u001dH\u0004J\b\u00107\u001a\u00020\u001dH\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00068"}, d2={"Ldev/slimevr/desktop/platform/SteamVRBridge;", "Ldev/slimevr/desktop/platform/ProtobufBridge;", "Ljava/lang/Runnable;", "server", "Ldev/slimevr/VRServer;", "threadName", "", "bridgeName", "bridgeSettingsKey", "shareableTrackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ldev/slimevr/VRServer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getServer", "()Ldev/slimevr/VRServer;", "getBridgeSettingsKey", "()Ljava/lang/String;", "getShareableTrackers", "()Ljava/util/List;", "runnerThread", "Ljava/lang/Thread;", "getRunnerThread", "()Ljava/lang/Thread;", "config", "Ldev/slimevr/config/BridgeConfig;", "getConfig", "()Ldev/slimevr/config/BridgeConfig;", "startBridge", "", "getShareSetting", "", "role", "Ldev/slimevr/tracking/trackers/TrackerRole;", "updateShareSettingsAutomatically", "getAutomaticSharedTrackers", "setAutomaticSharedTrackers", "value", "changeShareSettings", "share", "createNewTracker", "trackerAdded", "Ldev/slimevr/desktop/platform/ProtobufMessages$TrackerAdded;", "writeBatteryUpdate", "localTracker", "batteryReceived", "batteryMessage", "Ldev/slimevr/desktop/platform/ProtobufMessages$Battery;", "lastSteamVRStatus", "", "getLastSteamVRStatus", "()I", "setLastSteamVRStatus", "(I)V", "reportDisconnected", "reportConnected", "desktop"})
@SourceDebugExtension(value={"SMAP\nSteamVRBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteamVRBridge.kt\ndev/slimevr/desktop/platform/SteamVRBridge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n1#2:461\n*E\n"})
public abstract class SteamVRBridge
extends ProtobufBridge
implements Runnable {
    @NotNull
    private final VRServer server;
    @NotNull
    private final String bridgeSettingsKey;
    @NotNull
    private final List<Tracker> shareableTrackers;
    @NotNull
    private final Thread runnerThread;
    @NotNull
    private final BridgeConfig config;
    private int lastSteamVRStatus;

    public SteamVRBridge(@NotNull VRServer server, @NotNull String threadName, @NotNull String bridgeName, @NotNull String bridgeSettingsKey, @NotNull List<Tracker> shareableTrackers) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(threadName, "threadName");
        Intrinsics.checkNotNullParameter(bridgeName, "bridgeName");
        Intrinsics.checkNotNullParameter(bridgeSettingsKey, "bridgeSettingsKey");
        Intrinsics.checkNotNullParameter(shareableTrackers, "shareableTrackers");
        super(bridgeName);
        this.server = server;
        this.bridgeSettingsKey = bridgeSettingsKey;
        this.shareableTrackers = shareableTrackers;
        this.runnerThread = new Thread((Runnable)this, threadName);
        this.config = this.server.configManager.getVrConfig().getBridge(this.bridgeSettingsKey);
    }

    @NotNull
    protected final VRServer getServer() {
        return this.server;
    }

    @NotNull
    protected final String getBridgeSettingsKey() {
        return this.bridgeSettingsKey;
    }

    @NotNull
    protected final List<Tracker> getShareableTrackers() {
        return this.shareableTrackers;
    }

    @NotNull
    protected final Thread getRunnerThread() {
        return this.runnerThread;
    }

    @NotNull
    protected final BridgeConfig getConfig() {
        return this.config;
    }

    @Override
    public void startBridge() {
        for (Tracker tr : this.shareableTrackers) {
            TrackerPosition trackerPosition = tr.getTrackerPosition();
            TrackerRole role = trackerPosition != null ? trackerPosition.getTrackerRole() : null;
            this.changeShareSettings(role, this.config.getBridgeTrackerRole(role, false));
        }
        this.runnerThread.start();
    }

    @Override
    public boolean getShareSetting(@NotNull TrackerRole role) {
        Intrinsics.checkNotNullParameter((Object)role, "role");
        for (Tracker tr : this.shareableTrackers) {
            TrackerPosition trackerPosition = tr.getTrackerPosition();
            if ((trackerPosition != null ? trackerPosition.getTrackerRole() : null) != role) continue;
            return this.sharedTrackers.contains(tr);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean updateShareSettingsAutomatically() {
        if (!this.config.automaticSharedTrackersToggling || this.server.getPauseTracking()) {
            return false;
        }
        skeleton = VRServer.Companion.getInstance().humanPoseManager.getSkeleton();
        v0 = skeleton.getHipTracker();
        if (v0 != null && (v0 = v0.getDevice()) != null ? v0.isOpenVrDevice() : false) ** GOTO lbl-1000
        v1 = skeleton.getWaistTracker();
        v2 = v1 != null && (v1 = v1.getDevice()) != null ? v1.isOpenVrDevice() : false;
        if (v2) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        isWaistSteamVr = v3;
        this.changeShareSettings(TrackerRole.WAIST, skeleton.getHasSpineTracker() != false && isWaistSteamVr == false);
        hasChest = skeleton.getUpperChestTracker() != null || skeleton.getChestTracker() != null;
        v4 = skeleton.getUpperChestTracker();
        if (v4 != null && (v4 = v4.getDevice()) != null ? v4.isOpenVrDevice() : false) ** GOTO lbl-1000
        v5 = skeleton.getChestTracker();
        v6 = v5 != null && (v5 = v5.getDevice()) != null ? v5.isOpenVrDevice() : false;
        if (v6) lbl-1000:
        // 2 sources

        {
            v7 = true;
        } else {
            v7 = false;
        }
        isChestSteamVr = v7;
        this.changeShareSettings(TrackerRole.CHEST, hasChest != false && isChestSteamVr == false);
        hasLeftFoot = skeleton.getLeftUpperLegTracker() != null || skeleton.getLeftLowerLegTracker() != null;
        v8 = skeleton.getLeftLowerLegTracker();
        if (v8 != null && (v8 = v8.getDevice()) != null ? v8.isOpenVrDevice() : false) ** GOTO lbl-1000
        v9 = skeleton.getLeftFootTracker();
        v10 = v9 != null && (v9 = v9.getDevice()) != null ? v9.isOpenVrDevice() : false;
        if (v10) lbl-1000:
        // 2 sources

        {
            v11 = true;
        } else {
            v11 = false;
        }
        isLeftFootSteamVr = v11;
        hasRightFoot = skeleton.getRightUpperLegTracker() != null || skeleton.getRightLowerLegTracker() != null;
        v12 = skeleton.getRightLowerLegTracker();
        if (v12 != null && (v12 = v12.getDevice()) != null ? v12.isOpenVrDevice() : false) ** GOTO lbl-1000
        v13 = skeleton.getRightFootTracker();
        v14 = v13 != null && (v13 = v13.getDevice()) != null ? v13.isOpenVrDevice() : false;
        if (v14) lbl-1000:
        // 2 sources

        {
            v15 = true;
        } else {
            v15 = false;
        }
        isRightFootSteamVr = v15;
        this.changeShareSettings(TrackerRole.LEFT_FOOT, hasLeftFoot != false && isLeftFootSteamVr == false);
        this.changeShareSettings(TrackerRole.RIGHT_FOOT, hasRightFoot != false && isRightFootSteamVr == false);
        v16 = skeleton.getLeftUpperLegTracker();
        v17 = v16 != null && (v16 = v16.getDevice()) != null ? v16.isOpenVrDevice() : (isLeftKneeSteamVr = false);
        v18 = skeleton.getRightUpperLegTracker();
        isRightKneeSteamVr = v18 != null && (v18 = v18.getDevice()) != null ? v18.isOpenVrDevice() : false;
        this.changeShareSettings(TrackerRole.LEFT_KNEE, hasLeftFoot != false && isLeftKneeSteamVr == false);
        this.changeShareSettings(TrackerRole.RIGHT_KNEE, hasRightFoot != false && isRightKneeSteamVr == false);
        hasLeftElbow = skeleton.getHasLeftArmTracker();
        v19 = skeleton.getLeftUpperArmTracker();
        if (v19 != null && (v19 = v19.getDevice()) != null ? v19.isOpenVrDevice() : false) ** GOTO lbl-1000
        v20 = skeleton.getLeftLowerArmTracker();
        v21 = v20 != null && (v20 = v20.getDevice()) != null ? v20.isOpenVrDevice() : false;
        if (v21) lbl-1000:
        // 2 sources

        {
            v22 = true;
        } else {
            v22 = false;
        }
        isLeftElbowSteamVr = v22;
        hasRightElbow = skeleton.getHasRightArmTracker();
        v23 = skeleton.getRightUpperArmTracker();
        if (v23 != null && (v23 = v23.getDevice()) != null ? v23.isOpenVrDevice() : false) ** GOTO lbl-1000
        v24 = skeleton.getRightLowerArmTracker();
        v25 = v24 != null && (v24 = v24.getDevice()) != null ? v24.isOpenVrDevice() : false;
        if (v25) lbl-1000:
        // 2 sources

        {
            v26 = true;
        } else {
            v26 = false;
        }
        isRightElbowSteamVr = v26;
        this.changeShareSettings(TrackerRole.LEFT_ELBOW, hasLeftElbow != false && isLeftElbowSteamVr == false);
        this.changeShareSettings(TrackerRole.RIGHT_ELBOW, hasRightElbow != false && isRightElbowSteamVr == false);
        return true;
    }

    @Override
    public boolean getAutomaticSharedTrackers() {
        return this.config.automaticSharedTrackersToggling;
    }

    @Override
    public void setAutomaticSharedTrackers(boolean value) {
        if (value == this.config.automaticSharedTrackersToggling) {
            return;
        }
        this.config.automaticSharedTrackersToggling = value;
        if (value) {
            this.updateShareSettingsAutomatically();
            ProtocolAPI protocolAPI = VRServer.Companion.getInstance().protocolAPI;
            RPCHandler rPCHandler = VRServer.Companion.getInstance().protocolAPI.rpcHandler;
            Intrinsics.checkNotNullExpressionValue(rPCHandler, "rpcHandler");
            RPCSettingsHandler.Companion.sendSteamVRUpdatedSettings(protocolAPI, rPCHandler);
        }
        VRServer.Companion.getInstance().configManager.saveConfig();
    }

    @Override
    public void changeShareSettings(@Nullable TrackerRole role, boolean share) {
        if (role == null) {
            return;
        }
        for (Tracker tr : this.shareableTrackers) {
            TrackerPosition trackerPosition = tr.getTrackerPosition();
            if ((trackerPosition != null ? trackerPosition.getTrackerRole() : null) != role) continue;
            if (share) {
                this.addSharedTracker(tr);
            } else {
                this.removeSharedTracker(tr);
            }
            this.config.setBridgeTrackerRole(role, share);
            VRServer.Companion.getInstance().configManager.saveConfig();
        }
    }

    @Override
    @NotNull
    protected Tracker createNewTracker(@NotNull ProtobufMessages.TrackerAdded trackerAdded) {
        boolean bl;
        Intrinsics.checkNotNullParameter(trackerAdded, "trackerAdded");
        Device device = VRServer.Companion.getInstance().deviceManager.createDevice(trackerAdded.getTrackerName(), trackerAdded.getTrackerSerial(), "OpenVR");
        String displayName = null;
        if (trackerAdded.getTrackerId() == 0) {
            displayName = Intrinsics.areEqual(trackerAdded.getTrackerName(), "HMD") ? "SteamVR Driver HMD" : "Feeder App HMD";
            bl = true;
        } else {
            displayName = trackerAdded.getTrackerName();
            bl = false;
        }
        boolean isHmd = bl;
        TrackerRole role = TrackerRole.Companion.getById(trackerAdded.getTrackerRole());
        TrackerPosition trackerPosition = role != null ? TrackerPosition.Companion.getByTrackerRole(role) : null;
        int n = VRServer.Companion.getNextLocalTrackerId();
        String string = trackerAdded.getTrackerSerial();
        Intrinsics.checkNotNullExpressionValue(string, "getTrackerSerial(...)");
        Tracker tracker = new Tracker(device, n, string, displayName, trackerPosition, trackerAdded.getTrackerId(), true, true, false, true, false, true, null, false, false, true, false, isHmd, false, null, null, 1930496, null);
        device.getTrackers().put(0, tracker);
        VRServer.Companion.getInstance().deviceManager.addDevice(device);
        return tracker;
    }

    @Override
    protected void writeBatteryUpdate(@NotNull Tracker localTracker) {
        Intrinsics.checkNotNullParameter(localTracker, "localTracker");
        float lowestLevel = 0.0f;
        lowestLevel = 200.0f;
        float trackerLevel = 0.0f;
        float trackerVoltage = 0.0f;
        boolean isCharging = false;
        List<Tracker> allTrackers = VRServer.Companion.getInstance().getAllTrackers();
        Enum enum_ = localTracker.getTrackerPosition();
        if (enum_ == null || (enum_ = ((TrackerPosition)enum_).getTrackerRole()) == null) {
            return;
        }
        Enum role = enum_;
        List batteryTrackers = new FastList();
        TrackerPosition trackerPosition = TrackerPosition.Companion.getByTrackerRole((TrackerRole)role);
        if (trackerPosition == null) {
            return;
        }
        batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, trackerPosition));
        switch (WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
            case 1: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.WAIST));
                if (this.config.getBridgeTrackerRole(TrackerRole.CHEST, true)) break;
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.CHEST));
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.UPPER_CHEST));
                break;
            }
            case 2: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.CHEST));
                if (this.config.getBridgeTrackerRole(TrackerRole.WAIST, true)) break;
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.WAIST));
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.HIP));
                break;
            }
            case 3: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.LEFT_LOWER_LEG));
                if (this.config.getBridgeTrackerRole(TrackerRole.LEFT_KNEE, true)) break;
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.LEFT_UPPER_LEG));
                break;
            }
            case 4: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.RIGHT_LOWER_LEG));
                if (this.config.getBridgeTrackerRole(TrackerRole.RIGHT_KNEE, true)) break;
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.RIGHT_UPPER_LEG));
                break;
            }
            case 5: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.LEFT_LOWER_ARM));
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.LEFT_SHOULDER));
                break;
            }
            case 6: {
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.RIGHT_LOWER_ARM));
                batteryTrackers.add(TrackerUtils.getTrackerForSkeleton(allTrackers, TrackerPosition.RIGHT_SHOULDER));
            }
        }
        for (Tracker batteryTracker : batteryTrackers) {
            float f;
            boolean bl;
            Object object = batteryTracker;
            if (object != null && (object = ((Tracker)object).getBatteryLevel()) != null) {
                float it = ((Number)object).floatValue();
                boolean bl2 = false;
                bl = it < lowestLevel;
            } else {
                bl = false;
            }
            if (!bl) continue;
            Float f2 = batteryTracker.getBatteryLevel();
            Intrinsics.checkNotNull(f2);
            lowestLevel = f2.floatValue();
            if (batteryTracker.getBatteryVoltage() != null) {
                Float f3 = batteryTracker.getBatteryVoltage();
                Intrinsics.checkNotNull(f3);
                f = f3.floatValue();
            } else {
                f = 0.0f;
            }
            trackerVoltage = f;
        }
        if (lowestLevel >= 200.0f || lowestLevel < 0.0f || (double)trackerVoltage < 3.2 && lowestLevel <= 0.0f || trackerVoltage >= 5.0f && lowestLevel > 150.0f) {
            return;
        }
        trackerLevel = lowestLevel / (float)100;
        if ((double)trackerVoltage >= 4.3) {
            isCharging = true;
        }
        ProtobufMessages.Battery.Builder builder = ProtobufMessages.Battery.newBuilder().setTrackerId(localTracker.getTrackerNum());
        builder.setBatteryLevel(trackerLevel);
        builder.setIsCharging(isCharging);
        ProtobufMessages.ProtobufMessage protobufMessage = ProtobufMessages.ProtobufMessage.newBuilder().setBattery(builder).build();
        Intrinsics.checkNotNullExpressionValue(protobufMessage, "build(...)");
        this.sendMessage(protobufMessage);
    }

    @Override
    protected void batteryReceived(@NotNull ProtobufMessages.Battery batteryMessage) {
        Intrinsics.checkNotNullParameter(batteryMessage, "batteryMessage");
        Tracker tracker = this.getInternalRemoteTrackerById(batteryMessage.getTrackerId());
        if (tracker == null) {
            return;
        }
        Tracker tracker2 = tracker;
        tracker2.setBatteryLevel(Float.valueOf(batteryMessage.getBatteryLevel()));
        if (batteryMessage.getIsCharging()) {
            tracker2.setBatteryVoltage(Float.valueOf(4.3f));
        } else {
            tracker2.setBatteryVoltage(Float.valueOf(3.7f));
        }
    }

    protected final int getLastSteamVRStatus() {
        return this.lastSteamVRStatus;
    }

    protected final void setLastSteamVRStatus(int n) {
        this.lastSteamVRStatus = n;
    }

    protected final void reportDisconnected() {
        if (this.lastSteamVRStatus != 0) {
            return;
        }
        StatusSteamVRDisconnectedT statusData = new StatusSteamVRDisconnectedT();
        statusData.setBridgeSettingsName(this.bridgeSettingsKey);
        StatusDataUnion status = new StatusDataUnion();
        status.setType((byte)3);
        status.setValue(statusData);
        this.lastSteamVRStatus = VRServer.Companion.getInstance().statusSystem.addStatusInt(status, false);
    }

    protected final void reportConnected() {
        if (this.lastSteamVRStatus == 0) {
            return;
        }
        VRServer.Companion.getInstance().statusSystem.removeStatusInt(UInt.constructor-impl(this.lastSteamVRStatus));
        this.lastSteamVRStatus = 0;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackerRole.values().length];
            try {
                nArray[TrackerRole.WAIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerRole.CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerRole.LEFT_FOOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerRole.RIGHT_FOOT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerRole.LEFT_ELBOW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerRole.RIGHT_ELBOW.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

