/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.platform.linux;

import com.google.protobuf.InvalidProtocolBufferException;
import dev.slimevr.VRServer;
import dev.slimevr.desktop.platform.ProtobufMessages;
import dev.slimevr.desktop.platform.SteamVRBridge;
import dev.slimevr.tracking.trackers.Tracker;
import io.eiren.util.logging.LogManager;
import java.io.File;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;

public class UnixSocketBridge
extends SteamVRBridge
implements AutoCloseable {
    public final String socketPath;
    public final UnixDomainSocketAddress socketAddress;
    private final ByteBuffer dst = ByteBuffer.allocate(2048).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer src = ByteBuffer.allocate(2048).order(ByteOrder.LITTLE_ENDIAN);
    private ServerSocketChannel server;
    private SocketChannel channel;
    private Selector selector;
    private boolean socketError = false;

    public UnixSocketBridge(VRServer server, String bridgeSettingsKey, String bridgeName, String socketPath, List<Tracker> shareableTrackers) {
        super(server, "Named socket thread", bridgeName, bridgeSettingsKey, shareableTrackers);
        this.socketPath = socketPath;
        this.socketAddress = UnixDomainSocketAddress.of(socketPath);
        File socketFile = new File(socketPath);
        if (socketFile.exists()) {
            throw new RuntimeException(socketPath + " socket already exists.");
        }
        socketFile.deleteOnExit();
    }

    @Override
    public void run() {
        try {
            this.server = this.createSocket();
            while (true) {
                if (this.channel == null) {
                    this.reportDisconnected();
                    this.selector = Selector.open();
                    this.channel = this.server.accept();
                    this.channel.configureBlocking(false);
                    this.channel.register(this.selector, 1);
                    if (this.channel == null) continue;
                    VRServer.Companion.getInstance().queueTask(() -> this.reconnected());
                    LogManager.info("[" + this.bridgeName + "] Connected to " + this.channel.getRemoteAddress().toString());
                    continue;
                }
                if (this.socketError || !this.channel.isConnected()) {
                    this.resetChannel();
                    continue;
                }
                try {
                    boolean updated = this.updateSocket();
                    this.updateMessageQueue();
                    if (updated) {
                        this.reportConnected();
                        continue;
                    }
                    this.waitForData(10L);
                }
                catch (IOException ioError) {
                    this.resetChannel();
                    ioError.printStackTrace();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    protected void signalSend() {
        Selector selector = this.selector;
        if (selector == null) {
            return;
        }
        selector.wakeup();
    }

    private void waitForData(long timeoutMs) throws IOException {
        this.selector.select(timeoutMs);
    }

    @Override
    protected boolean sendMessageReal(ProtobufMessages.ProtobufMessage message) {
        if (this.channel != null) {
            try {
                int size2 = message.getSerializedSize() + 4;
                this.src.putInt(size2);
                byte[] serialized = message.toByteArray();
                this.src.put(serialized);
                this.src.flip();
                while (this.src.hasRemaining()) {
                    this.channel.write(this.src);
                }
                this.src.clear();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean updateSocket() throws IOException {
        int read = this.channel.read(this.dst);
        if (read == -1) {
            LogManager.info("[" + this.bridgeName + "] Reached end-of-stream on connection of " + this.channel.getRemoteAddress().toString());
            this.socketError = true;
            return false;
        }
        if (read == 0) {
            return false;
        }
        boolean readAnything = false;
        while (this.dst.position() >= 4) {
            int messageLength = this.dst.getInt(0);
            if (messageLength > 1024) {
                LogManager.severe("[" + this.bridgeName + "] Buffer overflow on socket. Message length: " + messageLength);
                this.socketError = true;
                break;
            }
            if (this.dst.position() < messageLength) break;
            try {
                ProtobufMessages.ProtobufMessage message = UnixSocketBridge.parseMessage(this.dst.array(), 4, messageLength - 4);
                this.messageReceived(message);
            }
            catch (InvalidProtocolBufferException e) {
                LogManager.severe("Failed to read protocol message", e);
            }
            int originalpos = this.dst.position();
            this.dst.position(messageLength);
            this.dst.compact();
            this.dst.position(originalpos - messageLength);
            readAnything = true;
        }
        return readAnything;
    }

    private static ProtobufMessages.ProtobufMessage parseMessage(byte[] data, int offset, int length) throws InvalidProtocolBufferException {
        return ProtobufMessages.ProtobufMessage.parser().parseFrom(data, offset, length);
    }

    private void resetChannel() throws IOException {
        LogManager.info("[" + this.bridgeName + "] Disconnected from " + this.channel.getRemoteAddress().toString());
        this.selector.close();
        this.selector = null;
        this.channel.close();
        this.channel = null;
        this.socketError = false;
        this.dst.clear();
        VRServer.Companion.getInstance().queueTask(() -> this.disconnected());
    }

    private ServerSocketChannel createSocket() throws IOException {
        ServerSocketChannel server = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
        server.bind(this.socketAddress);
        LogManager.info("[" + this.bridgeName + "] Socket " + this.socketPath + " created");
        return server;
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }
}

