/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.platform.linux;

import dev.slimevr.VRServer;
import dev.slimevr.bridge.Bridge;
import dev.slimevr.desktop.platform.linux.UnixSocketConnection;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.tracking.trackers.Tracker;
import io.eiren.util.logging.LogManager;
import java.io.File;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.stream.Stream;

public class UnixSocketRpcBridge
implements Bridge,
ProtocolAPIServer,
Runnable,
AutoCloseable {
    private final Thread runnerThread = new Thread((Runnable)this, "Named socket thread");
    private final String socketPath;
    private final ProtocolAPI protocolAPI;
    private final ServerSocketChannel socket;
    private final Selector selector;

    public UnixSocketRpcBridge(VRServer server, String socketPath, List<Tracker> shareableTrackers) {
        this.socketPath = socketPath;
        this.protocolAPI = server.protocolAPI;
        File socketFile = new File(socketPath);
        if (socketFile.exists()) {
            throw new RuntimeException(socketPath + " socket already exists.");
        }
        socketFile.deleteOnExit();
        try {
            this.socket = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            this.selector = Selector.open();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Socket open failed.");
        }
        server.protocolAPI.registerAPIServer(this);
    }

    private void disconnected() {
    }

    @Override
    public void dataRead() {
    }

    @Override
    public void dataWrite() {
    }

    @Override
    public void addSharedTracker(Tracker tracker) {
    }

    @Override
    public void removeSharedTracker(Tracker tracker) {
    }

    @Override
    public void startBridge() {
        this.runnerThread.start();
    }

    @Override
    public void run() {
        try {
            this.socket.bind(UnixDomainSocketAddress.of(this.socketPath));
            this.socket.configureBlocking(false);
            this.socket.register(this.selector, 16);
            LogManager.info("[SolarXR Bridge] Socket " + this.socketPath + " created");
            while (this.socket.isOpen()) {
                this.selector.select(0L);
                for (SelectionKey key2 : this.selector.selectedKeys()) {
                    SocketChannel channel;
                    UnixSocketConnection conn = (UnixSocketConnection)key2.attachment();
                    if (conn != null) {
                        ByteBuffer message;
                        while ((message = conn.read()) != null) {
                            this.protocolAPI.onMessage(conn, message);
                            conn.next();
                        }
                        continue;
                    }
                    while ((channel = this.socket.accept()) != null) {
                        channel.configureBlocking(false);
                        channel.register(this.selector, 1, new UnixSocketConnection(channel));
                        LogManager.info("[SolarXR Bridge] Connected to " + channel.getRemoteAddress().toString());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws Exception {
        this.socket.close();
        this.selector.close();
    }

    @Override
    public boolean isConnected() {
        return this.selector.keys().stream().anyMatch(key2 -> key2.attachment() != null);
    }

    @Override
    public Stream<GenericConnection> getAPIConnections() {
        return this.selector.keys().stream().map(key2 -> (GenericConnection)key2.attachment()).filter(conn -> conn != null);
    }
}

