/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.platform.windows;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import dev.slimevr.VRServer;
import dev.slimevr.desktop.platform.ProtobufMessages;
import dev.slimevr.desktop.platform.SteamVRBridge;
import dev.slimevr.desktop.platform.windows.Kernel32IO;
import dev.slimevr.desktop.platform.windows.PipeState;
import dev.slimevr.desktop.platform.windows.WindowsPipe;
import dev.slimevr.tracking.trackers.Tracker;
import io.eiren.util.logging.LogManager;
import java.io.IOException;
import java.util.List;

public class WindowsNamedPipeBridge
extends SteamVRBridge {
    private static final Kernel32 k32 = Kernel32.INSTANCE;
    private static final Kernel32IO k32io = Kernel32IO.INSTANCE;
    private static final Advapi32 adv32 = Advapi32.INSTANCE;
    protected final String pipeName;
    private final byte[] buffArray = new byte[2048];
    protected WindowsPipe pipe;
    protected WinNT.HANDLE openEvent = k32.CreateEvent(null, false, false, null);
    protected WinNT.HANDLE readEvent = k32.CreateEvent(null, false, false, null);
    protected WinNT.HANDLE writeEvent = k32.CreateEvent(null, false, false, null);
    protected WinNT.HANDLE rxEvent = k32.CreateEvent(null, false, false, null);
    protected WinNT.HANDLE txEvent = k32.CreateEvent(null, false, false, null);
    protected WinNT.HANDLE[] events = new WinNT.HANDLE[]{this.rxEvent, this.txEvent};
    private final WinBase.OVERLAPPED overlappedOpen = new WinBase.OVERLAPPED();
    private final WinBase.OVERLAPPED overlappedWrite = new WinBase.OVERLAPPED();
    private final WinBase.OVERLAPPED overlappedRead = new WinBase.OVERLAPPED();
    private final WinBase.OVERLAPPED overlappedWait = new WinBase.OVERLAPPED();
    private final IntByReference bytesWritten = new IntByReference(0);
    private final IntByReference bytesAvailable = new IntByReference(0);
    private final IntByReference bytesRead = new IntByReference(0);
    private boolean pendingWait = false;

    public WindowsNamedPipeBridge(VRServer server, String bridgeSettingsKey, String bridgeName, String pipeName, List<Tracker> shareableTrackers) {
        super(server, "Named pipe thread", bridgeName, bridgeSettingsKey, shareableTrackers);
        this.pipeName = pipeName;
        this.overlappedWait.hEvent = this.rxEvent;
    }

    @Override
    public void run() {
        try {
            this.createPipe();
            while (true) {
                boolean pipesUpdated = false;
                if (this.pipe.state == PipeState.CREATED) {
                    this.reportDisconnected();
                    this.tryOpeningPipe(this.pipe);
                }
                if (this.pipe.state == PipeState.OPEN) {
                    pipesUpdated = this.updatePipe();
                    if (pipesUpdated) {
                        this.reportConnected();
                    }
                    this.updateMessageQueue();
                }
                if (this.pipe.state == PipeState.ERROR) {
                    this.resetPipe();
                }
                if (pipesUpdated) continue;
                if (this.pipe.state == PipeState.OPEN) {
                    this.waitForData(10);
                    continue;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    protected void signalSend() {
        k32.SetEvent(this.txEvent);
    }

    private void waitForData(int timeoutMs) {
        int evIdx;
        if (this.pipe.state != PipeState.OPEN) {
            return;
        }
        if (!this.pendingWait) {
            k32.ReadFile(this.pipe.pipeHandle, null, 0, null, this.overlappedWait);
            this.pendingWait = true;
        }
        if ((evIdx = k32.WaitForMultipleObjects(this.events.length, this.events, false, timeoutMs)) == 0) {
            this.pendingWait = false;
        }
    }

    @Override
    protected boolean sendMessageReal(ProtobufMessages.ProtobufMessage message) {
        if (this.pipe.state != PipeState.OPEN) {
            return false;
        }
        try {
            int size2 = message.getSerializedSize();
            CodedOutputStream os = CodedOutputStream.newInstance(this.buffArray, 4, size2);
            message.writeTo(os);
            this.buffArray[0] = (byte)((size2 += 4) & 0xFF);
            this.buffArray[1] = (byte)(size2 >> 8 & 0xFF);
            this.buffArray[2] = (byte)(size2 >> 16 & 0xFF);
            this.buffArray[3] = (byte)(size2 >> 24 & 0xFF);
            this.overlappedWrite.clear();
            this.overlappedWrite.hEvent = this.writeEvent;
            boolean immediate = k32.WriteFile(this.pipe.pipeHandle, this.buffArray, size2, null, this.overlappedWrite);
            int err = k32.GetLastError();
            if (!immediate && err != 997) {
                this.setPipeError("WriteFile failed: " + err);
                return false;
            }
            if (!k32io.GetOverlappedResult(this.pipe.pipeHandle, this.overlappedWrite, this.bytesWritten, true)) {
                this.setPipeError("sendMessageReal/GetOverlappedResult failed: " + k32.GetLastError());
                return false;
            }
            if (this.bytesWritten.getValue() != size2) {
                this.setPipeError("Bytes written " + this.bytesWritten.getValue() + ", expected " + size2);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean updatePipe() throws IOException {
        if (this.pipe.state != PipeState.OPEN) {
            return false;
        }
        boolean readAnything = false;
        while (k32.PeekNamedPipe(this.pipe.pipeHandle, this.buffArray, 4, null, this.bytesAvailable, null)) {
            if (this.bytesAvailable.getValue() < 4) {
                return readAnything;
            }
            int messageLength = Byte.toUnsignedInt(this.buffArray[3]) << 24 | Byte.toUnsignedInt(this.buffArray[2]) << 16 | Byte.toUnsignedInt(this.buffArray[1]) << 8 | Byte.toUnsignedInt(this.buffArray[0]);
            if (messageLength > 1024) {
                this.setPipeError("Pipe overflow. Message length: " + messageLength);
                return readAnything;
            }
            if (this.bytesAvailable.getValue() < messageLength) {
                return readAnything;
            }
            this.overlappedRead.clear();
            this.overlappedRead.hEvent = this.readEvent;
            boolean immediate = k32.ReadFile(this.pipe.pipeHandle, this.buffArray, messageLength, null, this.overlappedRead);
            int err = k32.GetLastError();
            if (!immediate && err != 997) {
                this.setPipeError("ReadFile failed: " + err);
                return readAnything;
            }
            if (!k32io.GetOverlappedResult(this.pipe.pipeHandle, this.overlappedRead, this.bytesRead, true)) {
                this.setPipeError("updatePipe/GetOverlappedResult failed: " + k32.GetLastError());
                return readAnything;
            }
            if (this.bytesRead.getValue() != messageLength) {
                this.setPipeError("Bytes read " + this.bytesRead.getValue() + ", expected " + messageLength);
                return readAnything;
            }
            try {
                ProtobufMessages.ProtobufMessage message = ProtobufMessages.ProtobufMessage.parser().parseFrom(this.buffArray, 4, messageLength - 4);
                this.messageReceived(message);
                readAnything = true;
            }
            catch (InvalidProtocolBufferException parseEx) {
                parseEx.printStackTrace();
                this.setPipeError("Failed to parse message: " + parseEx.getMessage());
                return readAnything;
            }
        }
        int err = k32.GetLastError();
        if (err == 109) {
            this.setPipeError("Pipe closed");
        } else {
            this.setPipeError("Pipe error: " + err);
        }
        return readAnything;
    }

    private void setPipeError(String message) {
        this.pipe.state = PipeState.ERROR;
        LogManager.severe("[" + this.bridgeName + "] " + message);
    }

    private void resetPipe() {
        WindowsPipe.safeDisconnect(this.pipe);
        this.pipe.state = PipeState.CREATED;
        VRServer.Companion.getInstance().queueTask(() -> this.disconnected());
    }

    private void createPipe() throws IOException {
        try {
            WinNT.SECURITY_DESCRIPTOR descriptor = new WinNT.SECURITY_DESCRIPTOR(65536);
            adv32.InitializeSecurityDescriptor(descriptor, 1);
            adv32.SetSecurityDescriptorDacl(descriptor, true, null, false);
            adv32.SetSecurityDescriptorControl(descriptor, (short)4096, (short)4096);
            WinBase.SECURITY_ATTRIBUTES attributes = new WinBase.SECURITY_ATTRIBUTES();
            attributes.lpSecurityDescriptor = descriptor.getPointer();
            attributes.bInheritHandle = false;
            this.pipe = new WindowsPipe(k32.CreateNamedPipe(this.pipeName, 0x40000003, 0, 1, 16384, 16384, 0, attributes), this.pipeName);
            LogManager.info("[" + this.bridgeName + "] Pipe " + this.pipe.name + " created");
            if (WinBase.INVALID_HANDLE_VALUE.equals(this.pipe.pipeHandle)) {
                throw new IOException("Can't open " + this.pipeName + " pipe: " + k32.GetLastError());
            }
            LogManager.info("[" + this.bridgeName + "] Pipes are created");
        }
        catch (IOException e) {
            WindowsPipe.safeDisconnect(this.pipe);
            throw e;
        }
    }

    private boolean tryOpeningPipe(WindowsPipe pipe) {
        this.overlappedOpen.clear();
        this.overlappedOpen.hEvent = this.openEvent;
        boolean ok = k32.ConnectNamedPipe(pipe.pipeHandle, this.overlappedOpen);
        int err = k32.GetLastError();
        if (!ok && err != 535) {
            if (err != 997) {
                this.setPipeError("ConnectNamedPipe failed: " + err);
                return false;
            }
            if (!k32io.GetOverlappedResult(pipe.pipeHandle, this.overlappedOpen, this.bytesRead, true)) {
                this.setPipeError("tryOpeningPipe/GetOverlappedResult failed: " + k32.GetLastError());
                return false;
            }
        }
        pipe.state = PipeState.OPEN;
        LogManager.info("[" + this.bridgeName + "] Pipe " + pipe.name + " is open");
        VRServer.Companion.getInstance().queueTask(() -> this.reconnected());
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.pipe != null && this.pipe.state == PipeState.OPEN;
    }
}

