/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import dev.slimevr.desktop.serial.SerialPortWrapper;
import dev.slimevr.serial.SerialHandler;
import dev.slimevr.serial.SerialListener;
import io.eiren.util.logging.LogManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u001a\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001cH\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020\rJ\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\b\u00105\u001a\u00020'H\u0016J\b\u00106\u001a\u00020\rH\u0016J\b\u0010;\u001a\u00020\u0012H\u0002J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u0010088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006>"}, d2={"Ldev/slimevr/desktop/serial/DesktopSerialHandler;", "Ldev/slimevr/serial/SerialHandler;", "Lcom/fazecast/jSerialComm/SerialPortMessageListener;", "<init>", "()V", "listeners", "", "Ldev/slimevr/serial/SerialListener;", "getDevicesTimer", "Ljava/util/Timer;", "currentPort", "Lcom/fazecast/jSerialComm/SerialPort;", "watchingNewDevices", "", "lastKnownPorts", "", "Ldev/slimevr/desktop/serial/SerialPortWrapper;", "startWatchingNewDevices", "", "stopWatchingNewDevices", "onNewDevice", "port", "onDeviceDel", "addListener", "channel", "removeListener", "openSerial", "portLocation", "", "auto", "rebootRequest", "factoryResetRequest", "infoRequest", "wifiScanRequest", "closeSerial", "writeSerial", "serialText", "write", "buff", "", "setWifi", "ssid", "passwd", "addLog", "str", "server", "getListeningEvents", "", "serialEvent", "event", "Lcom/fazecast/jSerialComm/SerialPortEvent;", "isConnected", "()Z", "getMessageDelimiter", "delimiterIndicatesEndOfMessage", "knownPorts", "Ljava/util/stream/Stream;", "getKnownPorts", "()Ljava/util/stream/Stream;", "detectNewPorts", "getCurrentPort", "Ldev/slimevr/serial/SerialPort;", "desktop"})
@SourceDebugExtension(value={"SMAP\nDesktopSerialHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopSerialHandler.kt\ndev/slimevr/desktop/serial/DesktopSerialHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,265:1\n1863#2,2:266\n1863#2,2:268\n1863#2,2:275\n1863#2,2:277\n1863#2,2:279\n1863#2,2:281\n1863#2,2:289\n11165#3:270\n11500#3,3:271\n11165#3:283\n11500#3,3:284\n1#4:274\n1317#5,2:287\n*S KotlinDebug\n*F\n+ 1 DesktopSerialHandler.kt\ndev/slimevr/desktop/serial/DesktopSerialHandler\n*L\n75#1:266,2\n79#1:268,2\n115#1:275,2\n136#1:277,2\n161#1:279,2\n209#1:281,2\n252#1:289,2\n94#1:270\n94#1:271,3\n250#1:283\n250#1:284,3\n251#1:287,2\n*E\n"})
public final class DesktopSerialHandler
extends SerialHandler
implements SerialPortMessageListener {
    @NotNull
    private final List<SerialListener> listeners = new CopyOnWriteArrayList();
    @NotNull
    private final Timer getDevicesTimer = new Timer("GetDevicesTimer");
    @Nullable
    private SerialPort currentPort;
    private boolean watchingNewDevices;
    @NotNull
    private Set<SerialPortWrapper> lastKnownPorts = SetsKt.emptySet();

    public DesktopSerialHandler() {
        this.startWatchingNewDevices();
    }

    public final void startWatchingNewDevices() {
        if (this.watchingNewDevices) {
            return;
        }
        this.watchingNewDevices = true;
        this.getDevicesTimer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ DesktopSerialHandler this$0;
            {
                this.this$0 = desktopSerialHandler;
            }

            public void run() {
                TimerTask $this$startWatchingNewDevices_u24lambda_u240 = this;
                boolean bl = false;
                try {
                    DesktopSerialHandler.access$detectNewPorts(this.this$0);
                }
                catch (Throwable t) {
                    LogManager.severe("[SerialHandler] Error while watching for new devices, cancelling the \"getDevicesTimer\".", t);
                    DesktopSerialHandler.access$getGetDevicesTimer$p(this.this$0).cancel();
                }
            }
        }, 0L, 3000L);
    }

    public final void stopWatchingNewDevices() {
        if (!this.watchingNewDevices) {
            return;
        }
        this.watchingNewDevices = false;
        this.getDevicesTimer.cancel();
        this.getDevicesTimer.purge();
    }

    private final void onNewDevice(SerialPort port2) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerialListener it = (SerialListener)element$iv;
            boolean bl = false;
            it.onNewSerialDevice(new SerialPortWrapper(port2));
        }
    }

    private final void onDeviceDel(SerialPort port2) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerialListener it = (SerialListener)element$iv;
            boolean bl = false;
            it.onSerialDeviceDeleted(new SerialPortWrapper(port2));
        }
    }

    @Override
    public void addListener(@NotNull SerialListener channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.listeners.add(channel);
    }

    @Override
    public void removeListener(@NotNull SerialListener channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.listeners.removeIf(arg_0 -> DesktopSerialHandler.removeListener$lambda$4(arg_0 -> DesktopSerialHandler.removeListener$lambda$3(channel, arg_0), arg_0));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean openSerial(@Nullable String portLocation, boolean auto) {
        block18: {
            LogManager.info("[SerialHandler] Trying to open: " + portLocation + ", auto: " + auto);
            ports = SerialPort.getCommPorts();
            Intrinsics.checkNotNull(ports);
            var4_4 = ports;
            var14_5 = this;
            $i$f$map = false;
            var6_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
            $i$f$mapTo = 0;
            var10_24 = $this$mapTo$iv$iv.length;
            for (var9_20 = 0; var9_20 < var10_24; ++var9_20) {
                var12_30 = item$iv$iv = $this$mapTo$iv$iv[var9_20];
                var15_32 = destination$iv$iv;
                $i$a$-map-DesktopSerialHandler$openSerial$1 = false;
                Intrinsics.checkNotNull(it);
                var15_32.add(new SerialPortWrapper((SerialPort)it));
            }
            var14_5.lastKnownPorts = CollectionsKt.toSet((List)destination$iv$iv);
            $this$mapTo$iv$iv = ports;
            $i$f$mapTo = $this$mapTo$iv$iv.length;
            for (destination$iv$iv = 0; destination$iv$iv < $i$f$mapTo; ++destination$iv$iv) {
                it = var9_21 = $this$mapTo$iv$iv[destination$iv$iv];
                $i$a$-find-DesktopSerialHandler$openSerial$newPort$1 = false;
                if (!auto && Intrinsics.areEqual(it.getPortLocation(), portLocation)) ** GOTO lbl-1000
                if (auto) {
                    Intrinsics.checkNotNull(it);
                    ** if (!SerialHandler.Companion.isKnownBoard((dev.slimevr.serial.SerialPort)((dev.slimevr.serial.SerialPort)new SerialPortWrapper((SerialPort)it)))) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v0 = true;
                    ** GOTO lbl33
                }
lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
lbl33:
                // 2 sources

                if (!v0) continue;
                v1 = var9_21;
                break block18;
            }
            v1 = newPort = null;
        }
        if (newPort == null) {
            LogManager.info("[SerialHandler] No serial ports found to connect to (" + ports.length + ") total ports");
            return false;
        }
        if (this.isConnected()) {
            v2 = new SerialPortWrapper(newPort);
            v3 = this.currentPort;
            if (v3 != null) {
                destination$iv$iv = v3;
                var14_5 = v2;
                $i$a$-let-DesktopSerialHandler$openSerial$2 = false;
                v4 = new SerialPortWrapper((SerialPort)it);
                v2 = var14_5;
            } else {
                v4 = null;
            }
            if (!Intrinsics.areEqual(v2, v4)) {
                v5 = this.currentPort;
                Intrinsics.checkNotNull(v5);
                LogManager.info("[SerialHandler] Closing current serial port " + v5.getDescriptivePortName());
                v6 = this.currentPort;
                Intrinsics.checkNotNull(v6);
                v6.removeDataListener();
                v7 = this.currentPort;
                Intrinsics.checkNotNull(v7);
                v7.closePort();
            } else {
                LogManager.info("[SerialHandler] Reusing already open port");
                $this$forEach$iv = this.listeners;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (SerialListener)element$iv;
                    $i$a$-forEach-DesktopSerialHandler$openSerial$3 = false;
                    v8 = this.currentPort;
                    Intrinsics.checkNotNull(v8);
                    it.onSerialConnected(new SerialPortWrapper(v8));
                }
                return true;
            }
        }
        v9 = this.currentPort = newPort;
        Intrinsics.checkNotNull(v9);
        LogManager.info("[SerialHandler] Trying to connect to new serial port " + v9.getDescriptivePortName());
        v10 = this.currentPort;
        if (v10 != null) {
            v10.setBaudRate(115200);
        }
        v11 = this.currentPort;
        if (v11 != null) {
            v11.clearRTS();
        }
        v12 = this.currentPort;
        if (v12 != null) {
            v12.clearDTR();
        }
        v13 = this.currentPort;
        v14 = v13 != null ? !v13.openPort(1000) : false;
        if (v14) {
            v15 = this.currentPort;
            v16 = this.currentPort;
            LogManager.warning("[SerialHandler] Can't open serial port " + (v15 != null ? v15.getDescriptivePortName() : null) + ", last error: " + (v16 != null ? Integer.valueOf(v16.getLastErrorCode()) : null));
            this.currentPort = null;
            return false;
        }
        v17 = this.currentPort;
        if (v17 != null) {
            v17.addDataListener(this);
        }
        $this$forEach$iv = this.listeners;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (SerialListener)element$iv;
            $i$a$-forEach-DesktopSerialHandler$openSerial$4 = false;
            v18 = this.currentPort;
            Intrinsics.checkNotNull(v18);
            it.onSerialConnected(new SerialPortWrapper(v18));
        }
        LogManager.info("[SerialHandler] Serial port " + newPort.getDescriptivePortName() + " is open");
        return true;
    }

    @Override
    public void rebootRequest() {
        this.writeSerial("REBOOT");
    }

    @Override
    public void factoryResetRequest() {
        this.writeSerial("FRST");
    }

    @Override
    public void infoRequest() {
        this.writeSerial("GET INFO");
    }

    @Override
    public void wifiScanRequest() {
        this.writeSerial("GET WIFISCAN");
    }

    @Override
    public synchronized void closeSerial() {
        try {
            SerialPort serialPort = this.currentPort;
            if (serialPort != null) {
                serialPort.closePort();
            }
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SerialListener it = (SerialListener)element$iv;
                boolean bl = false;
                it.onSerialDisconnected();
            }
            SerialPort serialPort2 = this.currentPort;
            LogManager.info("[SerialHandler] Port " + (serialPort2 != null ? serialPort2.getDescriptivePortName() : null) + " closed okay");
            this.currentPort = null;
        }
        catch (Exception e) {
            SerialPort serialPort = this.currentPort;
            LogManager.warning("[SerialHandler] Error closing port " + (serialPort != null ? serialPort.getDescriptivePortName() : null), e);
        }
    }

    private final synchronized void writeSerial(String serialText) {
        Object object = this.currentPort;
        if (object == null || (object = ((SerialPort)object).getOutputStream()) == null) {
            return;
        }
        Object os = object;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os);
        try {
            writer.append(serialText).append("\n");
            writer.flush();
            DesktopSerialHandler.addLog$default(this, "-> " + serialText + "\n", false, 2, null);
        }
        catch (IOException e) {
            DesktopSerialHandler.addLog$default(this, "[!] Serial error: " + e.getMessage() + "\n", false, 2, null);
            LogManager.warning("[SerialHandler] Serial port write error", e);
        }
    }

    @Override
    public void write(@NotNull byte[] buff) {
        block0: {
            Intrinsics.checkNotNullParameter(buff, "buff");
            LogManager.info("[SerialHandler] WRITING " + buff);
            Object object = this.currentPort;
            if (object == null || (object = ((SerialPort)object).getOutputStream()) == null) break block0;
            ((OutputStream)object).write(buff);
        }
    }

    @Override
    public synchronized void setWifi(@NotNull String ssid, @NotNull String passwd) {
        Intrinsics.checkNotNullParameter(ssid, "ssid");
        Intrinsics.checkNotNullParameter(passwd, "passwd");
        Object object = this.currentPort;
        if (object == null || (object = ((SerialPort)object).getOutputStream()) == null) {
            return;
        }
        Object os = object;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os);
        try {
            writer.append("SET WIFI \"").append(ssid).append("\" \"").append(passwd).append("\"\n");
            writer.flush();
            CharSequence charSequence = passwd;
            Regex regex = new Regex(".");
            String string = "*";
            DesktopSerialHandler.addLog$default(this, "-> SET WIFI \"" + ssid + "\" \"" + regex.replace(charSequence, string) + "\"\n", false, 2, null);
        }
        catch (IOException e) {
            DesktopSerialHandler.addLog$default(this, e + "\n", false, 2, null);
            LogManager.warning("[SerialHandler] Serial port write error", e);
        }
    }

    public final void addLog(@NotNull String str, boolean server) {
        Intrinsics.checkNotNullParameter(str, "str");
        LogManager.info("[Serial] " + str);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerialListener it = (SerialListener)element$iv;
            boolean bl = false;
            it.onSerialLog(str, server);
        }
    }

    public static /* synthetic */ void addLog$default(DesktopSerialHandler desktopSerialHandler, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        desktopSerialHandler.addLog(string, bl);
    }

    @Override
    public int getListeningEvents() {
        return 0x10000010;
    }

    @Override
    public void serialEvent(@NotNull SerialPortEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        switch (event.getEventType()) {
            case 16: {
                byte[] newData = event.getReceivedData();
                String string = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(newData)).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String s = string;
                this.addLog(s, false);
                break;
            }
            case 0x10000000: {
                this.closeSerial();
            }
        }
    }

    @Override
    public synchronized boolean isConnected() {
        SerialPort serialPort = this.currentPort;
        return serialPort != null ? serialPort.isOpen() : false;
    }

    @Override
    @NotNull
    public byte[] getMessageDelimiter() {
        byte[] byArray = new byte[]{10};
        return byArray;
    }

    @Override
    public boolean delimiterIndicatesEndOfMessage() {
        return true;
    }

    @NotNull
    public Stream<SerialPortWrapper> getKnownPorts() {
        SerialPort[] serialPortArray = SerialPort.getCommPorts();
        Intrinsics.checkNotNullExpressionValue(serialPortArray, "getCommPorts(...)");
        return StreamsKt.asStream(SequencesKt.filter(SequencesKt.map(ArraysKt.asSequence((Object[])serialPortArray), DesktopSerialHandler::_get_knownPorts_$lambda$12), DesktopSerialHandler::_get_knownPorts_$lambda$13));
    }

    /*
     * WARNING - void declaration
     */
    private final void detectNewPorts() {
        try {
            SerialPortWrapper element$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Sequence<SerialPortWrapper> addDifferences = SequencesKt.minus(StreamsKt.asSequence(this.getKnownPorts()), (Iterable)this.lastKnownPorts);
            Set<SerialPortWrapper> delDifferences = SetsKt.minus(this.lastKnownPorts, (Iterable)SequencesKt.toSet(StreamsKt.asSequence(this.getKnownPorts())));
            SerialPort[] serialPortArray = SerialPort.getCommPorts();
            Intrinsics.checkNotNullExpressionValue(serialPortArray, "getCommPorts(...)");
            Object[] objectArray = serialPortArray;
            DesktopSerialHandler desktopSerialHandler = this;
            boolean $i$f$map = false;
            Iterator<SerialPortWrapper> iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SerialPort serialPort = (SerialPort)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection.add(new SerialPortWrapper((SerialPort)it));
            }
            desktopSerialHandler.lastKnownPorts = CollectionsKt.toSet((List)destination$iv$iv);
            Object $this$forEach$iv = addDifferences;
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                SerialPortWrapper it = element$iv = iterator2.next();
                boolean bl = false;
                this.onNewDevice(it.getPort());
            }
            $this$forEach$iv = delDifferences;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                SerialPortWrapper it = element$iv = iterator2.next();
                boolean bl = false;
                this.onDeviceDel(it.getPort());
            }
        }
        catch (Throwable e) {
            LogManager.severe("[SerialHandler] Using serial ports is not supported on this platform", e);
            throw new RuntimeException("Serial unsupported");
        }
    }

    @Override
    @Nullable
    public dev.slimevr.serial.SerialPort getCurrentPort() {
        SerialPort serialPort = this.currentPort;
        if (serialPort == null) {
            return null;
        }
        SerialPort port2 = serialPort;
        return new SerialPortWrapper(port2);
    }

    private static final boolean removeListener$lambda$3(SerialListener $channel, SerialListener it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $channel == it;
    }

    private static final boolean removeListener$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final SerialPortWrapper _get_knownPorts_$lambda$12(SerialPort it) {
        Intrinsics.checkNotNull(it);
        return new SerialPortWrapper(it);
    }

    private static final boolean _get_knownPorts_$lambda$13(SerialPortWrapper it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SerialHandler.Companion.isKnownBoard(it);
    }

    public static final /* synthetic */ void access$detectNewPorts(DesktopSerialHandler $this) {
        $this.detectNewPorts();
    }

    public static final /* synthetic */ Timer access$getGetDevicesTimer$p(DesktopSerialHandler $this) {
        return $this.getDevicesTimer;
    }
}

