/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.desktop.tracking.trackers.hid;

import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.hid.HIDCommon;
import dev.slimevr.tracking.trackers.hid.HIDDevice;
import io.eiren.util.logging.LogManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.event.HidServicesEvent;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0016J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010)H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006/"}, d2={"Ldev/slimevr/desktop/tracking/trackers/hid/DesktopHIDManager;", "Ljava/lang/Thread;", "Lorg/hid4java/HidServicesListener;", "name", "", "trackersConsumer", "Ljava/util/function/Consumer;", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ljava/lang/String;Ljava/util/function/Consumer;)V", "devices", "", "Ldev/slimevr/tracking/trackers/hid/HIDDevice;", "devicesBySerial", "", "", "devicesByHID", "Lorg/hid4java/HidDevice;", "lastDataByHID", "hidServicesSpecification", "Lorg/hid4java/HidServicesSpecification;", "hidServices", "Lorg/hid4java/HidServices;", "checkConfigureDevice", "", "hidDevice", "removeDevice", "dataReadRunnable", "Ljava/lang/Runnable;", "getDataReadRunnable", "()Ljava/lang/Runnable;", "deviceEnumerateRunnable", "getDeviceEnumerateRunnable", "dataRead", "deviceEnumerate", "run", "getDevices", "", "Ldev/slimevr/tracking/trackers/Device;", "hidDeviceAttached", "event", "Lorg/hid4java/event/HidServicesEvent;", "hidDeviceDetached", "hidFailure", "hidDataReceived", "p0", "Companion", "desktop"})
@SourceDebugExtension(value={"SMAP\nDesktopHIDManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopHIDManager.kt\ndev/slimevr/desktop/tracking/trackers/hid/DesktopHIDManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class DesktopHIDManager
extends Thread
implements HidServicesListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Consumer<Tracker> trackersConsumer;
    @NotNull
    private final List<HIDDevice> devices;
    @NotNull
    private final Map<String, List<Integer>> devicesBySerial;
    @NotNull
    private final Map<HidDevice, List<Integer>> devicesByHID;
    @NotNull
    private final Map<HidDevice, Integer> lastDataByHID;
    @NotNull
    private final HidServicesSpecification hidServicesSpecification;
    @Nullable
    private HidServices hidServices;
    @NotNull
    private static final String resetSourceName = "TrackerServer";

    public DesktopHIDManager(@NotNull String name, @NotNull Consumer<Tracker> trackersConsumer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(trackersConsumer, "trackersConsumer");
        super(name);
        this.trackersConsumer = trackersConsumer;
        this.devices = new ArrayList();
        this.devicesBySerial = new HashMap();
        this.devicesByHID = new HashMap();
        this.lastDataByHID = new HashMap();
        this.hidServicesSpecification = new HidServicesSpecification();
        this.hidServicesSpecification.setAutoStart(false);
        try {
            HidServices hidServices = this.hidServices = HidManager.getHidServices(this.hidServicesSpecification);
            if (hidServices != null) {
                hidServices.addHidServicesListener(this);
            }
            Thread dataReadThread = new Thread(this.getDataReadRunnable());
            dataReadThread.setDaemon(true);
            dataReadThread.setName("hid4java data reader");
            dataReadThread.start();
            Thread deviceEnumerateThread = new Thread(this.getDeviceEnumerateRunnable());
            deviceEnumerateThread.setDaemon(true);
            deviceEnumerateThread.setName("hid4java device enumerator");
            deviceEnumerateThread.start();
        }
        catch (HidException e) {
            LogManager.severe("Error initializing HID services: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkConfigureDevice(HidDevice hidDevice) {
        if (hidDevice.getVendorId() == 4617 && hidDevice.getProductId() == 30352) {
            String serial;
            List<Integer> $i$a$-check-DesktopHIDManager$checkConfigureDevice$222;
            if (hidDevice.isClosed() && !hidDevice.open()) {
                boolean $i$a$-check-DesktopHIDManager$checkConfigureDevice$222 = false;
                String $i$a$-check-DesktopHIDManager$checkConfigureDevice$222 = "Unable to open device";
                throw new IllegalStateException($i$a$-check-DesktopHIDManager$checkConfigureDevice$222.toString());
            }
            String string = hidDevice.getSerialNumber();
            if (string == null) {
                string = "Unknown HID Device";
            }
            if (($i$a$-check-DesktopHIDManager$checkConfigureDevice$222 = this.devicesBySerial.get(serial = string)) != null) {
                List<Integer> it = $i$a$-check-DesktopHIDManager$checkConfigureDevice$222;
                boolean bl = false;
                this.devicesByHID.put(hidDevice, it);
                List<HIDDevice> list = this.devices;
                synchronized (list) {
                    boolean bl2 = false;
                    Iterator<Integer> iterator2 = it.iterator();
                    while (iterator2.hasNext()) {
                        int id = ((Number)iterator2.next()).intValue();
                        HIDDevice device = this.devices.get(id);
                        for (Tracker value : device.getTrackers().values()) {
                            if (value.getStatus() != TrackerStatus.DISCONNECTED) continue;
                            value.setStatus(TrackerStatus.OK);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                LogManager.info("[TrackerServer] Linked HID device reattached: " + serial);
                return;
            }
            List list = new ArrayList();
            this.devicesBySerial.put(serial, list);
            this.devicesByHID.put(hidDevice, list);
            this.lastDataByHID.put(hidDevice, 0);
            LogManager.info("[TrackerServer] (Probably) Compatible HID device detected: " + serial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDevice(HidDevice hidDevice) {
        block5: {
            List<Integer> list = this.devicesByHID.get(hidDevice);
            if (list == null) break block5;
            List<Integer> it = list;
            boolean bl = false;
            List<HIDDevice> list2 = this.devices;
            synchronized (list2) {
                boolean bl2 = false;
                Iterator<Integer> iterator2 = it.iterator();
                while (iterator2.hasNext()) {
                    int id = ((Number)iterator2.next()).intValue();
                    HIDDevice device = this.devices.get(id);
                    for (Tracker value : device.getTrackers().values()) {
                        if (value.getStatus() != TrackerStatus.OK) continue;
                        value.setStatus(TrackerStatus.DISCONNECTED);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            this.devicesByHID.remove(hidDevice);
            LogManager.info("[TrackerServer] Linked HID device removed: " + hidDevice.getSerialNumber());
        }
    }

    private final synchronized Runnable getDataReadRunnable() {
        return () -> DesktopHIDManager._get_dataReadRunnable_$lambda$5(this);
    }

    private final synchronized Runnable getDeviceEnumerateRunnable() {
        return () -> DesktopHIDManager._get_deviceEnumerateRunnable_$lambda$6(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dataRead() {
        Map<HidDevice, List<Integer>> map = this.devicesByHID;
        synchronized (map) {
            boolean bl = false;
            boolean devicesPresent = false;
            boolean devicesDataReceived = false;
            int[] nArray = new int[]{0, 0, 0, 0};
            int[] q = nArray;
            int[] nArray2 = new int[]{0, 0, 0};
            int[] a = nArray2;
            Object object = new int[]{0, 0, 0};
            int[] m = object;
            object = this.devicesByHID.entrySet().iterator();
            while (object.hasNext()) {
                byte[] byArray;
                Map.Entry entry = (Map.Entry)object.next();
                HidDevice hidDevice = (HidDevice)entry.getKey();
                List deviceList = (List)entry.getValue();
                try {
                    byArray = hidDevice.readAll(0);
                }
                catch (NegativeArraySizeException e) {
                    continue;
                }
                byte[] dataReceived = byArray;
                devicesPresent = true;
                if (!(dataReceived.length == 0)) {
                    if (dataReceived.length % 16 != 0) {
                        LogManager.info("[TrackerServer] Malformed HID packet, ignoring");
                        continue;
                    }
                    devicesDataReceived = true;
                    this.lastDataByHID.put(hidDevice, 0);
                    int packetCount = dataReceived.length / 16;
                    int i = 0;
                    while (i < packetCount * 16) {
                        int id;
                        int packetType = UByte.constructor-impl(dataReceived[i]) & 0xFF;
                        int deviceId = id = UByte.constructor-impl(dataReceived[i + 1]) & 0xFF;
                        if (packetType == 255) {
                            String deviceName;
                            ByteBuffer buffer = ByteBuffer.wrap(dataReceived, i + 2, 8);
                            buffer.order(ByteOrder.LITTLE_ENDIAN);
                            long addr = buffer.getLong() & 0xFFFFFFFFFFFFL;
                            String string = "%012X";
                            Object[] objectArray = new Object[]{addr};
                            Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
                            HIDCommon.Companion.deviceIdLookup(this.devices, hidDevice.getSerialNumber(), deviceId, deviceName, deviceList);
                            i += 16;
                            continue;
                        }
                        HIDDevice device = HIDCommon.Companion.deviceIdLookup(this.devices, hidDevice.getSerialNumber(), deviceId, null, deviceList);
                        if (device == null) {
                            i += 16;
                            continue;
                        }
                        HIDCommon.Companion.processPacket(dataReceived, i, packetType, device, q, a, m, this.trackersConsumer);
                        i += 16;
                    }
                    continue;
                }
                Integer n = this.lastDataByHID.get(hidDevice);
                Intrinsics.checkNotNull(n);
                this.lastDataByHID.put(hidDevice, ((Number)n).intValue() + 1);
            }
            if (!devicesPresent) {
                Thread.sleep(10L);
            } else if (!devicesDataReceived) {
                Thread.sleep(1L);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deviceEnumerate() {
        HidDeviceInfoStructure root = null;
        try {
            root = HidApi.enumerateDevices(4617, 30352);
        }
        catch (Throwable e) {
            LogManager.severe("[TrackerServer] Couldn't enumerate HID devices", e);
        }
        List hidDeviceList = new ArrayList();
        if (root != null) {
            HidDeviceInfoStructure hidDeviceInfoStructure = root;
            do {
                hidDeviceList.add(new HidDevice(hidDeviceInfoStructure, null, this.hidServicesSpecification));
            } while ((hidDeviceInfoStructure = hidDeviceInfoStructure.next()) != null);
            HidApi.freeEnumeration(root);
        }
        Map<HidDevice, List<Integer>> map = this.devicesByHID;
        synchronized (map) {
            boolean bl = false;
            List<HidDevice> removeList = CollectionsKt.toMutableList((Collection)this.devicesByHID.keySet());
            removeList.removeAll(hidDeviceList);
            for (HidDevice device : removeList) {
                this.removeDevice(device);
            }
            for (HidDevice device : this.devicesByHID.keySet()) {
                Integer n = this.lastDataByHID.get(device);
                Intrinsics.checkNotNull(n);
                if (((Number)n).intValue() <= 100) continue;
                LogManager.info("[TrackerServer] Reopening device " + device.getSerialNumber() + " after no data received");
                device.open();
            }
            hidDeviceList.removeAll((Collection)this.devicesByHID.keySet());
            for (HidDevice device : hidDeviceList) {
                this.checkConfigureDevice(device);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void run() {
    }

    @NotNull
    public final List<Device> getDevices() {
        return this.devices;
    }

    @Override
    public void hidDeviceAttached(@NotNull HidServicesEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @Override
    public void hidDeviceDetached(@NotNull HidServicesEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @Override
    public void hidFailure(@NotNull HidServicesEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @Override
    public void hidDataReceived(@Nullable HidServicesEvent p0) {
    }

    private static final void _get_dataReadRunnable_$lambda$5(DesktopHIDManager this$0) {
        while (true) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            this$0.dataRead();
        }
    }

    private static final void _get_deviceEnumerateRunnable_$lambda$6(DesktopHIDManager this$0) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            this$0.deviceEnumerate();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/desktop/tracking/trackers/hid/DesktopHIDManager$Companion;", "", "<init>", "()V", "resetSourceName", "", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

