/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.filtering;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class CircularArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private final int n;
    private final List<E> buf;
    private int head = 0;
    private int tail = 0;

    public CircularArrayList(int capacity) {
        this.n = capacity + 1;
        this.buf = new ArrayList<Object>(Collections.nCopies(this.n, null));
    }

    public int capacity() {
        return this.n - 1;
    }

    private int wrapIndex(int i) {
        int m = i % this.n;
        if (m < 0) {
            m += this.n;
        }
        return m;
    }

    private void shiftBlock(int startIndex, int endIndex) {
        assert (endIndex > startIndex);
        for (int i = endIndex - 1; i >= startIndex; --i) {
            this.set(i + 1, this.get(i));
        }
    }

    @Override
    public int size() {
        return this.tail - this.head + (this.tail < this.head ? this.n : 0);
    }

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf.get(this.wrapIndex(this.head + i));
    }

    public E getLatest() {
        return this.buf.get(this.wrapIndex(this.head + this.size() - 1));
    }

    @Override
    public E set(int i, E e) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf.set(this.wrapIndex(this.head + i), e);
    }

    @Override
    public void add(int i, E e) {
        int s = this.size();
        if (s == this.n - 1) {
            throw new IllegalStateException("CircularArrayList is filled to capacity. (You may want to remove from front before adding more to back.)");
        }
        if (i < 0 || i > s) {
            throw new IndexOutOfBoundsException();
        }
        this.tail = this.wrapIndex(this.tail + 1);
        if (i < s) {
            this.shiftBlock(i, s);
        }
        this.set(i, e);
    }

    @Override
    public E remove(int i) {
        int s = this.size();
        if (i < 0 || i >= s) {
            throw new IndexOutOfBoundsException();
        }
        E e = this.get(i);
        if (i > 0) {
            this.shiftBlock(0, i);
        }
        this.head = this.wrapIndex(this.head + 1);
        return e;
    }

    @Override
    public E removeLast() {
        int s = this.size();
        if (0 == s) {
            throw new IndexOutOfBoundsException();
        }
        E e = this.get(0);
        this.head = this.wrapIndex(this.head + 1);
        return e;
    }
}

