/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.filtering;

import com.jme3.system.NanoTimer;
import dev.slimevr.VRServer;
import dev.slimevr.filtering.CircularArrayList;
import dev.slimevr.filtering.TrackerFilters;
import io.github.axisangles.ktmath.Quaternion;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010)\u001a\u00020*J\u0015\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0007\u00a2\u0006\u0004\b-\u0010\u0014J\u001d\u0010.\u001a\u00020*2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007\u00a2\u0006\u0004\b0\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0016\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0016\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ldev/slimevr/filtering/QuaternionMovingAverage;", "", "type", "Ldev/slimevr/filtering/TrackerFilters;", "amount", "", "initialRotation", "Lio/github/axisangles/ktmath/Quaternion;", "<init>", "(Ldev/slimevr/filtering/TrackerFilters;FFFFFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getType", "()Ldev/slimevr/filtering/TrackerFilters;", "getAmount", "()F", "setAmount", "(F)V", "filteredQuaternion", "getFilteredQuaternion", "()Lio/github/axisangles/ktmath/Quaternion;", "setFilteredQuaternion-oS71L7k", "(FFFF)V", "filteredQuaternion-w", "F", "filteringImpact", "getFilteringImpact", "setFilteringImpact", "smoothFactor", "predictFactor", "rotBuffer", "Ldev/slimevr/filtering/CircularArrayList;", "latestQuaternion", "getLatestQuaternion", "setLatestQuaternion-oS71L7k", "latestQuaternion-w", "smoothingQuaternion", "getSmoothingQuaternion", "setSmoothingQuaternion-oS71L7k", "smoothingQuaternion-w", "fpsTimer", "Lcom/jme3/system/NanoTimer;", "timeSinceUpdate", "update", "", "addQuaternion", "q", "addQuaternion-oS71L7k", "resetQuats", "reference", "resetQuats-T8bZSfw", "(FFFFFFFF)V", "core"})
@SourceDebugExtension(value={"SMAP\nQuaternionMovingAverage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuaternionMovingAverage.kt\ndev/slimevr/filtering/QuaternionMovingAverage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1797#2,3:129\n*S KotlinDebug\n*F\n+ 1 QuaternionMovingAverage.kt\ndev/slimevr/filtering/QuaternionMovingAverage\n*L\n65#1:129,3\n*E\n"})
public final class QuaternionMovingAverage {
    @NotNull
    private final TrackerFilters type;
    private float amount;
    private float filteredQuaternion-w;
    private float filteredQuaternion-x;
    private float filteredQuaternion-y;
    private float filteredQuaternion-z;
    private float filteringImpact;
    private float smoothFactor;
    private float predictFactor;
    @Nullable
    private CircularArrayList<Quaternion> rotBuffer;
    private float latestQuaternion-w;
    private float latestQuaternion-x;
    private float latestQuaternion-y;
    private float latestQuaternion-z;
    private float smoothingQuaternion-w;
    private float smoothingQuaternion-x;
    private float smoothingQuaternion-y;
    private float smoothingQuaternion-z;
    @NotNull
    private final NanoTimer fpsTimer;
    private float timeSinceUpdate;

    private QuaternionMovingAverage(TrackerFilters type, float amount, float f, float f2, float f3, float f4) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.type = type;
        this.amount = amount;
        Quaternion.Companion companion = Quaternion.Companion;
        this.filteredQuaternion-w = companion.getIDENTITY-w();
        this.filteredQuaternion-x = companion.getIDENTITY-x();
        this.filteredQuaternion-y = companion.getIDENTITY-y();
        this.filteredQuaternion-z = companion.getIDENTITY-z();
        companion = Quaternion.Companion;
        this.latestQuaternion-w = companion.getIDENTITY-w();
        this.latestQuaternion-x = companion.getIDENTITY-x();
        this.latestQuaternion-y = companion.getIDENTITY-y();
        this.latestQuaternion-z = companion.getIDENTITY-z();
        companion = Quaternion.Companion;
        this.smoothingQuaternion-w = companion.getIDENTITY-w();
        this.smoothingQuaternion-x = companion.getIDENTITY-x();
        this.smoothingQuaternion-y = companion.getIDENTITY-y();
        this.smoothingQuaternion-z = companion.getIDENTITY-z();
        this.fpsTimer = VRServer.Companion.getInstanceInitialized() ? VRServer.Companion.getInstance().getFpsTimer() : new NanoTimer();
        this.amount = RangesKt.coerceAtLeast(this.amount, 0.0f);
        if (this.type == TrackerFilters.SMOOTHING) {
            this.smoothFactor = 42.0f * (1.0f - RangesKt.coerceAtMost(this.amount, 1.0f)) + 11.0f;
            if (this.amount > 1.0f) {
                this.smoothFactor /= this.amount;
            }
        }
        if (this.type == TrackerFilters.PREDICTION) {
            this.predictFactor = 15.0f * this.amount + 10.0f;
            this.rotBuffer = new CircularArrayList(6);
        }
        this.resetQuats-T8bZSfw(f, f2, f3, f4, f, f2, f3, f4);
    }

    public /* synthetic */ QuaternionMovingAverage(TrackerFilters trackerFilters, float f, float f2, float f3, float f4, float f5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            Quaternion.Companion companion = Quaternion.Companion;
            f2 = companion.getIDENTITY-w();
            f3 = companion.getIDENTITY-x();
            f4 = companion.getIDENTITY-y();
            f5 = companion.getIDENTITY-z();
        }
        if ((n & 8) != 0) {
            // empty if block
        }
        if ((n & 0x10) != 0) {
            // empty if block
        }
        if ((n & 0x20) != 0) {
            // empty if block
        }
        this(trackerFilters, f, f2, f3, f4, f5, null);
    }

    @NotNull
    public final TrackerFilters getType() {
        return this.type;
    }

    public final float getAmount() {
        return this.amount;
    }

    public final void setAmount(float f) {
        this.amount = f;
    }

    @NotNull
    public final Quaternion getFilteredQuaternion() {
        return Quaternion.box-impl(this.filteredQuaternion-w, this.filteredQuaternion-x, this.filteredQuaternion-y, this.filteredQuaternion-z);
    }

    public final void setFilteredQuaternion-oS71L7k(float f, float f2, float f3, float f4) {
        this.filteredQuaternion-w = f;
        this.filteredQuaternion-x = f2;
        this.filteredQuaternion-y = f3;
        this.filteredQuaternion-z = f4;
    }

    public final float getFilteringImpact() {
        return this.filteringImpact;
    }

    public final void setFilteringImpact(float f) {
        this.filteringImpact = f;
    }

    private final Quaternion getLatestQuaternion() {
        return Quaternion.box-impl(this.latestQuaternion-w, this.latestQuaternion-x, this.latestQuaternion-y, this.latestQuaternion-z);
    }

    private final void setLatestQuaternion-oS71L7k(float f, float f2, float f3, float f4) {
        this.latestQuaternion-w = f;
        this.latestQuaternion-x = f2;
        this.latestQuaternion-y = f3;
        this.latestQuaternion-z = f4;
    }

    private final Quaternion getSmoothingQuaternion() {
        return Quaternion.box-impl(this.smoothingQuaternion-w, this.smoothingQuaternion-x, this.smoothingQuaternion-y, this.smoothingQuaternion-z);
    }

    private final void setSmoothingQuaternion-oS71L7k(float f, float f2, float f3, float f4) {
        this.smoothingQuaternion-w = f;
        this.smoothingQuaternion-x = f2;
        this.smoothingQuaternion-y = f3;
        this.smoothingQuaternion-z = f4;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void update() {
        if (this.type == TrackerFilters.PREDICTION) {
            CircularArrayList<Quaternion> rotBuf = this.rotBuffer;
            if (rotBuf != null && !((Collection)rotBuf).isEmpty()) {
                void $this$fold$iv;
                Iterable iterable = rotBuf;
                Quaternion initial$iv = this.getLatestQuaternion();
                boolean $i$f$fold = false;
                Quaternion accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void rot;
                    Quaternion quaternion = (Quaternion)element$iv;
                    Quaternion quaternion2 = accumulator$iv;
                    boolean bl = false;
                    float f = quaternion2.unbox-impl-w();
                    float f2 = quaternion2.unbox-impl-x();
                    float f3 = quaternion2.unbox-impl-y();
                    float f4 = quaternion2.unbox-impl-z();
                    accumulator$iv = Quaternion.times-oS71L7k(f, f2, f3, f4, rot.unbox-impl-w(), rot.unbox-impl-x(), rot.unbox-impl-y(), rot.unbox-impl-z());
                }
                Quaternion quaternion = accumulator$iv;
                float f = quaternion.unbox-impl-w();
                float f5 = quaternion.unbox-impl-x();
                float f6 = quaternion.unbox-impl-y();
                float f7 = quaternion.unbox-impl-z();
                float amt = RangesKt.coerceAtMost(this.predictFactor * this.fpsTimer.getTimePerFrame(), 1.0f);
                Quaternion quaternion3 = Quaternion.interpQ-jCQAsEA(this.filteredQuaternion-w, this.filteredQuaternion-x, this.filteredQuaternion-y, this.filteredQuaternion-z, f, f5, f6, f7, amt);
                this.setFilteredQuaternion-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z());
            }
        } else if (this.type == TrackerFilters.SMOOTHING) {
            this.timeSinceUpdate += this.fpsTimer.getTimePerFrame();
            float amt = RangesKt.coerceAtMost(this.smoothFactor * this.timeSinceUpdate, 1.0f);
            Quaternion quaternion = Quaternion.interpQ-jCQAsEA(this.smoothingQuaternion-w, this.smoothingQuaternion-x, this.smoothingQuaternion-y, this.smoothingQuaternion-z, this.latestQuaternion-w, this.latestQuaternion-x, this.latestQuaternion-y, this.latestQuaternion-z, amt);
            this.setFilteredQuaternion-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        }
        this.filteringImpact = Quaternion.angleToR-oS71L7k(this.latestQuaternion-w, this.latestQuaternion-x, this.latestQuaternion-y, this.latestQuaternion-z, this.filteredQuaternion-w, this.filteredQuaternion-x, this.filteredQuaternion-y, this.filteredQuaternion-z);
    }

    public final synchronized void addQuaternion-oS71L7k(float f, float f2, float f3, float f4) {
        float f5 = this.latestQuaternion-w;
        float f6 = this.latestQuaternion-x;
        float f7 = this.latestQuaternion-y;
        float f8 = this.latestQuaternion-z;
        Quaternion quaternion = Quaternion.twinNearest-oS71L7k(f, f2, f3, f4, f5, f6, f7, f8);
        float f9 = quaternion.unbox-impl-w();
        float f10 = quaternion.unbox-impl-x();
        float f11 = quaternion.unbox-impl-y();
        float f12 = quaternion.unbox-impl-z();
        this.setLatestQuaternion-oS71L7k(f9, f10, f11, f12);
        if (this.type == TrackerFilters.PREDICTION) {
            CircularArrayList<Quaternion> circularArrayList = this.rotBuffer;
            Intrinsics.checkNotNull(circularArrayList);
            int n = circularArrayList.size();
            CircularArrayList<Quaternion> circularArrayList2 = this.rotBuffer;
            Intrinsics.checkNotNull(circularArrayList2);
            if (n == circularArrayList2.capacity()) {
                CircularArrayList<Quaternion> circularArrayList3 = this.rotBuffer;
                if (circularArrayList3 != null) {
                    circularArrayList3.removeLast();
                }
            }
            CircularArrayList<Quaternion> circularArrayList4 = this.rotBuffer;
            if (circularArrayList4 != null) {
                Quaternion quaternion2 = Quaternion.inv-impl(f5, f6, f7, f8);
                circularArrayList4.add(Quaternion.times-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z(), f9, f10, f11, f12));
            }
        } else if (this.type == TrackerFilters.SMOOTHING) {
            this.timeSinceUpdate = 0.0f;
            this.setSmoothingQuaternion-oS71L7k(this.filteredQuaternion-w, this.filteredQuaternion-x, this.filteredQuaternion-y, this.filteredQuaternion-z);
        } else {
            this.setFilteredQuaternion-oS71L7k(f9, f10, f11, f12);
        }
    }

    public final synchronized void resetQuats-T8bZSfw(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        Quaternion quaternion = Quaternion.twinNearest-oS71L7k(f, f2, f3, f4, f5, f6, f7, f8);
        float f9 = quaternion.unbox-impl-w();
        float f10 = quaternion.unbox-impl-x();
        float f11 = quaternion.unbox-impl-y();
        float f12 = quaternion.unbox-impl-z();
        CircularArrayList<Quaternion> circularArrayList = this.rotBuffer;
        if (circularArrayList != null) {
            circularArrayList.clear();
        }
        this.setLatestQuaternion-oS71L7k(f9, f10, f11, f12);
        this.setFilteredQuaternion-oS71L7k(f9, f10, f11, f12);
        this.addQuaternion-oS71L7k(f9, f10, f11, f12);
    }

    public final /* synthetic */ float getFilteredQuaternion-w() {
        return this.filteredQuaternion-w;
    }

    public final /* synthetic */ float getFilteredQuaternion-x() {
        return this.filteredQuaternion-x;
    }

    public final /* synthetic */ float getFilteredQuaternion-y() {
        return this.filteredQuaternion-y;
    }

    public final /* synthetic */ float getFilteredQuaternion-z() {
        return this.filteredQuaternion-z;
    }

    public final /* synthetic */ float getLatestQuaternion-w() {
        return this.latestQuaternion-w;
    }

    public final /* synthetic */ float getLatestQuaternion-x() {
        return this.latestQuaternion-x;
    }

    public final /* synthetic */ float getLatestQuaternion-y() {
        return this.latestQuaternion-y;
    }

    public final /* synthetic */ float getLatestQuaternion-z() {
        return this.latestQuaternion-z;
    }

    public final /* synthetic */ float getSmoothingQuaternion-w() {
        return this.smoothingQuaternion-w;
    }

    public final /* synthetic */ float getSmoothingQuaternion-x() {
        return this.smoothingQuaternion-x;
    }

    public final /* synthetic */ float getSmoothingQuaternion-y() {
        return this.smoothingQuaternion-y;
    }

    public final /* synthetic */ float getSmoothingQuaternion-z() {
        return this.smoothingQuaternion-z;
    }

    public /* synthetic */ QuaternionMovingAverage(TrackerFilters type, float amount, float f, float f2, float f3, float f4, DefaultConstructorMarker $constructor_marker) {
        this(type, amount, f, f2, f3, f4);
    }
}

