/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.firmware;

import dev.slimevr.firmware.FirmwareUpdateStatus;
import dev.slimevr.firmware.UpdateDeviceId;
import dev.slimevr.firmware.UpdateStatusEvent;
import io.eiren.util.logging.LogManager;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0010H\u0002J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00062"}, d2={"Ldev/slimevr/firmware/OTAUpdateTask;", "", "firmware", "", "deviceId", "Ldev/slimevr/firmware/UpdateDeviceId;", "", "deviceIp", "Ljava/net/InetAddress;", "statusCallback", "Ljava/util/function/Consumer;", "Ldev/slimevr/firmware/UpdateStatusEvent;", "<init>", "([BLdev/slimevr/firmware/UpdateDeviceId;Ljava/net/InetAddress;Ljava/util/function/Consumer;)V", "receiveBuffer", "socketServer", "Ljava/net/ServerSocket;", "getSocketServer", "()Ljava/net/ServerSocket;", "setSocketServer", "(Ljava/net/ServerSocket;)V", "uploadSocket", "Ljava/net/Socket;", "getUploadSocket", "()Ljava/net/Socket;", "setUploadSocket", "(Ljava/net/Socket;)V", "authSocket", "Ljava/net/DatagramSocket;", "getAuthSocket", "()Ljava/net/DatagramSocket;", "setAuthSocket", "(Ljava/net/DatagramSocket;)V", "canceled", "", "getCanceled", "()Z", "setCanceled", "(Z)V", "bytesToMd5", "", "bytes", "authenticate", "localPort", "upload", "serverSocket", "run", "", "cancel", "Companion", "core"})
public final class OTAUpdateTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] firmware;
    @NotNull
    private final UpdateDeviceId<Integer> deviceId;
    @NotNull
    private final InetAddress deviceIp;
    @NotNull
    private final Consumer<UpdateStatusEvent<Integer>> statusCallback;
    @NotNull
    private final byte[] receiveBuffer;
    @Nullable
    private ServerSocket socketServer;
    @Nullable
    private Socket uploadSocket;
    @Nullable
    private DatagramSocket authSocket;
    private boolean canceled;
    private static final int FLASH = 0;
    private static final int PORT = 8266;
    @NotNull
    private static final String PASSWORD = "SlimeVR-OTA";
    private static final int AUTH = 200;

    public OTAUpdateTask(@NotNull byte[] firmware, @NotNull UpdateDeviceId<Integer> deviceId, @NotNull InetAddress deviceIp, @NotNull Consumer<UpdateStatusEvent<Integer>> statusCallback) {
        Intrinsics.checkNotNullParameter(firmware, "firmware");
        Intrinsics.checkNotNullParameter(deviceId, "deviceId");
        Intrinsics.checkNotNullParameter(deviceIp, "deviceIp");
        Intrinsics.checkNotNullParameter(statusCallback, "statusCallback");
        this.firmware = firmware;
        this.deviceId = deviceId;
        this.deviceIp = deviceIp;
        this.statusCallback = statusCallback;
        this.receiveBuffer = new byte[38];
    }

    @Nullable
    public final ServerSocket getSocketServer() {
        return this.socketServer;
    }

    public final void setSocketServer(@Nullable ServerSocket serverSocket) {
        this.socketServer = serverSocket;
    }

    @Nullable
    public final Socket getUploadSocket() {
        return this.uploadSocket;
    }

    public final void setUploadSocket(@Nullable Socket socket) {
        this.uploadSocket = socket;
    }

    @Nullable
    public final DatagramSocket getAuthSocket() {
        return this.authSocket;
    }

    public final void setAuthSocket(@Nullable DatagramSocket datagramSocket) {
        this.authSocket = datagramSocket;
    }

    public final boolean getCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    private final String bytesToMd5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(bytes);
        byte[] digest = md5.digest();
        StringBuilder md5str = new StringBuilder();
        for (byte b : digest) {
            String string = "%02x";
            Object[] objectArray = new Object[]{b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            md5str.append(string2);
        }
        String string = md5str.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean authenticate(int localPort2) {
        try {
            Closeable closeable = new DatagramSocket();
            Throwable throwable = null;
            try {
                DatagramSocket socket = (DatagramSocket)closeable;
                boolean bl = false;
                this.authSocket = socket;
                this.statusCallback.accept(new UpdateStatusEvent(this.deviceId, FirmwareUpdateStatus.AUTHENTICATING, 0, 0L, 12, null));
                LogManager.info("[OTAUpdate] Sending OTA invitation to: " + this.deviceIp);
                String fileMd5 = this.bytesToMd5(this.firmware);
                String message = "0 " + localPort2 + " " + this.firmware.length + " " + fileMd5 + "\n";
                byte[] byArray = message.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                socket.send(new DatagramPacket(byArray, message.length(), this.deviceIp, 8266));
                socket.setSoTimeout(10000);
                DatagramPacket authPacket = new DatagramPacket(this.receiveBuffer, this.receiveBuffer.length);
                socket.receive(authPacket);
                byte[] byArray2 = authPacket.getData();
                Intrinsics.checkNotNullExpressionValue(byArray2, "getData(...)");
                byte[] byArray3 = byArray2;
                int n = 0;
                int n2 = authPacket.getLength();
                String data = new String(byArray3, n, n2, Charsets.UTF_8);
                if (Intrinsics.areEqual(data, "OK")) {
                    boolean bl2 = true;
                    return bl2;
                }
                String[] stringArray = new String[]{" "};
                List args2 = StringsKt.split$default((CharSequence)data, stringArray, false, 0, 6, null);
                if (args2.size() != 2 || !Intrinsics.areEqual(args2.get(0), "AUTH")) {
                    boolean bl3 = false;
                    return bl3;
                }
                LogManager.info("[OTAUpdate] Authenticating...");
                String authToken = (String)args2.get(1);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                byte[] byArray4 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray4, "getBytes(...)");
                String signature = this.bytesToMd5(byArray4);
                byte[] byArray5 = PASSWORD.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray5, "getBytes(...)");
                String hashedPassword = this.bytesToMd5(byArray5);
                String resultText = hashedPassword + ":" + authToken + ":" + signature;
                byte[] byArray6 = resultText.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray6, "getBytes(...)");
                String payload = this.bytesToMd5(byArray6);
                String authMessage = "200 " + signature + " " + payload + "\n";
                socket.setSoTimeout(10000);
                byte[] byArray7 = authMessage.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray7, "getBytes(...)");
                socket.send(new DatagramPacket(byArray7, authMessage.length(), this.deviceIp, 8266));
                DatagramPacket authResponsePacket = new DatagramPacket(this.receiveBuffer, this.receiveBuffer.length);
                socket.receive(authResponsePacket);
                byte[] byArray8 = authResponsePacket.getData();
                Intrinsics.checkNotNullExpressionValue(byArray8, "getData(...)");
                byte[] byArray9 = byArray8;
                int n3 = 0;
                int n4 = authResponsePacket.getLength();
                String authResponse = new String(byArray9, n3, n4, Charsets.UTF_8);
                boolean bl4 = Intrinsics.areEqual(authResponse, "OK");
                return bl4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            LogManager.severe("OTA Authentication exception", e);
            return false;
        }
    }

    private final boolean upload(ServerSocket serverSocket) {
        try {
            int chunkLen;
            Socket connection;
            LogManager.info("[OTAUpdate] Starting on: " + serverSocket.getLocalPort());
            LogManager.info("[OTAUpdate] Waiting for device...");
            this.uploadSocket = connection = serverSocket.accept();
            connection.setSoTimeout(1000);
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            DataInputStream dis = new DataInputStream(connection.getInputStream());
            LogManager.info("[OTAUpdate] Upload size: " + this.firmware.length + " bytes");
            int chunkSize = 2048;
            for (int offset = 0; offset != this.firmware.length && !this.canceled; offset += chunkLen) {
                this.statusCallback.accept(new UpdateStatusEvent(this.deviceId, FirmwareUpdateStatus.UPLOADING, (int)((double)offset / (double)this.firmware.length * (double)100), 0L, 8, null));
                chunkLen = Math.min(chunkSize, this.firmware.length - offset);
                dos.write(this.firmware, offset, chunkLen);
                dos.flush();
                dis.skipNBytes(4L);
            }
            if (this.canceled) {
                return false;
            }
            LogManager.info("[OTAUpdate] Waiting for result...");
            connection.setSoTimeout(10000);
            byte[] responseBytes = dis.readAllBytes();
            Intrinsics.checkNotNull(responseBytes);
            String response = new String(responseBytes, Charsets.UTF_8);
            return StringsKt.contains$default((CharSequence)response, "OK", false, 2, null);
        }
        catch (Exception e) {
            LogManager.severe("Unable to upload the firmware using ota", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Closeable closeable = new ServerSocket(0);
        Throwable throwable = null;
        try {
            ServerSocket serverSocket = (ServerSocket)closeable;
            boolean bl = false;
            this.socketServer = serverSocket;
            if (!this.authenticate(serverSocket.getLocalPort())) {
                this.statusCallback.accept(new UpdateStatusEvent(this.deviceId, FirmwareUpdateStatus.ERROR_AUTHENTICATION_FAILED, 0, 0L, 12, null));
                return;
            }
            if (!this.upload(serverSocket)) {
                this.statusCallback.accept(new UpdateStatusEvent(this.deviceId, FirmwareUpdateStatus.ERROR_UPLOAD_FAILED, 0, 0L, 12, null));
                return;
            }
            this.statusCallback.accept(new UpdateStatusEvent(this.deviceId, FirmwareUpdateStatus.REBOOTING, 0, 0L, 12, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public final void cancel() {
        block2: {
            this.canceled = true;
            ServerSocket serverSocket = this.socketServer;
            if (serverSocket != null) {
                serverSocket.close();
            }
            DatagramSocket datagramSocket = this.authSocket;
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            Socket socket = this.uploadSocket;
            if (socket == null) break block2;
            socket.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/slimevr/firmware/OTAUpdateTask$Companion;", "", "<init>", "()V", "FLASH", "", "PORT", "PASSWORD", "", "AUTH", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

