/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.firmware;

import dev.slimevr.VRServer;
import dev.slimevr.firmware.SerialRebootListener;
import dev.slimevr.firmware.UpdateDeviceId;
import dev.slimevr.serial.SerialListener;
import dev.slimevr.serial.SerialPort;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\"\u0010\u0002\u001a\u001e\u0012\u001a\u0012\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R*\u0010\u0002\u001a\u001e\u0012\u001a\u0012\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/slimevr/firmware/SerialRebootHandler;", "Ldev/slimevr/serial/SerialListener;", "watchRestartQueue", "", "Lkotlin/Pair;", "Ldev/slimevr/firmware/UpdateDeviceId;", "Lkotlin/Function0;", "", "server", "Ldev/slimevr/VRServer;", "serialRebootListener", "Ldev/slimevr/firmware/SerialRebootListener;", "<init>", "(Ljava/util/List;Ldev/slimevr/VRServer;Ldev/slimevr/firmware/SerialRebootListener;)V", "currentPort", "Ldev/slimevr/serial/SerialPort;", "disconnectedDevices", "onSerialConnected", "port", "onSerialDisconnected", "onSerialLog", "str", "", "ignored", "", "onNewSerialDevice", "onSerialDeviceDeleted", "core"})
@SourceDebugExtension(value={"SMAP\nSerialRebootHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialRebootHandler.kt\ndev/slimevr/firmware/SerialRebootHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class SerialRebootHandler
implements SerialListener {
    @NotNull
    private final List<Pair<UpdateDeviceId<?>, Function0<Unit>>> watchRestartQueue;
    @NotNull
    private final VRServer server;
    @NotNull
    private final SerialRebootListener serialRebootListener;
    @Nullable
    private SerialPort currentPort;
    @NotNull
    private final List<SerialPort> disconnectedDevices;

    public SerialRebootHandler(@NotNull List<Pair<UpdateDeviceId<?>, Function0<Unit>>> watchRestartQueue, @NotNull VRServer server, @NotNull SerialRebootListener serialRebootListener) {
        Intrinsics.checkNotNullParameter(watchRestartQueue, "watchRestartQueue");
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(serialRebootListener, "serialRebootListener");
        this.watchRestartQueue = watchRestartQueue;
        this.server = server;
        this.serialRebootListener = serialRebootListener;
        this.disconnectedDevices = new CopyOnWriteArrayList();
    }

    @Override
    public void onSerialConnected(@NotNull SerialPort port2) {
        Intrinsics.checkNotNullParameter(port2, "port");
        this.currentPort = port2;
    }

    @Override
    public void onSerialDisconnected() {
        this.currentPort = null;
    }

    @Override
    public void onSerialLog(@NotNull String str, boolean ignored) {
        Intrinsics.checkNotNullParameter(str, "str");
        if (StringsKt.contains$default((CharSequence)str, "starting up...", false, 2, null)) {
            Object v1;
            Object object;
            block4: {
                object = this.watchRestartQueue;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    Pair it = (Pair)t;
                    boolean bl = false;
                    SerialPort serialPort = this.currentPort;
                    if (!Intrinsics.areEqual(((UpdateDeviceId)it.getFirst()).getId(), serialPort != null ? serialPort.getPortLocation() : null)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            Pair foundPort = v1;
            if (foundPort != null) {
                Collection collection = this.disconnectedDevices;
                object = this.currentPort;
                TypeIntrinsics.asMutableCollection(collection).remove(object);
                this.serialRebootListener.onSerialDeviceReconnect(foundPort);
                if (this.server.serialHandler.isConnected()) {
                    this.server.serialHandler.closeSerial();
                }
            }
        }
    }

    @Override
    public void onNewSerialDevice(@NotNull SerialPort port2) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(port2, "port");
            Iterable iterable = this.watchRestartQueue;
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(((UpdateDeviceId)it.getFirst()).getId(), port2.getPortLocation())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Pair foundPort = v0;
        if (foundPort != null && this.disconnectedDevices.contains(port2)) {
            this.disconnectedDevices.remove(port2);
            this.serialRebootListener.onSerialDeviceReconnect(foundPort);
            if (this.server.serialHandler.isConnected()) {
                this.server.serialHandler.closeSerial();
            }
        }
    }

    @Override
    public void onSerialDeviceDeleted(@NotNull SerialPort port2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(port2, "port");
            Iterable iterable = this.watchRestartQueue;
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(((UpdateDeviceId)it.getFirst()).getId(), port2.getPortLocation())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Pair foundPort = v0;
        if (foundPort != null) {
            this.disconnectedDevices.add(port2);
        }
    }
}

