/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.games.vrchat;

import dev.slimevr.VRServer;
import dev.slimevr.games.vrchat.VRCAvatarMeasurementType;
import dev.slimevr.games.vrchat.VRCConfigHandler;
import dev.slimevr.games.vrchat.VRCConfigListener;
import dev.slimevr.games.vrchat.VRCConfigRecommendedValues;
import dev.slimevr.games.vrchat.VRCConfigValidity;
import dev.slimevr.games.vrchat.VRCConfigValues;
import dev.slimevr.games.vrchat.VRCSpineMode;
import dev.slimevr.games.vrchat.VRCTrackerModel;
import dev.slimevr.tracking.processor.config.SkeletonConfigToggles;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/slimevr/games/vrchat/VRChatConfigManager;", "", "server", "Ldev/slimevr/VRServer;", "handler", "Ldev/slimevr/games/vrchat/VRCConfigHandler;", "<init>", "(Ldev/slimevr/VRServer;Ldev/slimevr/games/vrchat/VRCConfigHandler;)V", "getServer", "()Ldev/slimevr/VRServer;", "listeners", "", "Ldev/slimevr/games/vrchat/VRCConfigListener;", "currentValues", "Ldev/slimevr/games/vrchat/VRCConfigValues;", "getCurrentValues", "()Ldev/slimevr/games/vrchat/VRCConfigValues;", "setCurrentValues", "(Ldev/slimevr/games/vrchat/VRCConfigValues;)V", "isSupported", "", "()Z", "recommendedValues", "Ldev/slimevr/games/vrchat/VRCConfigRecommendedValues;", "addListener", "", "listener", "removeListener", "checkValidity", "Ldev/slimevr/games/vrchat/VRCConfigValidity;", "values", "recommended", "onChange", "core"})
@SourceDebugExtension(value={"SMAP\nVRCConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VRCConfigHandler.kt\ndev/slimevr/games/vrchat/VRChatConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1863#2,2:181\n*S KotlinDebug\n*F\n+ 1 VRCConfigHandler.kt\ndev/slimevr/games/vrchat/VRChatConfigManager\n*L\n175#1:181,2\n*E\n"})
public final class VRChatConfigManager {
    @NotNull
    private final VRServer server;
    @NotNull
    private final VRCConfigHandler handler;
    @NotNull
    private final List<VRCConfigListener> listeners;
    @Nullable
    private VRCConfigValues currentValues;

    public VRChatConfigManager(@NotNull VRServer server, @NotNull VRCConfigHandler handler) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.server = server;
        this.handler = handler;
        this.listeners = new CopyOnWriteArrayList();
        this.handler.initHandler((Function1<? super VRCConfigValues, Unit>)new Function1<VRCConfigValues, Unit>((Object)this){

            @Override
            public final void invoke(VRCConfigValues p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((VRChatConfigManager)this.receiver).onChange(p0);
            }
        });
    }

    @NotNull
    public final VRServer getServer() {
        return this.server;
    }

    @Nullable
    public final VRCConfigValues getCurrentValues() {
        return this.currentValues;
    }

    public final void setCurrentValues(@Nullable VRCConfigValues vRCConfigValues) {
        this.currentValues = vRCConfigValues;
    }

    public final boolean isSupported() {
        return this.handler.isSupported();
    }

    @NotNull
    public final VRCConfigRecommendedValues recommendedValues() {
        boolean forceArmsFromHMD = this.server.humanPoseManager.getToggle(SkeletonConfigToggles.FORCE_ARMS_FROM_HMD);
        Tracker tracker = TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.LEFT_HAND);
        boolean hasLeftHandWithPosition = tracker != null ? tracker.getHasPosition() : false;
        Tracker tracker2 = TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.RIGHT_HAND);
        boolean hasRightHandWithPosition = tracker2 != null ? tracker2.getHasPosition() : false;
        boolean isMissingAnArmTracker = TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.LEFT_LOWER_ARM) == null || TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.RIGHT_LOWER_ARM) == null || TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.LEFT_UPPER_ARM) == null || TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.RIGHT_UPPER_ARM) == null;
        boolean isMissingAShoulderTracker = TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.LEFT_SHOULDER) == null || TrackerUtils.getTrackerForSkeleton(this.server.getAllTrackers(), TrackerPosition.RIGHT_SHOULDER) == null;
        boolean bl = (forceArmsFromHMD || !hasLeftHandWithPosition || !hasRightHandWithPosition || isMissingAnArmTracker) && (!forceArmsFromHMD && hasLeftHandWithPosition && hasRightHandWithPosition || isMissingAShoulderTracker);
        double d = this.server.humanPoseManager.getRealUserHeight();
        VRCTrackerModel vRCTrackerModel = VRCTrackerModel.AXIS;
        Object object = new VRCSpineMode[]{VRCSpineMode.LOCK_HIP, VRCSpineMode.LOCK_HEAD};
        VRCSpineMode[] vRCSpineModeArray = object;
        object = VRCAvatarMeasurementType.HEIGHT;
        return new VRCConfigRecommendedValues(false, bl, true, d, 0.2, true, vRCTrackerModel, vRCSpineModeArray, (VRCAvatarMeasurementType)((Object)object));
    }

    public final void addListener(@NotNull VRCConfigListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull VRCConfigListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listeners.removeIf(arg_0 -> VRChatConfigManager.removeListener$lambda$1(arg_0 -> VRChatConfigManager.removeListener$lambda$0(listener2, arg_0), arg_0));
    }

    @NotNull
    public final VRCConfigValidity checkValidity(@NotNull VRCConfigValues values2, @NotNull VRCConfigRecommendedValues recommended) {
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(recommended, "recommended");
        boolean bl = values2.getLegacyMode() == recommended.getLegacyMode();
        boolean bl2 = values2.getShoulderTrackingDisabled() == recommended.getShoulderTrackingDisabled();
        boolean bl3 = ArraysKt.contains(recommended.getSpineMode(), values2.getSpineMode());
        boolean bl4 = values2.getTrackerModel() == recommended.getTrackerModel();
        boolean bl5 = Math.abs(values2.getCalibrationRange() - recommended.getCalibrationRange()) < 0.1;
        boolean bl6 = Math.abs((double)this.server.humanPoseManager.getRealUserHeight() - values2.getUserHeight()) < 0.1;
        boolean bl7 = values2.getCalibrationVisuals() == recommended.getCalibrationVisuals();
        boolean bl8 = values2.getAvatarMeasurementType() == recommended.getAvatarMeasurementType();
        boolean bl9 = values2.getShoulderWidthCompensation() == recommended.getShoulderWidthCompensation();
        return new VRCConfigValidity(bl, bl2, bl9, bl6, bl5, bl7, bl4, bl3, bl8);
    }

    public final void onChange(@NotNull VRCConfigValues values2) {
        Intrinsics.checkNotNullParameter(values2, "values");
        VRCConfigRecommendedValues recommended = this.recommendedValues();
        VRCConfigValidity validity = this.checkValidity(values2, recommended);
        this.currentValues = values2;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VRCConfigListener it = (VRCConfigListener)element$iv;
            boolean bl = false;
            it.onChange(validity, values2, recommended);
        }
    }

    private static final boolean removeListener$lambda$0(VRCConfigListener $listener, VRCConfigListener l) {
        Intrinsics.checkNotNullParameter(l, "l");
        return l == $listener;
    }

    private static final boolean removeListener$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

